//loppu.ini
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

#switch (clock)
#range (0,.5)
#declare kirka=clock*2;
#break
#range (.5,100)
#declare kirka=1;
#break
#end
global_settings {ambient_light kirka}

light_source
{
  0*x
  color red kirka  green kirka  blue kirka
  translate <-20, 40, -20>
}



#declare vpuu = texture {
pigment {
    wood
    turbulence 0.04
    octaves 3
    scale <0.05, .05, 1>
    color_map {
        [0.1 rgb <0.988, 0.700, 0.4>*1.3]
        [0.9 rgb <0.700, 0.500, 0.3>*1.3]
    }
}
finish {phong .3}
}
camera
{
  location  <0.0 , 7.0 ,0.0>
  look_at   <0.0 , 0.0 , 2.0>
}
#switch (clock)
#range (0,.25)
#declare eki=0;
#break
#range (0.25,2.25)
#declare eki=sin((clock-.25)*135*pi/180)*2;
#break
#range (2.25,12.25)
#declare eki=-2
#break
#end

blob {
#declare xxx=-5;
#while (xxx<5.4)
cylinder {<xxx,-2,-10>,<xxx,-2,10>,3,3 scale <2,1,1>}
#declare xxx=xxx+2;
#end
cylinder {<-3.1,0,4>,<-3.1,0,3>,.5,eki}
cylinder {<-3.1,0,3.3>,<-3.1,0,3.7>,.5,eki}
cylinder {<-3.1,0,4>,<-2.7,0,4.2>,.5,eki}
cylinder {<-2.5,0,4>,<-2.7,0,4.2>,.5,eki}
cylinder {<-3.1,0,3>,<-2.7,0,2.8>,.5,eki}
cylinder {<-2.5,0,3>,<-2.7,0,2.8>,.5,eki}

cylinder {<-1.4,0,2.8>,<-1.4,0,4.2>,.5,eki}
cylinder {<-1.4,0,2.8>,<-1.4,0,4.2>,.5,eki}
cylinder {<-.6,0,2.8>,<-.6,0,4.2>,.5,eki}
cylinder {<-.6,0,2.8>,<-.6,0,4.2>,.5,eki}
cylinder {<-1.19,0,3.5>,<-1.21,0,3.5>,.5,eki}

cylinder {<0.2,0,2.8>,<0.2,0,4.2>,.5,eki}
cylinder {<0.2,0,2.8>,<0.2,0,4.2>,.5,eki}
cylinder {<0.4,0,4.2>,<.8,0,4.2>,.5,eki}
cylinder {<0.4,0,3.5>,<.8,0,3.5>,.5,eki}
cylinder {<0.4,0,2.8>,<.8,0,2.8>,.5,eki}
cylinder {<0.6,0,4.2>,<.8,0,4.2>,.5,eki}
cylinder {<0.6,0,3.5>,<.8,0,3.5>,.5,eki}
cylinder {<0.6,0,2.8>,<.8,0,2.8>,.5,eki}

cylinder {<-3.1+4.7,0,4>,<-3.1+4.7,0,3>,.5,eki}
cylinder {<-3.1+4.7,0,3.3>,<-3.1+4.7,0,3.7>,.5,eki}
cylinder {<-3.1+4.7,0,4>,<-2.7+4.7,0,4.2>,.5,eki}
cylinder {<-2.5+4.7,0,4>,<-2.7+4.7,0,4.2>,.5,eki}
cylinder {<-3.1+4.7,0,3>,<-2.7+4.7,0,2.8>,.5,eki}
cylinder {<-2.5+4.7,0,3>,<-2.7+4.7,0,2.8>,.5,eki}

cylinder {<3,0,2.8>,<3,0,4.2>,.5,eki}
cylinder {<3,0,2.8>,<3,0,4.2>,.5,eki}

cylinder {<3,0,3.5>,<3.7,0,4.2>,.5,eki}
cylinder {<3,0,3.5>,<3.7,0,2.8>,.5,eki}
cylinder {<3,0,3.5>,<3.7,0,4.2>,.5,eki}
cylinder {<3,0,3.5>,<3.7,0,2.8>,.5,eki}

cylinder {<-3,0,1.8>,<-3,0,.4>,.5,eki}
cylinder {<-1.5,0,1.8>,<-1.5,0,.4>,.5,eki}
cylinder {<-3,0,1.8>,<-2.25,0,.4>,.5,eki}
cylinder {<-1.5,0,1.8>,<-2.25,0,.4>,.5,eki}

cylinder {<-1,0,.4>,<-0.5,0,1.8>,.5,eki}
cylinder {<0,0,.4>,<-0.5,0,1.8>,.5,eki}
cylinder {<-.6,0,.7>,<-.4,0,.7>,.5,eki}

cylinder {<.8,0,.4>,<.8,0,1.8>,.5,eki}
cylinder {<.3,0,1.8>,<1.3,0,1.8>,.5,eki}

cylinder {<2,0,.4>,<2,0,1.8>,.5,eki}
cylinder {<2,0,.4>,<2.5,0,.4>,.5,eki}
cylinder {<2,0,1.1>,<2.5,0,1.1>,.5,eki}
cylinder {<2,0,1.8>,<2.5,0,1.8>,.5,eki}
texture {vpuu}
}
