// Persistence of Vision Ray Tracer Scene Description File
// File: Cat.inc
// Vers: 3.1
// Desc: Cat oject file
// Date: 8/15/98
// Auth: Steve Sloan II

#include "cat_ears.inc"

/*******************/
/* Define Pigments */
/*******************/

#declare head_pigment =
pigment { image_map { gif "catheadt.gif" map_type 1 interpolate 2 } rotate 90*y }

#declare cat_gray = color 0.33;

#declare skin_color = color <0.5, 0.4, 0.4>;

#declare cone_stripe =
pigment {
    gradient z
    color_map {
        [ 0.0 color cat_gray transmit 0 ]
        [ 0.3 color cat_gray transmit 0 ]
        [ 0.7 color Black transmit 0 ]
        [ 1.0 color Black transmit 0 ]
    }
}

#declare cone_stripe =
pigment {
    gradient z
    color_map {
        [ 0.0  color cat_gray transmit 0 ]
        [ 0.55 color cat_gray transmit 0 ]
        [ 0.95 color Black transmit 0 ]
        [ 1.0  color Black transmit 0 ]
    }
}

#declare sphere_stripe =
pigment {
    gradient z
    color_map {
        [ 0.0 color Black transmit 0 ]
        [ 0.3 color Black transmit 0 ]
        [ 0.7 color cat_gray transmit 0 ]
        [ 1.0 color cat_gray transmit 0 ]
    }
}

#declare sphere_stripe =
pigment {
    gradient z
    color_map {
        [ 0.0 color Black transmit 0 ]
        [ 0.1 color Black transmit 0 ]
        [ 0.5 color cat_gray transmit 0 ]
        [ 1.0 color cat_gray transmit 0 ]
    }
}

#declare iris_pigment =
pigment {
    bozo
    color_map {
        [ 0.0 color RichBlue ]
        [ 0.7 color RichBlue ]
        [ 0.7 color SteelBlue ]
        [ 1.0 color SteelBlue ]
    }
    turbulence 0.5
    scale 0.1
}

/***********************/
/* Get the Cat's Teeth */
/***********************/

#include "catteeth.inc"

/**************/
/* Create Cat */
/**************/

#declare Cat_Head_Bounding = sphere { 0, 2.2 translate 0.5*z }

/* Head without Jaw */
#declare Head_without_Jaw =
blob {
    threshold .65

    /* Main part of head */
    sphere {
        0, 1, 1 scale 2.275
        scale 1.57
        pigment { head_pigment }
    }

    /* Muzzle */
    sphere {
        0, 1, 1 scale 2.275
        scale <0.45, 0.45, 0.78>
        translate < 0.45, 0, 1.46>
        pigment { head_pigment }
    }
    sphere {
        0, 1, 1 scale 2.275
        scale <0.45, 0.45, 0.78>
        translate <-0.45, 0, 1.46>
        pigment { head_pigment }
    }

    /* Bridge of nose */
    cylinder {
        0, 0.6*z, 1, 1 scale <2.275, 2.275, 1>
        scale <0.15, 0.15, 1>
        rotate 15*x
        translate <0, 0.85, 1.0>
        pigment { head_pigment }
    }

    /* Nose */
    sphere {
        0, 1, 1 scale 2.275
        scale 0.15
        translate <0, -0.1, 1.3>
        rotate 15*x
        translate <0, 0.85, 1.0>
        pigment { color Red*10 }
    }

    /* Carve out the roof of the mouth */
    sphere {
        0, 1, -1 scale 2.275
        scale <0.35, 0.34, 0.67>
        translate <0, -0.79, 1.35>
        pigment { color Red*10 }
    }
//    bounded_by { object { Cat_Head_Bounding } }
}

/* Jaw */
#declare Jaw =
blob {
    threshold .65

    /* Main part of head */
    sphere {
        0, 1, 1 scale 2.275
        scale 1.569
        pigment { color White }
    }

    /* Jaw */
    sphere {
        0, 1, 1 scale 2.275
        scale <0.4, 0.34, 0.67>
        pigment { head_pigment }
        translate  <0, -0.34, 0.5>
//        rotate (60*JawAngle - 15)*x
        rotate (40*JawAngle - 15)*x
        translate -0.5*z
        translate <0, -0.45, 1.35>
        pigment { color White }
    }

    /* Carve out the depression of the jaw */
    sphere {
        0, 1, -1 scale 2.275
        scale <0.35, 0.3, 0.6>
        translate  0.5*z
        rotate (60*JawAngle - 15)*x
        translate -0.5*z
        translate <0, -0.45, 1.35>
        pigment { color Red*10 }
    }
}

#declare CatEarPart1 = object { CatEar(Ear1Height) }
#declare CatEar1 =
union {
    object { CatEarPart1 pigment { color cat_gray } }
    object { CatEarPart1 scale 0.999 pigment { color skin_color } }
    rotate 180*y
    rotate -Ear1Rot*180*y
    rotate 45*z
}

#declare CatEarPart2 = object { CatEar(Ear2Height) }
#declare CatEar2 =
union {
    object { CatEarPart2 pigment { color cat_gray } }
    object { CatEarPart2 scale 0.999 pigment { color skin_color } }
    scale <-1, 1, 1>
    rotate 180*y
    rotate Ear2Rot*180*y
    rotate -45*z
}

/* Eyes */
#declare LeftEye = 
union {
    sphere {
        0, 1
        pigment {
            radial
            color_map {
                [ 0.0  cat_gray ]
                [ 0.38 - 0.15*LEyeOpen cat_gray ]
                [ 0.38 - 0.15*LEyeOpen White ]
                [ 0.43 - 0.15*LEyeOpen White ]
                [ 0.43 - 0.15*LEyeOpen Black ]
                [ 0.45 - 0.15*LEyeOpen Black ]
                [ 0.45 - 0.15*LEyeOpen color rgbt 1 ]
                [ 0.45 + 0.15*LEyeOpen color rgbt 1 ]
                [ 0.45 + 0.15*LEyeOpen Black ]
                [ 0.47 + 0.15*LEyeOpen Black ]
                [ 0.47 + 0.15*LEyeOpen White ]
                [ 0.52 + 0.15*LEyeOpen White ]
                [ 0.52 + 0.15*LEyeOpen cat_gray ]
                [ 1.0  cat_gray ]
            }
        }
        scale 0.45
        rotate <0, 90, 90>
        rotate <-40, 0, -20>
    }
    sphere {
        0, 1
        pigment {
            wood
            pigment_map {
                [0.0  color Black ]
                [0.75 color Black ]
                [0.75 iris_pigment ]
                [1.0  iris_pigment ]
            }
            scale 2
        }
        finish { specular 1 roughness 0.0001 reflection 0.13 ambient 0.5 }
        scale 0.44
        rotate -30*x
    }
    translate < 0.9, 0.56, 1>
}

#declare RightEye = 
union {
    sphere {
        0, 1
        pigment {
            radial
            color_map {
                [ 0.0  cat_gray ]
                [ 0.38 - 0.15*REyeOpen cat_gray ]
                [ 0.38 - 0.15*REyeOpen White ]
                [ 0.43 - 0.15*REyeOpen White ]
                [ 0.43 - 0.15*REyeOpen Black ]
                [ 0.45 - 0.15*REyeOpen Black ]
                [ 0.45 - 0.15*REyeOpen color rgbt 1 ]
                [ 0.45 + 0.15*REyeOpen color rgbt 1 ]
                [ 0.45 + 0.15*REyeOpen Black ]
                [ 0.47 + 0.15*REyeOpen Black ]
                [ 0.47 + 0.15*REyeOpen White ]
                [ 0.52 + 0.15*REyeOpen White ]
                [ 0.52 + 0.15*REyeOpen cat_gray ]
                [ 1.0  cat_gray ]
            }
        }
        scale 0.45
        rotate <0, 90, 90>
        rotate <-40, 0, 20>
    }
    sphere {
        0, 1
        pigment {
            wood
            pigment_map {
                [0.0  color Black ]
                [0.75 color Black ]
                [0.75 iris_pigment ]
                [1.0  iris_pigment ]
            }
            scale 2
        }
        finish { specular 1 roughness 0.0001 reflection 0.13 ambient 0.5 }
        scale 0.44
        rotate -30*x
    }
    translate <-0.9, 0.56, 1>
}

#declare UpperTeeth = 
object {
    UpperTeethMain
    rotate -15*x
    translate <0, -0.5, 1>
    pigment { color White }
}

#declare LowerTeeth = 
object {
    LowerTeethMain
    translate  <0, -0.1, 0.5>
    rotate (60*JawAngle - 15)*x
    rotate 15*x
    translate -0.5*z
    translate <0, -0.45, 1.35>
    pigment { color White }
}

#declare Cat_Head =
union {
    union {
        object { Head_without_Jaw }
        object { Jaw }
    }
    object { UpperTeeth }
    object { LowerTeeth }

    /* Ears */
    object { CatEar1 }
    object { CatEar2 }

    /* Eyes */
    object { LeftEye }
    object { RightEye }
}

/* Include the spline macros into your POV file */
#include "spline31.inc"

#declare step_size = 0.05;

#declare Cat_Body =
union {
    /* Draw a spline curve */

    /* Get the x and y coordinates from the macro */
    #declare oldxpos = SplinePoint(0, Bodyx)
    #declare oldypos = SplinePoint(0, Bodyy)
    #declare oldzpos = SplinePoint(0, Bodyz)

    #declare oldxrad = SplinePoint(0, Bodyxrad)
    #declare oldyrad = SplinePoint(0, Bodyyrad)

    sphere {
        0, 1
        scale <oldxrad, oldyrad, 1>
        translate <oldxpos, oldypos, oldzpos>
        pigment { color cat_gray }
    }

    #declare t1 = step_size;
    #while (t1 <= 1)
        /* Get the x, y, and z coordinates from the macro */
        #declare xpos = SplinePoint(t1, Bodyx)
        #declare ypos = SplinePoint(t1, Bodyy)
        #declare zpos = SplinePoint(t1, Bodyz)

        #declare xrad = SplinePoint(t1, Bodyxrad)
        #declare yrad = SplinePoint(t1, Bodyyrad)

        #declare vstart = <oldxpos, oldypos, oldzpos>;
        #declare vend   = <xpos, ypos, zpos>;

        #declare selen = vlength(vend - vstart);

        /* Draw the little objects that make up the spline */
        cone {
            0, oldyrad, <xpos - oldxpos, ypos - oldypos, zpos - oldzpos>, yrad
            scale <oldxrad/oldyrad, 1, 1>

            pigment {
                gradient y
                pigment_map {
                    [ 0.0  color Black ]
                    [ 0.03 color Black ]
                    [ 0.1  cone_stripe scale <1, 1, selen> ]
                    [ 0.85 cone_stripe scale <1, 1, selen> ]
                    [ 0.95 color White ]
                    [ 1.0  color White ]
                }
                translate -0.5*y
                scale yrad*2.1

                #declare body_angle = get_angle(vstart, vend);
                rotate body_angle.y*y
                rotate body_angle.x*x
            }
            translate <oldxpos, oldypos, oldzpos>
        }
        sphere {
            0, 1
            scale <xrad, yrad, yrad>

            pigment {
                gradient y
                pigment_map {
                    [ 0.0  color Black ]
                    [ 0.03 color Black ]
                    [ 0.1  sphere_stripe scale <1, 1, selen> ]
                    [ 0.85 sphere_stripe scale <1, 1, selen> ]
                    [ 0.95 color White ]
                    [ 1.0  color White ]
                }
                translate -0.5*y
                scale yrad*2.1

                #declare body_angle = get_angle(vstart, vend);
                rotate body_angle.y*y
                rotate body_angle.x*x
            }
            translate <xpos, ypos, zpos>
        }

        /* Update variables */
        #declare oldxpos = xpos;
        #declare oldypos = ypos;
        #declare oldzpos = zpos;
        #declare oldxrad = xrad;
        #declare oldyrad = yrad;

        #declare t1 = t1 + step_size;
    #end
}

#declare step_size = 0.1;

#declare Cat_Tail =
union {
    /* Draw a spline curve */

    /* Get the x and y coordinates from the macro */
    #declare oldxpos = SplinePoint(0, Tailx)
    #declare oldypos = SplinePoint(0, Taily)
    #declare oldzpos = SplinePoint(0, Tailz)

    #declare oldrad = SplinePoint(0, Tailrad)

    sphere {
        0, 1
        scale oldrad
        translate <oldxpos, oldypos, oldzpos>
        pigment { color cat_gray }
    }

    #declare t1 = step_size;
    #while (t1 <= 1)
        /* Get the x, y, and z coordinates from the macro */
        #declare xpos = SplinePoint(t1, Tailx)
        #declare ypos = SplinePoint(t1, Taily)
        #declare zpos = SplinePoint(t1, Tailz)
        #declare rad = SplinePoint(t1, Tailrad)

        #declare vstart = <oldxpos, oldypos, oldzpos>;
        #declare vend   = <xpos, ypos, zpos>;

        #declare selen = vlength(vend - vstart);
        #declare t1inv = 1 - t1;
        #declare pigment_factor = 0.5 * t1inv;
        #declare tail_black = color t1inv * t1inv * t1inv * cat_gray;

        /* Draw the little objects that make up the spline */
        cone {
            0, oldrad, <0, 0, selen>, rad

            pigment {
                gradient z
                color_map {
                    [ 0.0 color cat_gray ]
                    [ 0.5 - pigment_factor color cat_gray ]
                    [ 0.5 + pigment_factor color tail_black ]
                    [ 1.0 color tail_black ]
                }
                scale <1, 1, selen>
            }

            #declare tail_angle = get_angle(vstart, vend);
//            #render concat("vstart = <", str(vstart.x,5,2), ", ", str(vstart.y,5,2))
//            #render concat(", ", str(vstart.z,5,2), ">, ")
//            #render concat("vend = <", str(vend.x,5,2), ", ", str(vend.y,5,2))
//            #render concat(", ", str(vend.z,5,2), ">, ")
//            #render concat("Angles: x = ", str(tail_angle.x,5,0))
//            #render concat(", y = ", str(tail_angle.y,5,0),"\n")

            rotate tail_angle.x*x
            rotate tail_angle.z*z

            translate <oldxpos, oldypos, oldzpos>
        }
        sphere { 0, rad translate <xpos, ypos, zpos> pigment { color Black } }

        /* Update variables */
        #declare oldxpos = xpos;
        #declare oldypos = ypos;
        #declare oldzpos = zpos;
        #declare oldrad  = rad;

        #declare t1 = t1 + step_size;
    #end
}

/******************/
/* Fetch the legs */
/******************/

#include "catlegs.inc"

#declare Cat =
union {
    object {
        Cat_Head
        rotate HeadRoll*z
        #declare vstart = <Bodyx[1], Bodyy[1], Bodyz[1]>;
        #declare vend = <Bodyx[0], Bodyy[0], Bodyz[0]>;
        #declare head_angle = get_angle(vstart, vend);
        rotate -HeadAngle*x
        rotate head_angle.x*x
        rotate head_angle.y*y
        rotate HeadYaw*y
        translate <0, Bodyy[1], Bodyz[1]>
    }
    object { Cat_Body }
    object { Cat_Front_Legs }
    object { Cat_Hind_Legs }
    object {
        Cat_Tail
        translate <Bodyx[4], Bodyy[4] + Bodyyrad[4] - Tailrad[1], Bodyz[4]>
    }
    scale in
}
