// Persistence of Vision Ray Tracer Scene Description File
// File: CatLegs.inc
// Vers: 3
// Desc: An include file that creates legs for the Cat
// Date: 9/25/98
// Auth: Steve Sloan II

#declare BodyTexture = 
texture {
    pigment {
        gradient y
        pigment_map {
            [ 0.0  color Black transmit 0 ]
            [ 0.03 color Black transmit 0 ]
            [ 0.1  sphere_stripe scale <1, 1, selen> ]
            [ 0.85 sphere_stripe scale <1, 1, selen> ]
            [ 0.95 color White transmit 0 ]
            [ 1.0  color White transmit 0 ]
        }
        translate -0.5*y
    }
}

#declare LegTexture = 
texture { pigment { color cat_gray*0.3 transmit 0 } }
/*texture {
    pigment {
        gradient y
        color_map {
            [ 0.0 color Black transmit 0 ]
            [ 0.3 color Black transmit 0 ]
            [ 0.7 color cat_gray transmit 0 ]
            [ 1.0 color cat_gray transmit 0 ]
        }
    }
    translate -10*y
}*/

#declare GrayTexture = 
//texture { pigment { color cat_gray transmit 0 } }
texture { pigment { color Black transmit 0 } }

#declare Cat_Front_Legs =
blob {
    threshold .65

    /* Chest */
    sphere {
        0, 1, 1 scale 2.275
        scale <Bodyxrad[2], Bodyyrad[2], Bodyyrad[2]>
        texture {
//            BodyTexture
            GrayTexture
            scale <Bodyxrad[2], 2*Bodyyrad[2], Bodyyrad[2]/2>
            rotate 180*x +
                get_angle(<Bodyx[2], Bodyy[2], Bodyz[2]>, <Bodyx[1], Bodyy[1], Bodyz[1]>)
        }
    }

    /************/
    /* Left Leg */
    /************/

    /* Arm */
    sphere {
        0, 1, 1 //scale 2.275
        texture { LegTexture }
        scale <0.75, 1.4, 1>
        translate -0.4*y
        rotate 35.5*x
        rotate -LArmAngle*x
        translate <0.75 - Bodyxrad[2], -1, 1.2>
    }

    /* Forearm */
    cylinder {
        0, -3*y, 1, 1 //scale 2.275
        texture { LegTexture }
        scale <0.75, 1, 1>
        rotate -35.5*x
        rotate LForearmAngle*x
        translate -y
        rotate 35.5*x
        rotate -LArmAngle*x
        translate <0.75 - Bodyxrad[2], -1, 1.2>
    }

    /* Paw Toe 1 */
    sphere {
        0, 1, 1 //scale 2.275
        pigment { color cat_gray transmit 0 }
        scale <0.3, 0.75, 1>
        translate 0.7*z
        rotate LFrontPawAngle*x
        translate -3.2*y
        rotate -35.5*x
        rotate LForearmAngle*x
        translate -y
        rotate 35.5*x
        rotate -LArmAngle*x
        translate <0.75 - Bodyxrad[2], -1, 1.2>
    }

    /* Paw Toe 2 */
    sphere {
        0, 1, 1 //scale 2.275
        pigment { color cat_gray transmit 0 }
        scale <0.3, 0.75, 1>
        translate <0.3, 0, 0.7>
        rotate LFrontPawAngle*x
        translate -3.2*y
        rotate -35.5*x
        rotate LForearmAngle*x
        translate -y
        rotate 35.5*x
        rotate -LArmAngle*x
        translate <0.75 - Bodyxrad[2], -1, 1.2>
    }

    /* Paw Toe 3 */
    sphere {
        0, 1, 1 //scale 2.275
        scale <0.3, 0.75, 1>
        pigment { color cat_gray transmit 0 }
        translate <-0.3, 0, 0.7>
        rotate LFrontPawAngle*x
        translate -3.2*y
        rotate -35.5*x
        rotate LForearmAngle*x
        translate -y
        rotate 35.5*x
        rotate -LArmAngle*x
        translate <0.75 - Bodyxrad[2], -1, 1.2>
    }

    /*************/
    /* Right Leg */
    /*************/

    /* Arm */
    sphere {
        0, 1, 1 //scale 2.275
        texture { LegTexture }
        scale <0.75, 1.4, 1>
        translate -0.4*y
        rotate 35.5*x
        rotate -RArmAngle*x
        translate <Bodyxrad[2] - 0.75, -1, 1.2>
    }

    /* Forearm */
    cylinder {
        0, -3*y, 1, 1 //scale 2.275
        texture { LegTexture }
        scale <0.75, 1, 1>
        rotate -35.5*x
        rotate RForearmAngle*x
        translate -y
        rotate 35.5*x
        rotate -RArmAngle*x
        translate <Bodyxrad[2] - 0.75, -1, 1.2>
    }

    /* Paw Toe 1 */
    sphere {
        0, 1, 1 //scale 2.275
        scale <0.3, 0.75, 1>
        pigment { color cat_gray transmit 0 }
        translate 0.7*z
        rotate RFrontPawAngle*x
        translate -3.2*y
        rotate -35.5*x
        rotate RForearmAngle*x
        translate -y
        rotate 35.5*x
        rotate -RArmAngle*x
        translate <Bodyxrad[2] - 0.75, -1, 1.2>
    }

    /* Paw Toe 2 */
    sphere {
        0, 1, 1 //scale 2.275
        scale <0.3, 0.75, 1>
        pigment { color cat_gray transmit 0 }
        translate <0.3, 0, 0.7>
        rotate RFrontPawAngle*x
        translate -3.2*y
        rotate -35.5*x
        rotate RForearmAngle*x
        translate -y
        rotate 35.5*x
        rotate -RArmAngle*x
        translate <Bodyxrad[2] - 0.75, -1, 1.2>
    }

    /* Paw Toe 3 */
    sphere {
        0, 1, 1 //scale 2.275
        scale <0.3, 0.75, 1>
        pigment { color cat_gray transmit 0 }
        translate <-0.3, 0, 0.7>
        rotate RFrontPawAngle*x
        translate -3.2*y
        rotate -35.5*x
        rotate RForearmAngle*x
        translate -y
        rotate 35.5*x
        rotate -RArmAngle*x
        translate <Bodyxrad[2] - 0.75, -1, 1.2>
    }

    translate <Bodyx[2], Bodyy[2], Bodyz[2]>
}

#declare Cat_Hind_Legs =
blob {
    threshold .65

    /* Hips */
    sphere {
        0, 1, 1 scale 2.275
//        texture { BodyTexture scale <1, 2, 0.75> }
        texture { GrayTexture }
        scale <Bodyxrad[4], Bodyyrad[4], Bodyyrad[4]/2>
        scale 0.95
    }

    /************/
    /* Left Leg */
    /************/

    /* Thigh */
    sphere {
        0, 1, 1 //scale 2.275
        scale <0.75, 1.75, 1.65>
        texture { LegTexture }
        rotate -LThighAngle*x
        translate <0.75 - Bodyxrad[4], -1.33, 0>
    }

    /* Forearm */
    cylinder {
        -0.5*y, -1.5*y, 1, 1 //scale 2.275
        scale <0.75, 1, 0.75>
        texture { LegTexture }
        rotate 50*x
        translate <0, -0.66, 0.66>
        rotate -LThighAngle*x
        translate <0.75 - Bodyxrad[4], -1.33, 0>
    }

    /* Hindpaw */
    cylinder {
        -0.5*y, -1.5*y, 1, 1 //scale 2.275
        scale <0.75, 1, 1>
        texture { LegTexture }
        rotate -70*x
        rotate -LHeelAngle*x
        translate -2*y
        rotate 50*x
        translate <0, -0.66, 0.66>
        rotate -LThighAngle*x
        translate <0.75 - Bodyxrad[4], -1.33, 0>
    }

    /* Paw Toe 1 */
    sphere {
        0, 1, 1 //scale 2.275
        scale <0.3, 0.75, 1>
        pigment { color cat_gray transmit 0 }
        translate 0.7*z
        rotate LHindPawAngle*x
        rotate 20*x
        translate -1.5*y
        rotate -70*x
        rotate -LHeelAngle*x
        translate -2*y
        rotate 50*x
        translate <0, -0.66, 0.66>
        rotate -LThighAngle*x
        translate <0.75 - Bodyxrad[4], -1.33, 0>
    }

    /* Paw Toe 2 */
    sphere {
        0, 1, 1 //scale 2.275
        scale <0.3, 0.75, 1>
        pigment { color cat_gray transmit 0 }
        translate <0.3, 0, 0.7>
        rotate LHindPawAngle*x
        rotate 20*x
        translate -1.5*y
        rotate -70*x
        rotate -LHeelAngle*x
        translate -2*y
        rotate 50*x
        translate <0, -0.66, 0.66>
        rotate -LThighAngle*x
        translate <0.75 - Bodyxrad[4], -1.33, 0>
    }

    /* Paw Toe 3 */
    sphere {
        0, 1, 1 //scale 2.275
        scale <0.3, 0.75, 1>
        pigment { color cat_gray transmit 0 }
        translate <-0.3, 0, 0.7>
        rotate LHindPawAngle*x
        rotate 20*x
        translate -1.5*y
        rotate -70*x
        rotate -LHeelAngle*x
        translate -2*y
        rotate 50*x
        translate <0, -0.66, 0.66>
        rotate -LThighAngle*x
        translate <0.75 - Bodyxrad[4], -1.33, 0>
    }

    /*************/
    /* Right Leg */
    /*************/

    /* Thigh */
    sphere {
        0, 1, 1 //scale 2.275
        scale <0.75, 1.75, 1.65>
        texture { LegTexture }
        rotate -RThighAngle*x
        translate <Bodyxrad[4] - 0.75, -1.33, 0>
    }

    /* Forearm */
    cylinder {
        -0.5*y, -1.5*y, 1, 1 //scale 2.275
        scale <0.75, 1, 0.75>
        texture { LegTexture }
        rotate 50*x
        translate <0, -0.66, 0.66>
        rotate -RThighAngle*x
        translate <Bodyxrad[4] - 0.75, -1, 0>
    }

    /* Hindpaw */
    cylinder {
        -0.5*y, -1.5*y, 1, 1 //scale 2.275
        scale <0.75, 1, 1>
        texture { LegTexture }
        rotate -70*x
        rotate -RHeelAngle*x
        translate -2*y
        rotate 50*x
        translate <0, -0.66, 0.66>
        rotate -RThighAngle*x
        translate <Bodyxrad[4] - 0.75, -1, 0>
    }

    /* Paw Toe 1 */
    sphere {
        0, 1, 1 //scale 2.275
        scale <0.3, 0.75, 1>
        pigment { color cat_gray transmit 0 }
        translate 0.7*z
        rotate RHindPawAngle*x
        rotate 20*x
        translate -1.5*y
        rotate -70*x
        rotate -RHeelAngle*x
        translate -2*y
        rotate 50*x
        translate <0, -0.66, 0.66>
        rotate -RThighAngle*x
        translate <Bodyxrad[4] - 0.75, -1, 0>
    }

    /* Paw Toe 2 */
    sphere {
        0, 1, 1 //scale 2.275
        scale <0.3, 0.75, 1>
        pigment { color cat_gray transmit 0 }
        translate <0.3, 0, 0.7>
        rotate RHindPawAngle*x
        rotate 20*x
        translate -1.5*y
        rotate -70*x
        rotate -RHeelAngle*x
        translate -2*y
        rotate 50*x
        translate <0, -0.66, 0.66>
        rotate -RThighAngle*x
        translate <Bodyxrad[4] - 0.75, -1, 0>
    }

    /* Paw Toe 3 */
    sphere {
        0, 1, 1 //scale 2.275
        scale <0.3, 0.75, 1>
        pigment { color cat_gray transmit 0 }
        translate <-0.3, 0, 0.7>
        rotate RHindPawAngle*x
        rotate 20*x
        translate -1.5*y
        rotate -70*x
        rotate -RHeelAngle*x
        translate -2*y
        rotate 50*x
        translate <0, -0.66, 0.66>
        rotate -RThighAngle*x
        translate <Bodyxrad[4] - 0.75, -1, 0>
    }

    translate <Bodyx[4], Bodyy[4], Bodyz[4]>
}

