// Persistence of Vision Ray Tracer Scene Description File
// File: CatSuces.pov
// Vers: 3
// Desc: Cat "Success"
// Date: 9/20/98
// Auth: Steve Sloan II

#version 3.1;

#include "colors.inc"
#include "textures.inc"
#include "catmacro.inc"

global_settings { assumed_gamma 1.0 }

#declare inch   = 1;
#declare in     = inch;
#declare inches = inch;
#declare feet   = 12*inch;
#declare foot   = 12*inch;
#declare ft     = 12*inch;

camera {
    location <0, 0, 10>
    look_at  <0, 0,  0>
}

sky_sphere { pigment { color Black } }

//light_source { <0, 0, 10> color White }
#declare color_var = SineWaveClock(clock)
//#declare color_var = 1.0;
light_source { <0, 0, 10> color <color_var, color_var, color_var> }

#include "catobjs.inc"

#declare cat_gray = color 0.33;

#declare CatPigment =
texture {
    pigment {
        gradient y
        pigment_map {
            [ 0.0 color cat_gray ]
            [ 0.2 color cat_gray ]
            [ 0.3 color White ]
            [ 0.4 color Black ]
            [ 0.6 color Black ]
            [ 0.7 color White ]
            [ 0.8 color cat_gray ]
            [ 1.0 color cat_gray ]
        }
        turbulence 0.2
        scale 0.5
    }
    normal { bumps 0.75 scale 0.1 }
    finish { diffuse 0.5 ambient 0 }
}

// Text
text {
    ttf "comicbd.ttf", "Success ! ! !", 0.5, 0
    scale 2
    scale <-1, 1, 0.1>
    translate 6*x
    texture { CatPigment }
}
