// Persistence Of Vision raytracer version 3.1 sample file.
// Description: Old fashioned lamppost on a reflective floor
// File by Anton Raves
// ==== Standard POV-Ray Includes ====
#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "metals.inc"
#include "chamfer.inc"

#declare jif=1.0/30;

#declare AAA = 9;


light_source { <-1,36,-1> color White*0.25 }
light_source { <-1,36,19.5> color White*0.25 }
light_source { <19.5,36,-1> color White*0.25 }
light_source { <19.5,36,19.5> color White*0.25 }


sky_sphere { pigment { White*0.7 } }

#macro dcos (a)
  cos(radians(a))
#end

#macro dsin (a)
  sin(radians(a))
#end

#macro cshell (p1,p2,r1,r2)
#local n=p2-p1;
difference {
  cylinder { p1, p2, r1 }
  cylinder { p1-0.1*n, p2+0.1*n, r2 }
}
#end


#declare mYellow = rgb <1,0.741,0.141>;
#declare plYellow = texture {
  pigment { mYellow }
  finish { ambient 0.7 }
}

#declare mRed = rgb <1,0,0>;
#declare plRed = texture {
  pigment { mRed }
  finish { ambient 0.7 }
}

#declare mBlue = rgb <0.188,0.471,0.894>;
#declare plBlue = texture {
  pigment { mBlue }
  finish { ambient 0.7 }
}

#declare mGreen = rgb <0,0.55,0>;
#declare plGreen = texture {
  pigment { mGreen }
  finish { ambient 0.7 }
}

#macro atorus (r1,r2,t1,t2)
  difference {
    torus { r1, r2 }
    #if (mod(t2-t1+3600,360)>180)
    intersection {
      plane { z,0 rotate -t1*y }
      plane { -z,0 rotate -t2*y }
    }
    #else
    union {
      plane { z,0 rotate -t1*y }
      plane { -z,0 rotate -t2*y }
    }
    #end
  }             
#end

#macro rdisk (r, tk)
  union {
    torus { r-tk/2, tk/2 }
    cylinder { -tk/2*y, tk/2*y, r-tk/2 }
  }
#end

plane { y, -1/8 texture {T_Wood2 rotate 180*x translate -3*y } }
object {
  chbox ( <0,-1/8,0>, <18.5,0,18.5>, 0.9/16 )
  pigment { image_map { png "board.png" } rotate 90*x rotate 180*y scale 18.5 } 
  finish { ambient 0.2 }
}

#include "mtobj.pov"

#macro rubberband(p1,p2)          
#declare dr1 = p2-p1;
#declare ang = atan2(dr1.x, dr1.z) * 180/3.141592;
  union {
    difference {
      torus { 1/8, 1/32 }
      box { <-1/4,-1/4,0>, <1/4,1/4,-1/4> }
      rotate ang*y
      translate p2
    }
    difference {
      torus { 1/8, 1/32 }
      box { <-1/4,-1/4,0>, <1/4,1/4,-1/4> }
      rotate (ang+180)*y        
      translate p1
    }
    cylinder { 0, vlength(dr1)*z, 1/32 translate 1/8*x rotate ang*y translate p1 }
    cylinder { 0, vlength(dr1)*z, 1/32 translate -1/8*x rotate ang*y translate p1 }
    pigment { rgb <225,182,117>/255 }
    finish { ambient 0.7 diffuse 0.2 }
  }
#end
  
// The animation is broken into several "stages"
#declare s_start     =  0.0;
#declare s_crank     =  s_start + 60/30; 
#declare s_stopforw  =  s_crank + 45/30;
#declare s_boot      =  s_stopforw + 1/30;
#declare s_bucket    =  s_boot + 1/30;
#declare s_stairs    =  s_bucket + 10/30;
#declare s_gutter    =  s_stairs + 78/30;
#declare s_ball2     =  s_gutter + 45/30;
#declare s_diver     =  s_ball2 + 35/30;
#declare s_cage      =  s_diver + 7/30;
#declare s_done      =  s_cage + 54/30;
#declare s_stop      =  s_done + 30/30;

#declare cl=s_stop*clock;

#declare t_start     = (cl-s_start)/(s_crank-s_start);
#declare t_crank     = (cl-s_crank)/(s_stopforw-s_crank);
#declare t_stopforw  = (cl-s_stopforw)/(s_boot-s_stopforw);
#declare t_boot      = (cl-s_boot)/(s_bucket-s_boot);
#declare t_bucket    = (cl-s_bucket)/(s_stairs-s_boot);
#declare t_stairs    = (cl-s_stairs)/(s_gutter-s_stairs);
#declare t_gutter    = (cl-s_gutter)/(s_ball2-s_gutter);
#declare t_ball2     = (cl-s_ball2)/(s_diver-s_ball2);
#declare t_diver     = (cl-s_diver)/(s_cage-s_diver);
#declare t_cage      = (cl-s_cage)/(s_done-s_cage);
  
#switch (cl)
  #range (0,s_crank)
    #declare tt = cl/s_crank;
    #declare cloc = <9,10/16,1.5>*(1-tt) + <9.5,20,40>*tt;
    #declare clat = <9,9.9/16,1.49>*(1-tt) + <9.5,3,9.5>*tt;
    #declare dz = 1.8;
  #break
  #range (s_crank,s_bucket)
    #declare tt = (cl-s_crank)/(s_bucket-s_crank);
    #declare cloc = vrotate (<0,20,40-9.5>, 130*tt*y) + <9.5,0,9.5>;
    #declare clat = <9.5,3,9.5>*(1-tt) + <14,3,14>*tt;
    #declare dz = 1.8 + 2.2*tt;
  #break    
  #range (s_bucket,s_ball2)
    #declare tt = (cl-s_bucket)/(s_ball2-s_bucket);
    #declare cloc = vrotate (<0,20,40-9.5>, (130-40*tt)*y) + <9.5,0,9.5>;
    #declare clat = <14,3,14>*(1-tt) + <9.5,3,9.5>*tt;
    #declare dz = 4.0 - 2.0*tt;
  #break
  #range (s_ball2,s_cage)
    #declare tt = (cl-s_ball2)/(s_cage-s_ball2);
    #declare tt2 = (cl-s_ball2)/(s_done-s_ball2);
    #declare cloc = vrotate (<0,20,40-9.5>, (90+120*tt2)*y) + <9.5,0,9.5>;
    #declare clat = <9.5,3,9.5>;
    #declare dz = 2.0;
  #break
  #range (s_cage,s_done)
    #declare tt = (cl-s_cage)/(s_done-s_cage);
    #declare tt2 = (cl-s_ball2)/(s_done-s_ball2);
    #declare cloc = vrotate (<0,20,40-9.5>, (90+120*tt2)*y) + <9.5,0,9.5>;
    #declare clat = <9.5,3,9.5>*(1-tt) + <1467,0,390>/1800*18.5*tt;
    #declare dz = 2.0;
  #break
  #else
    #declare tt = (cl-s_done)/(s_stop-s_done);
    #declare cloc = vrotate (<0,20,40-9.5>, 210*y) + <9.5,0,9.5>;
    #declare clat = <1467,0,390>/1800*18.5;
    #declare dz = 1.8 + 5.2*tt;
#end

camera
{
  location  cloc
  direction z*dz
  up        y
  right     1.33*x
  look_at   clat
}

//Base A assembley
#declare Tr1 = transform { rotate -13*y translate <4.25,0,14> translate 0.5*x }
object { BaseA transform Tr1 }
object { CrankSupport translate 9/16*y transform Tr1 }
#switch (t_crank)                                     
  #range (0.875,1)
    #declare sang = 24*(t_crank-0.875)*8;
  #break
  #else
    #switch (t_stopforw)
      #range (0,1)
        #declare sang = 24*(1-t_stopforw);
      #break
      #else
        #declare sang = 0;
    #end
#end
object { StopSign rotate (-12-sang)*y translate <3.9564,0.9375,-0.2984> transform Tr1 }
object { RedGear 
  #switch (t_crank)
    #range (0,1) 
      rotate 257*z*t_crank
    #break
  #end
  translate 9/16*y translate <1.0313,2.375-11/32,0.4375-0.125> transform Tr1 }
object { Crank 
  #switch (t_crank)
    #range (0,1) 
      rotate 257*z*t_crank
    #break
  #end
  translate <1.0313,2.375-11/32+9/16,0.4375+0.25+4/32> transform Tr1 }
object { YellowGear rotate 7*y
  #switch (t_crank)
    #range (0,1) 
      rotate 257*y*t_crank
    #break
  #end
  translate <0.97321,1.40625,-0.97133> transform Tr1 }
object { LampPost translate <6.85648,1.5625,-0.60725> transform Tr1 }
object { Boot 
  #switch (t_boot)
    #range (0,1)
      rotate 41*t_boot*x 
    #break
    #range (1,2)
      rotate 41*(2-t_boot)*x
  #end
  translate <6.85648,1.5625,-0.60725> translate <2.5,4.875+1/32,0> transform Tr1 }
object { rubberband (vrotate (<4.1875,1.25,5/64>+<-1.8125,0,-3/16>, (-12-sang)*y)+<3.9564,0,-0.2984>, 
                        <5.77186,1.25,-1.989>) transform Tr1 }

// Stair assembley
#declare Tr2 = transform { rotate 8*y translate <12.75,0,7.5> }
object { Stairs transform Tr2 }
object { Bucket 
  #switch (cl)
    #range (-1,s_bucket)                // do nothing
    #break                                           
    #range (s_bucket,s_bucket+3*jif)
      rotate -90*x*(cl-s_bucket)/(3*jif)
    #break
    #else
      rotate -90*x
  #end
  translate <1/2,0,1/4> rotate -7*y translate <0.75,2.125+3/4+11/8,5> transform Tr2
}

// Pipe assembley
#declare Tr3 = transform { rotate 108*y translate <4.625+.25,0,9> }
object { BaseB transform Tr3 }
object { RainGutter translate -<1/8,0,-0.3125-6/32> rotate 11*z rotate -90*y 
                              translate <-0.3532,0.25,0.375> transform Tr3 }
#declare Tr3b = transform { rotate 180*y translate <2.625,0.625,0> rotate 108*y translate <4.625+.25,0,9> }
object { Pipes transform Tr3b } 
object { Pole rotate 180*y translate <3+0.24+9/64,4.75+2.375+12/16+4.5/32*19/15,0> transform Tr3b }
object { Tub rotate 180*y translate (4.875-1/2)*y transform Tr3b }
object { Thingamajig translate <0,1/16-0.7,-17/16> rotate -90*y 
  #if (cl > s_ball2)
    rotate 8*z      
  #end
  translate <2.75,8.25+0.25,0> transform Tr3b
} 
object { DivingBoard 
  #switch (cl)
    #range (-1,s_diver)
      rotate -12*z
    #break
    #range (s_diver,s_diver+jif)
      rotate (-12+24*(cl-s_diver)/jif)*z
    #break
    #else
      rotate 12*z
  #end
  rotate -101.1554*y translate <4.0723,7/16,1.7585> transform Tr3
}
object { Diver
  #declare tt2 = (cl-s_diver)/jif;
  #switch (tt2)
    #range (0,1)
      translate 0.875*tt2*y
    #break
    #range (1,7)
      #declare tt = (tt2-1)/6;
      rotate 180*tt*x
      translate <0,0.875+(2.75-0.875)*tt+1.25*dsin(180*tt),1.25-1.25*dcos(180*tt)>
    #break
    #else
      #switch (cl)
        #range (-1,s_cage)
        #break
        #range (s_cage,s_cage+3*jif)
          #declare tt = (cl-s_cage)/(3*jif);
          rotate (180-40*tt)*x
          translate <-0.25*tt,2.75-0.25*tt,2.5-1.7*tt>
        #break
        #else
          rotate (180-40)*x
          translate <-0.25,2.5,0.8>
      #end
  #end
  rotate -11.2*y translate <3.6491,5/16,3.9046> transform Tr3
}


// Cage assembley
#declare Tr4 = transform { rotate 4*y translate <10.25,0,4.5> }
object { BaseC transform Tr4 }
object { Washtub translate 1/16*y transform Tr4 }
object { CagePole translate <3.75,0.25+5/32,0> transform Tr4 }
object { Cage translate <0,-31/16,0>
  #switch (cl)
    #range (-1,s_cage)
      rotate -8*z translate <3/16+3/4,9.375-5/16,0>
    #break
    #range (s_cage,s_cage+3*jif)
      #declare tt = (cl-s_cage)/(3*jif);
      rotate -8*(1-tt)*z translate <3/16*(1-tt)+3/4,(9.375-5/16)*(1-tt)+7.75*tt,0>
    #break
    #range (s_cage+3*jif,s_cage+53*jif)
      #declare tt = (cl-s_cage-3*jif)/(51*jif);
      #declare see1 = seed (1000*tt);
      rotate (10-20*rand(see1))*z
      rotate (10-20*rand(see1))*x
      rotate -10*rand(see1)*y
      translate <3/4,(7.75*(1-tt)+31/16*tt),0>
    #break
    #else
      rotate -8*z
      translate <3/4,(31-3)/16,0>
  #end  
      
  translate <3.75,0.25+5/32,0> transform Tr4
}

// first marble
object { Marble
  #switch (cl)
    #range (-1,s_bucket)
      translate <0,-(1/4-3/32)+1/16+5/32,0>
      translate <1/2,0,1/4> rotate -7*y translate <0.75,2.125+3/4+11/8,5>
      transform Tr2
    #break                                           
    #range (s_bucket,s_bucket+3*jif)
      #declare tt = (cl-s_bucket)/(3*jif);
      translate <0,-(1/4-3/32)+1/16+5/32,0>
      translate 25/32*(tt*tt*tt)*y
      rotate -90*tt*x
      translate <1/2,0,1/4> rotate -7*y translate <0.75,2.125+3/4+11/8,5>
      transform Tr2
    #break
    #range (s_bucket+3*jif,s_stairs)
      translate 5/16*y
      #declare tt = (cl-s_bucket-3*jif)/(7*jif);
      translate <0.5*dcos(7)+0.75,2.125,0.25*dsin(7)+5-5/16>*(1-tt) + <5/16,2.125,4>*tt
      translate 11/8*y
      transform Tr2
    #break
    #range (s_stairs,s_gutter)
      #declare tt2 = (cl-s_stairs)/jif;
      #switch (tt2)
        #range (0,9)
          #declare tt = tt2/9;
          translate <(3/16+5/16)*(1-tt)+(2.125-5/16)*tt,0,5.5/16>
          rotate -4*x rotate -5*z translate <0,2.125,3.25>
        #break;
        #range (9,13)
          translate <2.125-5/16,0,5.5/16>
          rotate -4*x rotate -5*z translate <0,2.125,3.25>
        #break;
        #range (13,22)
          #declare tt = (tt2-13)/9;
          translate <(2.25-5/16)*(1-tt)+(3/16+5/16)*tt,0,5.5/16>
          rotate -5*x rotate 7*z translate <0.0625,1.5,2.625> 
        #break;
        #range (22,26)
          translate <3/16+5/16,0,3/16+5/16>
          rotate -5*x rotate 7*z translate <0.0625,1.5,2.625> 
        #break;
        #range (26,35)
          #declare tt = (tt2-26)/9;
          translate <(3/16+5/16)*(1-tt)+(2.25-5/16)*tt,0,5.5/16>
          rotate -2*x rotate -5*z translate <0.0625,1.5,2.125>
        #break;
        #range (35,39)
          translate <2.25-5/16,0,5.5/16>
          rotate -2*x rotate -5*z translate <0.0625,1.5,2.125> 
        #break;
        #range (39,48)
          #declare tt = (tt2-39)/9;
          translate <(2.375-5/16)*(1-tt)+(0.25+1/16+5/16)*tt,0,5.5/16>
          rotate -4*x rotate 4*z translate <0.0625,1,1.5>
        #break;
        #range (48,52)
          translate <0.25+1/16+5/16,0,5.5/16>
          rotate -4*x rotate 4*z translate <0.0625,1,1.5>
        #break;
        #range (52,61)
          #declare tt = (tt2-52)/9;
          translate <(3/16+5/16)*(1-tt)+(2.25-5/16)*tt,0,5.5/16>
          rotate -8*x rotate -2*z translate <0.125,0.825,0.875>
        #break;
        #range (61,65)
          translate <2.25-5/16,0,5.5/16>
          rotate -8*x rotate -2*z translate <0.125,0.825,0.875>
        #break;
        #range (65,74)
          #declare tt = (tt2-65)/9;
          translate <(2.1875-5/16)*(1-tt)+(3/16+5/16)*tt,0,5.5/16>
          rotate -8*x rotate 9*z translate 0.25*y
        #break;
        #range (74,78)
          translate <3/16+5/16,0,5.5/16>
          rotate -8*x rotate 9*z translate 0.25*y
        #break;
      #end
      translate 11/8*y
      transform Tr2
    #break
    #range (s_gutter,s_ball2)
      #declare tt2 = (cl-s_gutter)/jif;
      #switch (tt2)
        #range (0,10)
          #declare tt = tt2/10;
          translate <8.125,0,-0.8125*tt+0.3125*(1-tt)>
        #break   
        #range (10,20)
          #declare tt=(tt2-10)/10;
          translate 0.6875*x
          rotate 180*y*tt
          translate <7.4375,0,-0.8125>
        #break
        #range (20,25)
          #declare tt=(tt2-20)/5;
          translate <6.75,0,-0.8125*(1-tt)>
        #break  
        #range (25,30)
          #declare tt=(tt2-25)/5;
          translate 0.625*x
          rotate -90*tt*y
          translate <6.125,0,0.5>
        #break   
        #range (30,35)
          #declare tt=(tt2-30)/5;
          translate <4.3125*tt+6.125*(1-tt),0,1.125>
        #break  
        #range (35,38)
          #declare tt=(tt2-35)/3;
          translate 0.5625*x
          rotate (-90-90*tt)*y
          translate <4.3125,0,0.5625>
        #break;  
        #range (38,40)
          #declare tt=(tt2-38)/2;
          translate 0.5625*x
          rotate 90*tt*y             
          translate <3.1875,0,0.5625>
        #break;  
        #range (40,45)
          #declare tt=(tt2-40)/5;
          translate <3.1875*(1-tt),0,0>
        #break  
      #end
      translate -<1/8,0,-0.3125-6/32> rotate 11*z rotate -90*y translate <-0.3532,0.25,0.375> transform Tr3
    #break
    #else
      translate -<1/8,0,-0.3125-6/32> rotate 11*z rotate -90*y translate <-0.3532,0.25,0.375> transform Tr3
  #end
  
}

object { Marble 
  #switch (cl)
    #range (-1,s_ball2+15*jif)
      #declare tt = (cl-s_ball2)/(15*jif);
      #if (tt<0)
        translate <0,0.7+sqrt(19)/16,7/8> 
      #else
        translate <0,0.7+5/16,7/8+(3.125-0.625+5/16-7/8)*tt>
      #end
      translate <0,1/16-0.7,-17/16> rotate -90*y rotate 8*z translate <2.75,8.25+0.25,0> 
    #break  
    #range (s_ball2+15*jif,s_diver)
      #declare tt2 = (cl-s_ball2)/jif;
      #switch (tt2)
        #range (15,18)
          #declare tt = (tt2-15) / 3;
          #declare bv1 = <0,0.7+5/16,7/8+(3.125-0.625+5/16-7/8)> + <0,1/16-0.7,-17/16>;
          #declare bv1 = vrotate (bv1, -90*y); 
          #declare bv1 = vrotate (bv1, 8*z); 
          #declare bv1 = bv1 + <2.75,8.25+0.25,0>;
          translate bv1*(1-tt) + <0,4.875-1/2+5/16+9/16,0>*tt
        #break
        #range (18,31)
          #declare tt = (tt2-18) / 13;
          translate <(-2.5+0.6875)*tt,4.875-1/2+5/16+9/16,0>
        #break       
        #range (31,35)
          #declare tt = (tt2-31) / 4;
          translate <-2.5+0.6875,(4.875-1/2+5/16+9/16)*(1-tt)+0.75*tt,0>
        #break
        #else
          translate <-2.5+0.6875,0.75,0>
      #end
    #break
    #range (s_diver-0.0001,s_diver+jif)
      #declare tt = (cl-s_diver)/jif;
      translate <-2.5+0.6875,0.75*(1-tt),0>
    #break
    #range (s_diver+jif,s_diver+6*jif)
      #declare tt = (cl-s_diver-jif)/jif;
      translate <-2.5+0.6875,-0.25,0.75*tt>
    #break
    #else
      #declare tt = (cl-s_diver-jif)/jif;
      translate <-2.5+0.6875,-0.25-1/8,0.75*tt>
  #end
  transform Tr3b
}
                        
object { Die rotate -90*x rotate -17*y translate <9,5/16,1.5> }

object { Mouse texture { plBlue } rotate 180*y translate <1467,0,390>/1800*18.5 }
object { Mouse texture { plGreen } 
  #declare tt2 = cl/jif;
  #switch (tt2)
    #range (0,40)
      rotate 180*y
      translate <1047+(1470-1047)*tt2/40,0,177>/1800*18.5
    #break
    #range (40,50)
      #declare tt = (tt2-40)/10;
      rotate (180-45*tt)*y
      translate (<1470,0,177>*(1-tt)+<1605,0,258>*tt)/1800*18.5
    #break
    #range (50,60)
      #declare tt = (tt2-50)/10;
      rotate (135-45*tt)*y
      translate (<1605,0,258>*(1-tt)+<1671,0,435>*tt)/1800*18.5
    #break
    #else
      rotate 90*y
      translate <1671,0,435>/1800*18.5
  #end
}

