
#declare Washtub =
union {
  cylinder { 0*y, 5/32*y, 2.6875/2 }
  difference {
    cone { 5/32*y, 2.6875/2 (1.5)*y, 3.03125/2 }
    cone { 0.157*y, (2.6875/2-3/32), (1.5)*y, 2.84375/2 }
    cylinder { (1.499)*y, (1.51)*y, 3.1/2 }    
    texture { plYellow }
    normal { wood rotate 90*x translate 10*z }
  }                                    
  cshell ( (1.5-5/32)*y, 1.5*y, 3.0625/2, 2.84375/2 )
  
  texture { plYellow }
}

#declare BaseC =
union {   
  cshell ( 0*y, 1/16*y, 1.5, 1.25 )
  difference {
    prism { 0, 1/16, 5, <0,-1.5>, <3.75,-0.25>, <3.75,0.25>, <0,1.5>, <0,-1.5> }          // fixme
    cylinder { -0.1*y, 3/32*y, 1.25 }
  }                                  
  box { <-9/64,0,-1.4>, <9/64,1/16,1.4> }
  box { <-1.4,0,-9/64>, <1.4,1/16,9/64> }
  difference {
    cone { 1/16*y, 1.5, (1.5+1/16)*y, 0 }
    cylinder { 0*y, 1.6*y, 1.375 }
  }
  cshell ( <3.75,0,0>, <3.75,1,0>, 0.25, 3/16 )
  box { <1.375,0,-1/32>, <3.5,3/16,1/32> }
  prism {
    -1/32, 1/32, 4
    <0,0>, <7/32,0>, <7/32,7/16>, <0,0>
    rotate -90*x
    translate <3.5-7/32,3/16,0>
  }                  
  difference {
    box { <1.625-5/32,0,-1.296>, <1.625+5/32,1/16,1.296> }
    cylinder { <1.625,-3/16,-1.21875>, <1.625,1/16+0.01,-1.21875>, 5/64 }
    cylinder { <1.625,-3/16,1.21875>, <1.625,1/16+0.01,1.21875>, 5/64 }
  }
  cshell ( <1.625,-3/16,-1.21875>, <1.625,1/16+0.01,-1.21875>, 5/32, 5/64 )
  cshell ( <1.625,-3/16,1.21875>, <1.625,1/16+0.01,1.21875>, 5/32, 5/64 )
  box { <3/16+1/32,0,-1/32>, <3/16-3/32,31/32,1/32> rotate 45*y translate 3.75*x } // fixme (slot)
    
  texture { plRed }
}

#declare CrankSupport =
union {             
  prism { 0, 1/16, 7, 
        <0,0>, <2.0625,0>, <2.3046,0.4375>, <1.8204,1.3125>, <0.2421,1.3125>, <-0.2421,0.4375>, <0,0> }
  difference {
    prism { -1/32, 1/32, 5, <0,0>, <1.5784,0>, <1.1330,2.375>, <0.4455,2.375>, <0,0>
      rotate -90*x translate <0.2421,0,0.4375>
    }
    cylinder { <1.0313,2.375-11/32,0>, <1.0313,2.375-11/32,1>, 7/32 }
  }
//  cshell ( <1.0313,2.375-11/32,0.4375-0.25>, <1.0313,2.375-11/32,0.4375+0.125>, 9/32, 7/32 )
  cshell ( <1.0313,2.375-11/32,0.4375-0.125>, <1.0313,2.375-11/32,0.4375+0.25>, 9/32, 7/32 )
  union {
    cylinder { -1/32*y, 1/32*y, 0.25-1/32 }
    torus { 0.25-1/32, 1/32 }
    rotate 90*z
    translate <1.5313,1/16,0.4375>
          }
  union {
    cylinder { -1/32*y, 1/32*y, 0.25-1/32 }
    torus { 0.25-1/32, 1/32 }
    rotate 90*z
    translate <0.5313,1/16,0.4375>
  }             
  cylinder { <0.5313,1/16,0.4375>, <0.5313,1/16,1.3125>, 1/32 }
  cylinder { <1.5313,1/16,0.4375>, <1.5313,1/16,1.3125>, 1/32 }
  prism {
    -1/32, 1/32, 6
    <0,0>, <0.375,0>, <0.125,1.375>, <0.125,1.75>, <0,1.75>, <0,0>
    rotate -90*x
    rotate -90*y
    translate <1.0313,1/16,0.4375>
  }
  
  texture { plBlue }    
}

#declare DivingBoard =
union {           
  difference {
    box { <-67/32,-1/16,-15/32>, <67/32,1/16,15/32> }
    box { <-65/32,-1/8,-13/32>, <65/32,0,13/32> }
  }
  box { <-65/32,1/16,-12/32>, <65/32,3/32,12/32> }
  cylinder { <13/8,0,0>, <13/8,1/8,0>, 3/64 }
  cylinder { <-13/8,0,0>, <-13/8,1/8,0>, 3/64 }
                                                                        
  difference {  
    union {
      prism { -1/32, 1/32, 5, <0.25,0.25>, <1.25,0>, <-1.25,0>, <-0.25,0.25>, <0.25,0.25>
              rotate 90*x translate <0,-1/16,-1/4> }
      prism { -1/32, 1/32, 5, <0.25,0.25>, <1.25,0>, <-1.25,0>, <-0.25,0.25>, <0.25,0.25>
              rotate 90*x translate <0,-1/16,+1/4> }
    }
    union {
      cylinder { <0,-0.1875,-0.5>, <0,-0.1875,0.5>, 0.125 }
      box { <-0.125,-0.1875,-0.5>, <0.125,-0.325,0.5> }
    }
  }     
  cshell ( <-0.5,0,0>, <-0.5,-0.1875,0>, 1/8, 1/16 )
  cshell ( <0.5,0,0>, <0.5,-0.1875,0>, 1/8, 1/16 )
  
  translate 0.1875*y
  
  texture { plBlue }
}

#declare Bucket =
difference
{         
  union {
    cone { 0*y, 29/64, 25/32*y, 17/32 }
    cylinder { 21/32*y, 25/32*y, 17/32 }
  }        
  cone { 1/16*y, 25/64, (25/32+0.01)*y, 15/32 }
  cylinder { <-1,1/4-3/32,0>, <1,1/4-3/32,0>, 3/32 }
  box { <-1,1/16,-3/32>, <1,1/4-3/32,3/32> }
  box { <29/64,-1/16,-3/32>, <25/64,1/16,3/32> }
  box { <-29/64,-1/16,-3/32>, <-25/64,1/16,3/32> }
  translate -(1/4-3/32)*y
  
  texture { plYellow }
}

#macro slide_path(r,e)
merge
{
  cylinder { <0-e,0,0>, <3.1875+e,0,0>, r }
  intersection {
    torus { 0.5625, r }
    box { <0,-0.4,0+e>, <1,0.4,-1> }
    translate <3.1875,0,0.5625>
  }
  intersection {
    torus { 0.5625, r }   
    box { <-1,-0.4,0>, <0,0.4,1> }
    translate <4.3125,0,0.5625>
  }   
  cylinder { <4.3125-e,0,1.125>, <6.125+e,0,1.125>, r }
  intersection {
    torus { 0.625, r }
    box { <0,-0.4,0>, <1,0.4,1> }
    translate <6.125,0,0.5>
  }                       
  cylinder { <6.75,0,0.5+e>, <6.75,0,-0.8125-e>, r }
  intersection {
    torus { 0.6875, r }
    box { <-1.2,-0.4,-1.2>, <1.2,0.4,0> }
    translate <7.4375,0,-0.8125>
  }                       
  cylinder { <8.125,0,-0.8125-e>, <8.125,0,0.3125+e>, r }
}
#end

#declare RainGutter =
union
{
  difference {
    slide_path (0.375, 0)
    intersection {
      slide_path (0.3125, 0.0001)
      box { <-0.1,-0.25,-5>, <13,1,2> }
    }
    box { <-0.1,0,-5>, <13,1,2> }
  }
  object { slide_path (1/32, 0) translate -0.25*y }

  merge
  {
    cylinder { <0,0,0.3125+3/32>, <3.1875,0,0.3125+3/32>, 3/32 }
    cylinder { <0,0,-0.3125-3/32>, <3.1875,0,-0.3125-3/32>, 3/32 }
    intersection {
      torus { 0.5625-0.3125-3/32, 3/32 }
      box { <0,-1,0>, <1,1,-1> }
      translate <3.1875,0,0.5625>
    }
    intersection {
      torus { 0.5625+0.3125+3/32, 3/32 }
      box { <0,-1,0>, <1,1,-1> scale 2 }
      translate <3.1875,0,0.5625>
    }            
    intersection {
      torus { 0.5625+0.3125+3/32, 3/32 }
      box { <-2,-0.4,0>, <0,0.4,2> }
      translate <4.3125,0,0.5625>
    }   
    intersection {
      torus { 0.5625-0.3125-3/32, 3/32 }
      box { <-2,-0.4,0>, <0,0.4,2> }
      translate <4.3125,0,0.5625>
    }   
    cylinder { <4.3125,0,1.125+0.3125+3/32>, <6.125,0,1.125+0.3125+3/32>, 3/32 }
    cylinder { <4.3125,0,1.125-0.3125-3/32>, <6.125,0,1.125-0.3125-3/32>, 3/32 }
    intersection {
      torus { 0.625-0.3125-3/32, 3/32 }
      box { <0,-0.4,0>, <1,0.4,1> }
      translate <6.125,0,0.5>
    }                       
    intersection {
      torus { 0.625+0.3125+3/32, 3/32 }
      box { <0,-0.4,0>, <2,0.4,2> }
      translate <6.125,0,0.5>
    }                       
    cylinder { <6.75+0.3125+3/32,0,0.5>, <6.75+0.3125+3/32,0,-0.8125>, 3/32 }
    cylinder { <6.75-0.3125-3/32,0,0.5>, <6.75-0.3125-3/32,0,-0.8125>, 3/32 }
    intersection {
      torus { 0.6875+0.3125+3/32, 3/32 }
      box { <-2,-0.4,-2>, <2,0.4,0> }
      translate <7.4375,0,-0.8125>
    }                       
    intersection {
      torus { 0.6875-0.3125-3/32, 3/32 }
      box { <-1.2,-0.4,-1.2>, <1.2,0.4,0> }
      translate <7.4375,0,-0.8125>
    }                       
    cylinder { <8.125+0.3125+3/32,0,-0.8125>, <8.125+0.3125+3/32,0,0.3125>, 3/32 }
    cylinder { <8.125-0.3125-3/32,0,-0.8125>, <8.125-0.3125-3/32,0,0.3125>, 3/32 }
  }
  
  cylinder { <1/8,0,0.3125+6/32>, <1/8,1/16,0.3125+6/32>, 1/8 }
  cylinder { <1/8,0,-0.3125-6/32>, <1/8,1/16,-0.3125-6/32>, 1/8 }
  cylinder { <1/8,0,0.3125+6/32>, <1/8,-1/4,0.3125+6/32>, 1/32 }
  cylinder { <1/8,0,-0.3125-6/32>, <1/8,-1/4,-0.3125-6/32>, 1/32 }
  
  cylinder { <5.21875,-0.37,1.125>, <5.21875,-0.37-17/16,1.125>, 0.125 }
  prism { -1/32, 1/32, 5, <-1/8,0.5>, <1/8,0.5>, <5/8,0>, <-5/8,0>, <-1/8,0.5>
    rotate 90*x translate <5.21875,-0.37,1.125> }
  cylinder { <7.4375,-0.37,-1.5>, <7.4375,-0.37-1.5,-1.5>, 5/32 }
  prism { -1/32, 1/32, 5, <-5/32,0.75>, <5/32,0.75>, <9/16,0>, <-9/16,0>, <-5/32,0.75>
    rotate 90*x translate <7.4375,-0.37,-1.5> }
  cylinder { <8.125,-0.37,0.03125>, <8.125,-0.37-1.625,0.03125>, 5/32 }
  prism { -1/32, 1/32, 4, <0,0>, <0.375,0>, <0,0.75>, <0,0>
    rotate 90*y rotate -90*z translate <8.125,-0.37,0.03125-5/32> }


  texture { plRed }
}

#declare Die =
difference {
  object { chbox ( <-5,-5,-5>, <5,5,5>, 1/2) pigment { White } finish { ambient 0.4 } }
  union {                
    // 1
    sphere { <0,5,0>, 1 }
    // 2
    sphere { <-2.5,2.5,-5>, 1 }
    sphere { <2.5,-2.5,-5>, 1 }  
    // 3
    sphere { <5,-2.5,-2.5>, 1 }
    sphere { <5,0,0>, 1 }
    sphere { <5,2.5,2.5>, 1 }
    // 4           
    sphere { <-5,-2.5,-2.5>, 1 }
    sphere { <-5,-2.5,2.5>, 1 }
    sphere { <-5,2.5,-2.5>, 1 }
    sphere { <-5,2.5,2.5>, 1 }
    // 5
    sphere { <-2.5,-2.5,5>, 1 }
    sphere { <-2.5,2.5,5>, 1 }
    sphere { <2.5,-2.5,5>, 1 }
    sphere { <2.5,2.5,5>, 1 }
    sphere { <0,0,5>, 1 }
    // 6
    sphere { <-2.5,-5,-2.5>, 1 }
    sphere { <0,-5,-2.5>, 1 }
    sphere { <2.5,-5,-2.5>, 1 }
    sphere { <-2.5,-5,2.5>, 1 }
    sphere { <0,-5,2.5>, 1 }
    sphere { <2.5,-5,2.5>, 1 }
    
    pigment { Black }
    finish { Shiny }
  }
  scale 1/16
  //translate 5/16*y
}

#declare BaseA =
difference {
  union {
    prism { 0, 1/16, 19, <-0.24206,0.4375>, <0.24206,1.3125>, <1.82044,1.3125>,
                <2.30456,0.4375>, <2.0625,0>, <2.32967,-0.26315>, <3.92505,0.04566>,
                <6.86242,0.01772>, <6.69919,-1.21213>, <6.02965,-1.03804>,
                <5.99049,-2.21501>, <5.55323,-2.20046>, <5.17091,-0.81473>,
                <4.56602,-0.65745>, <3.94105,-0.65150>, <1.02072,-1.21678>,
                <0.75542,-1.09409>, <0,0>, <-0.24206,0.4375> }
    prism { 0, 1/2, 7,  <0,0>, <2.0625,0>, <2.3046,0.4375>, <1.8204,1.3125>,
                                        <0.2421,1.3125>, <-0.2421,0.4375>, <0,0> }
    cshell ( <0.97321,0,-0.97133>, <0.97321,1.40625-3/16,-0.97133>, 0.25, 0.25-1/16 )
    cshell ( <3.95640,0,-0.29840>, <3.95640,0.875,-0.29840>, 0.25, 0.25-1/16 )
    cshell ( <5.77186,0,-2.20774>, <5.77186,1.125,-2.20774>, 0.21875, 0.21875-1/16 )     
    box { <-1/16,0,0.2185-1/16>, <1/16,0.125,0.21875>  translate <5.77186,1.125,-2.20774> }
    box { <-1/16,0.125,0>, <1/16,0.25,0.21875>  translate <5.77186,1.125,-2.20774> }
//    cshell ( <5.84104,0,-0.12878>, <5.84104,1.375,-0.12878>, 0.15625, 0.15625-1/16 )
    cshell ( <5.64104,0,-0.12878>, <5.64104,1.375,-0.12878>, 0.15625, 0.15625-1/16 )
    
    cylinder { <6.85648,0,-0.60725>, <6.85648,0.125,-0.60725>, 0.625 }
    cone  { <6.85648,0.125,-0.60725>, 0.625, <6.85648,0.3125,-0.60725>, 17/32 }   
    cylinder { <6.85648,0.3125,-0.60725>, <6.85648,0.375,-0.60725>, 0.5 }
    sor { 5, <15/32+0.1,-0.173>, <15/32,0>, <5/16,0.4>, <0.1875,1.1875>, <0.1875,1.2>
          translate <6.85648,0.375,-0.60725> }
          
    box { <0+0.25-1/8,0,-1/32>, <3.058-0.25+1/8,0.3125,1/32>
                        rotate -192.71*y translate <3.9564,0,-0.2984> }
    box { <0+0.25-1/8,0,-1/32>, <2.916-0.6+1/8,0.3125,1/32>
                        rotate -353.92*y translate <3.9564,0,-0.2984> }
//    box { <0+0.21875-1/8,0,-1/32>, <2.080-0.15625+1/8,0.3125,1/32>
//                        rotate -91.91*y translate <5.7719,0,-2.2077> }
    box { <0+0.21875-1/8,0,-1/32>, <2.080-0.15625+1/8,0.3125,1/32>
                        rotate -93.91*y translate <5.7719,0,-2.2077> }
  }
  union {
    cylinder { <0.32044,-1/8,0.4375>, <0.32044,1/2,0.4375>, 0.25 }
    cylinder { <1.74206,-1/8,0.4375>, <1.74206,1/2,0.4375>, 0.1875 }
    cylinder { <6.85648,-1/8,-0.60725>, <6.85648,1.6,-0.60725>, 1/8 }
  }

  texture { plYellow }
  translate 1/16*y
}

#declare StopSign =
union {
  prism { 1/4, 5/16, 13,  <0,0>, <0,0.375>, <4.9375,0.375>, <5.733,-0.4205>,
              <7.39017,-0.4205>, <7.39017,-0.7955>, <5.57767,-0.7955>,
              <4.78217,0>, <3.6875,0>, <3.625,0.1875>, <3.25,0.1875>, <3.1875,0>, <0,0> }
  prism { 0, 1/16, 13,  <0,0>, <0,0.375>, <4.9375,0.375>, <5.733,-0.4205>,
              <7.39017,-0.4205>, <7.39017,-0.7955>, <5.57767,-0.7955>,
              <4.78217,0>, <3.6875,0>, <3.625,0.1875>, <2.1875,0.1875>, <2.125,0>, <0,0> }
  prism { 0, 5/16, 9,  <0,0>, <0,0.375>, <4.9375,0.375>, <5.733,-0.4205>,
              <7.39017,-0.4205>, <7.39017,-0.483>, <5.733,-0.483>, <4.9375,0.3125>, <0,0> }
  box { <0,0,0>, <1/16,5/16,0.375> }
  box { <7.32767,0,-0.7955>, <7.39017,5/16,-0.4205> }
    
  cylinder { <1/16,5/16,0>, <1/16,5/16,3/8>, 1/16 }
  cylinder { <1/16,5/32,-0.01>, <1/16,5/32,3/8>, 1/16 }
  cylinder { <1.8125,1/4,-0.01>, <1.8125,1/4,3/8>, 1/16 }
  cylinder { <2.9375,1/4,-0.01>, <2.9375,1/4,3/8>, 1/16 }
  cylinder { <4.1875,1/4,-0.01>, <4.1875,1/4,3/8>, 1/16 }
  cylinder { <7.26517,5/32,-0.7965>, <7.26517,5/32,-0.4205>, 1/16 }
  cylinder { <5.82767,5/32,-0.7965>, <5.82767,5/32,-0.4205>, 1/16 }
    
  box { <1.8125-1/64,0,0>, <1.8125+1/64,-5/8,3/8> }
  box { <1.8125-3/16,0,3/16-1/64>, <1.8125+3/16,-5/8,3/16+1/64> }
    
  box { <4.1875-1/32,5/16,0>, <4.1875+1/32,7/16,5/32> }
  cylinder { <4.1875,1/2,0>, <4.1875,1/2,5/32>, 1/16 }
  sphere { <4.1875,1/2,5/32>, 1/16 }

  prism { -1/16, 0, 7, <0,0>, <0,1.125>, <-0.17678,1.30178>, <-0.17678,2.05178>,
                <0.07322,2.05178>, <0.378,0>, <0,0>
                rotate -90*x rotate -90*y translate <7.39017,5/16,-0.7955> }
  prism { -1/16, 0, 7, <0,0>, <0,1.125>, <-0.17678,1.30178>, <-0.17678,2.05178>,
                <0.07322,2.05178>, <0.375,0>, <0,0>
                rotate -90*x rotate -90*y translate <7.39017-3/4,5/16,-0.7955> }
  prism { 0, 1/16, 7, <1,0>, <0.5,0.866>, <-0.5,0.866>, <-1,0>, <-0.5,-0.866>, <0.5,-0.866>, <1,0>
           translate 0.866*z scale <0.8125,1,0.8125> 
           rotate -90*x translate <6.98392,5/16+1.30178,-0.7955-0.17678> }
  cylinder { <6.98392,1.61428+3/16,-0.9722-1/16>, <6.98392,1.61428+3/16,-0.9872-1/16>, 1/8 }
  cylinder { <6.98392,1.61428+20/16,-0.9722-1/16>, <6.98392,1.61428+20/16,-0.9872-1/16>, 1/8 }

  translate <-1.8125,0,-3/16>
  texture { plRed }
}

#declare RedGear =
difference {
  union {
    prism { 0, 3/16, 10,   <0,0>, <-0.75013,0.79598>, <-0.52679,1.99409>,
                <-0.18041,2.26135>, <0.78830,2.27015>, <1.30224,1.97281>,
                <1.67234,0.97686>, <1.54997,0.55682>, <0.875,0>, <0,0>
                texture { plRed normal { wood 0.15 turbulence 0.03 translate <-6-6,0> scale 0.3 } }
    }
    union {
      #declare ang = 0;
      #while (ang < 360)
        cylinder { <0,0,1.03125>, <0,0.375,1.03125>, 1/32 rotate ang*y }
        #declare ang = ang + 36;
      #end
      translate <0.4375,3/16,1.125>
    }
    cylinder { <0.4375,-1/16,1.125>, <0.4375,4/16,1.125>, 0.21875 }
    cylinder { <0.4375,-1/16,1.125>, <0.4375,-3/8,1.125>, 3/16 }
    cylinder { <0.4375,-3/8,1.125>, <0.4375,-3/4,1.125>, 1/8 }
    cylinder { <0.4375,-3/8,1.125-3/322>, <0.4375,-3/4,1.125-3/32>, 1/16 }
  }
  union {
    prism { -1/32, 3/32, 10,   <0.0248,0.0574>, <-0.6902,0.8136>, <-0.4735,1.9615>,
                <-0.16,2.2023>, <0.7724,2.2097>, <1.2545,1.9325>, <1.6099,0.9746>,
                <1.4978,0.5912>, <0.8539,0.0588>, <0.0248,0.0574> }
                
    cylinder { <0.4375,-1/32,1.125>, <0.4375,5/16,1.125>, 0.1425 }
  }

  // comment {
//  translate -z
//  rotate 180*x
//  translate z  
  // }
  texture { plRed }
  translate <-0.4375,0,-1.125>
  rotate -90*x
}

#declare YellowGear =
difference {
  union {
    prism { 0, 3/16, 10,   <0,0>, <-0.2542,0.1818>, <-0.6537,1.1663>,
               <-0.3655,1.8587>, <0.5938,2.2996>, <1.5410,1.8454>,
               <1.7486,1.2616>, <1.6153,0.3653>, <1.1875,0>, <0,0>
               texture { plYellow normal { wood 0.15 turbulence 0.03 translate <-6-6,0> scale 0.3 } }
    }
    cylinder { <0.59375,-3/8,1.09375>, <0.59375,4/16,1.09375>, 0.171875 }
    union {
      #declare ang = 0;
      #while (ang < 360)
        cylinder { <0,0,1.03125>, <0,0.375,1.03125>, 1/32 rotate ang*y }
        #declare ang = ang + 36;
      #end
      translate <0.59375,3/16,1.09375>
    }      
    union {
      prism { -1/16, 1/16, 5, <0,0>, <9/16,0>, <9/16,1/4>, <1/8,1/4>, <0,0> }
      cylinder { <9/16,0,0>, <9/16,0,1/4>, 1/16 }
      rotate 90*x translate (19/16-3/8)*x rotate 105*y translate <0.59375,0,1.09375>
    }
  }
  cylinder { <0.59375,-1/2,1.09375>, <0.59375,5/16,1.09375>, 0.109375 }
  texture { plYellow }
  translate <-0.59375,-3/16,-1.09375>
}

#declare scrollwork =
union {
  sphere { 0.25*x, 3/64 rotate -60*y translate 0.25*x }
  object { atorus (0.25, 1/32, 60, 300) translate 0.25*x }   
  sphere { 0.25*x, 1/32 rotate -300*y translate 0.25*x }
  
  object { atorus (1.164, 1/32, 313, 359) translate <-0.4139,0,0.6394> }
  sphere { 1.164*x, 1/32 rotate -359*y translate <-0.4139,0,0.6394> }
  
  object { atorus (0.25, 1/32, 0, 90) translate <0.5,0,0.625> }
  object { atorus (0.125, 1/32, 90, 270) translate <0.5,0,0.75> }
  sphere { 0.125*x, 3/64 rotate -270*y translate <0.5,0,0.75> }
  
  object { atorus (0.4203, 1/32, 90, 134) translate <0.8381,0,-0.3219> }
  sphere { 0.4203*x, 1/32 rotate -134*y translate <0.8381,0,-0.3219> }
  cylinder { <0.8381,0,0.0985>, <0.9856,0,0.0985>, 1/32 }
  sphere { <0.9856,0,0.0985>, 3/64 }

  object { atorus (3.5987, 1/32, 133, 145) translate <3.5908,0,-1.9127> }
  sphere { 3.5987*x, 1/32 rotate -133*y translate <3.5908,0,-1.9127> }
  
  object { atorus (0.5, 1/32, 90, 135) translate <1.5,0,0.375> }
  object { atorus (0.25, 1/32, 0, 180) translate <1.5,0,0.625> }  
  cylinder { <1.25,0,0.625>, <1.25,0,0.5>, 1/32 }
  sphere { <1.25,0,0.5>, 3/64 }
  
  object { atorus (0.125, 1/32, 180, 0) translate <1.625,0,0.625> }
  cylinder { <1.5,0,0.625>, <1.5,0,0.75>, 1/32 }
  sphere { <1.5,0,0.75>, 3/64 }

  texture { plYellow }   
  scale <0.97,0.5,0.97>
}

#declare LampPost =
union {               
  cylinder { 0, -1/2*y, 1/8 }
  object { rdisk (7/32, 1/16) translate 1/32*y }
  //cylinder { 0, 1/16*y, 6/32 }
  //torus { 6/32, 1/32 translate 1/32*y }
  prism { -1/32, 1/32, 5, <9/64,0>, <3/32,2.53125>, <-3/32,2.53125>, <-9/64,0>, <9/64,0>
             rotate -90*x translate 1/16*y }
  prism { -1/32, 1/32, 5, <9/64,0>, <3/32,2.53125>, <-3/32,2.53125>, <-9/64,0>, <9/64,0>
             rotate -90*x rotate 90*y translate 1/16*y }
  
  // main pole
  cylinder { 2.59375*y, 5.5*y, 3/32 }
  object { rdisk (1/8, 1/16) translate 2.5625*y }
  object { rdisk (1/8, 1/16) translate (2.875+1/32)*y }
  object { rdisk (1/8, 1/16) translate (3.125+1/32)*y }
  object { rdisk (1/8, 1/16) translate (5.5+1/32)*y }

  // cross bar
  cylinder { <-0.875,4.875+1/32,0>, <2.875,4.875+1/32,0>, 3/32 }
  object { rdisk (1/4, 1/16) rotate 90*z translate <-1/16,4.875+1/32,0> }
  object { rdisk (1/4, 1/16) rotate 90*z translate <1/16,4.875+1/32,0> }
  object { rdisk (1/8, 1/16) rotate 90*z translate <-0.875-1/32,4.875+1/32,0> }
  intersection {
    sphere { <3/32+2+5/64+1/16,4.875+1/32,0>, 5/32 }
    box { <3/32+2+5/64+1/16-5/32,4.875+1/32-5/32,-5/32>, <3/32+2+5/64+1/16,4.875+1/32+5/32,5/32> }
  }
  cone { <2.875,4.875+1/32,0>, 3/32, <2.875+1/8,4.875+1/32,0>, 0 }
  sphere { <2.875+1/8,4.875+1/32,0>, 1/16 }
  box { <2.875-1/16,4.875+1/32,-1/64>, <2.875+1/32,4.875+1/32+3/32+1/64,1/64> }

  // scrollwork and supports
  cylinder { (3.875-0/32)*y, (3.875+2/32)*y, 7/64 }
  cylinder { <3/32+0.5,4.875+1/32,0>, <3/32+0.5+2/32,4.875+1/32,0>, 7/64 }
  cylinder { <3/32+1.5-2/32,4.875+1/32,0>, <3/32+1.5,4.875+1/32,0>, 7/64 }
  cylinder { <3/32+1.75+5/64,4.875-1/16-1/4-1/32,0>, <3/32+1.75+5/64,4.875-1/16-1/4+1/32,0>, 3/32 }
  object { scrollwork rotate -90*x translate <3/32+1/32,3.875+2/32,0> }

  // vertical part
  cylinder { <3/32+1.75+5/64,4.875+1/32,0>, <3/32+1.75+5/64,4.875+1/32-1.03125,0>, 5/64 }
  //cylinder { <3/32+1.75+5/64,4.875-1/2,0>, <3/32+1.75+5/64,4.875-1/2-1/16,0>, 3/16 }
  cone { <3/32+1.75+5/64,4.875-1/2-1/16,0>, 3/16, <3/32+1.75+5/64,4.875-1/2,0>, 5/64 }
  cylinder { <3/32+1.75+5/64,4.875-1/2-2/16,0>, <3/32+1.75+5/64,4.875-1/2-1/16,0>, 3/16 }
  object { rdisk (7/32, 1/16) translate <3/32+1.75+5/64,4.875-3/4,0> }
  
  blob {
    threshold 0.2
    sphere { 0, 1, 1 }
    sphere { -0.5*z, 0.5, -2 scale <0.9,1.1,1> }
    sphere { 0.5*z, 0.5, -2 scale <0.9,1.1,1> }
    scale <3/8,3/4,3/16>
    scale <0.68,0.68,0.57>
    translate <3/32+1.75+5/64,4.875-3/4-9/16,0>
  }

  texture { plYellow }
}

#declare xwave =
normal {
    gradient x
    normal_map {
      [0.35 waves 0]
      [0.35 gradient x 0.2 scale 0.1]
      [0.6 gradient x 0.2 scale 0.1]
      [0.6 waves 0]
      [1 waves 0] 
    }
}
#declare ywave =
normal {
    gradient y
    normal_map {
      [0.5 xwave]
      [0.5 gradient y 0.5 scale 0.1 ]
      [1.0 gradient y 0.5 scale 0.1 ]
    }   
    scale 1.2
}    

#declare bootbase =
blob {
  threshold 0.5
  
  sphere { <1,0,0>, 1, 0.8 }
  sphere { <0.7,0.5,0>, 0.5, -0.3 }
  sphere { <0.1,0.3,-0.5>, 0.5, -0.15 } 
  sphere { <0.1,0.3,-0.5>, 0.2, -0.15 } 
  sphere { <0.1,0.3,+0.5>, 0.5, -0.15 } 
  sphere { <0.1,0.3,+0.5>, 0.2, -0.15 } 
  cylinder { <0,0.1,0>, <0,1,0>, 1, 0.8 scale <1.2,1,0.8> }
  sphere { <-0.1,0.2,0>, 1, 0.2 }
  cylinder { <-0.1,1.8,-1>, <-0.1,1.8,1>, 0.7, -0.97 }
  //cylinder { <0.2,1.3,-1>, <0.2,1.3,1>, 0.5, -0.5 }
}

#declare Boot =
difference {
  union {
    union {
      intersection {
        object { bootbase texture { plGreen normal { ywave } } }
        box { <-2,-0.15,-2>, <2,2,2> }
      }
      difference {
        intersection {
          object { bootbase }
          box { <-2,0,-2>, <2,0.1,2> }
          scale <1,1.5,1> 
          translate -0.3*y 
        }
        box { <0,-0.5,-1>, <1,0,1>
          rotate -12*z
          translate <0.2,-0.17,0>
        }
      }
      translate <0,0.3,0>
      scale <0.56,0.44,0.375>
    }    
    
    cylinder { 0.3*y, 3.5*y, 3/32 }
    cylinder { <-7/32,3.5,0>, <7/32,3.5,0>, 3/16 rotate 45*y }
  }
  cylinder { <-8/32,3.5,0>, <8/32,3.5,0>, 1/8 rotate 45*y }
                       
  texture { plGreen }  
  
  rotate 135*y
  translate -3.5*y
}

#declare Crank =
union {
  prism { 0, 1/16, 7   <-0.25,0>, <-0.3617,0.1243>, <-0.28125,0.875>, <0.28125,0.875>,
                              <0.3617,0.1243>, <0.25,0>, <-0.25,0> }                
  cylinder { <-0.25,0,0.1123>, <-0.25,1/16,0.1123>, 0.1123 }
  cylinder { <0.25,0,0.1123>, <0.25,1/16,0.1123>, 0.1123 }  
  union {
    prism { 0, 1/15, 5 <-9/32,0>, <-4/32,1.25>, <4/32,1.25>, <9/32,0>, <-9/32,0> }
    cylinder { <0,0,1.25>, <0,1/16,1.25>, 4/32 }
    rotate -11.31*x translate <0,0,0.875>
  }
  object { chcyl (-3/32, 1/2, 3/16, 1/16) translate 3/8*z }
  object { chcyl (1/4, 5/4, 3/32, 1/32) translate 2*z }
  box { <-1/32,0,-5/16>, <1/32,3/8,1.25> 
                rotate -11.31*x translate 0.875*z clipped_by { plane { -y, 0 } } }
                               
  texture { plGreen }
  translate -3/8*z
  rotate 90*x
}

//#declare CageSupport =

#macro acshell (y1,y2,r1,r2,t1,t2)
  difference {
    //object { cshell (y1,y2,r1,r2) }
    cylinder { y1*y, y2*y, r1 }
    cylinder { (y1-0.1)*y, (y2+0.1)*y, r2 }
    #if (mod(t2-t1+3600,360)>180)
    intersection {
      plane { z,0 rotate -t1*y }
      plane { -z,0 rotate -t2*y }
    }
    #else
    union {
      plane { z,0 rotate -t1*y }
      plane { -z,0 rotate -t2*y }
    }
    #end
  }             
#end

#declare tooth =
union {
  prism { -3/64, 3/64, 5, <0,0.1263>, <0.1719,0.0271>, <0.1719,-0.0271>, <0,-0.1263>, <0,0.1263> }
  cylinder { <0.15625,-1/32,0>, <0.15625,1/32,0>, 3/64 }
  rotate 90*x
  
  texture { plYellow }
}

#declare CagePole =
union {
  box { <-1/32,0,-5/32>, <1/32,5/8,5/32> }
  object { acshell (-1/32, 1/32, 3/8+5/32, 3/8-5/32, 0, 90) 
                rotate 90*z translate <0,5/8,-3/8> }
  object { acshell (-1/32, 1/32, 3/8+5/32, 3/8-5/32, 270, 0) 
                rotate -90*z translate <0,1+3/8,-3/8> }
  box { <-1/32,11/8,-3/4+5/32>, <1/32,9.375-5/16,-3/4-5/32>  }
  box { <-1/32,9.375-5/16,-3/4>, <1/32,9.375,-3/4-5/32>  }
  cylinder { <0,9.375,-3/4>, <0,9.375,-3/4-5/32>, 1/32 }
  cylinder { <0,9.375-5/16,-3/4+5/32>, <0,9.375-5/16,-3/4-5/32>, 1/32 }
  
  box { <-5/32,0,-3/64>, <5/32,5/8,3/64> }
  object { acshell (-5/32, 5/32, 3/8+1/32, 3/8-3/64, 0, 90) 
                rotate 90*z translate <0,5/8,-3/8> }
  object { acshell (-5/32, 5/32, 3/8+1/32, 3/8-3/64, 270, 0) 
                rotate -90*z translate <0,1+3/8,-3/8> }
  //box { <-5/32,11/8,-3/4+1/32>, <5/32,10.125,-3/4-1/32>  }
  box { <-5/32,11/8,-3/4+3/64>, <5/32,2.5,-3/4-3/64>  }
  box { <-3/32,2.5,-3/4+3/64>, <5/32,2.625,-3/4-3/64>  }
  box { <-3/32,2.625,-3/4+3/64>, <3/32,7.75,-3/4-3/64>  } // 7.75
  box { <-5/32,7.75,-3/4+3/64>, <3/32,8,-3/4-3/64>  }
  box { <-5/32,8,-3/4+3/64>, <5/32,9,-3/4-3/64>  }
  cylinder { <-5/32,9,-3/4>, <5/32,9,-3/4>, 3/64 }

  #declare kth = 0;
  #while (kth < 17)
    object { tooth translate <0, 2.75-5/32+(5/16*kth),-3/4> }
    object { tooth rotate 180*y translate <0, 2.75+(5/16*kth),-3/4> }
    #declare kth = kth + 1;
  #end
  
  // knick-knacks
  object { rdisk ( 5.5/32, 1/16 ) translate 1/32*y }
  box { <-1/32,5/8,-5/32>, <1/32,5/8+3/32,-5/32-1/16> }
  box { <-1/32,5/8,-5/32>, <1/32,5/8+3/32,-5/32-1/16> rotate 90*y }
  box { <-1/32,5/8+3/32,3/64>, <-5/32,5/8+3/32+1/16,5/32> }
  
  texture { plYellow }
  rotate -90*y
}

#declare Thingamajig =
union {
  difference {
    union {
      prism { 0, 1/16, 13, <-6/8,0>, <6/8,0>, <7/8, 1/8>, <7/8,7/8>, <9/16,7/8>, <9/16,5/4>,
                 <0.6859,3.0787>, <-0.6859,3.0787>, <-9/16,5/4>, <-9/16,7/8>,
                 <-7/8,7/8>, <-7/8,1/8>, <-6/8,0> }
      cylinder { <-6/8,0,1/8>, <-6/8,1/16,1/8>, 1/8 }
      cylinder { <6/8,0,1/8>, <6/8,1/16,1/8>, 1/8 }
      prism { 3/16, 1/4, 13, <0.5103,1.3958>, <0.635,1.3958>, <0.7483,3.0745>, <0.6236,3.0829>,
                <-0.6236,3.0829>, <-0.7483,3.0745>, <-0.635,1.3958>, <-0.5103,1.3958>,
                <-0.5103,1.4042>, <-0.623,3.0745>, <0.623,3.0745>, <0.5103,1.4042>, <0.5103,1.3958> }
      prism { 1/16, 1/4, 15, <0.5103,0>, <0.5625,0>, <0.5625,1.25>, <0.6859,3.0787>,
                <0.6236,3.0829>, <-0.6236,3.0829>, <-0.6859,3.0787>, <-0.5625,1.25>, <-0.5625,0>,
                <-0.5103,0>, <-0.5103,1.3958>, <-0.623,3.0745>, <0.623,3.0745>, <0.5103,1.3958>,
                <0.5103,0> }
      intersection {                                    
        union {
          cylinder { <0,3/16,3.125>, <0,1/4,3.125>, 0.75 }
          cylinder { <0,0,3.125>, <0,3/16,3.125>, 0.6875 }
        }
        box { <-4,0,3.0745> <4,1,5> }
      }
    }
    union {        
      cylinder { <0,-1/16,3.125>, <0,5/16,3.125>, 0.625 } 
      cylinder { <0,-1/16,7/8>, <0,2/16,7/8>, 1/8 }
    }
  }
  difference {
    union {
      box { <7/8,1/16,7/8-1/16>, <5/8,-3/8,21/16> }
      prism { -2/16, -1/16, 5, <3/8,0>, <1/4,7/16>, <-6/16,7/16>, <-6/16,0>, <3/8,0>
        rotate 90*y  rotate -90*z translate <7/8,0,7/8> }
    }
    box { <13/16,2/16,7/8>, <9/16,-5/16,20/16> }
    box { <13/16,2/16,7/8>, <9/16,-1/4,22/16> }
  }
  difference {
    union {
      box { <7/8,1/16,7/8-1/16>, <5/8,-3/8,21/16> }
      prism { -2/16, -1/16, 5, <3/8,0>, <1/4,7/16>, <-6/16,7/16>, <-6/16,0>, <3/8,0>
        rotate 90*y  rotate -90*z translate <7/8,0,7/8> }
    }
    box { <13/16,2/16,7/8>, <9/16,-5/16,20/16> }
    box { <13/16,2/16,7/8>, <9/16,-1/4,22/16> }
    scale <-1,1,1>
  }         
  box { <3/8-1/32,0,5/8>, <3/8+1/32,-1/16,11/8> }
  box { <-3/8-1/32,0,5/8>, <-3/8+1/32,-1/16,11/8> }
  object { rdisk (5/32, 1/16) scale <1,1,3/5> rotate 90*x translate <0,1/32,3/32> }
  cylinder { <19/32,0,1/2>, <19/32,9/32,1/2>, 1/16 }
  cylinder { <0.5842,3/16,1.5839>, <0.5842,9/32,1.5839>, 0.06 }
  cylinder { <0.6668,3/16,2.8238>, <0.6668,9/32,2.8238>, 0.06 }
  cylinder { <0,3/16,3.811>, <0,9/32,3.811>, 0.06 }
  cylinder { <-19/32,0,1/2>, <-19/32,9/32,1/2>, 1/16 }
  cylinder { <-0.5842,3/16,1.5839>, <-0.5842,9/32,1.5839>, 0.06 }
  cylinder { <-0.6668,3/16,2.8238>, <-0.6668,9/32,2.8238>, 0.06 }
      
  texture { plRed }
  translate 0.7*y
}

#declare BaseB =
//union {
  difference {
    union {
      prism { 0, 1/16, 23, <0.7806,-0.625>, <2.625,-0.625>, <3.041,-0.4665>, <4.9254,1.214>,
                  <4.9616,1.3445>, <4.5832,2.56>, <4.2929,4.0316>, <3.0665,3.7897>,
                  <3.4777,1.7049>, <2.678,0.625>, <-0.447,0.625>, <-0.572,0.5>,
                  <-0.572,0.1875>, <-1.197,0.1875>, <-1.197,0.5>, <-1.322,0.625>,
                  <-1.6063,0.625>, <-1.7288,0.475>, <-1.3445,-1.4063>, <-1.2464,-1.5038>,
                  <-0.0898,-1.7341>, <0.0368,-1.6834>, <0.7806,-0.625> }
      // corners
      cylinder { <-1.6063,0,0.5>, <-1.6063,1/16,0.5>, 1/8 }
      cylinder { <-1.322,0,0.5>, <-1.322,1/16,0.5>, 1/8 }
      cylinder { <-0.447,0,0.5>, <-0.447,1/16,0.5>, 1/8 }
      cylinder { <-1.222,0,-1.3812>, <-1.222,1/16,-1.3812>, 1/8 }      // ???
      cylinder { <-0.0654,0,-1.6115>, <-0.0654,1/16,-1.6115>, 1/8 }
      cylinder { <2.625,0,0>, <2.625,1/16,0>, 5/8 }
      cylinder { <4.8422,0,1.3073>, <4.8422,1/16,1.3073>, 1/8 }
      // posts
      cylinder { <-1.4151,0,0.375>, <-1.4151,0.25,0.375>, 0.15625 }
      cylinder { <-0.3532,0,0.375>, <-0.3532,0.25,0.375>, 0.15625 }
      cylinder { <0,0,0>, <0,1.125,0>, 0.1875 }
      cylinder { <2.625,0,0>, <2.625,1.125,0>, 0.1875 }
      // rails
      box { <0,0,-1/32>, <1.7224,3/16,1/32> rotate -281.6*y translate <-1.4151,0,0.375> }
      box { <0,0,-1/32>, <0.7145,3/16,1/32> translate <-1.0704,0,-1.3125> }
      prism { -1/32, 1/32, 6, <0,0>, <1.2349,0>, <1.2349,7/16>, <1/8,3/16>, <0,3/16>, <0,0>
                  rotate -90*x rotate -74.8*y translate <-0.3559,0,-1.3125> }
      box { <0,0,-1/32>, <2.625,7/16,1/32> }
      box { <0,0,-1/32>, <1.877,7/16,1/32> rotate -61.5*y translate 2.625*x }
      cylinder { <-0.3559,0,-1.3125,>, <-0.3559,3/16,-1.3125>, 1/32 }
      cylinder { <-1.0704,0,-1.3125,>, <-1.0704,3/16,-1.3125>, 1/32 }
           
      difference {
        cylinder { 0*y, 5/16*y, 0.5938 }
        box { <-0.66,-1/16,-0.66>, <0.66,6/16,0> }
        rotate -11.2*y translate <3.6491,0,3.9046>
      }
      /*/ com {
      difference {
        cylinder { 0*y, 11/32*y, 0.5938 }
        cylinder { 0*y, 11/32*y, 0.5938-1/32 }
        box { <-0.6,0,0.1>, <0.6,5/16,0.6> }
        box { <-3/16,0,0>, <3/16,5/16,0.6> }
        rotate -11.2*y translate <3.6491,0,3.9046>
      } 
      */// }
      union {
        box { <0,0,0>, <1/8,3/32,1.5938> }
        box { <0.6875,0,0>, <0.8125,3/32,1.5938> }
        box { <0,0,0.5938>, <0.8125,3/32,0.8438> }
        rotate -11.2*y translate <3.5589,0,2.2624> 
      }
      
      prism { 0, 1/8, 9, <3.5282,2.2563>, <3.4298,2.1095>, <3.6112,1.1897>, <3.758,1.0913>,
                 <4.6165,1.2606>, <4.7149,1.4074>, <4.5335,2.3272>, <4.3867,2.4257>, <3.5282,2.2563> }
      cylinder { <3.5524,0,2.1337>, <3.5524,1/8,2.1337>, 1/8 }
      cylinder { <4.4109,0,2.3030>, <4.4109,1/8,2.3030>, 1/8 }
      cylinder { <3.7338,0,1.2139>, <3.7338,1/8,1.2139>, 1/8 }
      cylinder { <4.5923,0,1.3832>, <4.5923,1/8,1.3832>, 1/8 }
      prism { -1/16, 1/16, 7, <-0.4688,0>, <0.4688,0>, <0.1875,0.3125>, <0.109,0.719>,
                     <-0.109,0.719>, <-0.1875,0.3125>, <-0.4688,0> translate 1/8*z
                     rotate -90*x rotate 78.85*y translate <3.5818,0,1.6617> }  
      prism { -1/16, 1/16, 7, <-0.4688,0>, <0.4688,0>, <0.1875,0.3125>, <0.109,0.719>,
                     <-0.109,0.719>, <-0.1875,0.3125>, <-0.4688,0> translate 1/8*z
                     rotate -90*x rotate 78.85*y translate <4.5629,0,1.8552> }  
      cylinder { <0,-1/16,0.719>, <0,1/16,0.719>, 0.109 translate 1/8*z
                     rotate -90*x rotate 78.85*y translate <3.5818,0,1.6617> }  
      cylinder { <0,-1/16,0.719>, <0,1/16,0.719>, 0.109 translate 1/8*z
                     rotate -90*x rotate 78.85*y translate <4.5629,0,1.8552> }  
      cylinder { <4.5629,7/16,1.8552>, <3.5818,7/16,1.6617>, 3/32 }
      
      cylinder { <1.875,0,5/8>, <1.875,0,9/16>, 3/16 scale <1,0.9,1> translate 1/16*y }
    }
    union {
      prism { -1/16, 2/16, 5, <-0.3798,-1.2813>, <-0.1324,-0.3687>, <-1.2313,-0.3687>,
                  <-1.0449,-1.2813>, <-0.3798,-1.2813> }
      box { <0,-1/16,0>, <7/8,3/16,7/16> rotate -11.1573*y translate <3.6854,0,1.4592> }
      box { <0,-1/16,0>, <7/16,2/16,3/4> rotate -11.1573*y translate <3.5796,0,3.1265> }
      box { <0,-1/16,0>, <7/16,2/16,0.5938> rotate -11.1573*y translate <3.7428,0,2.2987> }
      // posts
      cylinder { <-1.4151,-0.1,0.375>, <-1.4151,0.35,0.375>, 0.0925 }
      cylinder { <-0.3532,-0.1,0.375>, <-0.3532,0.35,0.375>, 0.0925 }
      cylinder { <0,-0.1,0>, <0,1.225,0>, 0.125 }
      cylinder { <2.625,-0.1,0>, <2.625,1.225,0>, 0.125 }
    }
//  }
  texture { plYellow }
}

#declare phand =
union {
  object { atorus (0.25,3/64,15,90) }
  object { atorus (0.25,3/64,0,90) translate 3/32*y }
  object { atorus (0.25,3/64,0,90) translate 6/32*y }
  object { atorus (0.25,3/64,15,90) translate 9/32*y }
  object { atorus (0.25,3/64,60,90) translate 12/32*y }
  sphere { <0.25,0,0>, 3/64 rotate -15*y }
  sphere { <0.25,3/32,0>, 3/64 }
  sphere { <0.25,6/32,0>, 3/64 }
  sphere { <0.25,9/32,0>, 3/64 rotate -15*y }
  sphere { <0.25,12/32,0>, 3/64 rotate -60*y }

  intersection {
    union {
      torus { 0.25, 3/64 }
      torus { 0.25, 3/64 translate 12/32*y }
      difference {
        cylinder { 0*y, 12/32*y, 0.25+3/64 }
        cylinder { -1/32*y, 13/32*y, 0.25-3/64 }
      }
    }  
    box { <-1,-1,0>, <0,1,1> }
  }
  cylinder { <-0.25,0,0>, <-0.25,12/32,0>, 3/64 }
  sphere { <-0.25,0,0>, 3/64 }
  sphere { <-0.25,12/32,0>, 3/64 }
  object { rdisk (5/32,3/32) rotate 90*z translate <-0.24-3/32,6/32,0> }
    
  translate <0.24+9/64,-6/32,0>
  scale <1,19/15,1>
}
         
#declare pplate = 
difference {
  union {
    cylinder { 0*y, 1/16*y, 3/8 }
    box { <-3/8,0,0>, <0,1/16,3/8> }
  }
  union {
    cylinder { -1/16*y, 2/16*y, 5/32 }
    box { <-0.4,-1/16,-5/32>, <0,2/16,5/32> }
    box { <-0.4,-1/16,-5/32>, <-3/16,2/16,0.4> }
    box { <0,-1/16,-1/32>, <5/16,2/16,1/32> }
  }
}

#declare Pipes =         
union {
  cylinder { 0*y, 4.875*y, 7/64}
  cylinder { <0,1.4375,0>, <0.75,1.4375,0>, 7/64 }
  cylinder { <0,2.9375,0>, <1.125,2.9375,0>, 7/64 }
  cylinder { <1.125,1.8125,0>, <1.125,3.3447,0>, 7/64 }
  cylinder { <2.6402,5.0152,0>, <1.2348,3.6098,0>, 7/64 }
  cylinder { <2.75,5.2803,0>, <2.75,8.25+0.25,0>, 7/64 }
  cylinder { <1.5,6,0>, <1.5,5.2803,0>, 7/64 }      
  cylinder { <1.6098,5.0152,0>, <2.5076,4.1174,0>, 7/64 }
  cylinder { <2.6402,4.0625,0>, <3,4.0625,0>, 7/64 }
  cylinder { <1.125,2.375,0>, <3,2.375,0>, 7/64 }
  cylinder { <2,0.9375,0>, <2,2.375,0>, 7/64 }
  cylinder { <2.1875,0.75,0>, <2.4375,0.75,0>, 7/64 }
  cylinder { <2.625,0,0>, <2.625,0.5625,0>, 7/64 }
  cylinder { <2.75,6.5,0>, <3,6.5,0>, 7/64 } 
  cylinder { <2.75,2.375,0>, <2.75,4.0625,0>, 1/16 }
  cylinder { <1.5,5.3125,0>, <2.75,5.8303,0>, 1/16 }
 
  object { atorus (0.375,7/64,270,0) rotate -90*x translate <0.75,1.8125,0> }
  object { atorus (0.375,7/64,135,180) rotate -90*x translate <1.5,3.3447,0> }
  object { atorus (0.375,7/64,315,0) rotate -90*x translate <2.375,5.2803,0> }
  object { atorus (0.375,7/64,180,225) rotate -90*x translate <1.875,5.2803,0> }
  object { atorus (0.1875,7/64,225,270) rotate -90*x translate <2.6402,4.25,0> }
  object { atorus (0.1875,7/64,180,270) rotate -90*x translate <2.1875,0.9375,0> }
  object { atorus (0.1875,7/64,0,90) rotate -90*x translate <2.4375,0.5625,0> }

  object { phand scale <1,1,-1> translate <3,2.375,0> }
  object { phand translate <3,4.0625,0> }
  object { phand scale <1,1,-1> translate <3,6.5,0> }

  box { <2.75-3/32,8.25-3/16+0.25,-3/4>, <2.75+3/32,8.25+0.25,3/4> }
  prism { -1/32, 1/32, 5, <7/64,0>, <3/8,1/2>, <-3/8,1/2>, <-7/64,0>, <7/64,0>
               rotate -90*x rotate -90*y translate <2.75,8.25-9/16+0.25,0> }

  object { pplate rotate -90*y translate <3.5,6.5+5/16-1/32,0> }

  texture { plBlue }
}

#declare bighand =
#declare sc = 0.7;  
//union {
  blob {
    threshold 0.1
    cylinder { <-1.5,0,-1>, <-1.5,0,1>, 0.7, 0.8 scale <1,sc,1> }
    cylinder { <-1,0,-9/8>, <-1,0,9/8>, 0.7, 0.8 scale <1,sc,1> }
    cylinder { <-0.5,0,-9/8>, <-0.5,0,9/8>, 0.7, 0.8 scale <1,sc,1> }
    cylinder { <0,0,-9/8>, <0,0,9/8>, 0.7, 0.8 scale <1,sc,1> }
  
    sphere { <0.6,0,-9/8>, 0.6, 0.8 scale <1,sc,1> rotate 30*z }
    sphere { <1.1,0,-9/8>, 0.6, 0.8 scale <1,sc,1> rotate 30*z }
    sphere { <1.6,0,-9/8>, 0.6, 0.8 scale <1,sc,1> rotate 30*z }
    sphere { <0.6,0,-3/8>, 0.6, 0.8 scale <1,sc,1> rotate 30*z }
    sphere { <1.1,0,-3/8>, 0.6, 0.8 scale <1,sc,1> rotate 30*z }
    sphere { <1.6,0,-3/8>, 0.6, 0.8 scale <1,sc,1>rotate 30*z }
    sphere { <0.6,0,9/8>, 0.6, 0.8 scale <1,sc,1> rotate 30*z }
    sphere { <1.1,0,9/8>, 0.6, 0.8 scale <1,sc,1> rotate 30*z }
    sphere { <1.6,0,9/8>, 0.6, 0.8 scale <1,sc,1> rotate 30*z }
    sphere { <0.6,0,3/8>, 0.6, 0.8 scale <1,sc,1> rotate 30*z }
    sphere { <1.1,0,3/8>, 0.6, 0.8 scale <1,sc,1> rotate 30*z }
    sphere { <1.6,0,3/8>, 0.6, 0.8 scale <1,sc,1> rotate 30*z }
    
    sphere { 0, 0.8, 0.8 scale <1.5,0.85,1.5> translate <-1.2,0,0.8> }
    sphere { 0, 0.8, 0.8 scale <1.5,0.8,1.5> translate <-1.2,0,-0.8> }
    sphere { 0, 0.8, -0.3 translate <-0.3,0,0> }
    
    sphere { <0,0,0>, 0.6, 0.7 scale <1.5,sc,1> rotate -30*y translate <-0.6-0.5,0.2,16/8-0.4> }
    sphere { <0.6,0,16/8>, 0.6, 0.7 scale <1.5,sc,1> translate <-0.6-0.2,0,-0.2> rotate 15*z translate 0.2*y }
//  }

  scale <0.25,0.25,0.25*0.85>
}          

#declare grnhand =
union {
  object { bighand }
  object { chbox (<-4.5/8,-3/8,-7/32>, <-1.5/8,0,7/32>, 1/16) }
  translate <3/8,3/8,0>
  rotate 180*y
    
  texture { plGreen }
}

#declare Pole =
union {
  cylinder { 0, -8.125*y, 3/32 }
  object { rdisk (9/32, 1/16) }
  sphere { -8.125*y, 3/32 }
  box { <-1/32,0,-9/32>, <1/32,-7/8,9/32> }
  object { grnhand }
  prism { -1/32, 1/32, 6, <0,0>, <9/16,7/32>, <13/16,7/32>, <12/16,5/32>, <12/16,0>, <0,0>
           rotate -90*z translate <1/32,-4.75,2.5/32> }

  texture { plBlue }
}

#macro tubrim(P3,P4,n3,n4)
    #declare Pc3 = P3 + 0.125*n3;
    #declare ax3 = vrotate  (n3, 90);
    #declare Pc4 = P4 + 0.125*n4;
    #declare ax4 = vrotate  (n4, 90);
    #declare cn = 0;
    #declare dc = 180/tbn;
    #while (cn < 180)
      smooth_triangle {
        Pc3-0.125*vaxis_rotate (n3, ax3, cn), vaxis_rotate (n3, ax3, cn),
        Pc4-0.125*vaxis_rotate (n4, ax4, cn), vaxis_rotate (n4, ax4, cn),
        Pc4-0.125*vaxis_rotate (n4, ax4, cn+dc), vaxis_rotate (n4, ax4, cn+dc) }
      smooth_triangle {
        Pc3-0.125*vaxis_rotate (n3, ax3, cn), vaxis_rotate (n3, ax3, cn),
        Pc4-0.125*vaxis_rotate (n4, ax4, cn+dc), vaxis_rotate (n4, ax4, cn+dc),
        Pc3-0.125*vaxis_rotate (n3, ax3, cn+dc), vaxis_rotate (n3, ax3, cn+dc) }
      #declare cn = cn + dc;
    #end
    smooth_triangle {
      Pc3-0.125*vaxis_rotate (n3, ax3, cn), vaxis_rotate (n3, ax3, cn),
      Pc4-0.125*vaxis_rotate (n4, ax4, cn), vaxis_rotate (n4, ax4, cn),
      Pc4, vaxis_rotate (-n4, ax4, cn+90) }
    smooth_triangle {
      Pc3-0.125*vaxis_rotate (n3, ax3, cn), vaxis_rotate (n3, ax3, cn),
      Pc4, vaxis_rotate (n4, ax4, cn+90),
      Pc3, vaxis_rotate (n3, ax3, cn+90) }
#end

#declare tbn = 20;
#declare tubbase =
union {
  #declare an = 94.1;
  #declare da = (265.9-94.1)/tbn;
  #declare bn = 95.7;
  #declare db = (264.3-95.7)/tbn;
  #while (an < 265.9)
    #declare P1 = <0.6875+0.4375*dcos(bn),0,0.4375*dsin(bn)>;
    #declare P2 = <0.6875+0.4375*dcos(bn+db),0,0.4375*dsin(bn+db)>;
    #declare P3 = <0.6875+-0.75+0.6875*dcos(an+da),1.5,0.6875*dsin(an+da)>;
    #declare P4 = <0.6875+-0.75+0.6875*dcos(an),1.5,0.6875*dsin(an)>;
    #declare n3 = <dcos(an+da),0,dsin(an+da)>;
    #declare n4 = <dcos(an),0,dsin(an)>;
    smooth_triangle { P1, <dcos(bn),0,dsin(bn)>,
                      P2, <dcos(bn+db),0,dsin(bn+db)>,
                      P3, n3 }
    smooth_triangle { P1, <dcos(bn),0,dsin(bn)>,
                      P3, n3,
                      P4, n4 }
                      
    tubrim (P3, P4, n3, n4)
    #declare an = an + da;                      
    #declare bn = bn + db;
  #end

  #declare an = 265.9;
  #declare da = (360+94.1-265.9)/tbn;
  #declare bn = 264.3;
  #declare db = (360+95.7-264.3)/tbn;
  #while (an < 360+94.1)
    #declare P1 = <2.5+0.6875*dcos(bn),0,0.6875*dsin(bn)>;
    #declare P2 = <2.5+0.6875*dcos(bn+db),0,0.6875*dsin(bn+db)>;
    #declare P3 = <2.75+0.9375*dcos(an+da),1.5,0.9375*dsin(an+da)>;
    #declare P4 = <2.75+0.9375*dcos(an),1.5,0.9375*dsin(an)>;
    #declare n3 = <dcos(an+da),0,dsin(an+da)>;
    #declare n4 = <dcos(an),0,dsin(an)>;
    smooth_triangle { P1, <dcos(bn),0,dsin(bn)>,
                      P2, <dcos(bn+db),0,dsin(bn+db)>,
                      P3, n3 }
    smooth_triangle { P1, <dcos(bn),0,dsin(bn)>,
                      P3, n3,
                      P4, n4 }
                      
    tubrim (P3, P4, n3, n4)
    #declare an = an + da;                      
    #declare bn = bn + db;
  #end

  #declare P1 = <0.6875+0.4375*dcos(264.3),0,0.4375*dsin(264.3)>;
  #declare P2 = <2.5+0.6875*dcos(264.3),0,0.6875*dsin(264.3)>; 
  #declare P3 = <2.75+0.9375*dcos(265.9),1.5,0.9375*dsin(265.9)>;
  #declare P4 = <0.6875+-0.75+0.6875*dcos(265.9),1.5,0.6875*dsin(265.9)>;
  #declare n3 = <dcos(265.9),0,dsin(265.9)>;
  #declare n4 = <dcos(265.9),0,dsin(265.9)>;
  smooth_triangle { P1, <dcos(264.3),0,dsin(264.3)>, P2, <dcos(264.3),0,dsin(264.3)>, P3, n3 }
  smooth_triangle { P1, <dcos(264.3),0,dsin(264.3)>, P3, n3, P4, n4 }
  tubrim (P3, P4, n3, n4)

  #declare P1 = <0.6875+0.4375*dcos(95.7),0,0.4375*dsin(95.7)>;
  #declare P2 = <2.5+0.6875*dcos(95.7),0,0.6875*dsin(95.7)>; 
  #declare P3 = <2.75+0.9375*dcos(94.1),1.5,0.9375*dsin(94.1)>;
  #declare P4 = <0.6875+-0.75+0.6875*dcos(94.1),1.5,0.6875*dsin(94.1)>;
  #declare n3 = <dcos(94.1),0,dsin(94.1)>;
  #declare n4 = <dcos(94.1),0,dsin(94.1)>;
  smooth_triangle { P1, <dcos(95.7),0,dsin(95.7)>, P2, <dcos(95.7),0,dsin(95.7)>, P3, n3 }
  smooth_triangle { P1, <dcos(95.7),0,dsin(95.7)>, P3, n3, P4, n4 }
  tubrim (P3, P4, n3, n4)

  polygon { tbn+4,
    #declare bn = 95.7;
    #declare db = (264.3-95.7)/tbn;
    #while (bn < 264.3)
      <0.6875+0.4375*dcos(bn),0.4375*dsin(bn)>,
      #declare bn=bn+db;
    #end
    <2.5+0.6875*dcos(264.3),0.6875*dsin(264.3)>, <2.1,0>,
    <2.5+0.6875*dcos(95.7),0.6875*dsin(95.7)>, <0.6875+0.4375*dcos(95.7),0.4375*dsin(95.7)>
    rotate 90*x
  }
  disc { <2.5,0,0>, y, 0.6875, 0.3125 }
}

#declare Tub =
union {
  object { tubbase translate -0.6875*x }
  difference {
    union {
      cylinder { <2.5-0.6875,0,0>, <2.5-0.6875,-0.5,0>, 0.3125+1.5/32 }
      cylinder { <0,0,0>, <0,-9/16,0>, 3/16 }
      prism { -1/32, 1/32, 5, <-7/16,0>, <-3/16,9/16>, <3/16,9/16>, <7/16,0>, <-7/16,0>
                       rotate 90*x }
      cylinder { <-0.6875-0.75-1/4+3/16,1.5,0>, <-0.6875-0.75-1/4+3/16,1.5-0.625,0>, 3/16 }
      box { <-0.6875-0.75-1/4+6/16+1/32,1.5,1/32>, <-0.6875-0.75+6/16+1/32,1.5-0.625,-1/32> }
    }
    union {
      cylinder { <2.5-0.6875,0.1,0>, <2.5-0.6875,-0.6,0>, 0.3125 }
      cylinder { <0,1/16,0>, <0,-10/16,0>, 3/16-1/16 }
      cylinder { <-0.6875-0.75-1/4+3/16,1.4,0>, <-0.6875-0.75-1/4+3/16,1.5-0.725,0>, 3/16-1/16 }
      cylinder { -y, y, 0.6875  scale <0.9,1,1> //scale <1/cos(atan2(1,1.5)),1,1>  
                                rotate degrees(atan2(1,1.5))*z translate <-0.75,1.5,0> }
    }
  }
  translate 9/16*y
  
  texture { plRed }
}

#declare Diver =
union {
  blob {
    threshold 0.6
  
    cylinder { <1,0,0>, <1,0,-3>, 1.6, 0.8 }
    cylinder { <1,0,0>, <1,3,-1.5>, 1.6, 0.8 } 
      sphere { <1,0,0>, 1.8, -0.7 }
    cylinder { <1,3,-1.5>, <1.5,6,-4>, 1.6, 0.8 }
      sphere { <1,3,-1.5>, 1.6, -0.8 }
    cylinder { <1.5,6,-4>, <1.2,11,1>, 1.6, 0.8 }
      sphere { <1.5,6,-4>, 1.6, -0.8 }
    sphere { <1.4,6+5/3,-4+5/3>, 0.8, 0.8 }
    sphere { <1.35,6+7.5/3,-4+7.5/3>, 1.2, 0.8 }
    sphere { <1.3,6+10/3,-4+10/3>, 1.6, 0.8 }
    sphere { <1.25,6+12.5/3,-4+12.5/3>, 2.0, 0.8 }

    cylinder { <-1,0,0>, <-1,0,-3>, 1.6, 0.8 }
    cylinder { <-1,0,0>, <-1,3,-1.5>, 1.6, 0.8 } 
      sphere { <-1,0,0>, 1.8, -0.7 }
    cylinder { <-1,3,-1.5>, <-1.5,6,-4>, 1.6, 0.8 }
      sphere { <-1,3,-1.5>, 1.6, -0.8 }
    cylinder { <-1.5,6,-4>, <-1.2,11,1>, 1.6, 0.8 }
      sphere { <-1.5,6,-4>, 1.6, -0.8 }
    sphere { <-1.4,6+5/3,-4+5/3>, 0.8, 0.8 }
    sphere { <-1.35,6+7.5/3,-4+7.5/3>, 1.2, 0.8 }
    sphere { <-1.3,6+10/3,-4+10/3>, 1.6, 0.8 }
    sphere { <-1.25,6+12.5/3,-4+12.5/3>, 2.0, 0.8 }

    cylinder { <0,0,0>, <0,9,-3>, 2.6, 0.8 scale <2.5,1,1> translate <0,11,1> }
      sphere { <0,14,-0.2>, 2, 0.8 scale <1.3,1,1> }
    cylinder { <-8,15,1.9>, <8,15,1.9>, 1.5, -0.4 translate <0,-0.9,-0.9> }
      cylinder { <0,0,0>, <0,1.5,-0.5>, 1.3, -0.7 scale <1.5,1,1> translate <0,19,0.2> }
   
    cylinder { <2.5,19,-2>, <7,17,-2>, 1.06, 0.75 }
    cylinder { <-2.5,19,-2>, <-7,17,-2>, 1.06, 0.75 }
    cylinder { <7,16.5,-2>, <-7,16.5,-2>, 1.06, 0.7 }
  
    sphere { <0,16.5,-3>, 1.2, 0.8 scale <0.5,1,1> }
  
    sphere { <0,23,-2.7>, 3.0, 0.9 }
    sphere { <0,22.5,-2.7>, 1.5, 0.9 }
      cylinder { <0,22,-2.7+0.7/3>, <0,2,-2-0.7/3>, 2, -0.11 }
    sphere { <0,22.5,-4>, 0.5, 0.9 scale <0.5,1,1> }
    sphere { <0,21.8,-3.6>, 0.5, 0.9 scale <2,1,1> }
    sphere { <0.5,22.8,-4>, 0.3, -0.9 }
    sphere { <-0.5,22.8,-4>, 0.3, -0.9 }
     
    scale 1/8
    translate <0,1/8,1/4>
  }
  cylinder { 0, 1/8*y, 1/2 } 
  
  texture { plGreen }
}

#declare cbar =
difference {
  sor { 5, <1.4375+dcos (68.55),-dsin (68.55)>, <1.4375,0>, <0.75,1.75>, <0.3125,2>, <0,2> }
  sor { 5, <1.4375-1/16+dcos (68.55),-0.01-dsin (68.55)>, <1.4375-1/16,-0.01>, 
                              <0.75-1/16,1.75>, <0.3125,2-1/16>, <0,2-1/16> }
  box { <-2,-0.01,3/32>, <2,2.01,2> }
  box { <-2,-0.01,-3/32>, <2,2.01,-2> }
  cylinder { 0, 2.01*y, 3/16 }
}

#declare Cage =
union {
  object { cbar }
  object { cbar rotate 45*y }
  object { cbar rotate 90*y }
  object { cbar rotate 135*y }
  difference {
    sor { 4, <1.4375+1/8*dcos (68.55)+0.5/16,-1/8*dsin (68.55)>, 
                <1.4375-0/8*dcos (68.55)+0.5/16,0/8*dsin (68.55)>, 
                <1.4375-2/8*dcos (68.55)+0.5/16,2/8*dsin (68.55)>,
                <1.4375-3/8*dcos (68.55)+0.5/16,3/8*dsin (68.55)> }
    sor { 4, <1.4375+2/8*dcos (68.55)-0/16,-2/8*dsin (68.55)>, 
                <1.4375+1/8*dcos (68.55)-0/16,-1/8*dsin (68.55)>, 
                <1.4375-3/8*dcos (68.55)-0/16,3/8*dsin (68.55)>,
                <1.4375-4/8*dcos (68.55)-0/16,4/8*dsin (68.55)> }
  }
  difference {
    sor { 4, <1.4375-6/8*dcos (68.55)-0.5/16,6/8*dsin (68.55)>, 
                <1.4375-7/8*dcos (68.55)-0.5/16,7/8*dsin (68.55)>, 
                <1.4375-9/8*dcos (68.55)-0.5/16,9/8*dsin (68.55)>,
                <1.4375-10/8*dcos (68.55)-0.5/16,10/8*dsin (68.55)> }
    sor { 4, <1.4375-5/8*dcos (68.55)-1.5/16,5/8*dsin (68.55)>, 
                <1.4375-6/8*dcos (68.55)-1.5/16,6/8*dsin (68.55)>, 
                <1.4375-10/8*dcos (68.55)-1.5/16,10/8*dsin (68.55)>,
                <1.4375-11/8*dcos (68.55)-1.5/16,11/8*dsin (68.55)> }
  }
  object { cshell (-1/16*y, 0*y, 3.125/2, 1.4375) }
  object { cshell ((2-1/16)*y, 2*y, 6/16, 3/16) }
  object { cshell (2*y, 2.03*y, 4/16, 3/16) }

  translate 1/16*y
  texture { plRed }
}

#declare buckarms =
union {
  box { <-1/16,0,0>, <0-0.001,7/8,1/2> }
  box { <1+0.001,0,0>, <1+1/16,7/8,1/2> }
  box { <1/2-3/32,0,1/2+0.001>, <1/2+3/32,3/4-1/8,1/2+1/16> }
  box { <1/2-1/32,0,1/2+0.001>, <1/2+1/32,3/4-1/8,1/2+1/8> }
  prism { -1/4-1/32, -1/4+1/32, 4, <0,0>, <-4/16,0>, <0,4/8>, <0,0> rotate -90*x }
  prism { -1/4-1/32, -1/4+1/32, 4, <1,0>, <1+4/16,0>, <1,4/8>, <1,0> rotate -90*x }
  cylinder { <0,3/4,1/4>, <1/8,3/4,1/4>, 1/16 }
  cylinder { <1,3/4,1/4>, <1-1/8,3/4,1/4>, 1/16 }
}

#declare stairbase =
difference {   
  union {   
    union {
      box { <0,0,0>, <2.3125,-0.625,0.875> rotate -8*x rotate 9*z translate 0.25*y }
      box { <0,0,0>, <2.375,-0.825,0.625> rotate -8*x rotate -2*z translate <0.125,0.825,0.875>}
      box { <0,0,0>, <2.4,-1,0.625> rotate -4*x rotate 4*z translate <0.0625,1,1.5> }
      box { <0,0,0>, <2.375,-1.5,0.625> rotate -2*x rotate -5*z translate <0.0625,1.5,2.125> }
      box { <0,0,0>, <2.375,-1.5,0.75> rotate -5*x rotate 7*z translate <0.0625,1.5,2.625> }
      box { <0,0,0>, <2.375,-2.125,0.75> rotate -4*x rotate -5*z translate <0,2.125,3.25> }
      box { <0,0,0>, <2.5,-2.125,1> rotate -2*x rotate 7*z translate <0,2.125,4> }
      texture { plBlue } 
      normal { wood 0.8 rotate 90*y translate 100*z turbulence 0.08 scale 0.1 }
    }

    box { <0.25,0,0>, <2+0.25,-2.125,1> rotate 7*z translate <0,2.125,4.75> }
      box { <0,0,0>, <2.3105,-0.625,0.875> rotate -8*x rotate 9*z translate <0.001,0.249,-0.001> }
      box { <0,0,0>, <2.375,-0.825,0.625> rotate 6*x rotate -2*z translate <0.125,0.825,0.875> }
      box { <0,0,0>, <2.4,-1,0.625> rotate 5*x rotate 4*z translate <0.0625,1,1.5> }
      box { <0,0,0>, <2.375,-1.5,0.625> rotate 12*x rotate -5*z translate <0.0625,1.5,2.125> }
      box { <0,0,0>, <2.375,-1.5,0.75> rotate 9*x rotate 7*z translate <0.0625,1.5,2.625> }
      //box { <0,0,0>, <2.375,-1.5,0.75> rotate -5*x rotate 0*z translate <0.0625,1.5,2.625> }
      box { <0,0,0>, <2.375,-2.125,0.75> rotate 2*x rotate -5*z translate <0,2.125,3.25> }
      box { <0,0,0>, <2.5,-2.125,1> rotate 5*x rotate 7*z translate <0,2.125,4> }

    box { <0.125,0,0.125>, <0.125+1/16,0.125,0.75> rotate -8*x rotate 9*z translate 0.25*y }
      box { <0.75,0,1/16/*0.25*/>, <2.25,0.1875,1/16/*0.25*/+1/16> rotate -8*x rotate 9*z translate 0.25*y }
      box { <2.1875,0,0.3125>, <2.1875+1/16,1.5/8,0.5> rotate -8*x rotate 9*z translate 0.25*y }
    box { <2.25,0,0>, <2.25+1/16,1.5/8,0.3125> rotate -8*x rotate -2*z translate <0.125,0.825,0.875> }
      box { <0.1875,0,0>, <0.75,2/8,1/16> rotate -8*x rotate -2*z translate <0.125,0.825,0.875> }
      box { <0.75,0,0>, <1.375,1/8,1/16> rotate -8*x rotate -2*z translate <0.125,0.825,0.875> }
      box { <0.125,0,0.125>, <0.125+1/16,1.5/8,0.375> rotate -8*x rotate -2*z translate <0.125,0.825,0.875> }
    box { <0.25,0,0.125>, <0.25+1/16,1.5/8,0.4325> rotate -4*x rotate 4*z translate <0.0625,1,1.5> }
      box { <0.875,0,1/16>, <2.375,1/8,2/16> rotate -4*x rotate 4*z translate <0.0625,1,1.5> }
      box { <2.375-1/8,0,2/16>, <2.375-1/16,0.75/8,0.5> rotate -4*x rotate 4*z translate <0.0625,1,1.5> }
    box { <2.25,0,1/16>, <2.25+1/16,1.5/8,3/8> rotate -2*x rotate -5*z translate <0.0625,1.5,2.125> }
      box { <1/8,0,0>, <5/8,2/8,1/16> rotate -2*x rotate -5*z translate <0.0625,1.5,2.125> }
      box { <5/8,0,0>, <13/8,1/8,1/16> rotate -2*x rotate -5*z translate <0.0625,1.5,2.125> }
      box { <1/8,0,0>, <1/8+1/16,2/8,3/8> rotate -2*x rotate -5*z translate <0.0625,1.5,2.125> }
    box { <1/8,0,0>, <1/8+1/16,1.5/8,3/8> rotate -5*x rotate 7*z translate <0.0625,1.5,2.625> }
      box { <0.875,0,0>, <2.25,1/8,1/16> rotate -5*x rotate 7*z translate <0.0625,1.5,2.625> }
    box { <2.125,0,0>, <2.125+1/16,1.5/8,1/4> rotate -4*x rotate -5*z translate <0,2.125,3.25> }
      box { <1/8,0,0>, <1.5,1/8,1/16> rotate -4*x rotate -5*z translate <0,2.125,3.25> }
      box { <1/8,0,0>, <1/8+1/16,1/8,1.5/8> rotate -4*x rotate -5*z translate <0,2.125,3.25> }
    box { <1/8,0,0>, <1/8+1/16,1/8,5/8> rotate -2*x rotate 7*z translate <0,2.125,4> }
      box { <1,0,1/8>, <2,1/8,1/8+1/16> rotate -2*x rotate 7*z translate <0,2.125,4> }

    object { buckarms rotate -7*y translate <0.75,2.125,5> }
    
    cylinder { <1/2,0,1/8>, <1/2,1/8,1/8>, 3/16 }
      sphere { <1/2,1/8,1/8>, 3/16 }
    cylinder { <4/2,0,1/8>, <4/2,1/8,1/8>, 3/16 }
      sphere { <4/2,1/8,1/8>, 3/16 }

    cylinder { <1/2,0,5.75-1/8>, <4/4,2-3/16,5.75-1/8>, 3/16 }
      sphere { <1/2,2-3/16,5.75-1/8>, 3/16 }
    cylinder { <4/2,0,5.75-1/8>, <4/2,2.25-3/16,5.75-1/8>, 3/16 }
      sphere { <4/2,2.25-3/16,5.75-1/8>, 3/16 }
  }
  box { <-1,0,0>, <5,-5,7> }
  box { <-1,0,0>, <5,-7,-4.5> rotate -25*x translate <0,1.75,4.375> }
  box { <-1,-1,4.375>, <5,1.75,7> }
  //union {
    box { <1/16,-1/16,1/16>, <2.3125,-0.625,0.875>-<1/16,-1/16,1/16> rotate -8*x rotate 9*z translate 0.25*y }
    box { <1/16,-1/16,1/16>, <2.375,-0.825,0.625>-<1/16,-1/16,1/16> rotate -8*x rotate -2*z translate <0.125,0.825,0.875>}
      box { <1/16,-1/16,1/16>, <2.375,-0.825,0.625>-<1/16,-1/16,1/16> rotate 6*x rotate -2*z translate <0.125,0.825,0.875> }
    box { <1/16,-1/16,1/16>, <2.4,-1,0.625>-<1/16,-1/16,1/16> rotate -4*x rotate 4*z translate <0.0625,1,1.5> }
      box { <1/16,-1/16,1/16>, <2.4,-1,0.625>-<1/16,-1/16,1/16> rotate 5*x rotate 4*z translate <0.0625,1,1.5> }
    box { <1/16,-1/16,1/16>, <2.375,-1.5,0.625>-<1/16,-1/16,1/16> rotate -2*x rotate -5*z translate <0.0625,1.5,2.125> }
      box { <1/16,-1/16,1/16>, <2.375,-1.5,0.625>-<1/16,-1/16,1/16> rotate 12*x rotate -5*z translate <0.0625,1.5,2.125> }
    box { <1/16,-1/16,1/16>, <2.375,-1.5,0.75>-<1/16,-1/16,1/16> rotate -5*x rotate 7*z translate <0.0625,1.5,2.625> }
      box { <1/16,-1/16,1/16>, <2.375,-1.5,0.75>-<1/16,-1/16,1/16> rotate 9*x rotate 7*z translate <0.0625,1.5,2.625> }
      //box { <1/16,-1/16,1/16>, <2.375,-1.5,0.75>-<1/16,-1/16,1/16> rotate -5*x rotate 0*z translate <0.0625,1.5,2.625> }
    box { <1/16,-1/16,1/16>, <2.375,-2.125,0.75>-<1/16,-1/16,1/16> rotate -4*x rotate -5*z translate <0,2.125,3.25> }
      box { <1/16,-1/16,1/16>, <2.375,-2.125,0.75>-<1/16,-1/16,1/16> rotate 2*x rotate -5*z translate <0,2.125,3.25> }
    box { <1/16,-1/16,1/16>, <2.5,-2.125,1>-<1/16,-1/16,1/16> rotate -2*x rotate 7*z translate <0,2.125,4> }
      box { <1/16,-1/16,1/16>, <2.5,-2.125,1>-<1/16,-1/16,1/16> rotate 5*x rotate 7*z translate <0,2.125,4> }
    box { <1/16+0.25,-1/16,1/16>, <2+0.25,-2.125,1>-<1/16,-1/16,1/16> rotate 7*z translate <0,2.125,4.75> }
  //}
  box { <0,0,0>, <1,2.25,1/2> rotate -7*y translate <0.75,0.1,5> }

  bounded_by { box { <-0.5,0,-0.5>, <3.5,4,7> } }
                
  texture { plBlue }
  
//  rotate 180*y
//  translate 5*z
  //translate 2*z
//  rotate -120*y
//  translate <3,0,6>
//  rotate -30*x
}

#declare stsms =
union {
  prism { -1/16, 0, 9, <1,0>, <1-1.5/8,0>, <5/8,9/8>, <-5/8,9/8>, <-1+1.5/8,0>,
                     <-1,0>, <-7/8,11/8>, <7/8,11/8>, <1,0> rotate -90*x }
  box { <0,0,0>, <1.75,4/16,-1/16> rotate 4*z translate <-1.75/2,1/8,0> }
  box { <1-1.5/8,0,0>, <1+5/16,-1/16,5/16> }
  box { <-1+1.5/8,0,0>, <-1-5/16,-1/16,5/16> }
  prism { 11/8-1/16, 11/8, 9, <7/8,0>, <7/8,5/16>, <9/16,5/16>, <9/16,3/16>, <-9/16,3/16>,
                        <-9/16,5/16>, <-7/8,5/16>, <-7/8,0>, <7/8,0> }
  prism { -5/16, 0, 5, <1,0>, <7/8,11/8>, <6.5/8,11/8>, <15/16,0>, <1,0> rotate -90*x }
  prism { -5/16, 0, 5, <-1,0>, <-7/8,11/8>, <-6.5/8,11/8>, <-15/16,0>, <-1,0> rotate -90*x }
  prism { -3/16, -2/16, 4, <1,0>, <21/16,0>, <15/16,5/16>, <1,0> rotate -90*x }
  prism { -3/16, -2/16, 4, <-1,0>, <-21/16,0>, <-15/16,5/16>, <-1,0> rotate -90*x }
  
  cylinder { <21/32,21/16,0>, <21/32,21/16,5.25/16>, 1/16 }
  cylinder { <6.5/8,15/16,0>, <6.5/8,15/16,5.25/16>, 1/16 }
  cylinder { <29/32,1/16,0>, <29/32,1/16,5.25/16>, 1/16 }
  cylinder { <-21/32,21/16,0>, <-21/32,21/16,5.25/16>, 1/16 }
  cylinder { <-6.5/8,15/16,0>, <-6.5/8,15/16,5.25/16>, 1/16 }
  cylinder { <-29/32,1/16,0>, <-29/32,1/16,5.25/16>, 1/16 }
                     
  texture { plBlue }

  translate 1/16*y  
}

#declare stsml =
union {
  prism { -1/16, 0, 9, <9/8,0>, <1,0>, <1/2,23/8>, <-1/2,23/8>, <-1,0>, <-9/8,0>,
                <-29/32,25/8>, <29/32,25/8>, <9/8,0> rotate -90*x }
  box { <0,0,0>, <1.875,1/4,-1/16> rotate -4*z translate <-1.875/2,7/8,0> }
  box { <1,0,0>, <23/16,-1/16,5/16> }              
  box { <-1,0,0>, <-23/16,-1/16,5/16> }
  prism { 25/8-1/16, 25/8, 9, <29/32,0>, <29/32,5/16>, <19/32,5/16>, <19/32,3/16>, <-19/32,3/16>,
                        <-19/32,5/16>, <-29/32,5/16>, <-29/32,0>, <29/32,0> }
  prism { -5/16, 0, 5, <9/8,0>, <29/32,25/8>, <27/32,25/8>, <17/16,0>, <9/8,0> rotate -90*x }
  prism { -5/16, 0, 5, <-9/8,0>, <-29/32,25/8>, <-27/32,25/8>, <-17/16,0>, <-9/8,0> rotate -90*x }
  prism { -3/16, -2/16, 4, <9/8,0>, <23/16,0>, <17/16,5/16>, <9/8,0> rotate -90*x }
  prism { -3/16, -2/16, 4, <-9/8,0>, <-23/16,0>, <-17/16,5/16>, <-9/8,0> rotate -90*x }
  
  cylinder { <21/32,49/16,0>, <21/32,49/16,5.25/16>, 1/16 }
  cylinder { <13/16,45/16,0>, <13/16,45/16,5.25/16>, 1/16 }
  cylinder { <29/32,23/16,0>, <29/32,23/16,5.25/16>, 1/16 }
  cylinder { <17/16,1/16,0>, <17/16,1/16,5.25/16>, 1/16 }
  cylinder { <-21/32,49/16,0>, <-21/32,49/16,5.25/16>, 1/16 }
  cylinder { <-13/16,45/16,0>, <-13/16,45/16,5.25/16>, 1/16 }
  cylinder { <-29/32,23/16,0>, <-29/32,23/16,5.25/16>, 1/16 }
  cylinder { <-17/16,1/16,0>, <-17/16,1/16,5.25/16>, 1/16 }
                
  texture { plBlue }
  
  translate 1/16*y
  rotate 180*y
}

#declare Stairs =
union {
  object { stairbase }
  object { stsms translate <2.5/2,-11/8,0> }
  object { stsml translate <2.5/2,-11/8,5.75+1/16> }
  translate 11/8*y
}

#declare Marble =
sphere {
  0, 5/16
  texture { T_Chrome_5E }
}

        
//  The Moray generated mouse
        
//
// ********  OBJECTS  *******
//

#declare BezPtch001 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 3,
      <-1.000000, 0.000000, 0.000000>, <-1.000000, -0.550000, 0.000000>, <-0.550000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-1.210241, 0.000000, 0.411477>, <-1.210241, -0.550000, 0.411477>, <-0.572131, -1.000000, 0.322955>, <-0.022131, -1.000000, 0.322955>, 
      <-1.320895, 0.000000, 0.712301>, <-1.320895, -0.550000, 0.712301>, <-0.572131, -1.000000, 0.612713>, <-0.022131, -1.000000, 0.612713>, 
      <-1.392940, 0.000000, 0.893251>, <-1.392940, -0.483811, 0.893251>, <-0.698331, -0.879656, 0.937513>, <-0.181324, -0.879656, 0.934746>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 3,
      <0.000000, -1.000000, 0.000000>, <0.550000, -1.000000, 0.000000>, <1.000000, -0.550000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
      <-0.022131, -1.000000, 0.322955>, <0.527869, -1.000000, 0.322955>, <1.254503, -0.550000, 1.374162>, <1.254503, 0.000000, 1.374162>, 
      <-0.022131, -1.000000, 0.612713>, <0.527869, -1.000000, 0.612713>, <0.535256, -0.550000, 1.475809>, <0.535256, 0.000000, 1.475809>, 
      <-0.181324, -0.879656, 0.934746>, <0.335683, -0.879656, 0.931980>, <0.089739, -0.483811, 1.535041>, <0.089739, 0.000000, 1.535041>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 3,
      <1.000000, 0.000000, 0.000000>, <1.000000, 0.550000, 0.000000>, <0.550000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, 
      <1.254503, 0.000000, 1.374162>, <1.254503, 0.550000, 1.374162>, <0.527869, 1.000000, 0.322955>, <-0.022131, 1.000000, 0.322955>, 
      <0.535256, 0.000000, 1.475809>, <0.535256, 0.550000, 1.475809>, <0.527869, 1.000000, 0.612713>, <-0.022131, 1.000000, 0.612713>, 
      <0.089739, 0.000000, 1.535041>, <0.089739, 0.483811, 1.535041>, <0.335683, 0.879656, 0.931980>, <-0.181324, 0.879656, 0.934746>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 3,
      <0.000000, 1.000000, 0.000000>, <-0.550000, 1.000000, 0.000000>, <-1.000000, 0.550000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
      <-0.022131, 1.000000, 0.322955>, <-0.572131, 1.000000, 0.322955>, <-1.210241, 0.550000, 0.411477>, <-1.210241, 0.000000, 0.411477>, 
      <-0.022131, 1.000000, 0.612713>, <-0.572131, 1.000000, 0.612713>, <-1.320895, 0.550000, 0.712301>, <-1.320895, 0.000000, 0.712301>, 
      <-0.181324, 0.879656, 0.934746>, <-0.698331, 0.879656, 0.937513>, <-1.392940, 0.483811, 0.893251>, <-1.392940, 0.000000, 0.893251>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 3,
      <-1.392940, 0.000000, 0.893251>, <-1.392940, -0.483811, 0.893251>, <-0.698331, -0.879656, 0.937513>, <-0.181324, -0.879656, 0.934746>, 
      <-1.464985, 0.000000, 1.074201>, <-1.464985, -0.417622, 1.074201>, <-0.824531, -0.759312, 1.262312>, <-0.340517, -0.759312, 1.256779>, 
      <-1.588356, 0.022302, 1.381424>, <-1.588356, -0.146705, 1.381424>, <-1.450078, -0.284984, 1.381424>, <-1.236809, -0.284984, 1.469946>, 
      <-1.682241, -0.019895, 2.138978>, <-1.682241, -0.021445, 2.138978>, <-1.680973, -0.022713, 2.138978>, <-1.679423, -0.022713, 2.138978>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 3,
      <-0.181324, -0.879656, 0.934746>, <0.335683, -0.879656, 0.931980>, <0.089739, -0.483811, 1.535041>, <0.089739, 0.000000, 1.535041>, 
      <-0.340517, -0.759312, 1.256779>, <0.143497, -0.759312, 1.251247>, <-0.355778, -0.417622, 1.594272>, <-0.355778, 0.000000, 1.594272>, 
      <-1.236809, -0.284984, 1.469946>, <-1.023541, -0.284984, 1.558469>, <-0.774609, -0.146705, 1.602730>, <-0.774609, 0.022302, 1.602730>, 
      <-1.679423, -0.022713, 2.138978>, <-1.677873, -0.022713, 2.138978>, <-1.676605, -0.021445, 2.138978>, <-1.676605, -0.019895, 2.138978>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 3,
      <0.089739, 0.000000, 1.535041>, <0.089739, 0.483811, 1.535041>, <0.335683, 0.879656, 0.931980>, <-0.181324, 0.879656, 0.934746>, 
      <-0.355778, 0.000000, 1.594272>, <-0.355778, 0.417622, 1.594272>, <0.143497, 0.759312, 1.251247>, <-0.340517, 0.759312, 1.256779>, 
      <-0.774609, 0.022302, 1.602730>, <-0.774609, 0.191309, 1.602730>, <-1.023541, 0.329588, 1.558469>, <-1.236809, 0.329588, 1.469946>, 
      <-1.676605, -0.019895, 2.138978>, <-1.676605, -0.018345, 2.138978>, <-1.677873, -0.017076, 2.138978>, <-1.679423, -0.017076, 2.138978>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 3,
      <-0.181324, 0.879656, 0.934746>, <-0.698331, 0.879656, 0.937513>, <-1.392940, 0.483811, 0.893251>, <-1.392940, 0.000000, 0.893251>, 
      <-0.340517, 0.759312, 1.256779>, <-0.824531, 0.759312, 1.262312>, <-1.464985, 0.417622, 1.074201>, <-1.464985, 0.000000, 1.074201>, 
      <-1.236809, 0.329588, 1.469946>, <-1.450078, 0.329588, 1.381424>, <-1.588356, 0.191309, 1.381424>, <-1.588356, 0.022302, 1.381424>, 
      <-1.679423, -0.017076, 2.138978>, <-1.680973, -0.017076, 2.138978>, <-1.682241, -0.018345, 2.138978>, <-1.682241, -0.019895, 2.138978>
    }
  }
}
#declare BezPtch002 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.097802, -0.000000, -0.040639>, <-0.097802, -0.121296, -0.040639>, <0.097724, -0.121296, 0.040672>, <0.097724, -0.000000, 0.040672>, 
      <-1.498561, -0.000000, 1.512025>, <-1.498561, -0.121296, 1.512025>, <-1.288707, -0.121296, 1.540368>, <-1.288707, -0.000000, 1.540368>, 
      <-0.496184, -0.000000, 2.208096>, <-0.496184, -0.121296, 2.208096>, <-0.491146, -0.121296, 1.996396>, <-0.491146, -0.000000, 1.996396>, 
      <0.038600, -0.000000, 1.909700>, <0.038600, -0.121296, 1.909700>, <-0.027113, -0.121296, 1.722888>, <-0.027113, -0.000000, 1.722888>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.097724, -0.000000, 0.040672>, <0.097724, 0.121296, 0.040672>, <-0.097802, 0.121296, -0.040639>, <-0.097802, -0.000000, -0.040639>, 
      <-1.288707, -0.000000, 1.540368>, <-1.288707, 0.121296, 1.540368>, <-1.498561, 0.121296, 1.512025>, <-1.498561, -0.000000, 1.512025>, 
      <-0.491146, -0.000000, 1.996396>, <-0.491146, 0.121296, 1.996396>, <-0.496184, 0.121296, 2.208096>, <-0.496184, -0.000000, 2.208096>, 
      <-0.027113, -0.000000, 1.722888>, <-0.027113, 0.121296, 1.722888>, <0.038600, 0.121296, 1.909700>, <0.038600, -0.000000, 1.909700>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.038600, -0.000000, 1.909700>, <0.038600, -0.121296, 1.909700>, <-0.027113, -0.121296, 1.722888>, <-0.027113, -0.000000, 1.722888>, 
      <0.573385, -0.000000, 1.611304>, <0.573385, -0.121296, 1.611304>, <0.436921, -0.121296, 1.449379>, <0.436921, -0.000000, 1.449379>, 
      <-0.552839, -0.000000, -0.214022>, <-0.552839, -0.121296, -0.214022>, <-0.748562, -0.121296, -0.133185>, <-0.748562, -0.000000, -0.133185>, 
      <1.344311, -0.000000, 0.061676>, <1.344311, -0.014906, 0.061676>, <1.349846, -0.014906, 0.023611>, <1.349846, -0.000000, 0.023611>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.027113, -0.000000, 1.722888>, <-0.027113, 0.121296, 1.722888>, <0.038600, 0.121296, 1.909700>, <0.038600, -0.000000, 1.909700>, 
      <0.436921, -0.000000, 1.449379>, <0.436921, 0.121296, 1.449379>, <0.573385, 0.121296, 1.611304>, <0.573385, -0.000000, 1.611304>, 
      <-0.748562, -0.000000, -0.133185>, <-0.748562, 0.121296, -0.133185>, <-0.552839, 0.121296, -0.214022>, <-0.552839, -0.000000, -0.214022>, 
      <1.349846, -0.000000, 0.023611>, <1.349846, 0.014906, 0.023611>, <1.344311, 0.014906, 0.061676>, <1.344311, -0.000000, 0.061676>
    }
  }
  rotate <-90.0, 0.0, -90.0>
  translate  1.0*x
}
#declare CSG002 = union {
  sphere { // Sphere3
    <0,0,0>,1
    scale <0.2, 0.4, 0.7>
    translate  <-0.2, -0.3, 1.4>
  }
  sphere { // Sphere002
    <0,0,0>,1
    scale <0.2, 0.4, 0.7>
    translate  <-0.2, 0.3, 1.4>
  }
}
#declare CSG003 = intersection {
  object { CSG002 }
  plane { // Plane001
    z,0
    rotate -90.0*y
    translate  <-0.205941, 0.010079, 1.330614>
  }
}

#declare Mouse =
union { // CSG001
  object { BezPtch001 }
  sphere { // Sphere001
    <0,0,0>,1
    scale 0.128286
    translate  <-0.496946, 0.380478, 1.46694>
  }
  sphere { // Sphere2
    <0,0,0>,1
    scale 0.128286
    translate  <-0.496946, -0.38048, 1.46694>
  }
  object { BezPtch002 }
  object { CSG003 }
  rotate -90*x
  scale 1/4
}
