
#include "panelboard.inc"
#include "values.inc"

#ifdef (FINAL)
plane {
    -z,0
    texture { PanelPigment }
    scale <2,1,1>*3
    rotate x*90
    translate <0,-th,0>
}
#else
plane { y,-th
	pigment { DarkBrown }
    }
#end

#declare FromAbove =
    camera {
	direction x*3
	right z*4/3
	location <-0.001,7,l/2>
	look_at <0,0,l/2>
    }

#declare FromSide =
    camera {
	direction x*2
	right z*4/3
	location <-5,0.5,l/2>
	look_at <0,0,l/2>
    }

#declare Aesthetic =
    camera {
	direction x*2
	right z*4/3
	location <-4,3,-2>
	look_at
	    <0.2,-0.3,l/2-0.07>
	    +(BallPos-<0,0,l/2>)*0.4
    }

camera { Aesthetic }
//camera { FromAbove }
//camera { FromSide }

#ifdef (FINAL)
light_source {
    <0,20,l/2>
    color White*0.75
    area_light <2,0,0>,<0,0,2>,4,4
    adaptive 0.1
}
light_source {
    <-10,20,0>
    color White*0.35
}
#else
light_source {
    <0,20,l/2-1>
    color White
}
#end


