#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "stones.inc"
#include "woods.inc"

#include "realtime.inc"
#declare MotionBlurFilter=0
#include "robots.inc" // Not motion blurred - too slow

global_settings { max_trace_level 50 }

#declare BlurSteps=20
#declare BlurStep=1
#declare BlurTime=0.10
#declare realtime = realtime-BlurTime
#while (BlurStep <= BlurSteps)
    #declare MotionBlur=BlurStep/BlurSteps
    #declare MotionBlurFilter=(1-MotionBlur*MotionBlur*MotionBlur)
    #declare realtime=realtime+BlurTime/BlurSteps
    // Modulo maxrealtime
    #while ( realtime >= maxrealtime )
	#declare realtime = realtime - maxrealtime
    #end
    #while ( realtime < 0 )
	#declare realtime = realtime + maxrealtime
    #end
    #include "ballobj.inc"
    #include "ball.inc"
    object{ Ball translate BallPos }
    #declare BlurStep = BlurStep + 1
#end

#include "pingpong.inc"
