#include "values.inc"

#declare NetTexture=
	    texture {
	    pigment {
		gradient x
		color_map {
		 [0 Clear]
		 [0.9 Clear]
		 [0.9 White]
		 [1.0 White]
		}
		translate <100,0,l/2+0.01>
		rotate z*45
		scale 0.045
	    }
	    }
	    texture {
	    pigment {
		gradient x
		color_map {
		 [0 Clear]
		 [0.85 Clear]
		 [0.85 White]
		 [1.0 White]
		}
		translate <100,0,l/2+0.01>
		rotate z*-45
		scale 0.045
	    }
	    }

#declare LegW = hw*0.7
#declare LegT = 0.017
#declare LegA = 7
#declare Leg =
    union {
	cylinder { <0,0,0> <0,th*0.9,0> LegT rotate z*-LegA translate +LegW*x }
	cylinder { <0,0,0> <0,th*0.9,0> LegT rotate z*+LegA translate -LegW*x }
	cylinder { <-LegW,0,0> <+LegW,0,0> LegT }
	sphere { <-LegW,0,0> LegT }
	sphere { <+LegW,0,0> LegT }
	rotate x*-10
	texture { T_Chrome_3D }
	translate <0,-th+LegT,0.2>
    }

#declare Table =
    union {
	box {
	    <-hw,-0.03,0>
	    <+hw,0,l>
	    pigment { color rgb<0,0.5,0.2> }
	}
	// End lines
	box {
	    <-hw,0,0>
	    <+hw,0.00001,bw>
	    pigment { color White }
	}
	box {
	    <-hw,0,l-bw>
	    <+hw,0.00001,l>
	    pigment { color White }
	}
	// Side lines
	box {
	    <-hw,0,0>
	    <-hw+bw,0.00001,l>
	    pigment { color White }
	}
	box {
	    <hw-bw,0,0>
	    <hw,0.00001,l>
	    pigment { color White }
	}
	// Center line
	box {
	    <-clw/2,0,0>
	    <+clw/2,0.00001,l>
	    pigment { color White }
	}

	// Net (and supports)
	box {
	    <-netw/2,0,l/2-0.002>
	    <+netw/2,net,l/2+0.002>
	    texture { NetTexture }
	}
	cylinder { // cord
	    <-netw/2,net-0.004,l/2>
	    <+netw/2,net-0.004,l/2>
	    0.004
	    pigment { White }
	}
	cylinder { // post
	    <-netw/2,0,l/2>
	    <-netw/2,net,l/2>
	    0.004
	    pigment { White }
	}
	cylinder { // post
	    <+netw/2,0,l/2>
	    <+netw/2,net,l/2>
	    0.004
	    pigment { White }
	}
	cylinder { // support
	    <+netw/2,0,l/2>
	    <+hw/2,-0.2,l/2>
	    0.004
	    pigment { White }
	}
	cylinder { // support
	    <-netw/2,0,l/2>
	    <-hw/2,-0.2,l/2>
	    0.004
	    pigment { White }
	}
	// Legs
	object { Leg }
	object { Leg rotate y*180 translate l*z}
    }

// Origin sphere
//sphere {
//    <0,0,0>,0.05
//    pigment { color White }
//}

object { Table }

#include "common.inc"
