//#debug concat("\nA=",str(degrees(A),0,0))
//#debug concat("\nB=",str(degrees(B),0,0))
//#debug concat("\nC=",str(degrees(C),0,0))
//#debug concat("\nD=",str(degrees(D),0,0))
//#debug concat("\nE=",str(degrees(E),0,0))

#declare BaseY2 = BaseY*0.3
#declare Arm1W = 0.14
#declare Arm2W = 0.07
#declare Arm3W = 0.04

#declare Leg =
    union {
	cone { <0,-BaseY+BaseY2,0>,0.1  <0.7,-BaseY+0.08,0>,0.02  scale <1,1,0.35> }
	sphere { <0.65,-BaseY-0.05,0>, 0.15 }
	rotate y*90
    }

#declare Robot =
    union {
	union {
	    union {
		intersection {
		    difference {
			union {
			    cone { <0,0,0>,0.1 <Arm1,0,0>,0.05 }
			    sphere { <0,0,0>,0.1 }
			    sphere { <Arm1,0,0>,0.05 }
			}
			box {
			    <Arm1-Arm2W*1.5,-1,-Arm2W*0.51>
			    <Arm1+Arm2W*1.5,+1,+Arm2W*0.51>
			}
		    }
		    plane { z,Arm1W*0.5 rotate y*1 }
		    plane { -z,Arm1W*0.5 rotate y*-1 }
		}

		union {
		    intersection {
			difference {
			    union {
				cone { <0,0,0>,0.05 <Arm2,0,0>,0.025 }
				sphere { <0,0,0>,0.05 }
				sphere { <Arm2,0,0>,0.025 }
			    }
			    box {
				<Arm2-Arm3W*1.5,-1,-Arm3W*0.51>
				<Arm2+Arm3W*1.5,+1,+Arm3W*0.51>
			    }
			}
			plane { z,Arm2W*0.5 rotate y*0.7 }
			plane { -z,Arm2W*0.5 rotate y*-0.7 }
		    }
		    union {
			cone {
			    <0,0,0>
			    Arm3W*0.5

			    <Arm3*0.55-0.02,0,0>
			    Arm3W*(0.5+0.25)*0.55
			}
			cylinder {
			    <Arm3*0.1,0,0>
			    <Arm3*(0.55+0.03),0,0>
			    Arm3W*(0.5+0.25)*0.55*0.6
			    pigment { color Black }
			}
			union {
			    cone {
				<Arm3*0.55+0.02,0,0>
				Arm3W*(0.5+0.25)*0.55

				<Arm3,-0.015,0>
				Arm3W*0.25
				scale <1,1,0.5>
			    }
			    union {
				cylinder {
				    <0,0,0>
				    <0,-0.01,0>
				    0.075
				}
				difference {
				    union {
					cylinder {
					    <0,-0.01,0>
					    <0,-0.011,0>
					    0.075
					    pigment { color Black }
					}
					cylinder {
					    <0,0,0>
					    <0,0.001,0>
					    0.075
					    pigment { color Red }
					}
				    }
				    box {
					<-0.08,-0.02,-0.08>
					<-0.055,+0.02,+0.08>
				    }
				}
				scale <1.2,1,1>
				translate <Arm3-0.02,0,0>
			    }
			    texture { T_Wood7 scale 0.003 }
			    rotate -x*(degrees(E))
			}

			rotate -z*(180-degrees(D))
			translate <Arm2,0,0>
		    }
		    rotate -z*(180-degrees(C))
		    translate <Arm1,0,0>
		}
		rotate z*degrees(B)
		translate -x*BaseX
	    }
	    box {
		<-BaseX-0.1,-0.15,-BaseX*0.5>
		<+BaseX*0.6,-0.05,+BaseX*0.5>
	    }
	    cylinder {
		<-BaseX,0,-Arm1W*0.7>
		<-BaseX,0,-Arm1W*0.51>
		0.1
	    }
	    cylinder {
		<-BaseX,0,+Arm1W*0.7>
		<-BaseX,0,+Arm1W*0.51>
		0.1
	    }

	    rotate y*(degrees(A)+270)
	    #if ( R = 1 )
		rotate y*180
	    #end
	}
	union {
	    object { Leg rotate y*0 }
	    object { Leg rotate y*120 }
	    object { Leg rotate y*240 }
	}


	#if ( R = 0 )
	    pigment { color rgb<1,1,1>*1.4 }
	    finish { Shiny }
	    //texture { T_Chrome_3D }
	    //pigment { color rgbt <1.2,0.5,0.1,MotionBlurFilter> }
	    //finish { Shiny }
	#else
	    pigment { Black }
	    finish { Glossy }
	    //texture { Polished_Chrome }
	    //pigment { color rgbt <0,0,1,MotionBlurFilter> }
	    //finish { Shiny }
	#end

	#if ( MotionBlurFilter != 0 )
	    no_shadow
	#end
    }
