#include "colors.inc"

camera { location <0.167203, 0.275097, -1.65 -.0001>
	look_at <0.167203, 0.275097, 0> }

light_source { <-100, 100, -100> color White }

/*
0.167203
0.275097
*/
background { color White*0.05 }

#if (clock > 0.95)
	#declare Clock9 = (clock - 0.95)/0.05
#else
	#declare Clock9 = 0
#end

plane { z*-1, 1.3
	pigment { color rgbt <0.05, 0.05, 0.05, 1 - Clock9> }
}

#declare UnitSide = 1
#declare LongSide = UnitSide/2 + sqrt((UnitSide/2)*(UnitSide/2) + UnitSide*UnitSide)
#declare OddBit = LongSide - UnitSide
//#declare Angle = 1080*(cos(clock*pi + pi)+1)/2

#declare Credits =
"                   A Ratcrow Production (C) 1998     IRTC : M icrocosms     Aaron Gage     M athematics of Scale  "

#declare SLen = strlen(Credits)

#declare Angle = SLen * 10 * clock
#declare Count = floor(SLen * clock)
/*
#debug concat( str(SLen, 0, 1), "\n")
#debug concat( str(Angle, 0, 1), "\n")
#debug concat( str(Count, 0, 1), "\n")
*/

union {
#declare StartIndex = SLen - Count
#declare MasterLoop = 0
#while (MasterLoop < Angle)   // 360 - 720 - 1080
/*
#debug concat( str(StartIndex, 0, 1), "\n")
#debug concat( str(MasterLoop, 0, 1), "\n")
*/
	#declare RotLoop = 0
	#declare StartPoint = <-UnitSide, 0, 0>

	#declare Point = vaxis_rotate(StartPoint, z*-1, mod(MasterLoop, 90))
		#declare InnerLoop = 0
		#while ( InnerLoop < int(MasterLoop/90) )
			#declare Temp = Point.x
			#declare Temp = Temp - OddBit
			#declare Point = <Temp*(OddBit/UnitSide),
					Point.y*(OddBit/UnitSide),
					Point.z*(OddBit/UnitSide)>
			#declare Point = vaxis_rotate(Point, z*-1, 90)
		#declare InnerLoop = InnerLoop + 1
		#end
/*
	#debug concat( str(Point.x, 0, 6), "\n")
	#debug concat( str(Point.y, 0, 6), "\n")

	sphere { 0, 0.01*(1 - MasterLoop/Angle)
	    texture { LandArea scale 0.01*(1-MasterLoop/Angle)}
	    texture { OceanArea scale 0.01*(1-MasterLoop/Angle)}
	    texture { CloudArea scale 0.01*(1-MasterLoop/Angle)}
	    finish { ambient 0.8 }
	    translate Point
		}
*/

	text { ttf "timrom.ttf", substr(Credits, StartIndex, 1) 0.1, 0
		pigment { color White } finish { ambient 0.7 }
		translate x*-0.25
		scale 0.25*(1 - sqrt(MasterLoop/(SLen*10)))
		rotate z*-(MasterLoop + 10 - 90)
		translate Point
		}

#declare StartIndex = StartIndex + 1
#declare MasterLoop = MasterLoop + 10
#end

}
