// This file was created by PovChem version 1.00

#declare Camera_Position = < 59.2415, 0.394642, -4.78413 >
#include "colors.inc"

#declare Clock3 = min(1, clock/0.2)

#if (clock > 0.2)
	#declare Clock4 = (clock - 0.2)/0.2
#else #declare Clock4 = 0
#end

#if (clock > 0.925)
	#declare Clock5 = (clock - 0.925)/0.075
	plane { z*-1, 35 pigment { color rgbt <0.05, 0.05, 0.05, 1-Clock5> } }
#else #declare Clock5 = 0
#end

camera{
  //location < 0, 0, -80 + 42*clock >
  location < 0, 0, -38 >
  //direction < 0, 0, 2 >
  //look_at < 0, 0, 58.868 >
  //sky < 0, 1, 0 >
  //up < 0, 1, 0 >
  //right < 1.333, 0, 0 >
  //rotate < 0, 0, -90 >
  //rotate < -0, 0, 0 >
  //rotate < 0, -90, 0 >
  //translate Camera_Position
}

//light_source { < 59.241, -23.153, 33.48 > color rgb < 1, 1, 1 > }
//light_source { Camera_Position color rgb < 0.5, 0.5, 0.5 > }

light_source { < -100, 100, -100 > color rgb < 1, 1, 1 > }

background { color rgb < 0.05, 0.05, 0.05 > }

#declare Plastic =
  finish {
    ambient 0.4
    diffuse 0.7
    reflection 0.0
    brilliance 1.0
    phong 0.3
    phong_size 50
    specular 0.0
  }

#declare Hydrogen_Radius = 1.2 //*0.25
#declare Carbon_Radius = 1.7 //*0.25
#declare Nitrogen_Radius = 1.55 //*0.25
#declare Oxygen_Radius = 1.52 //*0.25
#declare Phosphorus_Radius = 1.8 //*0.25

#declare Atom_Hydrogen_Color = color rgb <0.8, 0.8, 0.8>
#declare Atom_Carbon_Color = color rgb <0.5, 0.5, 0.5>
#declare Atom_Nitrogen_Color = color rgb <0.2, 0.2, 0.8>
#declare Atom_Oxygen_Color = color rgb <0.8, 0.2, 0.2>
#declare Atom_Phosphorus_Color = color rgb <0.1, 0.7, 0.3>

#declare Atom_Hydrogen =
  sphere {
   <0,0,0>, Hydrogen_Radius
    texture {
      pigment { color Atom_Hydrogen_Color }
      finish { Plastic }
      normal { bozo }
    }
  }
#declare Atom_Carbon =
  sphere {
   <0,0,0>, Carbon_Radius
    texture {
      pigment { color Atom_Carbon_Color }
      finish { Plastic }
      normal { bozo }
    }
  }
#declare Atom_Nitrogen =
  sphere {
   <0,0,0>, Nitrogen_Radius
    texture {
      pigment { color Atom_Nitrogen_Color }
      finish { Plastic }
      normal { bozo }
    }
  }
#declare Atom_Oxygen =
  sphere {
   <0,0,0>, Oxygen_Radius
    texture {
      pigment { color Atom_Oxygen_Color }
      finish { Plastic }
      normal { bozo }
    }
  }
#declare Atom_Phosphorus =
  sphere {
   <0,0,0>, Phosphorus_Radius
    texture {
      pigment { color Atom_Phosphorus_Color }
      finish { Plastic }
      normal { bozo }
    }
  }

union {
#include "149d.inc"
rotate x*-90
rotate z*-20

rotate x*90*Clock3
rotate y*(360*Clock4)
}

/*
#declare UnitSide = 1
#declare LongSide = UnitSide/2 + sqrt((UnitSide/2)*(UnitSide/2) + UnitSide*UnitSide)
#declare OddBit = LongSide - UnitSide
#declare Angle = 540


#declare Arm =
blob {
   threshold 0.8

#declare MasterLoop = 0
#while (MasterLoop < Angle)   // 360 - 720 - 1080
	#declare RotLoop = 0
	#declare StartPoint = <-UnitSide, 0, 0>

	#declare Point = vaxis_rotate(StartPoint, z*-1, mod(MasterLoop, 90))
		#declare InnerLoop = 0
		#while ( InnerLoop < int(MasterLoop/90) )
			#declare Temp = Point.x
			#declare Temp = Temp - OddBit
			#declare Point = <Temp*(OddBit/UnitSide),
					Point.y*(OddBit/UnitSide),
					Point.z*(OddBit/UnitSide)>
			#declare Point = vaxis_rotate(Point, z*-1, 90)
		#declare InnerLoop = InnerLoop + 1
		#end

	sphere { 0, 0.25*(1 - MasterLoop/Angle), 1
	    translate Point
		}

#declare MasterLoop = MasterLoop + 5
#end

no_shadow

//translate <-0.167203, -0.275097, 0>
}

object { Arm
	texture {
		pigment { color White transmit (1 - sin(clock*pi)) }
		finish { ambient 0.8 }
		}
	scale 10
	translate z*-15
	translate y*-5
	translate x*1
} 
*/
