#include "colors.inc"
#include "finish.inc"

#declare Clock9 = min(1, clock/0.15 + 0.000000001)
#if (clock < 0.9)
	#declare Clock10 = 0
#else #declare Clock10 = (clock - 0.9)/0.1
#end

  #declare OceanArea = texture {
    pigment { color rgbt <0.5*Clock10, 0.5*Clock10, 1 - 0.25*clock + 0.7*Clock10, 0.3*Clock10> }
	normal {
		bozo
		scale <10, 1*Clock9, 10>
		normal_map {
			[0 waves scale <1, Clock9, 1>
				translate x*(50*sin(2*pi*clock))]
			[0.25 waves scale <1, Clock9, 1>
				translate <1000 + 100*clock, 0, 600-100*clock>]
			[0.5 waves scale <1, Clock9, 1>
				translate <-700+80*clock, 0, -900>]
			[0.75 waves scale <1, Clock9, 1>
				translate <-3000, 0, 100-20*clock>]
			[1 bozo translate z*(25*sin(5*pi*clock))]
			}
		}
	scale <1, Clock9, 1>
    }


camera { location <0.0001, 100 - 99.985*clock*0.99, -0.0001>
	look_at 0 }


//camera { location <0, 2, 3> look_at y*1 }

light_source { <-1000, 1000, -1000> color White rotate x*90}

/*
0.167203
0.275097
*/

background { color White*0.05 }

plane { y*1, 0
    texture { OceanArea scale 1 }
    finish { ambient 0.4 specular 0.2 roughness 0.001 refraction 0.4 ior 1.33 }
    translate y*0.005*sin(14*pi)
	}

#if (clock < 0.15)
    plane { y*1, 10
	    pigment { color rgbt <0.7, 0.7, 1 - 0.25*clock, Clock9> }
	    finish { ambient 0.4 }
	}
#end

	height_field { gif "micro1.ghf" smooth water_level 0.25
		translate -0.5
		texture {
			pigment {
				gradient y
				turbulence 0.5
				color_map {
				[0 color Brown*0.45 + Green*0.25 ]
				[0.45 color White*0.6 ]
				[0.55 color rgb <0.4, 0.6, 0.3> ]
				[0.6 color Green*0.6 + Brown*0.15 ]
				[0.85 color Green*0.4 + Brown*0.25 ]
				[1 color Red*0.2 + Brown*0.6 ]
					}
				}
			finish { Dull specular 0.1 ambient 0.3 }
			normal {
				gradient y
				turbulence 0.5
				normal_map
					{
					[0 bozo scale 0.1 ]
					[0.55 granite scale 0.1 ]
					[0.6 waves scale 0.1 ]
					[0.85 bozo scale 0.1 ]
					[1 bumps scale 0.1 ]
					}
				}
		scale 0.5
		}

	texture
		{
		pigment {
			granite
			turbulence 0.6
			color_map
				{
				[0 color rgbt 1]
				[0.8 color rgbf <0.890, 0.792, 0.675, 0.745>]
				[1.0 color rgbf <0.973, 0.627, 0.627, 0.600>]
				}
			}
		finish { ambient 0.3 }
		normal { bumps scale 0.1 }
		scale 0.5
		}

	texture
		{
		pigment {
			bozo
			turbulence 0.7
			color_map {
				[0 color rgbt 1]
				[0.95 color rgbt 1]
				[1 color White*0.45 ]
				}
			}
		finish { ambient 0.3 }
		scale 0.01
		}

	texture
		{
		pigment {
			bozo
			turbulence 0.4
			color_map
				{
				[0 color rgbt 1]
				[0.6 color rgbt <0.2, 0.8, 0.2, 0.6>]
				[0.8 color rgbt <0.8, 0.2, 0.2, 0.6>]
				[1 color rgbt 1 ]
				}
			}
		finish { ambient 0.3 }
		normal { waves scale 0.01 }
		scale 0.1
		}

	scale <10, 1, 10>
	translate z*-0.22
	}

#include "shell.inc"

object { Arm rotate x*100 scale 0.0025 translate y*0.005 }
