#include "colors.inc"

camera { location <0, 0, -3> look_at 0 }

light_source { <-100, 100, -100> color White }

background { color White*0.05 }

#declare UnitSide = 1
#declare LongSide = UnitSide/2 + sqrt((UnitSide/2)*(UnitSide/2) + UnitSide*UnitSide)
#declare OddBit = LongSide - UnitSide

#if (clock > 0.5)
	#declare Clock1 = (clock - 0.5)/0.5
#else
	#declare Clock1 = 0
#end

#declare Clock5 = min( (clock/0.1), 1)

#declare Square = union {
cylinder { <-LongSide/2, UnitSide/2, 0>, <-LongSide/2 + UnitSide, UnitSide/2, 0>, 0.01
        texture { pigment { color Red transmit 0.8*Clock1 } finish { ambient 0.5 } } } 
cylinder { <-LongSide/2, -UnitSide/2, 0>, <-LongSide/2 + UnitSide, -UnitSide/2, 0>, 0.01
        texture { pigment { color Red transmit 0.8*Clock1 } finish { ambient 0.5 } } } 
cylinder { <-LongSide/2 + UnitSide, UnitSide/2, 0>, <-LongSide/2 + UnitSide, -UnitSide/2, 0>, 0.01
        texture { pigment { color Red transmit 0.8*Clock1 } finish { ambient 0.5 } } } 
cylinder { <-LongSide/2, UnitSide/2, 0>, <-LongSide/2, -UnitSide/2, 0>, 0.01
        texture { pigment { color Red transmit 0.8*Clock1 } finish { ambient 0.5 } } } 


cylinder { <-LongSide/2 + UnitSide/2, UnitSide/2, 0>,
	   <-LongSide/2 + UnitSide/2, -UnitSide/2, 0>, 0.01
	texture { pigment { color Green transmit 0.8*Clock1 } finish { ambient 0.5 } } }

cylinder { <-LongSide/2 + UnitSide, UnitSide/2, 0>,
	   <-LongSide/2 + UnitSide/2, -UnitSide/2, 0>, 0.01
	texture { pigment { color Gold transmit 0.8*Clock1 } finish { ambient 0.5 } } }

cylinder { <LongSide/2, -UnitSide/2, 0>,
	   <-LongSide/2 + UnitSide/2, -UnitSide/2, 0>, 0.011
	texture { pigment { color Gold transmit 0.8*Clock1 } finish { ambient 0.5 } } }

#declare Loop3 = 30
#while (Loop3 < 90)
sphere { y*sqrt(1.25), 0.011 rotate -z*Loop3
		translate <-LongSide/2 + UnitSide/2, -UnitSide/2, 0>
	texture { pigment { color Gold transmit 0.8*Clock1 } finish { ambient 0.5 } } }
#declare Loop3 = Loop3 + 5
#end

cylinder { <LongSide/2, -UnitSide/2, 0>, <-LongSide/2 + UnitSide, -UnitSide/2, 0>, 0.012
	texture { pigment { color White transmit 0.8*Clock1 } finish { ambient 0.5 } } }

        translate x*((OddBit)/2 - UnitSide/2)
        translate y*(UnitSide/2)
}

#declare BBox = union
{
cylinder { <-LongSide/2, UnitSide/2, 0>, <LongSide/2, UnitSide/2, 0>, 0.01
	texture { pigment { color Red transmit 0.8*Clock1 } finish { ambient 0.5 } } }

cylinder { <-LongSide/2, -UnitSide/2, 0>, <LongSide/2, -UnitSide/2, 0>, 0.01
	texture { pigment { color Red transmit 0.8*Clock1 } finish { ambient 0.5 } } }

cylinder { <LongSide/2, UnitSide/2, 0>, <LongSide/2, -UnitSide/2, 0>, 0.01
	texture { pigment { color Red transmit 0.8*Clock1 } finish { ambient 0.5 } } }

cylinder { <-LongSide/2, UnitSide/2, 0>, <-LongSide/2, -UnitSide/2, 0>, 0.01
	texture { pigment { color Red transmit 0.8*Clock1 } finish { ambient 0.5 } } }

cylinder { <-LongSide/2, UnitSide/2, 0>, <-LongSide/2, -UnitSide/2, 0>, 0.01
	translate x*UnitSide
	texture { pigment { color Red transmit 0.8*Clock1 } finish { ambient 0.5 } } }

/*
cylinder { <-LongSide/2 + UnitSide/2, UnitSide/2, 0>,
	   <-LongSide/2 + UnitSide/2, -UnitSide/2, 0>, 0.01
	texture { pigment { color Green transmit 0.8*Clock1 } finish { ambient 0.5 } } }

cylinder { <-LongSide/2 + UnitSide, UnitSide/2, 0>,
	   <-LongSide/2 + UnitSide/2, -UnitSide/2, 0>, 0.01
	texture { pigment { color Gold transmit 0.8*Clock1 } finish { ambient 0.5 } } }
*/

	translate x*((OddBit)/2 - UnitSide/2)
	translate y*(UnitSide/2)
}

#declare Spiral = union
{
	#declare Loop = 0
	#while (Loop < 30)
		sphere { 0, 0.033 - 0.0190983/3*(Loop/30)
		    translate x*(-UnitSide) rotate z*-(3*Loop)
			texture { pigment { color rgb <0.4, 0.4, 1> }
				  finish { ambient 0.65 } }
			}
	#declare Loop = Loop + 1
	#end
}

object { BBox translate y*-(1 - OddBit/UnitSide) translate x*-0.75}
//object { Square translate y*-(1 - OddBit/UnitSide) translate x*-0.75}

#declare BB1 = object { BBox
	translate x*-OddBit scale <(OddBit/UnitSide), OddBit, 1> rotate z*-90
	}

#if (clock > 0.3)
object { BB1 translate y*-(1 - OddBit/UnitSide) translate x*-0.75}
#end

#declare BB2 = object { BB1
	translate x*-OddBit scale <(OddBit/UnitSide), OddBit, 1> rotate z*-90
	}

#if (clock > 0.6)
object { BB2 translate y*-(1 - OddBit/UnitSide) translate x*-0.75}
#end

#declare BB3 = object { BB2
	translate x*-OddBit scale <(OddBit/UnitSide), OddBit, 1> rotate z*-90
	}

#if (clock > 0.9)
object { BB3 translate y*-(1 - OddBit/UnitSide) translate x*-0.75}
#end

#declare Star = union
{
   #declare Loop666 = 0
   #while (Loop666 < 5)
	cylinder { <1, 0, 0>, <cos(radians(72)), sin(radians(72)), 0>, 0.025
			rotate z*72*Loop666
	#if (Loop666 = 0)
	texture { pigment { color White }
		finish { ambient 0.5*Clock5 diffuse Clock5 } }
	#else
	texture { pigment { color Red }
		finish { ambient 0.5*Clock5 diffuse Clock5 } }
	#end
	}

	cylinder { <cos(radians(216)), sin(radians(216)), 0>,
		<cos(radians(72)), sin(radians(72)), 0>, 0.025
			rotate z*72*Loop666
	#if (Loop666 = 0)
	texture { pigment { color Green }
		finish { ambient 0.5*Clock5 diffuse Clock5 } }
	#else
	texture { pigment { color Red }
		finish { ambient 0.5*Clock5 diffuse Clock5 } }
	#end
	}

   #declare Loop666 = Loop666 + 1
   #end
}

object { Star scale 0.5 rotate z*20*cos(clock*6*pi)
	rotate y*(4*360*clock)
	translate <1, -0.9, 0> }

union {
	#if (clock > 0.15)
	object { Spiral }
	#end
	#declare S2 = object { Spiral translate x*-OddBit scale (OddBit/UnitSide) rotate z*-90 }
	#if (clock > 0.45)
	object { S2 }
	#end
	#declare S3 = object { S2 translate x*-OddBit scale (OddBit/UnitSide) rotate z*-90 }
	#if (clock > 0.75)
	object { S3 }
	#end
	#declare S4 = object { S3 translate x*-OddBit scale (OddBit/UnitSide) rotate z*-90 }
	#if (clock > 0.9)
	object { S4 }
	#end
	#if(clock > 0.93)
	#declare S5 = object { S4 translate x*-OddBit scale (OddBit/UnitSide) rotate z*-90 }
	object { S5 }
	#end
	#if(clock > 0.96)
	#declare S6 = object { S5 translate x*-OddBit scale (OddBit/UnitSide) rotate z*-90 }
	object { S6 }
	object { S6 translate x*-OddBit scale (OddBit/UnitSide) rotate z*-90 }
	#end

translate y*-(1 - OddBit/UnitSide) translate x*-0.75
}

union {
text { ttf "crystal.ttf", "1" 0.1, 0
	translate <1 + 2, 0.75, 0>
	pigment { color Green }
	finish { ambient 0.6 }
	}

box { <1, 0.3, 0>, <5, 0.45, 0.1>
	pigment { color Red } finish { ambient 0.6 }
	}

text { ttf "crystal.ttf", str(OddBit, 1, -1) 0.1, 0
	translate <1, -0.5, 0>
	pigment { color White }
	finish { ambient 0.6 }
}

text { ttf "crystal.ttf", "= O" 0.1, 0
	rotate y*25
	translate <6, 0, 0>
	pigment { color Blue }
	finish { ambient 0.6 }
	}

text { ttf "crystal.ttf", "  |" 0.1, 0
	scale <1, 1.3, 1>
	translate y*-0.1
	rotate y*25
	translate <5.95, 0, 0>
	pigment { color Blue }
	finish { ambient 0.6 }
	}

scale 0.25
translate x*-0.1
}

text { ttf "crystal.ttf"
	"1.61803398874989484820458683436563811772030917980577" 0.1, 0
	pigment { color rgb <0.4, 0.4, 1> }
	finish { ambient 0.65 }

	scale 0.25

	translate <3 - 7.5*clock, -1, 0>
}

text { ttf "crystal.ttf" "0, 1, 1, 2, 3, 5, 8, 13, 21, 34, 55, 89, 144," 0.1, 0
	pigment { color Red }
	finish { ambient 0.5 }

	scale 0.25

	translate <2.5 - 6*clock, 1, 0>
}
