#include "colors.inc"
#include "finish.inc"

camera { location <0, 0, -5> look_at 0 }

light_source { <-100, 100, -100> color White }

background { color White*0.05 }

#if (clock > 0.19)
plane { z*-1, 4 pigment { rgbt <0.05, 0.05, 0.05, 1 - (clock - 0.19)/0.81> } }
#end

#declare UnitSide = 1
#declare LongSide = UnitSide/2 + sqrt((UnitSide/2)*(UnitSide/2) + UnitSide*UnitSide)
#declare OddBit = LongSide - UnitSide
#declare Angle = 1080

#declare Arm =
blob {
   threshold 0.8

#declare MasterLoop = 0
#while (MasterLoop < Angle)   // 360 - 720 - 1080
	#declare RotLoop = 0
	#declare StartPoint = <-UnitSide, 0, 0>

	#declare Point = vaxis_rotate(StartPoint, z*-1, mod(MasterLoop, 90))
		#declare InnerLoop = 0
		#while ( InnerLoop < int(MasterLoop/90) )
			#declare Temp = Point.x
			#declare Temp = Temp - OddBit
			#declare Point = <Temp*(OddBit/UnitSide),
					Point.y*(OddBit/UnitSide),
					Point.z*(OddBit/UnitSide)>
			#declare Point = vaxis_rotate(Point, z*-1, 90)
		#declare InnerLoop = InnerLoop + 1
		#end

	sphere { 0, 0.25*(1 - MasterLoop/Angle), 1
	    //hollow
	    //texture { pigment { color rgbt <1, 0.99, 1, 0.95> }
			//finish { ambient 0.5 }}
	    //texture { SpheryTexture finish { ambient 0.6 } }
	    //scale 1.5
	    translate Point
	    translate z*(MasterLoop*0.01)
		}

#declare MasterLoop = MasterLoop + 5
#end

no_shadow

translate <-0.167203, -0.275097, 0>
}

object { Arm scale 3 rotate x*90
		texture {
			pigment {
				gradient y
				turbulence 0.5
				color_map {
				[0 color Brown*0.45 + Green*0.25 ]
				[0.45 color White*0.6 ]
				[0.55 color rgb <0.4, 0.6, 0.3> ]
				[0.6 color Green*0.6 + Brown*0.15 ]
				[0.85 color Green*0.4 + Brown*0.25 ]
				[1 color Red*0.2 + Brown*0.6 ]
					}
				}
			finish { Dull specular 0.1 ambient 0.3 }
			normal {
				gradient y
				turbulence 0.5
				normal_map
					{
					[0 bozo scale 0.1 ]
					[0.55 granite scale 0.1 ]
					[0.6 waves scale 0.1 ]
					[0.85 bozo scale 0.1 ]
					[1 bumps scale 0.1 ]
					}
				}
		scale 0.5
		}

	texture
		{
		pigment {
			granite
			turbulence 0.6
			color_map
				{
				[0 color rgbt 1]
				[0.8 color rgbf <0.890, 0.792, 0.675, 0.745>]
				[1.0 color rgbf <0.973, 0.627, 0.627, 0.600>]
				}
			}
		finish { ambient 0.3 }
		normal { bumps scale 0.1 }
		scale 0.5
		}

	texture
		{
		pigment {
			bozo
			turbulence 0.7
			color_map {
				[0 color rgbt 1]
				[0.95 color rgbt 1]
				[1 color White*0.45 ]
				}
			}
		finish { ambient 0.3 }
		scale 0.01
		}

	texture
		{
		pigment {
			bozo
			turbulence 0.4
			color_map
				{
				[0 color rgbt 1]
				[0.6 color rgbt <0.2, 0.8, 0.2, 0.6>]
				[0.8 color rgbt <0.8, 0.2, 0.2, 0.6>]
				[1 color rgbt 1 ]
				}
			}
		finish { ambient 0.3 }
		normal { waves scale 0.01 }
		scale 0.1
		}

	rotate x*-90
	translate z*-0.5
	}

#declare T3 = texture { pigment { color Red } finish { ambient 0.3 } }
 
text { ttf "crystal.ttf",
   "  3.141592653589793238462643383279502884197169399375105820974944"
        0.1, 0 translate <2.8, -0.15, 0> texture { T3 }
        scale 0.625 translate x*-0.25
        translate x*-9 translate z*3 }

text { ttf "timrom.ttf",
	"Mathematics of Scale" 0.1, 0
	translate x*(-20/4) scale 0.5 translate y*-2
        pigment { Gold*0.75 }
        finish { specular 1 roughness 0.001 reflection 0.4 ambient 0.4 }
	translate x*0.1125
}
  #declare Clouds1 = pigment {
      bozo
      turbulence 1
      color_map {
        [0.0 color White filter 1]
        [0.5 color White]
        [1.0 color White filter 1]
      }
    }
  #declare Clouds2 = pigment {
    agate
    turbulence 1
    color_map {
      [0.0 color White filter 1]
      [0.5 color White]
      [1.0 color White filter 1]
      }
    }

  #declare Clouds3 = pigment {
    marble
    turbulence 1
    color_map {
      [0.0 color White filter 1]
      [0.5 color White]
      [1.0 color White filter 1]
    }
  }
  #declare Clouds4 = pigment {
    granite
    turbulence 1
    color_map {
      [0.0 color White filter 1]
      [0.5 color White]
      [1.0 color White filter 1]
    }
  }

  #declare CloudArea = texture {
    pigment {
      gradient y
      pigment_map {
        [0.00 Clouds1]
        [0.25 Clouds2]
        [0.50 Clouds3]
        [0.75 Clouds4]
        [1.00 Clouds1]
      }
    }
  }

text { ttf "timrom.ttf", "Aaron Gage" 0.1, 0
	translate x*(-10/4) scale 0.5 translate <0, 2, 0>

texture { CloudArea }
}
