/*
#declare Hydrogen_Radius = 1.2 // *0.25
#declare Carbon_Radius = 1.7 // *0.25
#declare Nitrogen_Radius = 1.55 // *0.25
#declare Oxygen_Radius = 1.52 // *0.25
#declare Phosphorus_Radius = 1.8 // *0.25

#declare Atom_Hydrogen_Color = color rgb <0.8, 0.8, 0.8>
#declare Atom_Carbon_Color = color rgb <0.3, 0.3, 0.3>
#declare Atom_Nitrogen_Color = color rgb <0.2, 0.2, 0.8>
#declare Atom_Oxygen_Color = color rgb <0.8, 0.2, 0.2>
#declare Atom_Phosphorus_Color = color rgb <0.1, 0.7, 0.3>
*/

#declare Methane = union
{
   sphere { 0, Carbon_Radius pigment { Atom_Carbon_Color } finish { ambient 0.4} }
   sphere { <3, 0, 0>, Hydrogen_Radius pigment { Atom_Hydrogen_Color } finish { ambient 0.4} }
   cylinder { 0, x*3, Hydrogen_Radius*0.5 pigment { color Blue } finish { ambient 0.4} }

#declare Loop = 0
#while (Loop < 3)
union {
   sphere { <-3, 0, 0>, Hydrogen_Radius pigment { Atom_Hydrogen_Color } finish { ambient 0.4} }
   cylinder { 0, x*-3, Hydrogen_Radius*0.1 pigment { color Blue } finish { ambient 0.4} }
   rotate z*45
   rotate x*120*Loop
}
#declare Loop = Loop + 1
#end
finish { ambient 0.4 }
}

#declare Cubie = union
{
   sphere { 0, 1.25 pigment { Atom_Carbon_Color } finish { ambient 0.4 } }
   sphere { <1, 1, 1>, 1 pigment { Atom_Hydrogen_Color } finish { ambient 0.4 } }
   sphere { <1, 1, -1>, 1 pigment { Atom_Hydrogen_Color } finish { ambient 0.4 } }
   sphere { <1, -1, 1>, 1 pigment { Atom_Hydrogen_Color } finish { ambient 0.4 } }
   sphere { <1, -1, -1>, 1 pigment { Atom_Hydrogen_Color } finish { ambient 0.4 } }
   sphere { <-1, 1, 1>, 1 pigment { Atom_Hydrogen_Color } finish { ambient 0.4 } }
   sphere { <-1, 1, -1>, 1 pigment { Atom_Hydrogen_Color } finish { ambient 0.4 } }
   sphere { <-1, -1, 1>, 1 pigment { Atom_Hydrogen_Color } finish { ambient 0.4 } }
   sphere { <-1, -1, -1>, 1 pigment { Atom_Hydrogen_Color } finish { ambient 0.4 } }
}
