#if (FracFade = 1)
 #if (clock > 0.5)
  #declare Dim = 1 - (clock-0.5)/0.5
 #else
  #declare Dim = 1
 #end
#else
  #declare Dim = 1
#end

#declare T1 = texture { pigment { color rgb <0.45, 0.45, 1> }
	finish { specular 0.75 roughness 0.01 ambient 0.5 } }
#declare T2 = texture { pigment { color Green } finish { ambient 0.5 } }
#declare T3 = texture { pigment { color Red } finish { ambient 0.5 } }

#declare MinorRadius = 0.05
#declare PolyParrot = union
{
   #declare Angle = (2*pi / Sides)
   #declare StartX = 1
   #declare StartY = 0
   #declare X2 = 1
   #declare Y2 = 0
   #declare DX = 0
   #declare DY = 0
   #declare raz = true
   #declare Estimate = 0
   #declare Iterations = floor(Sides/2)

   #declare Loop = 0
   #while (Loop < Iterations)
	#declare X2 = cos(Angle * (Loop + 1))
	#declare Y2 = sin(Angle * (Loop + 1))

	cylinder { <X2, Y2, 0>, <cos(Angle * Loop), sin(Angle * Loop), 0>,
		MinorRadius
		texture { T1 } }

	sphere { <X2, Y2, 0>, MinorRadius
		texture { T1 } }

	sphere { <cos(Angle*Loop), sin(Angle*Loop), 0>, MinorRadius
		texture { T1 } }

	#if (raz = true)
		#declare DX = X2 - StartX
		#declare DY = Y2 - StartY
		#declare raz = false
	#end

	#declare Loop = Loop + 1
   #end

   #declare Dist = StartX - X2
   #declare Side = sqrt( DX*DX + DY*DY )
   #declare Estimate = (Side * Sides) / Dist

   cylinder { <X2, 0, 0>, <1, 0, 0>, MinorRadius texture { T2 } }
   sphere { <X2, 0, 0>, MinorRadius texture { T2 } }
   sphere { <1, 0, 0>, MinorRadius texture { T2 } }

   #declare Denom = str( Dist, 1, -1)
   #declare Numer = str( Side*Sides, 1, -1)
   //#declare Result = concat( "= ", str( Estimate, 0, -1) )
   #declare Result = concat( "  ", str( Estimate, 0, -1) )

   #while (Loop < Sides)
	   #declare X2 = cos(Angle * (Loop + 1))
	   #declare Y2 = sin(Angle * (Loop + 1))

	cylinder { <X2, Y2, 0>, <cos(Angle * Loop), sin(Angle * Loop), 0>,
		MinorRadius
		texture { T1 } }

	sphere { <X2, Y2, 0>, MinorRadius
		texture { T1 } }

	sphere { <cos(Angle*Loop), sin(Angle*Loop), 0>, MinorRadius
		texture { T1 } }

	#declare Loop = Loop + 1
   #end

}

#declare Fraction = union
{
   text { ttf "crystal.ttf", Denom 0.1, 0 translate <-1.75, -1, 0> texture { T2
		finish { ambient 0.5*Dim diffuse Dim} } }
   text { ttf "crystal.ttf", Numer 0.1, 0 translate <-1.75, 0.5, 0> texture { T1
		finish { ambient 0.65*Dim diffuse Dim} } }
   text { ttf "crystal.ttf", "= " 0.1, 0 translate <2.8, -0.15, 0> texture { T3
		finish { ambient 0.5*Dim diffuse Dim} } }
   text { ttf "crystal.ttf", Result 0.1, 0 translate <2.8, -0.15, 0> texture { T3 } }
   box { <-1.5, 0.15, -0.1>, <2.5, 0, 0> translate x*-0.25 texture { T3
		finish { ambient 0.5*Dim diffuse Dim} } }
}
