#include "colors.inc"
#include "glass.inc"

camera { location <0, 0, -7> look_at 0 }

light_source { <-100, 100, -100> color White }

background { color White*0.05 }

#declare MaxSets = 3000
#declare Sides = floor(clock*clock*MaxSets) + 3 + 8 + 1

#declare FracFade = 1

#include "poly.inc"

object { PolyParrot rotate y*(clock*4*360 - 90 - 30)
	rotate z*(50 * sin(2 * 2 * pi * clock))
	translate x*-3.15 }
object { Fraction scale 0.625 translate x*-0.25
	}

torus { 1, 0.025 rotate x*90
	texture { T_Orange_Glass
		finish { ambient 0.75*(1-Dim) diffuse (1-Dim) }}
	translate <-3, -2.45, 0> }

