// Bookcase.inc   by Neil Alexander  1998 
// Bookcase for House.inc

#declare Shelf = box {
  <0.75,0,0.75>,<30.75,0.75,10.75>
  }

#declare Book = union {
  difference { // cover
    box { <0,0,0>,<1,1,1> }
    box { <0.05,-1,-1>,<0.95,2.0,0.98> }
    }
  box { <0.05,0.01,0.02>,<0.95,0.99,0.98>  // pages
    texture { pigment { color rgb <1,1,1> }}
    }
  }  // end Book

#declare Bookcase = union {  // Bookcase
union { // case
  difference {  // sides & back
    box { <0,0,0>,<31.5,79.5,11> }
    box { <0.75,-1,0.75>,<30.75,80,12> }
    }
  box { < 0.75,0,0.75>,<30.75,3,10> } // bottom panel
  object { Shelf translate 3*y }
  object { Shelf translate 15.5*y }
  object { Shelf translate 28*y }
  object { Shelf translate 40.75*y }
  object { Shelf translate 53.25*y }
  object { Shelf translate 65.75*y }
  object { Shelf translate 78.75*y }
  texture {
    pigment { color rgb <0.75,0.188,0> }
    finish { phong 0.5 phong_size 20 ambient 0 }
    }
  }  // end case

#declare R1 = seed(2);
#declare Counter = 1;

#while (Counter<8)
  #switch (Counter)
    #case(1)  // top shelf
      #declare Depthlimit = 28;
      #declare T1=0.5;
      #declare T2=1.5;
      #declare H1=6;
      #declare H2=2;
      #declare W1=4.5;
      #declare W2=1;
      #declare transloc = <0.75,66.5,0.75>;
      #break
    #case(2)  // 2nd shelf
      #declare Depthlimit = 28;
      #declare T1=0.5;
      #declare T2=1.5;
      #declare H1=6;
      #declare H2=2;
      #declare W1=4.5;
      #declare W2=1;
      #declare transloc = <0.75,54,0.75>;
      #break
    #case(3)  // 3rd shelf
      #declare Depthlimit = 27.5;
      #declare T1=1;
      #declare T2=1.5;
      #declare H1=7;
      #declare H2=3;
      #declare W1=6;
      #declare W2=1.5;
      #declare transloc = <0.75,41.5,0.75>;
      #break
    #case(4)  // 4th shelf
      #declare Depthlimit = 27.5;
      #declare T1=1;
      #declare T2=1.5;
      #declare H1=8;
      #declare H2=2;
      #declare W1=6;
      #declare W2=1.5;
      #declare transloc = <0.75,28.75,0.75>;
      #break
    #case(5)  // 5th shelf
      #declare Depthlimit = 27.5;
      #declare T1=1;
      #declare T2=1.5;
      #declare H1=8;
      #declare H2=2;
      #declare W1=6;
      #declare W2=1.5;
      #declare transloc = <0.75,16.25,0.75>;
      #break
    #case(6)  // 6th shelf
      #declare Depthlimit = 14.5;
      #declare T1=1;
      #declare T2=1.5;
      #declare H1=9;
      #declare H2=2;
      #declare W1=7;
      #declare W2=2;
      #declare transloc = <13.75,3.75,0.75>;
      #break
    #case(7)  // 6th shelf, books on side
      #declare Depthlimit = 8;
      #declare T1=0.25;
      #declare T2=0.75;
      #declare H1=11;
      #declare H2=2;
      #declare W1=9.5;
      #declare W2=1;
      #declare transloc = <0.75,3.75,0.75>;
      #break
    #end  // end case conditions

#declare Depth = 0;
union {  // row of books
  #while (Depth < Depthlimit)
    #declare Thick = T1 + rand(R1)*T2;
    object { Book
    #declare RR = rand(R1);
    #declare GG = rand(R1);
    #declare BB = rand(R1);
    #if ((RR<0.55)&(GG>0.45)&(BB<0.55))  // eliminate bright green
      #declare RR = 1;
      #declare GG = 1;
      #declare BB = 1;
      #end  // end if
    #if ((RR>0.45)&(GG<0.55)&(BB>0.45))  // eliminate bright purple
      #declare RR = 0.1;
      #declare GG = 0.1;
      #declare BB = 0.1;
      #end  // end if
    #declare Bookcolor = texture { pigment {color rgb <RR, GG, BB>}}
    #declare Textcolor = color rgb <rand(R1), rand(R1), rand(R1)>;
    #declare Textboz = texture {
      pigment {
        bozo
        color_map {
          [0.4 color rgb <RR,GG,BB>]
          [0.47, 0.49 color Textcolor color Textcolor]
          [0.55, 0.7 color rgb <RR,GG,BB> color rgb <RR,GG,BB>]
          [0.77, 0.79 color Textcolor color Textcolor]
          [0.85 color rgb <RR,GG,BB>]
          }
        scale <3,0.05,1>
        translate<rand(R1)*100,rand(R1)*100,rand(R1)*100>
        }
      }  // end Textboz
    #declare Textheight = rand(R1);
    texture {
      marble
      texture_map {
        [Textheight Bookcolor ]
        [Textheight Textboz ]
        }
      }
    scale <Thick, H1+rand(R1)*H2, W1+rand(R1)*W2>
    translate <Depth,0,0>
    }  // end object
    #declare Depth = Depth + Thick;
    #end  // end while loop - row of books
  #if (Counter=7)
    translate <-Depth,0,0>
    rotate <0,0,-90>
    #end  // end if - for bottom row on side
  translate transloc
  }  // end top row of books
#declare Counter = Counter + 1;
#end  // end while loop - Books

}  // end Bookcase


