//  Cell.inc  by Neil Alexander  1998
//  Various objects for animation Cosms.pov

/*camera {
  location <18, 0, -36>
  look_at <18, 0, 0>
  angle 60
  }

light_source { <-50, 200, -150> colour rgb 1 }

plane { -z, 0
  pigment {
    checker colour rgb 1 colour rgb 0.75
    }
  finish {
    ambient 0.2
    diffuse 0.8
    }
  translate <0.5,0.5,3>
  hollow
  }*/
  
#macro Nucleus (K) 
  sphere {  
    <0,0,0>,0.125
    texture { 
      pigment { bozo
        color_map {
          [0 color rgb <1,0.5,0.4>]
          [0.5 color rgb <0.4,0.3,0.05>]
          [1 color rgb <1,0.5,0.4>]
          }
        scale 0.01
        turbulence 0.5
        phase K
        }
      }
    texture {
      pigment { gradient x
        color_map {
          [0.9975 color rgbt <0.1,0.1,0.1,1>]
          [0.9994 color rgbt <0.1,0.1,0.1,0>]
          }
        scale 0.25
        translate x*-0.125
        }
      }
    no_shadow
    } 
  #end // end Nucleus        

#macro Cell (S1,K)   // random seed, clock

  #declare R1 = seed(S1);
  union {
    blob {
      threshold 0.56
      sphere {0,1,1
        scale (rand(R1)+1)/2
        translate x*(rand(R1)-0.5)*2.5
        }
      sphere {0,1,1
        scale (rand(R1)+3)/4
        translate y*(rand(R1)-0.5)*.5
        }
      texture { 
        pigment { color rgbf 0.9 }
        }
      interior {
        ior 1.01
        media {
          scattering {1, <0.9,1,0.7>}  
          density { bozo scale 0.01  }
          } // end media
        }  // end interior
      hollow
      }  // end blob
    object { Nucleus (K) }
    
    }  // end union
    
  #end // end Cell
    
#macro Microbe (S1, K) // random seed, clock variable

  #declare R1 = seed(S1);
  blob {
    threshold 0.56
    sphere {0,1,1}
    #declare W1 = 0;
    #while (W1<12)
      sphere {0,1,1
        #declare SC = rand(R1)*0.188+0.062;
        scale SC
        translate x*(SC*0.55*sin((K+W1/12)*pi*2)+0.55)
        rotate rand(R1)*360*z
        rotate rand(R1)*360*y
        texture { pigment {color rgb 1}}
        }
      #declare W1 = W1 + 1;
      #end // end while loop
    texture { pigment { color rgb <1,0,0>}}
    scale 0.5
    }  // end blob
 
  #end // end Microbe

#declare Molecule = union {
  sphere { 0, 1   // sphere 1
    texture { 
      pigment { color rgbt 1 }
      }
    interior {
      media {
        emission <0.4,0.28,0.31>
        scattering {1, <0.8,0.56,0.62>}  
         density { onion triangle_wave scale 1.125 }
        } // end media
      }  // end interior
    hollow
    }  // end sphere 1
  sphere { 0, 1   // sphere 2
    texture { 
      pigment { color rgbt 1 }
      }
    interior {
      media {
        emission <0.35,0.23,0.1>
        scattering {1, <0.7,0.45,0.2>}  
         density { onion triangle_wave scale 1.125 }
        } // end media
      }  // end interior
    scale 0.5
    translate x*1.25
    rotate <0,70,-30>
    hollow
    }  // end sphere 2
  sphere { 0, 1   // sphere 3
    texture { 
      pigment { color rgbt 1 }
      }
    interior {
      media {
        emission <0.2,0.95,1>
        scattering {1, <0.2,0.95,1>}  
         density { onion triangle_wave scale 1.125 }
        } // end media
      }  // end interior
    scale 0.375
    translate x*1.188
    rotate z*120
    hollow
    }  // end sphere 3  
  }  // end Molecule

#macro Protein (L,K)     // length(# of units),clock
  
  #declare K1 = -K;
  #declare C1 = 0;
  union {
    #while (C1<L)
      #declare Locx = C1*1.5;
      #declare Locy = (sin((K1+C1/20)*pi*2)-sin(K1*pi*2))*1.5;
      #declare Locz = (sin((K1+C1/13)*pi*2)-sin(K1*pi*2))*0.75;
      object { Molecule
        rotate x*sin((K1+C1/L)*pi*2)*(10+3*C1)
        translate <Locx,Locy,Locz>
        }
      #declare C1 = C1+1;
      #end  // end while loop
    }  // end union
  
  #end // end Protein


    
