// Chair.inc  by Neil Alexander  1998
// Chair for House.inc

#declare Clothcolor = texture {
  pigment { color rgb <1,0.97,0.93> }
  finish { ambient 0.15 diffuse 0.85 }
  }

#declare Cloth = normal { bumps 0.1 scale 0.1 }

#declare Button = normal { wood
  slope_map {
    [0 <0, 0>]
    [0.02 <0, 0>]
    [0.0375 <-10, -100>]
    [0.0375 <-10, 7>]
    [0.2 <1.0, 0>]
    }
  scale 40
  }

#declare CLeg = difference {
  box { <0,0,0>,<2.5,8.25,2.5> }
  plane { x,0
    rotate <0,0,17>
    translate<1.5,0,0>
    }
  plane { z,0
    rotate <-17,0,0>
    translate <0,0,1.5>
    }
  texture { pigment {color rgb <0.8,0.45,0.15>}}
  }

/*camera {
  location  <80, 50, 100>
  angle 35
  look_at   <0, 15, 10>

  }

light_source {
  <20,280,180>
  color Gray50
  }

light_source {
  <120,90,100>
  color Gray50
  }

plane {y, 0
  texture {
    pigment { color White }
    }
  }
 */

#declare Chair = union {
  superellipsoid {  // chair back
    <0.3, 0.7>   // around z-axis, around x-axis
    scale <12.5,11,4>
    texture { Clothcolor
      normal { average    // buttons
      normal_map {
        [Button translate <-3.25,-1,0>]
        [Button translate <3.25,-1,0>]
        [Cloth]
        }
      }
    }
  translate<0,11,0>
  rotate<-15,0,0>
  translate<0,16,4>
  }

superellipsoid {  // seat
  <0.25, 0.5>   // around z-axis, around x-axis
  scale <13,11,5>
  rotate<90,0,0>
  translate<0,13,15>
  }

superellipsoid {  // lower part
  <0.2, 0.1>   // around z-axis, around x-axis
  scale <13,11,1.25>
  rotate<90,0,0>
  translate<0,9.25,15>
  }

union {
  superellipsoid {  // arm side right
  <0.25, 0.225>   // around z-axis, around x-axis
  rotate <0,0,90>
  scale <2.25,9,10>
  }
  superellipsoid {  // arm roll
  <1, 0.225>   // around z-axis, around x-axis
  scale <3.25,2.25,10>
  rotate<0,0,15>
  translate <1,8.1,-0.15>
  }
  rotate <0,2.5,0>
  translate <11,16.5,10>
}

union {
  superellipsoid {  // arm side left
  <0.25, 0.225>   // around z-axis, around x-axis
  rotate <0,0,90>
  scale <2.25,9,10>
  }
  superellipsoid {  // arm roll
  <1, 0.225>   // around z-axis, around x-axis
  scale <3.25,2.25,10>
  rotate<0,0,-15>
  translate <-1,8.1,-0.15>
  }
  rotate <0,-2.5,0>
  translate <-11,16.5,10>
}
object { CLeg // front right
  translate <9.75,0,22.75>
  }
object { CLeg  // front left
  rotate <0,-90,0>
  translate <-9.75,0,22.75>
  }
object { CLeg  // back right
  rotate <0,90,0>
  translate <9.75,0,3>
  }
object { CLeg  // back left
  rotate <0,180,0>
  translate <-9.75,0,3>
  }

texture { Clothcolor
  normal { Cloth }
  }
rotate <0,0,0>
}  // end Chair







