//  Flea.inc  by Neil Alexander  1998
// Flea for animation Cosms.pov

/*camera {
  location <0, 0, -3>
  look_at <0, 0, 0>
  angle 30
  //orthographic
}

light_source { <-50, 200, -150> colour rgb 1 }

light_source { <50, -200, -100> colour rgb 0.75 }


plane { -z, -2
   pigment {
     checker colour rgb <0,1,1> colour rgb <0,0.75,1>
     }
   finish {
     ambient 0.2
     diffuse 0.8
     }
   translate <0.5,0.5,0>
} */ 

#declare Fleacolor = color rgb <1,0.375,0.188>;  

#declare Member1 = blob {
  threshold 0.56
  cylinder {<0,0,0>,<0,-1,0>,0.2,1}
  sphere {0,1,1
    scale <0.3,0.5,0.3>
    translate <-0.062,-0.5,0>
    }
  texture {
    pigment { marble
      color_map {
        [0 color Fleacolor*0.5]
        [0.75 color Fleacolor]
        }
      rotate z*90
      }
    finish { phong 0.5 phong_size 18 } 
    }
  } // end Member1
  
#declare Foot1 = union {
  #declare Count = 0;
  #while (Count < 7)
    sphere { 0,1
      texture {
        pigment { marble
          color_map {
            [0 color Fleacolor*0.5]
            [0.75 color Fleacolor]
            }
          rotate z*90
          scale 2
          translate y*1
          }
        finish { phong 0.5 phong_size 18 } 
        }
      scale <0.01,0.015,0.01>
      translate y*-0.02*Count
      }
    #declare Count = Count+1;
    #end  // end while
    cone {
      <0,0,0>,0.007,<0,-0.025,0>,0
      texture {
        pigment { Fleacolor }
        finish { phong 0.5 phong_size 18 } 
        }
      rotate <40,-30,0>
      translate y*-0.125
      }
    cone {
      <0,0,0>,0.007,<0,-0.025,0>,0
      texture { 
        pigment { Fleacolor }
        finish { phong 0.5 phong_size 18 } 
        }
      rotate <-40,30,0>
      translate y*-0.125
      }
    
    }  // end Foot1
    

#macro Flea (pose)   // 0=standing, 1=legs extended, -1=crouch 
union { 
  blob {
    threshold 0.56
    sphere { 0,1,1   // body
      scale <0.75,0.438,0.188>
      translate <-0.125,0.094,0>
      }
    sphere { 0,1,1   // back
      scale <0.25,0.125,0.125>
      translate <0.094,0.188,0>
      }    
    sphere { 0,1,1   // shoulders
      scale <0.125,0.125,0.125>
      translate <0.219,0.125,0>
      }
    sphere { 0,1,1   // head
      scale <0.188,0.125,0.188>
      rotate z*-15
      translate <0.375,0.156,0>
      }   
    cylinder { <0,0,-0.062>,<0,0,0.062>,0.062,0.5
      translate <0.39,0.175,0>
      }
    sphere { 0,1,1   // mouth part
      scale <0.01,0.094,0.01>
      rotate <10,-30,0>
      translate <0.45,0.062,-0.031>
      }      
    sphere { 0,1,1   // mouth part
      scale <0.01,0.094,0.01>
      rotate <-10,30,0>
      translate <0.45,0.062,0.031>
      }   
    sphere { 0,1,1   // mouth part
      scale <0.01,0.094,0.01>
      rotate <10,-60,0>
      translate <0.469,0.062,-0.02>
      }     
    sphere { 0,1,1   // mouth part
      scale <0.01,0.094,0.01>
      rotate <-10,60,0>
      translate <0.469,0.062,0.02>
      }
    
    
    
    texture { 
      pigment { wood 
        color_map {
          [0 Fleacolor*0.7]
          [1 Fleacolor]
          }           
        scale 0.05 translate <1,0.125,0>
        turbulence 0.05
        frequency 0.375
        ramp_wave
        }
      finish { phong 0.5 phong_size 18 } 
      normal { wood 0.07 
        scale 0.05 translate <1,0.125,0>
        turbulence 0.05
        frequency 0.375
        scallop_wave
        }
      }   // end texture
    }     // end blob 
  sphere { 0,1     // eye
    scale 0.02
    translate <0.406,0.175,-0.094>
    texture { 
      pigment { color rgb <0.4,0.2,0.15> }
      finish { phong 0.5 phong_size 18 } 
      }
    }         
  sphere { 0,1     // eye
    scale 0.02
    translate <0.406,0.175,0.094>
    texture { 
      pigment { color rgb <0.4,0.2,0.15> }
      finish { phong 0.5 phong_size 18 } 
      }
    }
  union { // leg r1
    object { Member1 scale 0.188 rotate z*90 translate x*-0.062 } // 1st member1
    union { //2
      object { Member1 scale 0.156 } // 2nd member1
      union { //3
        object { Member1 scale 0.14 }  // 3rd member1
        union { //4
          object { Member1 scale 0.125 } // 4th member1
          object { Foot1  // 5th member1
            rotate <0,0,10-10*pose> // relative to 4th member1
            translate y*-0.125
            }  
          rotate <0,0,40-40*pose>  // relative to 3rd member1
          translate y*-0.14
          }   //4
        rotate <0,0,-30+25*pose> // relative to 2nd member1
        rotate <0,10-5*pose,0>
        translate y*-0.156
        }  //3
      rotate <0,0,10+40*pose>  // relative to 1st member1 
      translate x*0.125
      }  //2
    rotate z*-40*pose
    rotate y*30   // relative to body
    translate <0.25,0.04,-0.05>
    }  // end leg r1  
    
  union { // leg l1
    object { Member1 scale 0.188 rotate z*90 translate x*-0.062 } // 1st member1
    union { //2
      object { Member1 scale 0.156 } // 2nd member1
      union { //3
        object { Member1 scale 0.14 }  // 3rd member1
        union { //4
          object { Member1 scale 0.125 } // 4th member1
          object { Foot1  // 5th member1
            rotate <0,0,10-10*pose> // relative to 4th member1
            translate y*-0.125
            }  
          rotate <0,0,40-40*pose>  // relative to 3rd member1
          translate y*-0.14
          }   //4
        rotate <0,0,-30+25*pose> // relative to 2nd member1
        rotate <0,-10+5*pose,0>
        translate y*-0.156
        }  //3
      rotate <0,0,10+40*pose>  // relative to 1st member1 
      translate x*0.125
      }  //2
    rotate z*-40*pose
    rotate y*-30   // relative to body
    translate <0.25,0.04,0.05>
    }  // end leg l1
  
  union { // leg r2
    object { Member1 scale 0.25 rotate z*90 translate x*-0.062 } // 1st member1
    union { //2
      object { Member1 scale 0.188 } // 2nd member1
      union { //3
        object { Member1 scale 0.156 }  // 3rd member1
        union { //4
          object { Member1 scale 0.125 } // 4th member1
          object { Foot1  // 5th member1
            rotate <0,0,15-5*pose> // relative to 4th member1
            translate y*-0.125
            }  
          rotate <0,0,80-20*pose>  // relative to 3rd member1
          #if (pose>0)
            rotate z*(-40*pose)  
            #end
          translate y*-0.156
          }   //4
        rotate <0,0,-30+5*pose> // relative to 2nd member1
        rotate <0,20-15*pose,0>
        translate y*-0.188
        }  //3
      rotate <40*pose,0,-30+5*pose>  // relative to 1st member1 
      rotate y*-70
      #if (pose>0)
        rotate y*(-30*pose)  
        #end
      translate x*0.188
      }  //2
    rotate z*(-10-40*pose)
    rotate y*90   // relative to body
    translate <0.203,0,-0.05>
    }  // end leg r2   
    
  union { // leg l2
    object { Member1 scale 0.25 rotate z*90 translate x*-0.062 } // 1st member1
    union { //2
      object { Member1 scale 0.188 } // 2nd member1
      union { //3
        object { Member1 scale 0.156 }  // 3rd member1
        union { //4
          object { Member1 scale 0.125 } // 4th member1
          object { Foot1  // 5th member1
            rotate <0,0,15-5*pose> // relative to 4th member1
            translate y*-0.125
            }  
          rotate <0,0,80-20*pose>  // relative to 3rd member1
          #if (pose>0)
            rotate z*(-40*pose)  
            #end
          translate y*-0.156
          }   //4
        rotate <0,0,-30+5*pose> // relative to 2nd member1
        rotate <0,-20+15*pose,0>
        translate y*-0.188
        }  //3
      rotate <-40*pose,0,-30+5*pose>  // relative to 1st member1 
      rotate y*70
      #if (pose>0)
        rotate y*(30*pose)  
        #end
      translate x*0.188
      }  //2
    rotate z*(-10-40*pose)
    rotate y*-90   // relative to body
    translate <0.203,0,0.05>
    }  // end leg l2  
    
  union { // leg r3
    object { Member1 scale 0.25 rotate z*90 translate x*-0.062 } // 1st member1
    union { //2
      object { Member1 scale 0.25 } // 2nd member1
      union { //3
        object { Member1 scale 0.188 }  // 3rd member1
        union { //4
          object { Member1 scale 0.156 } // 4th member1
          object { Foot1 scale 1.25  // 5th member1
            rotate <0,0,15-7*pose> // relative to 4th member1
            translate y*-0.156
            }  
          rotate <0,0,60-20*pose>  // relative to 3rd member1
          #if (pose>0)
            rotate z*(-40*pose)  
            #end
          rotate y*40
          translate y*-0.188
          }   //4
        rotate <0,0,-45+35*pose> // relative to 2nd member1
        rotate <-55+40*pose,0,0>
        translate y*-0.25
        }  //3
      rotate z*(45+10*pose)  // relative to 1st member1
      rotate x*(70+20*pose) 
      translate x*0.188
      }  //2
    rotate z*(-10-40*pose)
    rotate y*120   // relative to body
    translate <0.125,-0.04,-0.05>
    }  // end leg r3 
    
  union { // leg l3
    object { Member1 scale 0.25 rotate z*90 translate x*-0.062 } // 1st member1
    union { //2
      object { Member1 scale 0.25 } // 2nd member1
      union { //3
        object { Member1 scale 0.188 }  // 3rd member1
        union { //4
          object { Member1 scale 0.156 } // 4th member1
          object { Foot1 scale 1.25  // 5th member1
            rotate <0,0,15-7*pose> // relative to 4th member1
            translate y*-0.156
            }  
          rotate <0,0,60-20*pose>  // relative to 3rd member1
          #if (pose>0)
            rotate z*(-40*pose)  
            #end
          rotate y*-40
          translate y*-0.188
          }   //4
        rotate <0,0,-45+35*pose> // relative to 2nd member1
        rotate <55-40*pose,0,0>
        translate y*-0.25
        }  //3
      rotate z*(45+10*pose)  // relative to 1st member1
      rotate x*(-70-20*pose) 
      translate x*0.188
      }  //2
    rotate z*(-10-40*pose)
    rotate y*-120   // relative to body
    translate <0.125,-0.04,0.05>
    }  // end leg l3   
  scale 0.062
  }  // end union
#end  // end Flea
  
/*object { Flea(0)
  //translate y*0.188
  rotate y*20
  //rotate x*90
  }    */