// House.inc  by Neil Alexander  1998
// This file defines the house exterior and interior for Cosms.pov

// this file uses "rug2.gif" and "gable.gif"
#include "trim.inc"
#include "chair.inc"
#include "bookcase.inc"

//*********** TEXTURE DECLARATIONS ************

#declare Brickcolor = color rgb <0.86,0.29,0.09>;     
#declare Brickcolor2 = color rgb <1,0.89,0.48>;
#declare Roofcolor = array[2]
#declare Roofcolor[0] = color rgb <0.48,0.7,0.56>;
#declare Roofcolor[1] = color rgb <0.83,0.65,0.5>; 
#declare Troughcolor = array[2]
#declare Troughcolor[0] = color rgb <0.84,0.41,0.16>;
#declare Troughcolor[1] = color rgb <0.92,0.84,0.61>;

#declare Walltext = texture {
  pigment { color rgb <0.95, 0.93,0.79>}
  finish { diffuse 0.9 }
  normal { bumps 0.1 scale 0.01 }
  }

#declare Floortext1 = texture {
  pigment {
    wood
    turbulence 0.02
    octaves 3
    scale <0.1, .1, 1>
    color_map {
      [0.0, 0.2 color rgb <0.855, 0.643, 0.38>
        color rgb <0.855, 0.643, 0.38>]
      [0.98  color rgb <0.569, 0.373, 0.133>]
      }
    }
  finish { reflection 0.1 }
  rotate<10,0,0>
  translate<-50,0,0>
  }

#declare Floortext2 = texture {
  pigment {
    wood
    turbulence 0.02
    octaves 3
    scale <0.1, .1, 1>
    color_map {
      [0.0, 0.2 color rgb <0.855, 0.643, 0.38>
        color rgb <0.855, 0.643, 0.38>]
      [0.2, 0.98 color rgb <0.855, 0.643, 0.38>
        color rgb <0.569, 0.373, 0.133>]
      [0.98, 1.0 color rgb <0.569, 0.373, 0.133>
        color rgb <0.569, 0.373, 0.133>]
      }
    }
  finish { reflection 0.1 }
  rotate<-10,10,0>
  translate<-35,0,0>
  }

#declare Floortext3 = texture {
   pigment { color rgb <0,0,0> }
   }
  
//********************** ENVIRONMENT *********************

#declare Sky = sky_sphere {
  pigment { gradient y
    color_map { 
      [0.0 color rgb <0.9,0.95,1>]
      [1.0 color rgb <0.1,0.5,1>]
      }
    }
  }  
   
#declare Cloudsky = sphere {0,1  // clouds, ground
  texture { // clouds
    pigment { bozo
      color_map {
        [0.5 color rgbt 1]
        [0.7 color rgbt <0.9,0.95,1, 0.1>]
        [0.8 color rgbt <0.9,0.95,1, 0.1>]
        [1.0 color rgbt <0.90,0.85,0.95,0>]
        }
      scale 0.18
      turbulence 1
      omega 0.75
      }
    finish {ambient 1 diffuse 0}
    }
  texture { // ground
    pigment { gradient y
      color_map {
        [0 color rgb <0.3,0.28,0.25>]
        [0.2 color rgb <0.32,0.4,0.34>]
        [0.5 color rgbt <0.32,0.4,0.34,1>]
        }
      scale <0.08,3,0.08>
      translate y*-1
      turbulence 0.2
      lambda 4 
      omega 0.3
      }
    finish { ambient 1 diffuse 0 }
    } 
  scale <100000,10000,100000>
  no_shadow
  hollow
  }  // end Cloudsky
  
#declare Sun = 
  light_source {   // sun
    <0,0,0>
    color rgb 1
    translate 100000000*z
    rotate <-40,-62,0>
    }
 
//********************** HOUSE EXTERIOR *********************

#declare Gable = intersection {
  height_field {
    gif "gable.gif"   
    rotate y*90
    translate <0,-1,1>
    rotate z*90
    scale <1.1,163.469,72.781>
    }
  box {<-1,-1,-1>,<1,163.5,73>}
  texture { 
    pigment { color rgb 1 }
    finish { ambient 0.2 phong 0.5 phong_size 1 diffuse 0.7 }
    }   
  }   // end Gable
 
#macro House (Style)  // 0 or 1

#declare Rooftext = texture {
  pigment { brick
    Roofcolor[Style]*0.5, Roofcolor[Style]
    brick_size <18,12,18>
    mortar 1
    }
  normal { granite 0.08 }
  finish { diffuse 0.8 }
  } 

#declare Eavestrough = union {
  difference {
    box {<-32,93,-16>,<-28,98,16>}
    box {<-33,92,-18>,<-29,94,18>}
    box {<-33,94,-18>,<-31,96,18>}
    cylinder {<-31,94,-18>,<-31,94,18>,1}
    }
  cylinder {<-29,94,-16>,<-29,94,16>,1} 
  cylinder {<-31,96,-16>,<-31,96,16>,1}
  texture {
    pigment { Troughcolor[Style] }
    finish { diffuse 0.8 phong 0.2 phong_size 15 }
    }
  } // end union Eavestrough
  
#declare Downspout = union {
  cylinder {<-29.5,97,0>,<-29.5,85,0>,1.5
    texture { 
      pigment { Troughcolor[Style] }
      finish { diffuse 0.8 phong 0.2 phong_size 15 }
      normal { radial 1 frequency 12 sine_wave }
      translate <-29.5,0,0> 
      }
    } 
  intersection { // elbow
    torus {4.5,1.625}
    box {<-6.5,-2,-6.5>,<0,2,0>}
    texture {
      pigment { Troughcolor[Style] }
      finish { diffuse 0.8 phong 0.2 phong_size 15 }
      normal { radial 0.5 frequency 48 sine_wave }
      }
    rotate x*-90
    translate <-25,85,0>
    } // end elbow 
  cylinder {<-25,80.5,0>,<-16.5,80.5,0>,1.5
    texture { 
      pigment { Troughcolor[Style] }
      finish { diffuse 0.8 phong 0.2 phong_size 15 }
      normal { radial 1 frequency 12 sine_wave }
      rotate z*90
      translate <0,80.5,0> 
      }
    }
  intersection { // elbow
    torus {4.5,1.625}
    box {<-0,-2,-0>,<6.5,2,6.5>}
    texture {
      pigment { Troughcolor[Style] }
      finish { diffuse 0.8 phong 0.2 phong_size 15 }
      normal { radial 0.5 frequency 48 sine_wave }
      }
    rotate x*-90
    translate <-16.5,76,0>
    } // end elbow
  cylinder {<-12,-192,0>,<-12,76,0>,1.5
    texture { 
      pigment { Troughcolor[Style] }
      finish { diffuse 0.8 phong 0.2 phong_size 15 }
      normal { radial 1 frequency 12 sine_wave }
      translate <-12,0,0> 
      }
    }  
    
     
  }  // end union Downspout
   
union {  // house exterior
  difference {  // - windows & interior
    box {<-10,-192,-9>,<332,282,175>}
    plane {-y,0
      rotate z*43.4
      translate <-10,119,0>
      }
    plane {-y,0
      rotate -z*43.4
      translate <332,119,0>
      }
    box {<-8,-1,-1>,<157,115,157>
      texture { pigment { color rgb 1}}} // interior
    box { <-11,17,40>,<-7,82,73>} // hole for window
    box { <-11,17,93>,<-7,82,126>} // hole for 2nd window
    cylinder {<-11,82,56.5>,<-7,82,56.5>,16.5}
    cylinder {<-11,82,109.5>,<-7,82,109.5>,16.5}
    }  // end difference
  difference {   // peak
    box {<-10,119,0>,<0,282,166>}
    plane {-y,0
      rotate x*66
      translate <0,119,154>
      }
    plane {-y,0
      rotate -x*66
      translate <0,119,12>
      }
    box {<-10.5,148,69>,<-6,192,97>} // hole for attic window 
    cylinder {<-10.5,192,83>,<-6,192,83>,14}
    } // end intersection - peak 
  
  union { // Roof
    difference {
      intersection { // eaves - side peak
        box {<-28,91,-28>,<350,282,193>}
        plane {y,0
          rotate z*43.4
          translate <-10,120,0>
          }
        plane {y,0
          rotate -z*43.4
          translate <332,120,0>
          }
        }  // end intersection
      intersection {
        plane {y,0
          rotate z*43.4
          translate <-10,108,0>
          }
        plane {y,0
          rotate -z*43.4
          translate <332,108,0>
          }
        } // end intersection
      intersection {
        plane {y,0
          rotate x*66
          translate <0,102,154>
          }
        plane {y,0
          rotate -x*66
          translate <0,102,12>
          }
        plane {x,161}
        } // end intersection
      } // end difference - side eaves
  
    difference {
      intersection { // eaves - front peak
        box {<-28,100,0>,<161,284,166>}
        plane {y,0
          rotate x*66
          translate <0,120,154>
          }
        plane {y,0
          rotate -x*66
          translate <0,120,12>
          }
        }  // end intersection
      intersection {
        plane {y,0
          rotate x*66
          translate <0,102,154>
          }
        plane {y,0
          rotate -x*66
          translate <0,102,12>
          }
        } // end intersection
      box {<-8,-1,-1>,<157,115,157>} // interior
      } // end difference - eaves   
      
    texture { 
      pigment { color rgb 1 }
      finish { ambient 0.2 phong 0.5 phong_size 1 diffuse 0.7 }
      }
    } // end union Roof   
    
  union { // Shingles
    difference {
      intersection { //  side peak upper
        box {<-30,90,-30>,<352,284,195>}
        plane {y,0
          texture { Rooftext
            rotate z*-90
            translate y*2
            }
          rotate z*43.4
          translate <-10,121,0>
          }
        plane {y,0
          texture { Rooftext
            rotate z*90
            translate y*2
            }
          rotate -z*43.4
          translate <332,121,0>
          }
        }  // end intersection
      intersection { // side peak lower
        plane {y,0
          rotate z*43.4
          translate <-10,120,0>
          }
        plane {y,0
          rotate -z*43.4
          translate <332,120,0>
          }
        } // end intersection
      intersection { // cut-out for front
        plane {y,0
          rotate x*66
          translate <0,120,154>
          }
        plane {y,0
          rotate -x*66
          translate <0,120,12>
          }
        plane {x,161}
        } // end intersection
      } // end difference - side eaves
  
    difference {
      intersection { // eaves - front peak
        box {<-30,102,0>,<161,284,166>}
        plane {y,0
          texture { Rooftext
            rotate x*-90 
            translate y*2
            }
          rotate x*66
          translate <0,121,154>
          }
        plane {y,0
          texture { Rooftext
            rotate x*90 
            translate y*2
            }
          rotate -x*66
          translate <0,121,12>
          }
        }  // end intersection
      intersection {
        plane {y,0
          rotate x*66
          translate <0,120,154>
          }
        plane {y,0
          rotate -x*66
          translate <0,120,12>
          }
        } // end intersection
      box {<-8,-1,-1>,<157,115,157>} // interior
      } // end difference - eaves   
      
    texture { Rooftext }
    } // end union Shingles
  
  union {  // Gables
    #if (Style = 1)
      difference {
        intersection { // eaves - front peak
          box {<-26,92,0>,<-24,284,166>}
          plane {y,0
            rotate x*66
            translate <0,102,154>
            }
          plane {y,0
            rotate -x*66
            translate <0,102,12>
            }
          }  // end intersection
        intersection {
          plane {y,0
            rotate x*66
            translate <0,96,154>
            }
          plane {y,0
            rotate -x*66
            translate <0,96,12>
            }
          }
        }  // end difference
    #else
      object { Gable // Gingerbread gables 
        translate <-26,92,7>
        }
      object { Gable // Gingerbread gables
        rotate y*180 
        translate <-25,92,159>
        }
      
    #end  // if-else Gables
      
    intersection { // post
      box {<-28.5,212,81>,<-24.5,284,85>}
      plane {y,0
        rotate x*66
        translate <0,120,154>
        }
      plane {y,0
        rotate -x*66
        translate <0,120,12>
        }
      }  // end intersection
    texture { 
      pigment { color rgb 1 }
      finish { ambient 0.2 phong 0.5 phong_size 1 diffuse 0.7 }
      }
    }  // end union Gables
  
  object { Eavestrough
    translate z*-11.5
    }
    
  object { Downspout
    translate z*-8
    }
    
  object { Eavestrough
    translate z*176.5
    }
    
  object { Downspout
    translate z*173
    }  
  
  difference { // window arch
    cylinder {<-10.5,81,56.5>,<-8,81,56.5>,20.5}
    cylinder {<-11,81,56.5>,<-7,81,56.5>,16.5}
    plane {y,81}
    texture { 
      pigment { radial
        color_map {
          [0.85 Brickcolor]
          [0.85 color rgb 0.8]
          }
        frequency 30
        rotate <0,91,90>
        translate <0,81,56.5>
        }
      normal { granite 0.4 }
      finish { diffuse 0.8 }
      }
    } // end difference  
  
  difference { // 2nd window arch
    cylinder {<-10.5,81,109.5>,<-8,81,109.5>,20.5}
    cylinder {<-11,81,109.5>,<-7,81,109.5>,16.5}
    plane {y,81}
    texture { 
      pigment { radial
        color_map {
          [0.85 Brickcolor]
          [0.85 color rgb 0.8]
          }
        frequency 30
        rotate <0,91,90>
        translate <0,81,109.5>
        }
      normal { granite 0.4 }
      finish { diffuse 0.8 }
      }
    } // end difference 
  
  difference { // big arch
    cylinder {<-10.5,81,83>,<-8,81,83>,56}
    cylinder {<-11,81,83>,<-7,81,83>,48}
    plane {y,81}
    texture { 
      pigment { radial
        color_map {
          [0.85 Brickcolor2]
          [0.85 color rgb 0.6]
          }
        frequency 82
        rotate <0,90,90>
        translate <0,81,83>
        }
      normal { granite 0.2 }
      finish { diffuse 0.8 }
      }
    } // end difference  
  
  box { <-10.5,12,38>,<-7,19,75> // sill for window 
    texture {
      pigment { color rgb 0.95 }
      normal { granite 0.4}
      finish { diffuse 0.8 }
      }
    }
  
  box { <-10.5,12,91>,<-7,19,128> // sill for 2nd window
    texture {
      pigment { color rgb 0.95 }
      normal { granite 0.4 }
      finish { diffuse 0.8 }
      }
    }
  
  union {  // attic window
    difference {  // frame - opening
      union { // frame
        box {<-9.5,148,69>,<-8,192,97>}  
        cylinder {<-9.5,192,83>,<-8,192,83>,14}
        } // end frame
      box {<-11,148,73>,<-7,176,93>}
      box {<-11,180,73>,<-7,192,93>}
      cylinder {<-11,192,83>,<-7,192,83>,10}
      }  // end difference
    union { // face area
      box {<-9,148,73>,<-8,192,93>}
      cylinder {<-9,192,83>,<-8,192,83>,10}
      #if (Style = 0)
        texture { 
          pigment { gradient y
            color_map {
              [0 color rgb 1]
              [1 color rgb 0.3]
              }
            scale 3
            }
          normal { gradient y 10 scale 3 translate 300 }
          finish { phong 0.5 phong_size 1 diffuse 0.7 }
          }
      #else
        texture {
          pigment { color rgb 0.1 }
          finish { reflection 0.5 }
          }
        #end  
      } // end face area
    box {<-11,144,67>,<-9,148,99>} // sill
    texture { 
      pigment { color rgb 1 }
      finish { phong 0.5 phong_size 1 diffuse 0.7 }
      }
    }  // end attic window
  
  difference { // attic window arch
    cylinder {<-10.5,192,83>,<-8,192,83>,22}
    cylinder {<-11,192,83>,<-7,192,83>,14}
    plane {y,192}
    texture { 
      pigment { radial
        color_map {
          [0.85 Brickcolor2]
          [0.85 color rgb 0.6]
          }
        frequency 28
        rotate <0,90,90>
        translate <0,192,83>
        }
      normal { granite 0.2 }
      finish { diffuse 0.8 }
      }
    } // end difference   
  
  object { WindowFrame }

  object { WindowFrame
    translate<0,0,53>
    } 
    
  union { // corner bricks
    #declare Count=0;
    #while (Count<13 )
      box {<-0.01,Count*24,-0.01>,<7.625,(Count*24)+12,7.625>}
      box {<-0.01,(Count*24)+12,-0.01>,<2,(Count*24)+24,11.625>} 
      box {<-0.01,(Count*24)+12,-0.01>,<11.625,(Count*24)+24,2>}
      box {<-0.01,Count*24,175.625>,<7.625,(Count*24)+12,184.21>}
      box {<-0.01,(Count*24)+12,171.625>,<2,(Count*24)+24,184.21>}
      box {<-0.01,(Count*24)+12,180>,<11.625,(Count*24)+24,184.21>}
      #declare Count = Count+1;
      #end // end while
    texture { 
      pigment { brick
        color rgb 0.6, Brickcolor2
        brick_size <8,4,8>
        mortar 0.375
        translate <-0.2,4,-0.2>
        }
      normal { granite 0.2 }
      finish { diffuse 0.8 }
      }
    translate <-10,-192,-9>
    } // end corner bricks   
      
  texture {  // outer red brick
    pigment { brick
      color rgb 0.8, Brickcolor
      brick_size <8,4,8>
      mortar 0.375
      translate <-10.2,-188,-9.2>
      turbulence 0.1
      } 
    normal { granite 0.4 }
    finish { diffuse 0.8 }
    }
  }  // end union - house exterior
#end  // end House

//********************** LIVING ROOM ***********************

#declare Livingroom = union {
box { // floor
  <0, -1, 0>  // one corner position <X1 Y1 Z1>
  < 156,  0,  156>  // other corner position <X2 Y2 Z2>
  texture {
    gradient x
    texture_map {
      [ 0.0 Floortext1 ]
      [ 0.48 Floortext1 ]
      [ 0.48 Floortext3 ]
      [ 0.50 Floortext3 ]
      [ 0.50 Floortext2 ]
      [ 0.98 Floortext2 ]
      [ 0.98 Floortext3 ]
      }
    scale 4
    }
  }

box { // wall xy
  <-1, -1, -1>  // one corner position <X1 Y1 Z1>
  < 156, 114,  0>  // other corner position <X2 Y2 Z2>
  texture { Walltext }
  }

box { // wall xy column
  <72, -1, -1>  // one corner position <X1 Y1 Z1>
  < 92, 114, 15.5>  // other corner position <X2 Y2 Z2>
  texture { Walltext }
}

box { // wall xy opposite
  <-1, -1, 156>  // one corner position <X1 Y1 Z1>
  < 156, 114,  157>  // other corner position <X2 Y2 Z2>
  texture { Walltext }
}
 
difference {
  box {  // wall zy
    <-1, -1, -1>  // one corner position <X1 Y1 Z1>
    < 0, 114, 156>  // other corner position <X2 Y2 Z2>
    texture { Walltext }
  }
  box { // hole for window
    <-2,17,37>
    <1,101,76>
    }
  box { // hole for 2nd window
    <-2,17,90>
    <1,101,129>
    }
  }  

box {  // wall zy opposite
  <156, -1, -1>  // one corner position <X1 Y1 Z1>
  < 157, 114, 156>  // other corner position <X2 Y2 Z2>
  texture { Walltext }
  }  

box  // ceiling
{
  <0, 114, 0>  // one corner position <X1 Y1 Z1>
  < 156,  115,  156>  // other corner position <X2 Y2 Z2>
  texture {
    pigment { color rgb <1,1,1> }
    }
  }   

box { // rug
  <36,0,24>
  <102,0.25,120>
  texture {
    pigment {
      image_map {
        gif "rug2.gif" // the file to read (iff/gif/tga/png/sys)
        map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
        interpolate 2 // 0=none, 1=linear, 2=bilinear, 4=normalized distance
        } // image_map
      }
    scale<66,96,1>
    rotate<-90,0,0>
    translate<36,0,24>
    finish { diffuse 0.8 }
    }
  }

object { Baseboard }  // zy-wall

object { Baseboard  // xy-wall
  translate<0,0,-156>
  rotate<0,-90,0>
  }

object { Baseboard  // zy-wall opposite
  rotate<0,180,0>
  translate<156,0,156>
  }

object { Baseboard  // xy-wall opposite
  rotate<0,90,0>
  translate<0,0,156>
  }

difference{  // baseboard around column
  object { Baseboard
    translate<15.5,0,-156>
    rotate<0,-90,0>
    }
  plane{ z,0
    rotate<0,-45,0>
    translate<92,0,15.5>
    }
  plane{ z,0
    rotate<0,45,0>
    translate<72,0,15.5>
    }
  }

difference{
  object { Baseboard
    translate<92,0,0>
    }
  plane{ x,0
    rotate<0,45,0>
    translate<92,0,15.5>
    }
  }

difference{
  object { Baseboard
    rotate<0,180,0>
    translate<72,0,156>
    }
  plane{ -z,0
    rotate<0,45,0>
    translate<72,0,15.5>
    }
  }

object { Bookcase
  translate <38,0,1.5>
  }

object { Chair
  translate <-5,0,18>
  rotate<0,50,0>
  }

}  // end union - Livingroom

