// Trim.inc  by Neil Alexander  1998
// Windows and baseboard for House.inc


#declare Trimtext = texture {
  pigment { color rgb <1,1,1> }
  finish {  phong 0.5 phong_size 1 diffuse 0.7 }
  normal { bumps 0.1 scale 0.01}
  }

#declare Frame = prism { // window frame side and top
  linear_spline
    0, // sweep the following shape from here ...
    86, // ... up through here
    38, // the number of points making up the shape ...

<0,0>
<0,-9.25>
<-0.25,-9.25>
<-0.35,-9.55>
<-0.45,-9.65>
<-0.75,-9.75>
<-0.75,-10>
<-1.25,-10>
<-1.25,-9.75>
<-1.5,-9.75>
<-2,-9.5>
<-2.25,-9.5>
<-2.25,-9.25>
<-2.5,-9.25>
<-2.5,-9>
<-4,-9>
<-4,-8.75>
<-4.25,-8.75>
<-4.25,-8.5>
<-5.5,-8.5>
<-5.5,-8.25>
<-5.8,-8.15>
<-5.9,-8.05>
<-6,-7.75>
<-6,-7.5>
<-6.5,-7.5>
<-6.5,-6.5>
<-6,-6.5>
<-6,-4.5>
<-6.5,-4.5>
<-6.5,-4.25>
<-6,-4.25>
<-6,-2.25>
<-6.5,-2.25>
<-6.5,-1.5>
<-6,-1.5>
<-6,0>
<0,0>
}

#declare Sill = union { // inner window sill
  prism {
    linear_spline
    0, // sweep the following shape from here ...
    46, // ... up through here
    21, // the number of points making up the shape ...

  <6,0>
  <6,1.5>
  <1.5,1.5>
  <0.5,1.5>
  <0.5,6.5>
  <0,6.5>
  <0,10.5>
  <2,10.5>
  <2,10>
  <2.5,10.5>
  <3,10.5>
  <3,10.25>
  <3.75,10>
  <4,9.75>
  <4.15,9.75>
  <4.4,9.5>
  <4.5,9.35>
  <5.5,9.35>
  <5.5,9.25>
  <6,9.25>
  <6,0>
  }
  cylinder { <1,0,10.5>, <1,46,10.5>, 1 }
  cylinder { <5.75,0,9.25>, <5.75,46,9.25>, .25 }
}  // end Sill

#declare WindowFrame = union {
  intersection { // right vertical
    object { Frame
      rotate<0,-90,0>
      }
    plane { y,0
      rotate <-45,0,0>
      translate<0,86,0>
      }
    translate<-8.5,17,78>
    }
  intersection { // left vertical
    object { Frame
      rotate <180,90,0>
      translate<0,86,0>
      }
    plane { y,0
      rotate <45,0,0>
      translate<0,86,0>
      }
    translate<-8.5,17,35>
    }
  difference { // top
    object { Frame
      rotate <-90,0,90>
      translate<0,0,86>
      }
    plane { y,0
      rotate <45,0,0>
      translate<0,0,35>
      }
    plane { y,0
      rotate <-45,0,0>
      translate<0,0,78>
      }
    translate<-8.5,103,0>
    }
  difference { // sill across
    object { Sill
      rotate<-90,0,-90>
      }
    plane{z,0
      rotate<0,45,0>
      translate<11.5,0,-46>
      }
    plane{x,0
      rotate<0,45,0>
      translate<11.5,0,0>
      }
    translate<-8.5,19,79.5>
    }
  difference { // sill right edge
    object { Sill
      rotate<-90,0,-90>
      }
    plane{z,0
      rotate<0,45,0>
      translate<11.5,0,-46>
      }
    plane{x,0
      rotate<0,90,0>
      translate<0,0,-34.5>
      }
    translate<0,0,34.5>
    rotate<0,-90,0>
    translate<-8.5,19,68>
    }
  difference { // sill left edge
    object { Sill
      rotate<-90,0,-90>
      }
    plane{x,0
      rotate<0,45,0>
      translate<11.5,0,0>
      }
    plane{x,0
      rotate<0,-90,0>
      translate<0,0,-11.5>
      }
    translate<0,0,11.5>
    rotate<0,90,0>
    translate<-8.5,19,45>
    }   
  difference { // outer arch 1
    box {
      <-7,81,41.5>
      <-6.25,96.5,71.5>
      }
    cylinder {
      <-7.1,81 ,56.5>,
      <-6.2,81,56.5>,15
      }
    } 
  difference { // outer arch 2
    box {
      <-8.5,81,41>
      <-7,97,72>
      }
    cylinder {
      <-8.6,81 ,56.5>,
      <-6.9,81,56.5>,15.5
      }
    } 
  
  difference { // lower pane
    box {
      <-3.9,18.5,41>
      <-2.1,59,72>
      }
    box {
      <-4,21.5,43>
      <-2,58,70>
      }
    box {
      <-3.625,21.25,42.75>
      <-3.5,58.25,70.25>
      }
    }
  box {  // lower pane glass
    <-3.625,21.25,42.75>
    <-3.5,58.25,70.25>
    texture {
      pigment { color rgbf <0.95,1,1,0.8> }
      finish  {  reflection 0.2 }
      }
    no_shadow
    }
  difference { // upper pane
    box {
      <-6.15,58,41>
      <-4.35,97,72>
      }
    box {
      <-6.25,59,43>
      <-4.25,81,70>
      }
    box {
      <-5.875,58.25,42.75>
      <-5.75,94.75,70.25>
      }
    cylinder {
      <-6.25,81 ,56.5>,
      <-4.25,81,56.5>,13.5
      }
    }
  box {  // upper pane glass
    <-5.875,58.25,42.75>
    <-5.75,94.75,70.25>
    texture {
      pigment { color rgbf <0.95,1,1,0.8> }
      finish  { reflection 0.2 }
      }
    no_shadow
    }
  texture { Trimtext }
  }  // end WindowFrame

#declare Baseboard = union {
  prism {
    linear_spline
    0, // sweep the following shape from here ...
    156, // ... up through here
    13, // the number of points making up the shape ...
    <0,0>
    <1,0>
    <1,7>
    <0.8,7.05>
    <0.75,7.25>
    <0.55,7.3>
    <0.5,7.5>
    <0.854,8.354>
    <0.5,8.707>
    <0.5,9.8>
    <0.3,10>
    <0,10>
    <0,0>
    }
  cylinder { <0.5,0,8>, <0.5,156,8>, 0.5 }
  cylinder { <0.45,0,9.375>, <0.45,156,9.375>, 0.375 }
  cylinder { <1,0,0>, <1,156,0>, 1 }
  rotate<-90,0,0>       // oriented for window wall
  translate<0,0,156>
  texture { Trimtext }
  }  // end Baseboard
