// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions



sky_sphere {pigment {granite color_map {
[0.0 White]
[0.1 Black]
}
scale .1
}}

camera
{
  location  <-5.0 , 15.0 ,-20.0>
  look_at   <0.0 , 10.0 , 0.0>
}
// create a regular point light source

light_source
{
  0*x // light's position (translated below)
  color rgb 1.0  // light's color
  // <widthVector> <heightVector> nLightsWide mLightsHigh
  area_light
  <-5, -5, 0> <5, 5, 0> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3... 
  jitter              // adds random softening of light
  translate <-10, 30, -70>   // <x y z> position of light
}


background {rgb <0,0,0>}

global_settings {
#max_trace_level 30
}


plane {y,0 pigment {Green}}

lathe {
  cubic_spline // linear_spline | quadratic_spline | cubic_spline
  6, // number of points
  <5, -2>,<4.5, 0>, <3.2, 3>, <2.7, 8>, <3.7, 10>,<4, 10> // the list of <u,v> points
pigment {Gray80}
translate <-5,0,0>
}

lathe {
  cubic_spline // linear_spline | quadratic_spline | cubic_spline
  6, // number of points
  <5, -2>,<4.5, 0>, <3.2, 3>, <2.7, 8>, <3.7, 10>,<4, 10> // the list of <u,v> points
pigment {Gray80}
translate <5,0,0>
}



text
{
  ttf             // font type (only TrueType format for now)
  "c:\windows\fonts\ariblk.ttf",  // Microsoft Windows-format TrueType font file name
  "Tjernobyl",      // the string to create
  3,              // the extrusion depth
  0               // inter-character spacing
pigment {Clear}
hollow
interior {media  {
emission <0,.4,0>
}
}
scale 4
rotate <0,10,0>
translate <-10,15,0>
}

text
{
  ttf             // font type (only TrueType format for now)
  "c:\windows\fonts\ariblk.ttf",  // Microsoft Windows-format TrueType font file name
  "Tjernobyl",      // the string to create
  .1,              // the extrusion depth
  0               // inter-character spacing
pigment {Clear}
hollow
interior {media  {
emission <4,0,0>
}
}
scale 4
translate <0,0,-.1>
rotate <0,10,0>
translate <-10,15,0>
}

text
{
  ttf             // font type (only TrueType format for now)
  "c:\windows\fonts\ariblk.ttf",  // Microsoft Windows-format TrueType font file name
  "The Mutation Returns",      // the string to create
  .1,              // the extrusion depth
  0               // inter-character spacing
pigment {Clear}
hollow
interior {media  {
emission <4,0,2>
}
}
scale 1.4
translate <0,0,-.1>
rotate <0,10,0>
translate <-7,13,-3>
}




text
{
  ttf             // font type (only TrueType format for now)
  "c:\windows\fonts\ariblk.ttf",  // Microsoft Windows-format TrueType font file name
  "Modeling:",      // the string to create
  .1,              // the extrusion depth
  0               // inter-character spacing
pigment {Clear}
hollow
interior {media  {
emission <0,0,8>
}
}
scale 1
translate <0,0,-.1>
rotate <0,10,0>
translate <-8,12,-5>
}


text
{
  ttf             // font type (only TrueType format for now)
  "c:\windows\fonts\ariblk.ttf",  // Microsoft Windows-format TrueType font file name
  "Rendering:",      // the string to create
  .1,              // the extrusion depth
  0               // inter-character spacing
pigment {Clear}
hollow
interior {media  {
emission <0,0,8>
}
}
scale 1
translate <0,0,-.1>
rotate <0,10,0>
translate <-8,9,-5>
}


text
{
  ttf             // font type (only TrueType format for now)
  "c:\windows\fonts\ariblk.ttf",  // Microsoft Windows-format TrueType font file name
  "Screaming:",      // the string to create
  .1,              // the extrusion depth
  0               // inter-character spacing
pigment {Clear}
hollow
interior {media  {
emission <0,0,8>
}
}
scale 1
translate <0,0,-.1>
rotate <0,10,0>
translate <-8,6,-5>
}







text
{
  ttf             // font type (only TrueType format for now)
  "c:\windows\fonts\ariblk.ttf",  // Microsoft Windows-format TrueType font file name
  "Matti Raitoharju",      // the string to create
  .1,              // the extrusion depth
  0               // inter-character spacing
pigment {Clear}
hollow
interior {media  {
emission <4,0,0>
}
}
scale 2
translate <0,0,-.1>
rotate <0,10,0>
translate <-10,10,-5>
}


text
{
  ttf             // font type (only TrueType format for now)
  "c:\windows\fonts\ariblk.ttf",  // Microsoft Windows-format TrueType font file name
  "Vesa Syrjala",      // the string to create
  .1,              // the extrusion depth
  0               // inter-character spacing
pigment {Clear}
hollow
interior {media  {
emission <4,0,0>
}
}
scale 2
translate <0,0,-.1>
rotate <0,10,0>
translate <-8,7,-5>
}
text
{
  ttf             // font type (only TrueType format for now)
  "c:\windows\fonts\ariblk.ttf",  // Microsoft Windows-format TrueType font file name
  "                .. ..",      // the string to create
  .1,              // the extrusion depth
  0               // inter-character spacing
pigment {Clear}
hollow
interior {media  {
emission <4,0,0>
}
}
scale 2
translate <0,0,-.1>
rotate <0,10,0>
translate <-8.3,8.5,-5>
}


text
{
  ttf             // font type (only TrueType format for now)
  "c:\windows\fonts\ariblk.ttf",  // Microsoft Windows-format TrueType font file name
  "Petri Korhonen",      // the string to create
  .1,              // the extrusion depth
  0               // inter-character spacing
pigment {Clear}
hollow
interior {media  {
emission <4,0,0>
}
}
scale 2
translate <0,0,-.1>
rotate <0,10,0>
translate <-9,4,-5>
}

#declare risti=union {
box {<-.5,0,0>,<.5,5,.1>}
box {<-1.5,4,0>,<1.5,3,.1>}
pigment {DMFWood4}
}
union {
#local k=0;
#while (k<35)
#local p=-k*5;
#while (p<k)
object {risti translate <p,0,10+k*9>}
#local p=p+5;
#end
#local k=k+1;
#end
rotate <0,25,0>
}
sphere {0,0}