// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "skies.inc"
#local clocka=clock

/*camera
{
  location  <-5.0 , 5.0 ,-15.0>
  look_at   <0.0 , 3 , 0.0>
}
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-5, 10, -20>
}
*/
#switch (clocka)
#range (-1000,-3)
#local kiu=1;
#break
#range (-3,-1.5)
#local kiu=-(clocka+3)/1.5+1
#break
#range (-1.5,1000)
#local kiu=0
#break
#end
sky_sphere {
pigment {average pigment_map {
[kiu gradient y
        pigment_map {
            [0.01 rgb <0.847, 0.749, 0.847> ] // horizon
            [0.25 P_Cloud2 scale 0.25 rotate z*5]
            [0.60 P_Cloud3 scale <0.25, 0.15, 0.25> rotate z*10]
        }
   
]
[1-kiu Black]
}
}}

plane {y,0 pigment {
average pigment_map {
[kiu Green]
[1-kiu Black] 
}}

}


#switch (clocka)
#range (-100,-2)
camera
{
  location  <-90.0 , 90.0 ,-270.0>
  look_at   <0.0 , 105 , 0.0>
}
#break
#range (-2,0)
#local pp=((clocka+1)*pi)/2
camera
{
  location  <-47.5+sin(pp)*42.5 , 67.5-sin(pp)*22.5 ,-142.5+sin(pp)*127.5>
  look_at   <0.0 , 73.5-sin(pp)*31.5 , 0.0>
}
#break
#range (0,100)
camera
{
  location  <-5.0 , 45.0 ,-15.0>
  look_at   <0.0 , 42 , 0.0>
}
#break
#end


light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-5, 10, -20>*10
}



background {rgb <0,0,0>}

global_settings {
#max_trace_level 30
}




union {
#local poh=0
#if (clock>3.5)
#local poh=clock*3-10.5
#end
sphere {<-1,4.2,-3.5>,.7 pigment {gradient z pigment_map {
[0.1 granite color_map {
[0.0 Red]
[0.4 White]
[0.6 White]
}
turbulence 1
]
[0.15 Black]
[0.2 Green]
[0.3 Green]
[0.35 White]
[0.4 White]
[0.5 granite color_map {
[0.0 Red]
[0.4 White]
[0.6 White]
}
turbulence 1
]


}}
translate <0,0,-poh>
}
sphere {<1,4.2,-3.5>,.7 
pigment {gradient z pigment_map {
[0.1 granite color_map {
[0.0 Red]
[0.4 White]
[0.6 White]
}
turbulence 1
]
[0.15 Black]
[0.2 Green]
[0.3 Green]
[0.35 White]
[0.4 White]
[0.5 granite color_map {
[0.0 Red]
[0.4 White]
[0.6 White]
}
turbulence 1
]
}
}
translate <0,0,-poh>
}
                                   



#local pee=array[40]
#local pee[1]=-100    ;
#local pee[2]=1.11 ;
#local pee[3]=1.16 ;
#local pee[4]=1.41 ;
#local pee[5]=1.47 ;
#local pee[6]=1.52 ;
#local pee[7]=1.70 ;
#local pee[8]=1.72 ;
#local pee[9]=1.76 ;
#local pee[10]=1.83;
#local pee[11]=2.07;
#local pee[12]=2.10;
#local pee[13]=2.16;
#local pee[14]=2.33;
#local pee[15]=2.43;
#local pee[16]=2.70;
#local pee[17]=2.73;
#local pee[18]=2.83;
#local pee[19]=2.94;
#local pee[20]=2.97; 
#local pee[21]=3.19; 
#local pee[22]=3.40; 
#local pee[23]=3.45; 
#local pee[24]=3.77; 
#local pee[25]=3.96; 
#local pee[26]=200  ;

#local pep=array[30]

#local pep[1]=0    ;
#local pep[2]= 0   ;
#local pep[3]= 10  ;
#local pep[4]=10   ;
#local pep[5]= 3   ;
#local pep[6] = 10 ;
#local pep[7] = 10 ;
#local pep[8] = 1  ;
#local pep[9] = 1  ;
#local pep[10] = 10;
#local pep[11] = 10;
#local pep[12] = 8 ;
#local pep[13] = 10;
#local pep[14] = 9 ;
#local pep[15] = 10;
#local pep[16] = 10;
#local pep[17] = 9 ;
#local pep[18] = 10;
#local pep[19] = 9 ;
#local pep[20] = 10;
#local pep[21] = 9;
#local pep[22] = 7;
#local pep[23] = 10 ;
#local pep[24] = 10;
#local pep[25] = 0;
#local pep[26] = 0;


#local i=0;
#local kk=-100;
#while (kk<=clocka)
#local i=i+1;
#local kk=pee[i];
#end
// clock-alku+loppu-clock
#local jak=pee[i]-pee[i-1];
#local pr=pep[i-1]*(clocka-pee[i-1])/jak+pep[i]*(pee[i]-clocka)/jak;

#warning str(pr,5,5)

#local suukoko=pr/10+.1;
#local kop=0
#if (clocka>3.8)
#local kop=-pow(clocka*1.5-6.7,2)+1;
#end
blob {
#if (clocka<6)
sphere {<0,0,0>,5+kop,5 }
sphere {<1,4.2,-3.5>,1,-5 }
sphere {<-1,4.2,-3.5>,1,-5 }
sphere {<0,2.5,0>,5+kop,5 }
sphere {<0,5,0>,5+kop,5 }
sphere {<0,0,0>,4+kop,5 scale <1,1,1.3> translate <0,0,-2> }
sphere {<0,0,0>,2+kop,5 scale <1,1,3> translate <0,2.5,-4> }

sphere {<0,0,0>,2,-3 scale <1.3,.6*suukoko,2> translate <0,.7,-3> pigment {Green}}
#end


#local k=0;
#local ran=seed(10);
#local rep=seed(100);
#while (k<160)
#local er=rand(rep)*4+clock-1;
#while (er>1)
#local er=er-2;
#end
#local iku=1;
#if (clocka>4)
#local er=2;
#local iku=.5;
#if (clocka>6)
#local iku=.5+pow(clocka-6,1.5);
#end
#end
sphere {<(rand(ran)-.5)*8*iku,rand(ran)*8*iku,(rand(ran)-1)*5*iku>,.5,er pigment {rgb <1,.7,.6>*er}}
#local k=k+1;
#end

pigment {rgb <.8,.4,.3>}
normal {granite}
finish {phong .5}
#local paai=seed(213);
#if (kop>0)
translate <sin(rand(paai)*248+clock),sin(rand(paai)*248+clock*2),sin(rand(paai)*248+clock*5)>*kop
#end
}







#local atomi=union {
#local ra=seed(32);
#local neu=0;
#while (neu<40)
sphere {<rand(ra)-.5,rand(ra)-.5,rand(ra)-.5>,.2 pigment {Blue}}
sphere {<rand(ra)-.5,rand(ra)-.5,rand(ra)-.5>,.2 pigment {Red}}
#local neu=neu+1;
#end
#local neu=0;
#while (neu<40)
sphere {<-1.5,0,0>,.1 rotate <rand(ra)*360+clock*60,rand(ra)*360+clock*60,rand(ra)*360+clock*60> pigment {Yellow}}
#local neu=neu+1;
#end
scale 1.2
}
//-7
//13
//7
//-8
#local ee=0;
#local ra=seed(1242);
#while (ee<20)
object {atomi rotate <rand(ra)*360,rand(ra)*360,rand(ra)*360> 
translate <rand(ra)*26-7,(rand(ra)-.5)*16+2,5+rand(ra)*10>
}
#local ee=ee+1;
#end



#local bb=1
#if (clocka>5)
#local bb=6-clocka
#end
#if (clocka<6)


merge {
cylinder {<0,0,0>,<0,6,0>,6 hollow}
sphere {<0,0,0>,6 hollow}
sphere {<0,6,0>,6 hollow}
pigment {Clear}
interior {
media {
emission rgb <0,.03*bb,0>
}
}

}

#end  
  
  #switch (clocka)
  #range (5.8,6)
sphere {<0,4,0>,8 hollow
pigment {Clear}
interior {
media {
emission rgb <(clocka-5.8)/2,0,0>
}
  }
}
  #break
  #range (6,6.2)
sphere {<0,4,0>,8 hollow
pigment {Clear}
interior {
media {
emission rgb <(6.2-clocka)/2,0,0>
}
}}
  #break
  #end
  
  
#local pih=0
#switch (clocka)
#range (-4.5,-2.5)
scale <1,(clocka+4.5)*2+1,1>  
#break
#range (-2.5,-0.5)
scale <1,5-(clocka+2.5)*2,1>  
#break
#end

#switch (clocka)
#range (-3,0)
#local pih=(clocka+3)*20
#break
#range (0,100000)
#local pih=60
#break
#end

//  translate <0,40,0>
  translate <0,100-pih,0>
  }
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
 #if (clocka<0)
  
  
  
  
union {  
  
  #local jalka=union {
sphere {<0,0,0>,1}
#local kee=0;
#while (kee<2)
cone {<kee,0,0>,1,<kee+.4,0,0>,1.15}
#local kee=kee+.35;
#end

#local kee=0;
#while (kee<90)
#local kee=kee+15;
cone {<0,-1,0>,1,<.4,-1,0>,1.15 rotate <0,0,kee> translate <2,1,0>}
#end
texture {Soft_Silver finish {reflection 0}}
//clipped_by {plane {-y,0}}
translate <-3,0,0>
}

#local saari=union {
cylinder {<0,1,0>,<0,9,0>,1.1}
sphere {<0,0,0>,1 scale <1,4,1> translate <.8,5,0>}
texture {Soft_Silver finish {reflection 0} normal {dents 1}}
}

#local polvi=union {
#local keu=-30;
#while (keu<30)
cylinder {<0,-.2,0>,<0,.2,0>,1.4 rotate <0,0,keu>}
#local keu=keu+15;
#end
texture {Soft_Silver finish {reflection 0}}
scale <1,1.5,1>
}

#local reisi=union {
cone {<0,9.4,0>,1.1,<0,17,0>,1.4}
texture {Soft_Silver finish {reflection 0} normal {dents 1}}
}




union {
//sphere {<0,0,0>,1 scale <1,1.5,1> translate <0,17,0>}
cylinder {<0,0,0>,<0,12,0>,2 scale <1,1,2> translate <0,19,0>}
#difference {
sphere {<0,19,0>,2 scale <1,1,2>}
box {<-2,18,-3>,<2,10,3>}
}
box {<2,18,-2>,<2.2,16,2>}
sphere {<0,18,-2.5>,1.5}
sphere {<0,18,2.5>,1.5}
sphere {<0,0,0>,2 scale <.3,1,1> rotate <0,0,-20> translate <-1.5,30,-1>}
sphere {<0,0,0>,2 scale <.3,1,1> rotate <0,0,-20> translate <-1.5,30,1>}
sphere {<0,31,0>,2 scale <1,1,2>}
texture {Soft_Silver finish {reflection 0} normal {dents .5}}
}

union {
#local ef=0;
#while (ef<90)
cone {<0,-.2,-1.6>,1.5,<0,.2,-1.6>,1.3 rotate <ef,0,0>}
#local ef=ef+10;
#end
cone {<0,0,-1.6>,1.3,<0,-6,0>,.7}
sphere {<0,-6,0>,.7}
cone {<0,-6,0>,.7,<0,-11,3>,.7}
cone {<0,-11,3>,.6,<0,-13,4>,.1}
cone {<0,-11,3>,.6,<0,-12,4>,.1}
cone {<0,-11,3>,.6,<0,-11,4>,.1}
cone {<0,-11,3>,.6,<0,-10,4>,.1}
translate <0,-1.6,0>
rotate <0,0,-40>
translate <0,30,-3.5>
texture {Soft_Silver finish {reflection 0} normal {dents .5}}
}

union {
#local ef=0;
#while (ef>-90)
cone {<0,-.2,1.6>,1.5,<0,.2,1.6>,1.3 rotate <ef,0,0>}
#local ef=ef-10;
#end
cone {<0,0,1.6>,1.3,<0,-6,0>,.7}
sphere {<0,-6,0>,.7}
cone {<0,-6,0>,.7,<0,-11,-3>,.7}

cone {<0,-11,-3>,.6,<0,-13,-4>,.1}
cone {<0,-11,-3>,.6,<0,-12,-4>,.1}
cone {<0,-11,-3>,.6,<0,-11,-4>,.1}
cone {<0,-11,-3>,.6,<0,-10,-4>,.1}
translate <0,-1.6,0>
rotate <0,0,-40>
translate <0,30,3.5>
texture {Soft_Silver finish {reflection 0} normal {dents .5}}
}





difference  {
cylinder {<0,32,0>,<0,37,0> ,2.1}
box {<0,0,0>,<-3,.8,1.2> rotate <-30,0,0> translate <0,34.5,.6>}
box {<0,0,0>,<-3,.8,-1.2> rotate <30,0,0> translate <0,34.5,-.6>}
texture {Soft_Silver finish {reflection 0} normal {dents .5}}
}
union {
sphere {<0,37,0>,2.1}
#local peh=0;
#while (peh<10)
sphere {<0,37+peh,2.2+sin(peh)>     ,(10-peh)/10 pigment {White}}
sphere {<0,37+peh,-2.2-sin(peh)>     ,(10-peh)/10 pigment {White}}
#local peh=peh+.5;
#end
texture {Soft_Silver finish {reflection 0} normal {dents .5}}
}


box {<-1,0,-1>,<1,20,1> rotate <0,45,0> scale <.15,1,.3> translate <-8,0,0> texture {Soft_Silver finish {reflection .2}}}
cylinder {<-8,20,0>,<-8,22,0>,.5 texture {DMFWood6}}

object {jalka translate <0,0,2.5>}
object {jalka translate <0,0,-2.5>}
object {saari translate <0,.4,2.5>}
object {saari translate <0,.4,-2.5>}
object {polvi translate <0,9.4,-2.5>}
object {polvi translate <0,9.4,2.5>}
object {reisi translate <0,0,-2.5>}
object {reisi translate <0,0,2.5>}

  
#switch (clocka)
#range (-100,-2)
#local keke=6
#break
#range (-2,0)
#local keke=6+(clock+2)*10
#break
#range (0,100)
#local keke=26
#break
#end
rotate <0,-90,0>
scale keke
  
}  













#local puu=union {
#local k=1;
#while (k<100)
cone {<0,k,0>,sqrt(k)/10,<-sqrt((100-k)*9)-.4,pow(sqrt(k)/2,2),0>,0 rotate <0,k*37,0> pigment {Green}}
#local k=k+.6;
#end
}


#local puuj=union {
#local k=1;
#while (k<50)
torus {sqrt(100-k)/3,sqrt(sin(k)+1.5) translate <0,k,0> pigment {Brown}}
#local k=k+2.4;
#end
}

#local puuu=union {
object {puu translate <0,10,0>}
object {puuj}
}

#local puup=union {

#local ex=array[7]
#local ey=array[7]
#local ez=array[7]


#local ex[1]=0;
#local ey[1]=2;
#local ez[1]=0;

#local tx=array[5]
#local ty=array[5]
#local tz=array[5]

#local kx=array[5][5]
#local ky=array[5][5]
#local kz=array[5][5]

#local nx=array[5][5][5]
#local ny=array[5][5][5]
#local nz=array[5][5][5]

#local vx=array[5][5][5][5]
#local vy=array[5][5][5][5]
#local vz=array[5][5][5][5]


#local kee=0;
#while (kee<4) 
#local kee=kee+1;
#local tx[kee]=ex[1]+sin(kee*pi/2);
#local tz[kee]=ez[1]+cos(kee*pi/2);
#local ty[kee]=ey[1]+.7;
#end


#local kee=0;
#while (kee<4) 
#local kee=kee+1;
#local keee=0;
#while (keee<4) 
#local keee=keee+1;
#local kx[kee][keee]=tx[kee]+sin((kee+keee/2-1)*pi/2);
#local kz[kee][keee]=tz[kee]+cos((kee+keee/2-1)*pi/2);
#local ky[kee][keee]=ty[kee]+cos(keee*pi/2)+1;
#end
#end


#local kee=0;
#while (kee<4) 
#local kee=kee+1;
#local keee=0;
#while (keee<4) 
#local keee=keee+1;
#local keeee=0;
#while (keeee<4) 
#local keeee=keeee+1;
#local nx[kee][keee][keeee]=kx[kee][keee]+sin((kee+keee/2-1+keeee/4-.5)*pi/2);
#local nz[kee][keee][keeee]=kz[kee][keee]+cos((kee+keee/2-1+keeee/4-.5)*pi/2);
#local ny[kee][keee][keeee]=ky[kee][keee]+cos(keeee*pi/2)+.5;
#end
#end
#end



#local kee=0;
#while (kee<4) 
#local kee=kee+1;
#local keee=0;
#while (keee<4) 
#local keee=keee+1;
#local keeee=0;
#while (keeee<4) 
#local keeee=keeee+1;
#local keeeee=0;
#while (keeeee<4) 
#local keeeee=keeeee+1;

#local vx[kee][keee][keeee][keeeee]=nx[kee][keee][keeee]+sin((kee+keee/2-1+keeee/4-.5+keeeee/8-.25)*pi/2);
#local vz[kee][keee][keeee][keeeee]=nz[kee][keee][keeee]+cos((kee+keee/2-1+keeee/4-.5+keeeee/8-.25)*pi/2);
#local vy[kee][keee][keeee][keeeee]=ny[kee][keee][keeee]+cos(keeeee*pi/2)+.5;
#end
#end
#end
#end



cylinder {<0,0,0>,<ex[1],ey[1],ez[1]> ,.3 pigment {Red}}

#local kee=0;
#while (kee<4) 
#local kee=kee+1;
cylinder {<ex[1],ey[1],ez[1]>,<tx[kee],ty[kee],tz[kee]>,.1 pigment {Red}}
#end


#local kee=0;
#while (kee<4) 
#local kee=kee+1;
#local keee=0;
#while (keee<4) 
#local keee=keee+1;
cylinder {<tx[kee],ty[kee],tz[kee]>,<kx[kee][keee],ky[kee][keee],kz[kee][keee]>,.1 pigment {Red}}
#end
#end





#local kee=0;
#while (kee<4) 
#local kee=kee+1;
#local keee=0;
#while (keee<4) 
#local keee=keee+1;
#local keeee=0;
#while (keeee<4) 
#local keeee=keeee+1;
cylinder {<kx[kee][keee],ky[kee][keee],kz[kee][keee]>,<nx[kee][keee][keeee],ny[kee][keee][keeee],nz[kee][keee][keeee]>,.1 pigment {Red}}#end
#end
#end




#local kee=0;
#while (kee<4) 
#local kee=kee+1;
#local keee=0;
#while (keee<4) 
#local keee=keee+1;
#local keeee=0;
#while (keeee<4) 
#local keeee=keeee+1;
#local keeeee=0;
#while (keeeee<4) 
#local keeeee=keeeee+1;

cylinder {<nx[kee][keee][keeee],ny[kee][keee][keeee],nz[kee][keee][keeee]>,<vx[kee][keee][keeee][keeeee],vy[kee][keee][keeee][keeeee],vz[kee][keee][keeee][keeeee]>,.05 pigment {Red}}
#end
#end
#end
#end
}




#if (kiu>0)
object {puuu scale 70*kiu scale .08 translate <-80,0,290>}
object {puuu scale 60*kiu scale .08 translate <-180,0,590>}
object {puuu scale 70*kiu scale .08 translate <120,0,390>}
object {puuu scale 40*kiu scale .08 translate <250,0,490>}
object {puuu scale 80*kiu scale .08 translate <280,0,390>}
object {puuu scale 70*kiu scale .08 translate <-150,0,490>}
object {puup scale 60*kiu translate <180,0,190>}
#end





#end

sphere {0,0}