/*

    Definition of clock face for POVray
    Copyright (C) 1999 Aaron Gage

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.



*/

#declare Face = union
{
        text { ttf "timrom.ttf" "12", 0.1, 0
                translate x*-1/2
                scale <1, 1, 0.001>
                pigment { Black }

		translate y*5
                }

        text { ttf "timrom.ttf" "1", 0.1, 0
                translate x*-1/4
                scale <1, 1, 0.001>
                pigment { Black }

		translate y*5
		rotate z*-30
                }

        text { ttf "timrom.ttf" "2", 0.1, 0
                translate x*-1/4
                scale <1, 1, 0.001>
                pigment { Black }

		translate y*5
		rotate z*-60
                }

        text { ttf "timrom.ttf" "3", 0.1, 0
                translate x*-1/4
                scale <1, 1, 0.001>
                pigment { Black }

		translate y*5
		rotate z*-90
                }

        text { ttf "timrom.ttf" "4", 0.1, 0
                translate x*-1/4
                scale <1, 1, 0.001>
                pigment { Black }

		translate y*5
		rotate z*-120
                }
        text { ttf "timrom.ttf" "5", 0.1, 0
                translate x*-1/4
                scale <1, 1, 0.001>
                pigment { Black }

		translate y*5
		rotate z*-150
                }
        text { ttf "timrom.ttf" "6", 0.1, 0
                translate x*-1/4
                scale <1, 1, 0.001>
                pigment { Black }

		translate y*5
		rotate z*-180
                }
        text { ttf "timrom.ttf" "7", 0.1, 0
                translate x*-1/4
                scale <1, 1, 0.001>
                pigment { Black }

		translate y*5
		rotate z*-210
                }
        text { ttf "timrom.ttf" "8", 0.1, 0
                translate x*-1/4
                scale <1, 1, 0.001>
                pigment { Black }

		translate y*5
		rotate z*-240
                }
        text { ttf "timrom.ttf" "9", 0.1, 0
                translate x*-1/4
                scale <1, 1, 0.001>
                pigment { Black }

		translate y*5
		rotate z*-270
                }
        text { ttf "timrom.ttf" "10", 0.1, 0
                translate x*-1/2
                scale <1, 1, 0.001>
                pigment { Black }

		translate y*5
		rotate z*-300
                }
        text { ttf "timrom.ttf" "11", 0.1, 0
                translate x*-1/2
                scale <1, 1, 0.001>
                pigment { Black }

		translate y*5
		rotate z*-330
                }

	#declare Loop = 0
	#while (Loop < 12)
	box { <-0.05, 6.1, 0>, <0.05, 6.75, 0.1> pigment { Black }
		rotate z*-30*Loop }
	#declare Loop = Loop + 1
	#end

	#declare Loop = 0
	#while (Loop < 360)
	box { <-0.05, 6.5, 0>, <0.05, 6.75, 0.1> pigment { Black }
		rotate z*-6*Loop }
	#declare Loop = Loop + 1
	#end
}
