/*
    gear.inc : object definition for various clock parts
    Copyright (C) 1999 Aaron Gage

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/



#include "colors.inc"

//#declare PROTO = 1
#declare PROTO = 0

#declare GearTex = texture { T_Brass_4C
		finish { roughness 0.01 }
		normal { bozo scale <4, 4, 0.1> }
		}

#declare AGear10 = union { difference
{

   cylinder { <0, 0, -1.5>, <0, 0, 1.5>, 10 }

   #declare Loop = 0
   #while (Loop < 360)
   //box { <-0.51, 10.5, -3.1>, <0.51, 9, 3.1>
	//rotate z*Loop }
   difference {
	   box { <-0.75, 1, -3.1>, <0.75, -0.5, 3.1> }
	   plane { x*1, 0 rotate z*20 translate x*-0.5 }
	   plane { x*-1, 0 rotate z*-20 translate x*0.5 }
	bounded_by { box { <-0.76, 1.1, -3.2>, <0.76, -0.6, 3.2> } }

	translate y*9.5 rotate z*Loop
	}

   #declare Loop = Loop + 10
   #end

bounded_by { cylinder { <0, 0, -1.51>, <0, 0, 1.51>, 10.01 } }
#if(PROTO = 1)
pigment { color Orange } finish { ambient 0.6 }
#else
texture { GearTex }
#end
}
   cylinder { <0, 0, -1.501>, <0, 0, 1.501>, 3
	texture { T_Silver_3E normal { onion scale 0.1 } }
	}
}

#declare AGear5 = union { difference
{

   cylinder { <0, 0, -1.5>, <0, 0, 1.5>, 5 }

   #declare Loop = 0
   #while (Loop < 360)
   difference {
	   //box { <-0.51, 5.5, -3.1>, <0.51, 3, 3.1>
		//rotate z*Loop }
	   box { <-0.75, 1, -3.1>, <0.75, -0.5, 3.1> }
	   plane { x*1, 0 rotate z*20 translate x*-0.5 }
	   plane { x*-1, 0 rotate z*-20 translate x*0.5 }
	bounded_by { box { <-0.76, 1.1, -3.2>, <0.76, -0.6, 3.2> } }

	translate y*4.5
	rotate z*Loop
	}

   #declare Loop = Loop + 20
   #end
bounded_by { cylinder { <0, 0, -1.51>, <0, 0, 1.51>, 5.01 } }
#if(PROTO = 1)
pigment { color Green } finish { ambient 0.6 }
#else
texture { GearTex }
#end
}
   cylinder { <0, 0, -1.501>, <0, 0, 1.501>, 3
	texture { T_Silver_3E normal { onion scale 0.1 } }
	}
}

#declare AGear15 = difference
{

   cylinder { <0, 0, -1.5>, <0, 0, 1.5>, 15 }

   #declare Loop = 0
   #while (Loop < 360)
   difference {
           //box { <-0.51, 5.5, -3.1>, <0.51, 3, 3.1>
                //rotate z*Loop }
           box { <-0.75, 1, -3.1>, <0.75, -0.5, 3.1> }
           plane { x*1, 0 rotate z*20 translate x*-0.5 }
           plane { x*-1, 0 rotate z*-20 translate x*0.5 }
	bounded_by { box { <-0.76, 1.1, -3.2>, <0.76, -0.6, 3.2> } }

        translate y*14.5
        rotate z*Loop
        }

   #declare Loop = Loop + 10 * 2/3
   #end
bounded_by { cylinder { <0, 0, -1.51>, <0, 0, 1.51>, 15.01 } }
#if(PROTO = 1)
pigment { color Blue } finish { ambient 0.6 }
#else
texture { GearTex }
#end
}

#declare AGear20 = difference
{

   cylinder { <0, 0, -1.5>, <0, 0, 1.5>, 20 }

   #declare Loop = 0
   #while (Loop < 360)
   difference {
           //box { <-0.51, 5.5, -3.1>, <0.51, 3, 3.1>
                //rotate z*Loop }
           box { <-0.75, 1, -3.1>, <0.75, -0.5, 3.1> }
           plane { x*1, 0 rotate z*20 translate x*-0.5 }
           plane { x*-1, 0 rotate z*-20 translate x*0.5 }
	bounded_by { box { <-0.76, 1.1, -3.2>, <0.76, -0.6, 3.2> } }

        translate y*19.5
        rotate z*Loop
        }

   #declare Loop = Loop + 5
   #end
rotate z*-2.5
bounded_by { cylinder { <0, 0, -1.51>, <0, 0, 1.51>, 20.01 } }
#if(PROTO = 1)
pigment { color Brown } finish { ambient 0.6 }
#else
texture { GearTex }
#end
}

#declare BGear10 = difference
{

   cylinder { <0, 0, -1.5>, <0, 0, 1.5>, 10 }

   #declare Loop = 0
   #while (Loop < 360)
   //box { <-0.51, 10.5, -3.1>, <0.51, 9, 3.1>
	//rotate z*Loop }
   difference {
	   box { <-0.75, 1, -3.1>, <0.75, -0.5, 3.1> }
	   plane { x*1, 0 rotate z*20 translate x*-0.5 }
	   plane { x*-1, 0 rotate z*-20 translate x*0.5 }
	bounded_by { box { <-0.76, 1.1, -3.2>, <0.76, -0.6, 3.2> } }

	translate y*9.5 rotate z*Loop
	}

   #declare Loop = Loop + 10
   #end

   difference {
        cylinder { <0, 0, -1.6>, <0, 0, 1.6>, 8 }
        cylinder { <0, 0, -1.7>, <0, 0, 1.7>, 5 }
        box { <-8.5, 1.25, 1.25>, <8.5, -1.25, -1.25> }
        box { <-1.25, 8.5, 1.25>, <1.25, -8.5, -1.25> }

        bounded_by { cylinder { <0, 0, -1.8>, <0, 0, 1.8>, 8 } }
        }

bounded_by { cylinder { <0, 0, -1.51>, <0, 0, 1.51>, 10.01 } }
#if(PROTO = 1)
pigment { color Orange } finish { ambient 0.6 }
#else
texture { GearTex }
#end
}

#declare BGear15 = union {
difference
{

   cylinder { <0, 0, -1.5>, <0, 0, 1.5>, 15 }

   #declare Loop = 0
   #while (Loop < 360)
   difference {
           //box { <-0.51, 5.5, -3.1>, <0.51, 3, 3.1>
                //rotate z*Loop }
           box { <-0.75, 1, -3.1>, <0.75, -0.5, 3.1> }
           plane { x*1, 0 rotate z*20 translate x*-0.5 }
           plane { x*-1, 0 rotate z*-20 translate x*0.5 }
	bounded_by { box { <-0.76, 1.1, -3.2>, <0.76, -0.6, 3.2> } }

        translate y*14.5
        rotate z*Loop
        }

   #declare Loop = Loop + 10 * 2/3
   #end

   difference {
	cylinder { <0, 0, -1.6>, <0, 0, 1.6>, 12 }
	cylinder { <0, 0, -1.7>, <0, 0, 1.7>, 5 }
        difference {
		box { <-13, 1.25, 1.25>, <13, -1.25, -1.25> }
                //box { <-18, 2.25, 1.25>, <18, -2.25, -1.25> }
                box { <-11, 1.5, 1.26>, <-7, 1., -1.26> }
                box { <-11, -1.5, 1.26>, <-7, -1., -1.26> }
                box { <11, 1.5, 1.26>, <7, 1., -1.26> }
                box { <11, -1.5, 1.26>, <7, -1., -1.26> }
                cylinder { <-11, 1.25, -2>, <-11, 1.25, 2>, 0.25 }
                cylinder { <-7, -1.25, -2>, <-7, -1.25, 2>, 0.25 }
                cylinder { <11, 1.25, -2>, <11, 1.25, 2>, 0.25 }
                cylinder { <7, -1.25, -2>, <7, -1.25, 2>, 0.25 }

                cylinder { <-11, 1.25, -2>, <-11, 1.25, 2>, 0.25 }
                cylinder { <-7, -1.25, -2>, <-7, -1.25, 2>, 0.25 }
                cylinder { <11, -1.25, -2>, <11, -1.25, 2>, 0.25 }
                cylinder { <7, 1.25, -2>, <7, 1.25, 2>, 0.25 }
                }
        difference {
		box { <1.25, 13, 1.25>, <-1.25, -13, -1.25> }
                //box { <1.25, 18, 1.25>, <1.25, -18, -1.25> }
                box { <-1.5, 11, 1.26>, <-1., 7, -1.26> }
                box { <1.5, 11, 1.26>, <1., 7, -1.26> }
                box { <-1.5, -11, 1.26>, <-1., -7, -1.26> }
                box { <1.5, -11, 1.26>, <1., -7, -1.26> }
                cylinder { <-1.25, 11, -2>, <-1.25, 11, 2>, 0.25 }
                cylinder { <1.25, -11, -2>, <1.25, -11, 2>, 0.25 }
                cylinder { <-1.25, 7, -2>, <-1.25, 7, 2>, 0.25 }
                cylinder { <1.25, -7, -2>, <1.25, -7, 2>, 0.25 }

                cylinder { <1.25, 11, -2>, <1.25, 11, 2>, 0.25 }
                cylinder { <-1.25, -11, -2>, <-1.25, -11, 2>, 0.25 }
                cylinder { <1.25, 7, -2>, <1.25, 7, 2>, 0.25 }
                cylinder { <-1.25, -7, -2>, <-1.25, -7, 2>, 0.25 }
                }

	bounded_by { cylinder { <0, 0, -1.8>, <0, 0, 1.8>, 12 } }
	}

bounded_by { cylinder { <0, 0, -1.51>, <0, 0, 1.51>, 15.01 } }
#if(PROTO = 1)
pigment { color Blue } finish { ambient 0.6 }
#else
texture { GearTex }
#end
}
   cylinder { <0, 0, -1.501>, <0, 0, 1.501>, 3
	texture { T_Silver_3E normal { onion scale 0.1 } }
	}
}

#declare BGear20 = union { difference
{

   cylinder { <0, 0, -1.5>, <0, 0, 1.5>, 20 }

   #declare Loop = 0
   #while (Loop < 360)
   difference {
           //box { <-0.51, 5.5, -3.1>, <0.51, 3, 3.1>
                //rotate z*Loop }
           box { <-0.75, 1, -3.1>, <0.75, -0.5, 3.1> }
           plane { x*1, 0 rotate z*20 translate x*-0.5 }
           plane { x*-1, 0 rotate z*-20 translate x*0.5 }
	bounded_by { box { <-0.76, 1.1, -3.2>, <0.76, -0.6, 3.2> } }

        translate y*19.5
        rotate z*Loop
        }

   #declare Loop = Loop + 5
   #end

   difference {
        cylinder { <0, 0, -1.6>, <0, 0, 1.6>, 16 }
        cylinder { <0, 0, -1.7>, <0, 0, 1.7>, 5 }
	difference {
		box { <-18, 2.25, 1.25>, <18, -2.25, -1.25> }
		box { <-15, 2.5, 1.26>, <-8, 1.75, -1.26> }
		box { <-15, -2.5, 1.26>, <-8, -1.75, -1.26> }
		box { <15, 2.5, 1.26>, <8, 1.75, -1.26> }
		box { <15, -2.5, 1.26>, <8, -1.75, -1.26> }
		cylinder { <-15, 2.25, -2>, <-15, 2.25, 2>, 0.5 }
		cylinder { <-15, -2.25, -2>, <-15, -2.25, 2>, 0.5 }
		cylinder { <15, 2.25, -2>, <15, 2.25, 2>, 0.5 }
		cylinder { <15, -2.25, -2>, <15, -2.25, 2>, 0.5 }

		cylinder { <-8, 2.25, -2>, <-8, 2.25, 2>, 0.5 }
		cylinder { <-8, -2.25, -2>, <-8, -2.25, 2>, 0.5 }
		cylinder { <8, 2.25, -2>, <8, 2.25, 2>, 0.5 }
		cylinder { <8, -2.25, -2>, <8, -2.25, 2>, 0.5 }
		}
	difference {
		box { <2.25, 18, 1.25>, <-2.25, -18, -1.25> }
		box { <2.5, 15, 1.26>, <1.75, 8, -1.26> }
		box { <2.5, -15, 1.26>, <1.75, -8, -1.26> }
		box { <-2.5, 15, 1.26>, <-1.75, 8, -1.26> }
		box { <-2.5, -15, 1.26>, <-1.75, -8, -1.26> }
		cylinder { <-2.25, 15, -2>, <-2.25, 15, 2>, 0.5 }
		cylinder { <-2.25, -15, -2>, <-2.25, -15, 2>, 0.5 }
		cylinder { <2.25, 15, -2>, <2.25, 15, 2>, 0.5 }
		cylinder { <2.25, -15, -2>, <2.25, -15, 2>, 0.5 }

		cylinder { <-2.25, 8, -2>, <-2.25, 8, 2>, 0.5 }
		cylinder { <-2.25, -8, -2>, <-2.25, -8, 2>, 0.5 }
		cylinder { <2.25, 8, -2>, <2.25, 8, 2>, 0.5 }
		cylinder { <2.25, -8, -2>, <2.25, -8, 2>, 0.5 }
		}
        bounded_by { cylinder { <0, 0, -1.8>, <0, 0, 1.8>, 16 } }
        }

rotate z*-2.5
bounded_by { cylinder { <0, 0, -1.51>, <0, 0, 1.51>, 20.01 } }
#if(PROTO = 1)
pigment { color Brown } finish { ambient 0.6 }
#else
texture { GearTex }
#end
}
   cylinder { <0, 0, -1.501>, <0, 0, 1.501>, 3
	texture { T_Silver_3E normal { onion scale 0.1 } }
	}
}

#declare BGear25 = union {
difference
{

   cylinder { <0, 0, -1.5>, <0, 0, 1.5>, 25 }

   #declare Loop = 0
   #while (Loop < 360)
   difference {
           //box { <-0.51, 5.5, -3.1>, <0.51, 3, 3.1>
                //rotate z*Loop }
           box { <-0.75, 1, -3.1>, <0.75, -0.5, 3.1> }
           plane { x*1, 0 rotate z*20 translate x*-0.5 }
           plane { x*-1, 0 rotate z*-20 translate x*0.5 }
        bounded_by { box { <-0.76, 1.1, -3.2>, <0.76, -0.6, 3.2> } }

        translate y*24.5
        rotate z*Loop
        }

   #declare Loop = Loop + 4
   #end

   difference {
        cylinder { <0, 0, -1.6>, <0, 0, 1.6>, 20 }
        cylinder { <0, 0, -1.7>, <0, 0, 1.7>, 5 }
        difference {
                box { <-22, 2.25, 1.25>, <22, -2.25, -1.25> }
                box { <-20, 2.5, 1.26>, <-8, 1.75, -1.26> }
                box { <-20, -2.5, 1.26>, <-8, -1.75, -1.26> }
                box { <20, 2.5, 1.26>, <8, 1.75, -1.26> }
                box { <20, -2.5, 1.26>, <8, -1.75, -1.26> }
                cylinder { <-20, 2.25, -2>, <-20, 2.25, 2>, 0.5 }
                cylinder { <-20, -2.25, -2>, <-20, -2.25, 2>, 0.5 }
                cylinder { <20, 2.25, -2>, <20, 2.25, 2>, 0.5 }
                cylinder { <20, -2.25, -2>, <20, -2.25, 2>, 0.5 }

                cylinder { <-8, 2.25, -2>, <-8, 2.25, 2>, 0.5 }
                cylinder { <-8, -2.25, -2>, <-8, -2.25, 2>, 0.5 }
                cylinder { <8, 2.25, -2>, <8, 2.25, 2>, 0.5 }
                cylinder { <8, -2.25, -2>, <8, -2.25, 2>, 0.5 }
                }
        difference {
                box { <2.25, 22, 1.25>, <-2.25, -22, -1.25> }
                box { <2.5, 20, 1.26>, <1.75, 8, -1.26> }
                box { <2.5, -20, 1.26>, <1.75, -8, -1.26> }
                box { <-2.5, 20, 1.26>, <-1.75, 8, -1.26> }
                box { <-2.5, -20, 1.26>, <-1.75, -8, -1.26> }
                cylinder { <-2.25, 20, -2>, <-2.25, 20, 2>, 0.5 }
                cylinder { <-2.25, -20, -2>, <-2.25, -20, 2>, 0.5 }
                cylinder { <2.25, 20, -2>, <2.25, 20, 2>, 0.5 }
                cylinder { <2.25, -20, -2>, <2.25, -20, 2>, 0.5 }

                cylinder { <-2.25, 8, -2>, <-2.25, 8, 2>, 0.5 }
                cylinder { <-2.25, -8, -2>, <-2.25, -8, 2>, 0.5 }
                cylinder { <2.25, 8, -2>, <2.25, 8, 2>, 0.5 }
                cylinder { <2.25, -8, -2>, <2.25, -8, 2>, 0.5 }
                }
        bounded_by { cylinder { <0, 0, -1.8>, <0, 0, 1.8>, 20 } }
        }

rotate z*-2.5
bounded_by { cylinder { <0, 0, -1.51>, <0, 0, 1.51>, 25.01 } }
#if(PROTO = 1)
pigment { color Goldenrod } finish { ambient 0.6 }
#else
texture { GearTex }
#end
}
   cylinder { <0, 0, -1.501>, <0, 0, 1.501>, 3
        texture { T_Silver_3E normal { onion scale 0.1 } }
        }
}

#declare Escapement =
union
{
   object { BGear15 }
   #declare Loop = 0
   #while(Loop < 360)
   cylinder { <0, 13, 0>, <0, 13, -2.5>, 0.15
		texture { T_Silver_3E } normal { bozo scale <4, 4, 0.1> }
	rotate z*Loop
	}
   #declare Loop = Loop + 12
   #end

}

#declare PendulumWeight = union
{
   cylinder
	{
	<0, 18 + 12, 0>, <0, 0, 0>, 5  //4
	texture { T_Copper_3D normal { bozo scale 10 } finish { ambient 0.3 } }
	}

   cylinder
	{
	<0, 30, 0>, <0, 35, 0>, 3.5
	texture { T_Copper_3D normal { bozo scale 10 } finish { ambient 0.3 } }
	}

   difference {
	   cylinder {
		<0, 0, 0>, <0, -10, 0>, 4
		texture { T_Copper_3D
			normal {
				bump_map
					{ tga "bump.tga"
					map_type 2
					bump_size 5
					//once
					 }
				}
			finish { ambient 0.3 }
			scale <4, 4, 4>
			//translate y*-10
			translate y*-7
			}
		}
	   torus {
		6, 4
		translate y*0
		texture { T_Copper_3D normal { bozo scale 10 } finish { ambient 0.3 } }
		}
	   torus {
		6, 4
		translate y*-10
		texture { T_Copper_3D normal { bozo scale 10 } finish { ambient 0.3 } }
		}
   }
}
