/* Split form of gear.pov for use in editors that cannot handle the full
   file in one piece.

    Copyright (C) 1999 Aaron Gage

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


*/



        cylinder { <G17.x, G17.y, -10>, <G17.x, G17.y, 5>, 1.5
                texture { T_Copper_3D normal { bozo scale 10 } } }
        difference {
           union {
                cylinder { <G17.x, G17.y, -7.5>, <G17.x, G17.y, -10>, 2 }
                cylinder { <G17.x, G17.y, 2.5>, <G17.x, G17.y, 5>, 2 }

                cylinder { <G17.x, G17.y, -8.75>, <G18.x, G18.y, -8.75>, 1 }
                cylinder { <G17.x, G17.y, -8.75>, <G19.x, G19.y, -8.75>, 1 }
                }
                cylinder { <G18.x, G18.y, -10.1>, <G18.x, G18.y, 5.1>, 1.51 }
                cylinder { <G19.x, G19.y, -10.1>, <G19.x, G19.y, 5.1>, 1.51 }
                cylinder { <G17.x, G17.y, -10.1>, <G17.x, G17.y, 5.1>, 1.51 }
                texture { T_Silver_3C }
	}

        cylinder { <G18.x, G18.y, -10>, <G18.x, G18.y, 5>, 1.5
                texture { T_Copper_3D normal { bozo scale 10 } } }
        difference {
           union {
                cylinder { <G18.x, G18.y, -7.5>, <G18.x, G18.y, -10>, 2 }
                cylinder { <G18.x, G18.y, 2.5>, <G18.x, G18.y, 5>, 2 }

                cylinder { <G19.x, G19.y, -8.75>, <G18.x, G18.y, -8.75>, 1 }
                }
                cylinder { <G18.x, G18.y, -10.1>, <G18.x, G18.y, 5.1>, 1.51 }
                cylinder { <G19.x, G19.y, -10.1>, <G19.x, G19.y, 5.1>, 1.51 }
                texture { T_Silver_3C }
	}

        cylinder { <G19.x, G19.y, -10>, <G19.x, G19.y, 5>, 1.5
                texture { T_Copper_3D normal { bozo scale 10 } } }
        difference {
           union {
                cylinder { <G19.x, G19.y, -7.5>, <G19.x, G19.y, -10>, 2 }
                cylinder { <G19.x, G19.y, 2.5>, <G19.x, G19.y, 5>, 2 }

                }
                //cylinder { <G18.x, G18.y, -10.1>, <G18.x, G18.y, 5.1>, 1.51 }
                cylinder { <G19.x, G19.y, -10.1>, <G19.x, G19.y, 5.1>, 1.51 }
                texture { T_Silver_3C }
        }


	// Now for the key slot
	difference { 
		cylinder { <G13.x, G13.y, -12>, <G13.x, G13.y, 2.5>, 1.25 }
		box { <G13.x - 0.25, G13.y + 2, -9>,
				<G13.x + 0.25, G13.y - 2, -13> }
			texture { T_Silver_3A }
		}
	// and the string for the right-most freeweight
	cylinder { <G13.x + 10.1, G13.y, -2>, <G13.x + 10.1, G13.y - 100, -2>,
			0.1
		texture { T_Silver_3E
			normal { gradient y rotate z*-10 }
			finish { ambient 0.5 } } }

	torus { 2, 0.5 rotate x*90 translate <73.1, G13.y - 10, -2>
		texture { Soft_Silver } }

	cylinder { <73.1, G13.y - 12, -2>, <73.1, G13.y - 100, -2>,
			0.1
		texture { T_Silver_3E
			normal { gradient y rotate z*-10 }
			finish { ambient 0.5 } } }

	torus { 0.5, 0.1 rotate x*90 rotate y*90
			translate <73.1, G13.y - 12, -2>
		texture { T_Silver_3E
			normal { gradient y rotate z*-10 }
			finish { ambient 0.5 } } }

	// Now is the freeweight

	union {
		union {
		difference
			{
#declare PulleyRad = (73.1 - (G13.x + 10.1)) / 2
#declare PulleyX = (G13.x + 10.1 + 73.1) / 2
#declare PulleyY = G13.y - 100
			cylinder { <0, 0, -2.25>,
				<0, 0, -1.75>, PulleyRad + 0.25 }

			cylinder { <0, 0, -2.3>,
				<0, 0, -1.7>,
				PulleyRad - 0.75 }

			torus { PulleyRad, 0.25 rotate x*90 }
			}
		box { <-PulleyRad, 0.5, -2.25>,
			<PulleyRad, -0.5, -1.75> }

		box { <0.5, PulleyRad, -2.25>,
			<-0.5, -PulleyRad, -1.75> }

		rotate z*40

		texture { GearTex }
		  }

		cylinder { <0, 0, -2.4>, <0, 0, -1.6>, 0.45
			texture { T_Silver_3C } }

		box { <-0.6, 0.6, -2.3>, <0.6, -6, -2.39>
        texture { T_Copper_3D normal { bozo scale 10 } finish { ambient 0.3 } }
				}
		box { <-0.6, 0.6, -1.7>, <0.6, -6, -1.61>
        texture { T_Copper_3D normal { bozo scale 10 } finish { ambient 0.3 } }
			}

		cylinder { <0, -4.5, -2>, <0, -25, -2>, PulleyRad * 1.5
        texture { T_Copper_3D normal { bozo scale 10 } finish { ambient 0.3 } }
			}

#debug concat("\nX:", str(PulleyX, 2, 2), " Rad:", str(PulleyRad, 2, 2))
		translate <PulleyX, PulleyY, 0>
			
		}

	// The other key slot
        difference {
                cylinder { <G15.x, G15.y, -12>, <G15.x, G15.y, 2.5>, 1.25 }
                box { <G15.x - 0.25, G15.y + 2, -9>,
                                <G15.x + 0.25, G15.y - 2, -13> }
                        texture { T_Silver_3A }
                }

	// And the other freeweight (on the left side)

	union {
		union {
		difference
			{
#declare PulleyRad = (73.1 - (G13.x + 10.1)) / 2
#declare PulleyX = (G13.x + 10.1 + 73.1) / 2
#declare PulleyY = G13.y - 100
			cylinder { <0, 0, -2.25>,
				<0, 0, -1.75>, PulleyRad + 0.25 }

			cylinder { <0, 0, -2.3>,
				<0, 0, -1.7>,
				PulleyRad - 0.75 }

			torus { PulleyRad, 0.25 rotate x*90 }
			}
		box { <-PulleyRad, 0.5, -2.25>,
			<PulleyRad, -0.5, -1.75> }

		box { <0.5, PulleyRad, -2.25>,
			<-0.5, -PulleyRad, -1.75> }

		rotate z*40

		texture { GearTex }
		  }

		cylinder { <0, 0, -2.4>, <0, 0, -1.6>, 0.45
			texture { T_Silver_3C } }

		box { <-0.6, 0.6, -2.3>, <0.6, -6, -2.39>
        texture { T_Copper_3D normal { bozo scale 10 } finish { ambient 0.3 } }
				}
		box { <-0.6, 0.6, -1.7>, <0.6, -6, -1.61>
        texture { T_Copper_3D normal { bozo scale 10 } finish { ambient 0.3 } }
			}

		cylinder { <0, -4.5, -2>, <0, -25, -2>, PulleyRad * 1.5
        texture { T_Copper_3D normal { bozo scale 10 } finish { ambient 0.3 } }
			}

		translate <-PulleyX, PulleyY + 15, 0>
			
		}

   // And the left hand string

        cylinder { <-(G13.x + 10.1), G13.y, -2>, <-(G13.x + 10.1), G13.y - 100 + 15, -2>,
                        0.1
                texture { T_Silver_3E
                        normal { gradient y rotate z*-10 }
                        finish { ambient 0.5 } } }

        torus { 2, 0.5 rotate x*90 translate <-73.1, G13.y - 10, -2>
                texture { Soft_Silver } }

        cylinder { <-73.1, G13.y - 12, -2>, <-73.1, G13.y - 100 + 15, -2>,
                        0.1
                texture { T_Silver_3E
                        normal { gradient y rotate z*-10 }
                        finish { ambient 0.5 } } }

        torus { 0.5, 0.1 rotate x*90 rotate y*90
                        translate <-73.1, G13.y - 12, -2>
                texture { T_Silver_3E
                        normal { gradient y rotate z*-10 }
                        finish { ambient 0.5 } } }


	}

object { Hook

#if (clock > 870/1800)
	translate -Pivot
	rotate z*(-3*(-cos(Pan7*pi) + 1)/2)
	translate Pivot
#end
#if (clock > 1385/1800)
	translate -Pivot
	rotate z*(3*(-cos(Pan10*pi) + 1)/2)
	translate Pivot
#end

	translate <G15.x + 14.95, G15.y, G15.z> }

box { <75, 135, 12>, <-75, -100, 15>
	texture { T_Wood8 rotate x*80 rotate y*10 scale 10 finish { ambient 0.5 } } }

box { <75, -100, 12>, <-75, -375, 15>
	texture { pigment { color White*0.1 }
		finish { ambient 0.2 specular 0.3 roughness 0.01 }
		normal { bozo scale <50, 50, 0.1> } } }

box { <78, 135, -9>, <77, -375, 14> texture { Glass3 } }
box { <-78, 135, -9>, <-77, -375, 14> texture { Glass3 } }

box { <80, -95, 11.5>, <-80, -105, 15.01>
	texture { T_Wood8 rotate x*80 rotate y*10 translate x*-100
		scale 10 finish { ambient 0.5 } } }

box { <80, -375, 15>, <-80, -400, -10>
	texture { T_Wood8 rotate x*80 rotate y*10 translate y*100
		scale 10 finish { ambient 0.5 } } }

box { <80, 135, 15>, <-80, 140, -10>
	texture { T_Wood8 rotate x*80 rotate y*10 translate z*25
		scale 10 finish { ambient 0.5 } } }

difference {
	box { <80, 135, -10>, <75, -375, 15>
		texture { T_Wood8 rotate x*80 rotate y*10 translate x*11
			scale 10 finish { ambient 0.5 } } }
	box { <81, -105, 0>, <74, -370, 10>
		texture { T_Wood8 rotate x*80 rotate y*10 translate z*-20
			scale 10 finish { ambient 0.5 } } }
	box { <81, 125, 0>, <74, -95, 10>
		texture { T_Wood8 rotate x*80 rotate y*10 translate z*-50
			scale 10 finish { ambient 0.5 } } }

	}

difference {
	box { <-80, 135, -10>, <-75, -375, 15>
		texture { T_Wood8 rotate x*80 rotate y*10 translate y*-10
			scale 10 finish { ambient 0.5 } } }
	box { <-81, -105, 0>, <-74, -370, 10>
		texture { T_Wood8 rotate x*80 rotate y*10 translate y*-13
			scale 10 finish { ambient 0.5 } } }
	box { <-81, 125, 0>, <-74, -95, 10>
		texture { T_Wood8 rotate x*80 rotate y*10 translate y*-16
			scale 10 finish { ambient 0.5 } } }
}

#debug concat("\nX1:", str(G13.x, 5, 10), ", Y1:", str(G13.y, 5, 10), "\n")
#debug concat("X2:", str(G15.x, 5, 10), ", Y2:", str(G15.y, 5, 10), "\n")

object { Generator translate x*(G19.x - 8) translate y*(G19.y + 3.25 + 2.69)
	translate z*-3 }

object { Brain
	translate <-55, 112, -3> }

object { Screen
	translate <-30, 110, -3> }

cylinder { <-50, 110, -3>, <-60, 95, -3>, 0.35
	pigment { color Red }
	finish { ambient 0.45 specular 0.5 }
	}

cylinder { <-52, 110, -3>, <-62, 95, -3>, 0.35
	pigment { color White*0.05 }
	finish { ambient 0.45 specular 0.5 }
	}

cylinder { <-45, 112, -3>, <-30, 110, -3>, 0.35
	pigment { color Blue }
	finish { ambient 0.45 specular 0.5 }
	}

cylinder { <-45, 107, -3>, <-30, 105, -3>, 0.35
	pigment { color Yellow }
	finish { ambient 0.45 specular 0.5 }
	}

cylinder { <-45, 102, -3>, <-30, 105, -3>, 0.35
	pigment { color White*0.05 }
	finish { ambient 0.45 specular 0.5 }
	}

cylinder { <-45, 100, -3>, <-30, 103, -3>, 0.35
	pigment { color Red }
	finish { ambient 0.45 specular 0.5 }
	}

//camera { location <0, 0, -40> look_at 0 translate x*-39 translate y*102 }

#debug concat("\nX5:", str(G5.x, 5, 10), ", Y1:", str(G5.y, 5, 10), "\n")

union {
 difference {
   box { <-1000, 150, 16>, <1000, -400, 18>
        texture {
                pigment {
                        image_map
                                {
                                tga "wallpaper.tga"
                                map_type 0  //planar
                                }
                        }
                scale 25
                finish { specular 0.2 roughness 0.15 ambient 0.3 }
                }
	}
   box { <-450, 100, 15>, <-175, -150, 20> }
   }

        box { <-450, 100, 16.5>, <-175, -150, 17.5>
                texture { Glass3 }
                }
union {
	box  { <-450, 100, 16.5>, <-155, 120, 14> }
	box  { <-450, 120, 16.5>, <-470, -150, 14> }

	box  { <-450, -150, 16.5>, <-155, -170, 14> }
	box  { <-175, 120, 16.5>, <-155, -150, 14> }
        texture { T_Wood19
                finish { ambient 0.3 roughness 0.0001 specular 0.95
                        reflection 0.2 }
                rotate x*90 }
	}
}

//plane { y*1, -410 
blob { threshold 0.65
	cylinder { <-10000, -200, 1000>, <10000, 0, 1000>, 200, 1 }
	sphere { <-500, -150, 1000>, 200, 1 }
	sphere { <-200, -200, 1000>, 300, 1 }
	sphere { <-1000, -150, 1000>, 200, 1 }
	sphere { <-400, -200, 1000>, 300, 1 }
	sphere { <-250, -150, 1000>, 200, 1 }
	sphere { <-100, -200, 1000>, 300, 1 }
	texture
		{
		pigment { bozo
			color_map {
				[0 color MediumSpringGreen ]
				[0.25 color SpringGreen ]
				[0.5 color YellowGreen ]
				[0.75 color DarkWood ]
				[1 color Green]
				}
			}
		finish { ambient 0.8 specular 0.1 }
		normal { bozo scale <10, 50, 10> }
		scale 10
		}
	}

box { <-500, -400, 20>, <500, -405, -300>
        texture { T_Wood19
                finish { ambient 0.3 roughness 0.0001 specular 0.95
                        reflection 0.2 }
                rotate x*90 }
	}

union {
	difference {
	box { <-150, 135, 1>, <0, -375, -4> }

	box { <60, -125, 2>, <-60, -350, -5> translate x*-75 }
	cylinder { <G4.x, G4.y, 10>, <G4.x, G4.y, -20>, 55 translate x*-75 }

	texture { T_Wood8 rotate x*80 rotate y*10 scale 10 finish { ambient 0.5 } }
	}

	object { Face scale 8.5
		translate <G4.x, G4.y, -1.5> translate x*-75
		}
	box { <-149, 134, -1>, <-1, -374, -2> texture { Glass3 } }

	rotate y*-135
	translate <75, 0, -10>
}

object { Outlet scale 10 translate <-155, -360, 16.5> }
