/*

    Definition of generator for POVray
    Copyright (C) 1999 Aaron Gage

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.



*/

#declare Generator = union {
	difference {
		box { <-8, 6, -4>, <8, -6, 4> }
		cylinder { z*-5, z*5, 4
			translate <8, -6, 0>
			}
		cylinder { z*-3.1, z*3.1, 5
			translate <8, -6, 0>
			}
		pigment { DarkSlateGray }
		finish { ambient 0.5 specular 0.25 roughness 0.01 }
		normal { bozo scale 2 }
		}

	cylinder { <-4, 0, -2>, <-4, 0, 5>, 2
		pigment { DarkSlateGray }
		finish { ambient 0.5 specular 0.25 roughness 0.01 }
		normal { bozo scale 2 }
		}
	cylinder { <4, 0, -2>, <-4, 0, 5>, 2
		pigment { DarkSlateGray }
		finish { ambient 0.5 specular 0.25 roughness 0.01 }
		normal { bozo scale 2 }
		}

	text { ttf "crystal.ttf" "ACME", 0.1, 0
		translate x*-1
		scale 3
		translate y*2.5
		translate z*-4.1
		pigment { LightSteelBlue }
		finish { ambient 0.7 }
		}

	text { ttf "crystal.ttf" "Generator", 0.1, 0
		translate x*-9/4
		scale 3
		translate z*-4.1
		pigment { LightSteelBlue }
		finish { ambient 0.7 }
		}

	box { <-5, -1, -4.1>, <-4.25, -4, -4>
		pigment { color Red }
	#if(Power > 0)
		finish { ambient 1 diffuse 0}
	#else finish { ambient 0.3 diffuse 0}
	#end
		}
	box { <-4, -1, -4.1>, <-3.25, -4, -4>
		pigment { color rgb <1, 0.25, 0> }
	#if(Power > 1)
		finish { ambient 1 diffuse 0}
	#else finish { ambient 0.3 diffuse 0}
	#end
		}
	box { <-3, -1, -4.1>, <-2.25, -4, -4>
		pigment { color rgb <0.75, 0.5, 0> }
	#if(Power > 2)
		finish { ambient 1 diffuse 0}
	#else finish { ambient 0.3 diffuse 0}
	#end
		}
	box { <-2, -1, -4.1>, <-1.25, -4, -4>
		pigment { color rgb <0.5, 0.75, 0> }
	#if(Power > 3)
		finish { ambient 1 diffuse 0}
	#else finish { ambient 0.3 diffuse 0}
	#end
		}
	box { <-1, -1, -4.1>, <-0.25, -4, -4>
		pigment { color rgb <0.25, 0.75, 0> }
	#if(Power > 4)
		finish { ambient 1 diffuse 0}
	#else finish { ambient 0.3 diffuse 0}
	#end
		}
	box { <0, -1, -4.1>, <0.75, -4, -4>
		pigment { color rgb <0.25, 1, 0> }
	#if(Power > 5)
		finish { ambient 1 diffuse 0}
	#else finish { ambient 0.3 diffuse 0}
	#end
		}
	box { <1, -1, -4.1>, <1.75, -4, -4>
		pigment { color rgb <0, 1, 0> }
	#if(Power > 6)
		finish { ambient 1 diffuse 0}
	#else finish { ambient 0.3 diffuse 0}
	#end
		}

	box { <-5.5, -4.25, -3>, <2.25, -0.75, -4.01> pigment { color White*0.1 } }

	}
