/*

    Definition of clock hands for POVray
    Copyright (C) 1999 Aaron Gage

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.



*/


#include "lens.inc"

/*
#declare HourHand =
union {
	union {
		difference { 
			cylinder { z*-0.5, z*0.5, 3 }
			cylinder { z*-2, z*1, 1.5 }
			}
		difference {
			cylinder { <0, 15 + 2.75, -0.5>, <0, 15 + 2.75, 0.5>, 2.75 }
			cylinder { <0, 15 + 2.75, -0.51>, <0, 15 + 2.75, 0.51>, 2.25 }
			object { Lens scale 0.501 translate y*(5 + 5.25) }
			}
		difference {
			box { <-1.5, 0, -0.5>, <1.5, 20 + 2.75, 0.5> }
			cylinder { z*-5, z*5, 3 }
			cylinder { <0, 15 + 2.75, -5>, <0, 15 + 2.75, 5>, 2.75 }
			cylinder { <-4, 20 + 2.75, -5>, <-4, 20 + 2.75, 5>, 3.75 }
			cylinder { <4, 20 + 2.75, -5>, <4, 20 + 2.75, 5>, 3.75 }

			cylinder { <-1.5, 0, -5>, <-1.5, 0, 5>, 0.5
				scale <1, 20, 1> translate y*10 }

			cylinder { <1.5, 0, -5>, <1.5, 0, 5>, 0.5
				scale <1, 20, 1> translate y*10 }
			}
		texture { T_Silver_2B
			normal { bozo scale <50, 50, 0.1> } }
		}

object { Lens scale 0.5 translate y*(15 + 2.75) }
}
*/

#declare HourHand =
union {
	union {
		difference { 
			cylinder { z*-0.5, z*0.5, 2.75 }
			cylinder { z*-2, z*1, 1.25 }
			}
		difference {
			cylinder { <0, 15 + 2.75 + 10, -0.5>, <0, 15 + 2.75 + 10, 0.5>, 2.75 }
			cylinder { <0, 15 + 2.75 + 10, -0.51>, <0, 15 + 2.75 + 10, 0.51>, 2.25 }
			object { Lens scale 0.501 translate y*(5 + 5.25) }
			}
		difference {
			box { <-1.5, 0, -0.5>, <1.5, 20 + 2.75 + 10, 0.5> }
			cylinder { z*-5, z*5, 2.75 }
			cylinder { <0, 15 + 2.75 + 10, -5>, <0, 15 + 2.75 + 10, 5>, 2.75 }
			cylinder { <-4, 20 + 2.75 + 10, -5>, <-4, 20 + 2.75 + 10, 5>, 3.75 }
			cylinder { <4, 20 + 2.75 + 10, -5>, <4, 20 + 2.75 + 10, 5>, 3.75 }

			cylinder { <-1.5, 0, -5>, <-1.5, 0, 5>, 0.5
				scale <1, 30, 1> translate y*15 }

			cylinder { <1.5, 0, -5>, <1.5, 0, 5>, 0.5
				scale <1, 30, 1> translate y*15 }
			}

		difference {
			cylinder { <0, 3, -0.5>, <0, 3, 0.5>, 9 }
			cylinder { <0, -10, -5>, <0, -10, 5>, 20 }
			}
		texture { pigment { SteelBlue }
			finish { ambient 0.4 roughness 0.01 specular 0.5 }
			normal { bozo scale <3, 3, 1> } }
		}

object { Lens scale 0.5 translate y*(15 + 2.75 + 10) }
}

#declare MinuteHand =
union {
	union {
		difference { 
			cylinder { z*-0.5, z*0.5, 2.75 }
			cylinder { z*-2, z*1, 1 }
			}
		difference {
			cylinder { <0, 1.6666*(15 + 2.75 + 10), -0.5>,
				<0, 1.6666*(15 + 2.75 + 10), 0.5>, 2.75 }
			cylinder { <0, 1.6666*(15 + 2.75 + 10), -0.51>,
				<0, 1.6666*(15 + 2.75 + 10), 0.51>, 2.25 }
			object { Lens scale 0.501
				translate y*(1.6666*(15 + 2.5 + 10)) }
			}
		difference {
			box { <-1.5, 0, -0.5>, <1.5, 1.6666*(20 + 2.75 + 10), 0.5> }
			cylinder { z*-5, z*5, 2.75 }
			cylinder { <0, 1.6666*(15 + 2.75 + 10), -5>,
				<0, 1.6666*(15 + 2.75 + 10), 5>, 2.75 }
			cylinder { <-4, 0, -5>, <-4, 0, 5>, 3.75
				scale <1, 2, 1>
				translate y*(1.6666*(20 + 2.75 + 10))
				}
			cylinder { <4, 0, -5>, <4, 0, 5>, 3.75
				scale <1, 2, 1>
				translate y*(1.6666*(20 + 2.75 + 10))
				}

			cylinder { <-1.5, 0, -5>, <-1.5, 0, 5>, 0.5
				scale <1, 30*1.6666, 1> translate y*(15*1.6666) }

			cylinder { <1.5, 0, -5>, <1.5, 0, 5>, 0.5
				scale <1, 30*1.6666, 1> translate y*(15*1.6666) }
			}
		difference {
			cylinder { <0, 13, -0.5>, <0, 13, 0.5>, 9 }
			cylinder { <0, 0, -5>, <0, 0, 5>, 20 }
			}
		texture { pigment { SteelBlue }
			finish { ambient 0.4 roughness 0.01 specular 0.5 }
			normal { bozo scale <3, 3, 1> } }
		}

object { Lens scale 0.5 translate y*(1.6666*(15 + 2.75 + 10)) }
}

/*
object { HourHand rotate z*-(1*360/12) translate z*-12 }
object { MinuteHand translate z*-14 }
*/
