/*

    Definition of clock face for POVray
    Copyright (C) 1999 Aaron Gage

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.



*/

#declare OutletPlate =
difference {
	superellipsoid
		{
		<0.08, 0.08>
		scale <1, 1.5, 1>
		translate z*0.75
		}
	plane { z*-1, 0 }
	cylinder { <0, 0, 2>, <0, 0, -2>, 0.05 }
	pigment { color White*0.9 }
	finish { ambient 0.35 }

bounded_by {        superellipsoid
                {
                <0.08, 0.08>
                scale <1, 1.5, 1>
                translate z*0.75
                }
	}
}

#declare OutletJack =
difference {
	cylinder { <0, 0, -0.25>, <0, 0, 0.5>, 0.5
		pigment { color White*0.85 }
		finish { ambient 0.35 } }
	plane { y*-1, -0.4
		pigment { color White*0.85 }
		finish { ambient 0.35 } }
	plane { y*1, -0.4
		pigment { color White*0.85 }
		finish { ambient 0.35 } }
	box { <-0.2, 0.275, -0.3>, <-0.15, 0, 0.6>
		pigment { color White*0.1 } }
	box { <0.2, 0.265, -0.3>, <0.15, 0.01, 0.6>
		pigment { color White*0.1 } }
	union {
		difference {
			cylinder { <0, -0.225, -0.3>, <0, -0.225, 0.6>, 0.12 }
			plane { y*1, -0.226 }
			}
		box { <-0.12, -0.225, -0.3>, <0.12, -0.325, 0.6> }
		pigment { color White*0.1 }
		}
bounded_by {
	cylinder { <0, 0, -0.25>, <0, 0, 0.5>, 0.5 } }

	}

#declare JackShape = 
difference {
	cylinder { <0, 0, -1>, <0, 0, 1>, 0.5
		pigment { color White*0.1 } }
	plane { y*-1, -0.4
		pigment { color White*0.1 } }
	plane { y*1, -0.4
		pigment { color White*0.1 } }

bounded_by {
	cylinder { <0, 0, -1>, <0, 0, 1>, 0.5 } }
}

#declare Outlet =
union
	{
	difference {
		object { OutletPlate }
		object { JackShape scale <1.01, 1.01, 1> translate <0, 0.75, 0> }
		object { JackShape scale <1.01, 1.01, 1> translate <0, -0.75, 0> }
		}
	object { OutletJack translate y*0.75 }
	object { OutletJack translate y*-0.75 }
	}
