// Persistence of Vision Ray Tracer Scene Description File
// File: bottles.pov
// Vers: 3.1
// Desc: tasma napelniajaca butelki
// Date: begin: 13 july 1998
// Auth: Krzysztof Garus 'bajcik'
// e-mail: bajcik@priv.sos.com.pl or kgarus@bigfoot.com
// www: http://kolos.math.uni.lodz.pl/~garusk or www.bigfoot.com/~kgarus

//version 3.1

//---------------------------------------------------------------------- GLOBAL DEFS & MACROS
#include "btl_tex.pov" // TEXTURES

// klatek 88 klatek/s 16

#declare MaxRozwarcie = 50;
#declare Tasma_Side_Segs = 8; // wszystkich segmentw = Tasma_Side_Segs * 2 + 1
#declare Tasma_Side_Width = Tasma_Side_Segs * 6;

#declare deg = pi/180;
#declare NoTr = transform{translate 0}

global_settings {
	max_trace_level 6
	//ambient_light .5
	assumed_gamma 1.5
}

//------------------------------------------------------------------- TIME DEFS
#macro debval(name,c) #debug concat(concat(name," = "),str(c,0,5),"\n") #end
#macro inc(a) #declare a = a + 1; #end
#macro dec(a) #declare a = a - 1; #end
#macro interp(First,Last,T) (First+(T)*(Last-First)) #end // 0 <= T <= 1
#macro CutDown(a,Th) #if (a<Th) #declare a=Th; #end #end
#macro CutUp(a,Th) #if (a>Th) #declare a=Th; #end #end
#macro Sined(a) ((sin((a)*pi-pi/2)+1)/2) #end

//--------------------------------------------------------------------- macro SubPhase
// #switch (SetSubPhase({5,1,2,1,6,1,2,1,5},yes,num,ph))
#macro SubPhase(Arr,Phase,Ph)
	#local num = dimension_size(Arr,1);
	#local c = num;
	#local sum = 0;
	#while (c)
		#declare c = c-1
		#declare sum = sum + Arr[c];
	#end
	#local WP = (Phase)*sum;
	#declare sum = 0;
	#declare c = 0;
	#while (c<num & WP>sum)
		#declare sum = sum + Arr[c];
		inc(c)
	#end
	//#declare c = (c<1) ? 0:(c-1); // Doesn't work!
	#if (c<1) #declare c=0; #else dec(c) #end
	#declare Ph = (WP-sum)/Arr[c];
	c
#end

#macro SubPhaseBreaks(Arr,Phase,Ph,Break)
	#local num = dimension_size(Arr,1);
	#local Tab = array[num*2-1]
	#local c=0;
	#while (c<num)
		#declare Tab[c*2]=Arr[c];
		#if (c) #declare Tab[c*2-1]=Break; #end
		inc(c)
	#end
	SubPhase(Tab,Phase,Ph)
#end

#macro SubPhase01(Arr,Phase,Ph)
	#local num = dimension_size(Arr,1);
	//debval("num",num)
	//debval("Phase",Phase)
	#local c=0;
	#while ((c<num-1) & (Phase>Arr[c])) inc(c) #end dec(c)
	
	#if (c<0) #declare c=0; #end
	#local Left = Arr[c];
	#local Right = Arr[c+1];
	
	#declare Ph = (Phase-Left)/(Right-Left);
	//debval("c",c)
	//debval("Ph",Ph)
	c
#end
//--------------------------------------------------------------------- OBJECTS

// obrot=1 obraca o 180 deg
#macro Kogut(Kolor, Swiatlo, obrot)
	#local szklo = .2; // grubosc
	union {
		difference {
			merge {
				cylinder{0, 4*y, 2}
				sphere{0, 2 scale <1,.5,1> translate y*4}
			}
			merge {
				cylinder{0, 4*y, 2-szklo}
				sphere{
					0, 1 
					scale <2-szklo, 1-szklo, 2-szklo>
					translate y*4
				}
			}
			texture {
				pigment {color Kolor}
				finish {ior 1.4 specular .5 reflection .6}
			}
		}
		
		difference {
			cylinder {<-1, 2.5, 0>, <1, 2.5, 0>, 1 pigment {Black}}
			cylinder {<-2, 2.5, 0>, <2, 2.5, 0>, 0.8 pigment {Swiatlo}}
			rotate 180*y*obrot
		}
		
		union {
			cylinder {y*1.6, y*1,  .15}
			cylinder {y*1,	  y*.5, 1.3}
			box {<-2.3, 0, -2.3>, <2.3, .5, 2.3>}
			pigment {Brown}
		}
		
		light_source {y*2.5, color Swiatlo}
	}
#end // Kogut

#declare Bottle = difference {
	merge {
		sphere { y*5.3, 6.1 }
		cylinder { y*10, y*17.5, 2 }
		torus { 2, 0.5 translate y*17.5}
	}

	merge {
		sphere { y*5.5, 5 }
		cylinder { y*9, y*18.001, 1.5 }
		plane { y,0.001 }
	}
	texture { Tex_Bottle }
}

#declare Wine = merge {
	sphere { y*5.5, 4.9999 }
	cylinder { y*9, y*15, 1.4999 }
	texture { Tex_Wine }
}

// 0 <= winlevel <= 1
#macro SomeWine(winlevel)
	#if (winlevel<1)
		intersection {
			object { Wine }
			plane {y, interp(.5, 15, winlevel)}
		}
	#else
		object {Wine}
	#end
#end

#declare Korek = cone {
	y*16, 1.3
	y*19, 1.7
	texture { Tex_Cork }
}


#declare Label = cylinder {
	y*12, y*16, 2.001
	open
	texture {Tex_Label}
}

#declare Nalewnik_Rurka = union {
	#declare dXY = 1*cos(45*deg);
	#declare Z = -1;
	#declare R = .4;
	cylinder { <2,-1,Z>, <3,-1,Z>, R }              // poziomy
	cylinder { <4,0,Z>, <4,2,Z>, R }                // pionowy prawy
	cylinder { <-1,5+4*dXY,Z>, <-1,100,Z>, R }      // pionowy lewy
	cylinder { <3+dXY,2+dXY,Z>,<-dXY,5+3*dXY,Z>,R}  // ukosny
	intersection {      // kolanko lewe
		torus {1,R}
		intersection {
			plane {z,0}
			plane {-z+x,0}
		}
		rotate x*-90
		translate <0,5+4*dXY,Z>
	}
	intersection {      // kolanko prawe dolne
		torus {1,R}
		intersection {
			plane {z,0}
			plane {-x,0}
		}
		rotate x*-90
		translate <3,0,Z>
	}
	intersection {      // kolanko prawe grne
		torus {1,R}
		intersection {
			plane {-z,0}
			plane {z-x,0}
		}
		rotate x*-90
		translate <3,2,Z>
	}
	texture { Tex_Nalewnik_Rurka}
} /* Nalewnik_Rurka */


// 0 <= Down <= 1
#macro Nalewnik(Down)
	#local MaxUp = 18;
	union {
		cone { y*-2, 1.5, y*-20, .5 open texture { Tex_Nalewnik_Dziubek } }  // dziubek
		box { <-2.5,-2,-2.5>, <2.5,0,2.5> texture { Tex_Nalewnik_BigBox } }
		box { <-2.5,0,-1.8>, <1.8,.4,1.8> texture { Tex_Nalewnik_LDolne } }
		cylinder { <-2,.4,-1>, <-2,100,-1>, .5 texture { Tex_Nalewnik_Suwak} }
		cylinder { <-2,.4, 1>, <-2,100, 1>, .5 texture { Tex_Nalewnik_Suwak} }
		cylinder { 0, y*1.5, .6  texture { Tex_Nalewnik_Os}}
		// --
		object { Nalewnik_Rurka }
		rotate y*90
		translate y*(21+MaxUp*(1-Down))
	}
#end

/*#declare Beben = union {
	cylinder { 0,y*40,60 texture {Tex_Beben_Cyl1} }
	cylinder { 0,y*-10,75 texture {Tex_Beben_Cyl2} } // spod
	torus { 74,.7 translate y*6 texture {Tex_Beben_Porecz} }
}*/

#macro Scroller(Phase)
	union {
		#local HafUpCyl = intersection {
			cylinder {x*-4, x*4, 1}
			plane {-y,0}
			texture {Tex_Scroller_HafCyl}
			translate y*2
		}

		object {HafUpCyl}
		object {HafUpCyl scale <1,-1,1>}
		box {<-4, -3, 0> <4, 3, -.2> texture {Tex_Scroller_Back}}
		box {
			<-3.6, -2.1, -.8>
			<3.6, 2.1, -.81>
			texture {
				Tex_Scroller_Logo
				translate x*-.5
				translate y*Phase*1.5
				scale 2*3.6
			}
		}
	}
#end

#macro Szczypce_Ramie(rozw)
union {
	#local UP = <0,-.35,1>;
	#local LF = vrotate(UP,-y*120);
	sphere { <LF.x,LF.y,LF.z>, .4 texture {Tex_Szczypce_Krazek}}
	cylinder {vrotate(<0,-5.5,2>,y*-60), UP, .1 texture {Tex_Szczypce_Drucik}}
	cylinder {vrotate(<0,-5.5,2>,y*-60), LF, .1 texture {Tex_Szczypce_Drucik}}
	intersection {
		cylinder {y*-6, y*-5.2, 2.4}
		cylinder {y*-7, y*-4, 1.7 inverse}
		plane {x, -.3}
		plane {vrotate(x,y*60), -.3}
		texture {Tex_Szczypce_Docisk}
	}
	rotate y*-120
	translate <0,.35,-LF.z>
	rotate x*rozw
	translate <0,-.35,LF.z>
}
#end

#macro Szczypce(Rozw)
union {
	cylinder { 0, y*100, .2 texture {Tex_Szczypce_Drut}}
	#local z120 = vrotate(z,y*120);
	prism {
		0, -.7
		3
		<0,1>, <z120.x,z120.z>, <-z120.x,z120.z>
		sturm
		texture {Tex_Szczypce_Mostek}
	}
	object {Szczypce_Ramie(Rozw)}
	object {Szczypce_Ramie(Rozw) rotate y*120}
	object {Szczypce_Ramie(Rozw) rotate y*-120}
	translate y*24.5
	rotate y*-60
}
#end

//----------------------------------------- {

// Wysuniecie, Rozwarcie
#declare Laber_Hole = box {
	<-6, -3, -.1>
	< 6,  3, 10 >
	translate <-18, 14, 8>
	texture {Tex_Sciana_Hole}
}

#macro Labeler (Wys,Rowz)
	#local r = .4;
	#local rP = .2;
	#local R = .3;

	// kolanko prawe srodkowe przednie
	#local Neck = intersection {
		torus {R,rP}
		plane {z,0}
		plane {-x,0}
		translate <2+r, 0, R>
	}

	// srodkowy, w praktyce nie wystepujacy
	#local Uchwyt = union {
		object {Neck translate -z}
		object {Neck scale <1,1,-1> translate z*5}
		cylinder {z*(-1+R), z*(5-R), rP translate x*(2+r+R)}
		cylinder {x*-1, x*(2+r), rP translate z*5}
	}

	#local Zacisk = union { // prawy
	
		union {
			difference {
				box {<0,-2-r,-2-r>,<2,2+r,2+r>}
				cylinder {y*-3,y*3, 2.05}
			}
			box {<2,-2-r,-2>,<2+r,2+r,2>}
		
			intersection {
				cylinder {(-2-r)*y, (2+r)*y, r}
				plane {-z,0}
				plane {-x,0}
				translate <2,0,2>
			}
		
			intersection {
				cylinder {(-2-r)*y, (2+r)*y, r}
				plane { z,0}
				plane {-x,0}
				translate <2,0,-2>
			}
			texture {Tex_Labeler_Zacisk}
		}
		
		union {
			object {Uchwyt translate y}
			object {Uchwyt translate z*2}
			object {Uchwyt translate -y}
			texture {Tex_Labeler_Drucik}
		}
	} // Zacisk
	
	#local Drut = cylinder { // prawy gorny
		z*6, z*16, .3
		texture {Tex_Labeler_Drut}
		translate <1.6, 1.6, 0>
	} // Drut
	
	union {
		object {Zacisk translate x*Rowz*2.2}
		object {Zacisk translate x*Rowz*2.2 scale <-1,1,1>}
		object {Drut}
		object {Drut scale <-1, 1,1>}
		object {Drut scale < 1,-1,1>}
		object {Drut scale <-1,-1,1>}
		box { <-2,-2,3> <2,2,6> texture {Tex_Labeler_Mostek} }
		
		translate y*14 + z*(1-Wys)*11
	}
#end // Labeler

#declare Tasma_Segment = union {
	cylinder {
		z*-6
		z*6
		2
		scale y/4.01+x+z
		translate y*-.5
		texture {Tex_Tasma_Segment_Big}
	}
	cylinder {
		z*-6
		z*6
		.5
		scale x/3+y+z
		translate y*-.5
		translate x*3
		texture {Tex_Tasma_Segment_Small}
	}
}

#declare Tasma_Bok = union {
	box {
		<-Tasma_Side_Width, .05, -.1>
		<Tasma_Side_Width, -1.05, .1>
	}
	box {
		<-Tasma_Side_Width, .05, -.1>
		<Tasma_Side_Width, -1.05, .1>
		translate y*-2.2
	}
	texture {Tex_Tasma_Bok}
}

#macro Tasma(Move,Phase) // Move = 18
	union {
		object {Tasma_Bok translate z*7}
		object {Tasma_Bok translate z*-6}
		#local cnt = -Tasma_Side_Segs;
		#while (cnt <= Tasma_Side_Segs )
			object {Tasma_Segment translate x*(cnt*6-Phase*Move)} // 0 <= Phase < 1
			object {
				Tasma_Segment
				translate y*-2.2 // pod spodem
				translate x*(cnt*6+1.78+Phase*Move)
			}
			inc(cnt)
		#end
		union {
			cylinder { <-Tasma_Side_Width, -1.1, 0>, <Tasma_Side_Width, -1.1, 0>, .5}
			cylinder { <-Tasma_Side_Width, -1.1, 4>, <Tasma_Side_Width, -1.1, 4>, .5}
			cylinder { <-Tasma_Side_Width, -1.1, -3.5>, <Tasma_Side_Width, -1.1, -3.5>, .5}
			texture {Tex_Tasma_Rurka}
		}
	}
#end

#declare Sciany = union {
	difference {
		plane {
			-z,-8
			texture {Tex_Sciana}
		}
		object {Laber_Hole}
	}
	intersection {
		box {
			<-27.2, -4, -9>
			<27.2, 30, -7>
			inverse
		}
		intersection {
			plane {z, -8}
			plane {-z, 8.7}
		}
		texture {Tex_Front_Sciana}
	}
	light_source {<-18, 14, 8>+<-5,2,7> <1,1,.5>}
}

#declare Drzwi = box {
	<.4, .5, -7.4>
	<-.4, 28, 7.4>
	texture {Tex_Drzwi}
}
//----------------------------------------------------------- OBJECT WORK CYCLES
#macro Szczypce_Cycle(Phase)
	#local p_Szczypce_Up=0;
	#local p_Szczypce_Roty=0;
	#local p_Szczypce_Rozwarcie=0;
	#local p_Korek_Up=0;
	#local p_Korek_Roty=0;
	#local Ofs=0;	
	#switch (SubPhaseBreaks(array[4]{1.2, 1.4, .8, 1.2}, Phase, Ofs, .3))
		#case (0) // opuszczanie
			#declare p_Szczypce_Up =1+(1-Ofs)*16.3;
			#declare p_Korek_Up = 1+(1-Ofs)*16.3;
		#break

		#case (1) // wkrecanie
			#declare p_Szczypce_Up = (1-Ofs)*1;
			#declare p_Korek_Up = (1-Ofs)*1;
			#declare p_Szczypce_RotY = Ofs*MaxRotateY;
			#declare p_Korek_RotY = Ofs*MaxRotateY;
		#break

		#case (2) // rozwieranie
			#declare p_Szczypce_RotY = MaxRotateY;
			#declare p_Korek_RotY = MaxRotateY;
			#declare p_Szczypce_Rozwarcie = Ofs*MaxRozwarcie;
		#break

		#case (3) // podnoszenie
			#declare p_Szczypce_Rozwarcie = MaxRozwarcie;
			#declare p_Szczypce_RotY = MaxRotateY;
			#declare p_Korek_RotY = MaxRotateY;
			#declare p_Szczypce_Up =Ofs*9.7;
		#break
	#end
	
	object {
		Szczypce(p_Szczypce_Rozwarcie)
		rotate y*p_Szczypce_RotY
		translate y*p_Szczypce_Up
	}
    
   object {
   	Korek
		rotate y*p_Korek_RotY
		translate y*p_Korek_Up
   }
#end

//----------------------------------------------------------- TEMPORARY OBJECTS

//--------------------------------------------------------------------- CAMERAS
#declare Cam1 = camera {
	location <2,25,-3>
	look_at <0,22,0>
}

#declare Cam2 = camera {    // widok z gory na butelke
	location <6,36,-7>
	look_at <0,20,0>
}

#declare Cam3 = camera {    // widok na beben
	location <65,4,-50>
	look_at <57,10,0>
}

#declare Cam4 = camera {    // widok na korek, res 180 x 300
	right .6*x
	location <-16,30,-17>
	look_at <0,19,0>
}

#declare Cam5 = camera {    // widok na tasme, res 200 x 100
	right 2*x
	location <0,10,-35>
	look_at <0,10,0>
}

#declare Cam6 = camera { // na etykietke
	location <0,20,-15>
	look_at y*13.5
}


#declare Cam7 = camera { // na wszystko, +w160 +h100 || +w640 +h400
	right 1.6*x
	angle 50
	location <0, 14, -70>
	look_at y*13
}

#declare Cam8 = camera { // na wszystko, ale rozmiar normalny, lekko z ukosa
	//right 1.6*x
	angle 50
	location <-25, 20, -60>
	look_at <-1,13,0>
}

#declare Cam9 = camera { // na Labeler
	location <-18,14,0> + 10*<1,1,-2> 
	look_at <-18,14,0>
	angle 30
}

#declare Cama = camera { // na Scroller
	location <-10,25,7> + 10*<1,1,-1.4> 
	look_at <-10,25,7>
	angle 50
}
//----------------------------------------------------------- ANIM SCENE MACRO
#macro AnimateScene(clk)
	#local MaxRotY = 140;

	camera {Cam8}
	
	light_source {15*<-10,2,-5> White}
	light_source {100*<.5,1.4,-5> White}
	//light_source {15*<-10,2,-5> White}
	
	object {Sciany}
	
	#local Ph=0; #local Ph2=0; #local Ph3=0;

	#declare Ph = 5*clk;
	object {Kogut(Blue+.9*Clear, White, Ph) scale 1 rotate x*-90 translate <-5,26,8>}
	
	object {Scroller(clk+.16) scale 2.2 translate <-17,25,8>}
	
	#switch (SubPhase01(array[3]{0, .3, 1},clk,Ph)) // Tasma
		#case (0) #declare Ph = Sined(Ph); #break
		#case (1) #declare Ph = 1; #break
	#end
	object {Tasma(18,Ph)}
	#local c=0;
	#while (c<6)
		object {Bottle translate x*(18*(c-2)-Ph*18)}

		#if (c<3)
			object {Korek rotate y*MaxRotY translate x*(18*(c-2)-Ph*18)}
		#end

		#if (c<4)
			object {Wine translate x*(18*(c-2)-Ph*18)}
		#end

		#if (c<2)
			object {Label translate x*(18*(c-2)-Ph*18)}
		#end
		inc(c)
	#end
	
	#switch (SubPhase01(array[5]{0, .26, .34, .88, 1},clk,Ph)) // Drzwi (Podnoszenie)
		#case (0) #declare Ph = 1; #break
		#case (1) #declare Ph = Sined(1-Ph); #break
		#case (2) #declare Ph = 0; #break
		#case (3) #declare Ph = Sined(Ph); #break
	#end
	object {Drzwi translate y*22*Ph translate x*28.4}
	object {Drzwi translate y*22*Ph scale <1,1,-1> translate x*-28.4}
	
	#switch (SubPhase01(array[5]{0, .25, .45, .7, 1},clk,Ph)) // Nalewnik (opuszczenie)
		#case (0) #declare Ph = 0; #break
		#case (1) #declare Ph = Sined(Ph); #break
		#case (2) #declare Ph = 1; #break
		#case (3) #declare Ph = Sined(1-Ph); #break
	#end
	object {Nalewnik(Ph) translate x*18}

	#switch (SubPhase01(array[4]{0, .47, .79, 1}, clk, Ph)) // Winko
		#case (0) #declare Ph = 0; #break
		//    (1) - no change - linear
		#case (2) #declare Ph = 1; #break
	#end
	object {SomeWine(Ph) translate x*18}
	
	#switch (SubPhase01(array[5]{0, .2, .35, .85, 1},clk,Ph)) // Labeler.Wysuniecie
		#case (0) #declare Ph = 0; #break
		#case (1) #declare Ph = Sined(Ph); #break
		#case (2) #declare Ph = 1; #break
		#case (3) #declare Ph = Sined(1-Ph); #break
	#end
	#switch (SubPhase01(array[6]{0, .34, .42, .78, .86, 1},clk,Ph2)) // Labeler.Rozwarcie
		#case (0) #declare Ph2 = 1; #break
		#case (1) #declare Ph2 = Sined(1-Ph2); #break
		#case (2) #declare Ph2 = 0; #break
		#case (3) #declare Ph2 = Sined(Ph2); #break
		#case (4) #declare Ph2 = 1; #break
	#end
	object {Labeler(Ph,Ph2) translate x*-18}
	
	#if (clk>.5) // Label
		object {Label translate x*-18}
	#end

	#local UpLo=1;
	#local UpHi=17;
	#switch (SubPhase01(array[6]{0, .18, .34, .6, .75, 1},clk,Ph)) // Szczypce.Up
		#case (0) #declare Ph = UpHi; #break
		#case (1) #declare Ph = interp(UpHi,UpLo,Sined(Ph)); #break
		#case (2) #declare Ph = Sined((1-Ph)*UpLo); #break
		#case (3) #declare Ph = 0; #break
		#case (4) #declare Ph = Sined(Ph)*UpHi; #break
	#end
	#switch (SubPhase01(array[4]{0, .6, .77, 1}, clk, Ph2)) // Szczypce.Rozwarcie
		#case (0) #declare Ph2 = 0; #break
		//    (1) - no change - linear
		#case (2) #declare Ph2 = 1; #break
	#end
	#switch (SubPhase01(array[4]{0, .32, .6, 1}, clk, Ph3)) // Szczypce.Obrot
		#case (0) #declare Ph3 = 0; #break
		//    (1) - no change - linear
		#case (2) #declare Ph3 = 1; #break
	#end
	object {
		Szczypce(Ph2*50)
		rotate y*Ph3*MaxRotY
		translate y*Ph
	}
	
	#if (clk>.65)
		#declare Ph=0; // Korek zostaje na butelce
		#declare Ph3=1;		
	#end
	object {
		Korek
		rotate y*Ph3*MaxRotY
		translate y*Ph
	}
#end
//---------------------------------------------------------------------- SCENE

#declare clk = clock;

#declare Test = 0;
#if (Test)
	camera {Cam8}
	background {Gray65}
	
#else
	AnimateScene(clk)	
#end



