// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?[esp]
//

#version 3.1

#include "colors.inc"
#include "glass.inc"
//#include "twisted_tree.inc"

#declare SHOW_WINDOWS=1;

global_settings
{
  assumed_gamma 1.0
  ambient_light <0.1,0.1,0.1>
}

// ----------------------------------------
camera
{
  location  <5, 5, -15.0>
  direction 1.5*z
  right     4/3*x
  look_at   <-2, 3,  0.0>
}

light_source{0*x color red 0.2  green 0.2  blue 0.1 translate <-30, 30, -30>}

// ----------------------------------------
//#default{pigment{Red} finish{phong 1.0}}

#declare window_1=object{
 union{
  difference{
   box{<-1,-1,0>,<1,1,-0.125>}
   box{<-0.95,-0.95,-100>,<0.95,0.95,100>}
  }
  box{<-0.025,-1,0>,<0.025,1,-0.1>}
  box{<-1,-0.025,0>,<1,0.025,-0.1>}
  box{<-1,-1,0>,<1,1,0.05> texture{T_Old_Glass} interior{I_Glass}}
 }
}

#macro clock_1(minute_hand,hour_hand,trans_vector,ring_color)
 union{
  cylinder{<0,0,0>,<0,0,-0.1>0.5}
  sphere{<0,0,0>,0.5 scale<1,1,0.125> translate<0,0,-0.1>}
  cone{<0,0,0>,0.05,<0,0.4,0>,0 rotate<0,0,-hour_hand> translate<0,0,-0.2> pigment{Black}}
  cone{<0,0,0>,0.05,<0,0.45,0>,0 rotate<0,0,minute_hand> translate<0,0,-0.2> pigment{Black}}
  sphere{<0,0,0>,0.1 translate<0,0,-0.1> pigment{Black}}
  torus{0.5,0.1 rotate<90,0,0> texture{ring_color}}
  #declare z_rot=0;
  #while(z_rot<360)
   sphere{<0.4,0,-0.1>,0.05 rotate<0,0,z_rot> pigment{Black}}
   #declare z_rot=z_rot+30;
  #end
  translate trans_vector
  pigment{White}
 }
#end


#declare bld_1_tex = texture{pigment{Red}}
#declare building_1=object{
 union{
  light_source{0*x color red 1.0 green 1.0 blue 0.75 translate <1,2,0>}
  difference{
   union{
    superellipsoid{<0.1,0.1> translate<0,1,0> scale<1,2,1>}
    superellipsoid{<0.1,0.1> translate<0,1,0> scale<1,1.75,1> translate<1,0,0>}
    superellipsoid{<0.1,0.1> translate<0,2.5,0> scale<0.3,2,0.3> translate<0.75,0,0>}
    superellipsoid{<0.1,0.1> translate<0,9,0> scale<0.5,0.75,0.5> translate<0.75,0,0>}
   }
   union{
    superellipsoid{<0.1,0.1> translate<0,1,0> scale<1,2,1>}
    superellipsoid{<0.1,0.1> translate<0,1,0> scale<1,1.75,1> translate<1,0,0>}
    pigment{White}
    scale 0.99
   }
   box{<-1,-1,-100>,<1,1,0.5> scale<0.25,0.5,0.25> translate<0.8,0.5,-1> texture{bld_1_tex}} //door hole
   #if(SHOW_WINDOWS = 1)
    box{<-1,-1,-100>,<1,1,0.5> scale<0.25,0.5,0.5> translate<0,1,-1> pigment{White}}
    box{<-1,-1,-100>,<1,1,0.5> scale<0.25,0.5,0.5> translate<1.5,1,-1> pigment{White}}
    box{<-1,-1,-100>,<1,1,0.5> scale<0.25,0.5,0.5> translate<1.35,2.5,-1> pigment{White}}
    box{<-1,-1,-100>,<1,1,0.5> scale<0.5,0.25,0.5> translate<0,2,-1> pigment{White}}
   #end
  }
  superellipsoid{<0.1,0.1> scale<1,1,0.1> translate<1,0,0> rotate<0,-45,0> translate<-1,0,0> scale<0.25,0.5,0.25> translate<0.8,0.5,-1> texture{bld_1_tex}} //door
  #if(SHOW_WINDOWS = 1)
   object{window_1 scale<0.25,0.5,0.5> translate<0,1,-1> pigment{Black}}
   object{window_1 scale<0.25,0.5,0.5> translate<1.5,1,-1> pigment{Black}}
   object{window_1 scale<0.25,0.5,0.5> translate<1.35,2.5,-1> pigment{Black}}
   object{window_1 scale<0.5,0.25,0.5> translate<0,2,-1> pigment{Black}} 
  #end 
  clock_1(20,-100,<0.25,3.2,-1>,texture{bld_1_tex})
  texture{bld_1_tex}
 }
}


#declare bld_2_tex_01 = texture{pigment{Red}}
#declare bld_2_tex_02 = texture{pigment{Yellow}}
#declare bld_2_tex_03 = texture{pigment{Red}}
#declare bld_2_tex_04 = texture{pigment{Blue}}

#declare building_2=object{
 union{
  box{<-4,0,-5>,<4,12,5>}
  box{<-5,0,-4>,<5,12,4>}
  cylinder{<-4,0,-4>,<-4,10,-4>,1}
  cylinder{<4,0,4>,<4,10,4>,1}
  cylinder{<-4,0,4>,<-4,10,4>,1}
  cylinder{<4,0,-4>,<4,10,-4>,1}
  
  intersection{
   union{
    torus{2,1 rotate<90,0,0> translate<-6,10,-4>}
    torus{2,1 rotate<90,0,0> translate<6,10,-4>}  
    torus{2,1 rotate<90,0,0> translate<-6,10,4>}
    torus{2,1 rotate<90,0,0> translate<6,10,4>}  
   }
   box{<-6,10,-100>,<6,100,100>}
  }
  cylinder{<-10,12,-4>,<10,12,-4>,1}
  cylinder{<-10,12,4>,<10,12,4>,1}
  cylinder{<-10,14,-4>,<10,14,-4>,1}
  cylinder{<-10,14,4>,<10,14,4>,1}
  box{<-10,12,-5>,<10,14,5>}
  
   difference{
    cylinder{<-6,10,-5>,<-6,10,5>,4}
    cylinder{<-6,10,-10>,<-6,10,10>,2}
   }
   difference{
    cylinder{<6,10,-5>,<6,10,5>,4}
    cylinder{<6,10,-10>,<6,10,10>,2}   
   }

  

  
  texture{bld_2_tex_01}
 }
}


//object{building_1}
//object{building_2}

//#declare TREE_TEX_FILT=0.3;
//#declare tree_tex=texture{pigment{gradient y color_map{[0.0 1.0 color rgb<0.25,0,0> color rgb<0.5,0.5,0.1>]} turbulence 0.35 scale 5} normal{spiral1 8 , 0.5 turbulence 0.4 scale<0.25,0.5,0.25>}} texture{pigment{marble color_map{[0.0 0.4 color rgbf<0.1,0.1,0.0,TREE_TEX_FILT> color rgbf<0.2,0.15,0.1,TREE_TEX_FILT>][0.4 0.6 color rgbf<0.6,0.55,0.2,TREE_TEX_FILT> color rgbf<0.6,0.5,0.1,TREE_TEX_FILT>][0.6 1.0 color rgbf<0.2,0.15,0.1,TREE_TEX_FILT> color rgbf<0.0,0.0,0.0,TREE_TEX_FILT>]} frequency 20 turbulence 0.25 scale<2,3,1>} normal{spiral1 8 , 0.5 turbulence 0.4 scale<0.25,0.5,0.25>}}
//object{twisted_tree rotate<0,-20,0> scale 1 translate<-3,0,0>}
