
#version 3.1

#include "colors.inc"
#include "glass.inc"
#include "textures.inc"
//#include "twisted_tree.inc"
#include "building_1.inc"
#include "wrapped_ball.inc"

global_settings
{
  assumed_gamma 1.0
}

// ----------------------------------------
#declare box_tex=
texture{
 pigment{Wheat}
 finish{phong 1.0}
 normal{bumps 0.2 scale 0.25}
}

#declare trim_tex=
texture{
 pigment{White}
 finish{phong 1.0}
 normal{bumps 0.2 scale 0.25}
}

#declare wall_tex=
texture{
 pigment{Gray15}
 finish{diffuse 0.4}
 normal{bumps 0.2 scale 0.25}
}

#declare floor_tex=
texture{
 pigment{Gray10}
 finish{reflection 0.2}
}


#macro popper_1(scale_vec,trans_vec,rot_vec,pop_val,pop_rot_vec,tube_tex)
 union{                      
  union{
   cylinder{<0,0,0>,<0,1,0>,1}
   sphere{<0,1,0>,0.125 translate<0,0.05,-1>}
   difference{
    sphere{<0,1,0>,1}
    sphere{<0,1,0>,0.1 scale<2,1,1> translate<0,0.275,-1> rotate<0,26,0> pigment{White}}
    sphere{<0,1,0>,0.1 scale<2,1,1> translate<0,0.275,-1> rotate<0,-26,0> pigment{White}}
   }
   sphere{<0,1,0>,0.075 scale<2,1,1> translate<0,0.03,-1> rotate<0,5,0>}
   sphere{<0,1,0>,0.075 scale<2,1,1> translate<0,0.03,-1> rotate<0,-5,0>} 
   torus{1,0.05 scale<0.75,1,1> translate<0,0.7,0>}
   union{
    sphere{<0,1,0>,0.1 scale<1,1,1> translate<0,0.275,-0.85> rotate<0,26,0>}
    sphere{<0,1,0>,0.1 scale<1,1,1> translate<0,0.275,-0.85> rotate<0,-26,0>}
    pigment{Black} finish{phong 1.0}
   }
   cylinder{<0,0,0>,<0,0,0.1>,0.25 translate<-1,1,0>}
   cylinder{<0,0,0>,<0,0,0.1>,0.25 translate<1,1,0>} 
   pigment{image_map{tga "guy_1.tga" map_type 2 interpolate 2 once} scale<3.5,2.5,2.5> rotate y*-88}
   rotate pop_rot_vec
   translate<0,pop_val,0>
  }
  union{
   torus{1.5,0.125}
   difference{
    cylinder{<0,-0.3125,0>,<0,0,0>,1.5}
    torus{1.5,0.125 translate<0,-0.25,0>}
   }
   cylinder{<0,-5,0>,<0,0,0>,1.375}                                                 
   texture{tube_tex}
  }
  scale scale_vec
  rotate rot_vec
  translate trans_vec
 }
#end

#declare twist_1=object{
 union{
  #declare cnt=0;
  #declare trs=10;
  #declare scl=0.1;
  #while(trs>1)
   sphere{<trs,0,0>,scl rotate<0,0,cnt> rotate<0,cnt,0> pigment{Red}}
   sphere{<-trs,0,0>,scl rotate<0,0,cnt> rotate<0,cnt,0> pigment{Red}}
   #declare cnt=cnt+1;
   #declare trs=trs*0.995;
   #declare scl=scl*1.0035; 
  #end
 }
}

#declare dial_1=object{
 union{
  difference{
   cylinder{<0,0,0>,<0,0,-3>,3}
   #declare z_rot=0;
   #while(z_rot<360)
    cylinder{<-3.275,0,-10>,<-3,0,10>,0.35 rotate<0,0,z_rot> }
    #declare z_rot=z_rot+15;
   #end
  }
  cone{<0,0,-3>,2.75,<0,0,-3.5>,2.5}
  object{wrapped_ball rotate<-90,0,0> scale 0.35 translate<0,0,-3.5>}
  cylinder{<0,0,0>,<0,0,5>,0.75}
 }
}

#macro radar(dish_rot,stand_rot,scale_vec,trans_vec,dish_tex,stand_tex,poker_tex,axle_tex,bulb_tex)
 union{
  union{
   difference{
    sphere{<0,0,0>,1}
    sphere{<0,0,0>,0.95}
    box{<-10,0,-10>,<10,10,10>}
   }
   union{
    cylinder{<0,-0.9,0>,<0,1,0>,0.075}
    difference{
     sphere{<0,1,0>,0.2}
     box{<-10,1,-10>,<10,10,10>}
    }
    texture{poker_tex}
   }
   cylinder{<0,-1.1,0.1>,<0,-1.3,-0.1>,0.25}
   box{<-0.25,-0.95,0.1>,<0.25,-1.3,-0.1>}
   sphere{<0,1,0>,0.125 texture{bulb_tex}}  
   translate<0,1.3,0>
   rotate<0,0,dish_rot>
   texture{dish_tex}
  }
  union{
   cylinder{<0,0,-0.125>,<0,0,-0.3>,0.25}
   box{<-0.25,0,-0.125>,<0.25,-1,-0.3>}
   cylinder{<0,0,0.125>,<0,0,0.3>,0.25} 
   box{<-0.25,0,0.125>,<0.25,-1,0.3>}
   cylinder{<0,-1,0>,<0,-1.25,0>,0.75}
   sphere{<0,0,0>,0.75 scale<1,0.2,1> translate<0,-1,0>}
   texture{stand_tex}
  }
  union{
   cylinder{<0,0,0.35>,<0,0,-0.35>,0.12}
   texture{axle_tex}
  }
  rotate y*stand_rot
  scale scale_vec
  translate trans_vec
 }
#end

#declare sprocket=object{
// union{
  difference{
   box{<0.5,1,0.4>,<-0.5,-1,-0.4>}
   box{<0,10,10>,<-10,-10,-10> rotate<0,0,-10> translate<-0.5,0,0>}
   box{<0,10,10>,<10,-10,-10> rotate<0,0,10> translate<0.5,0,0>}   
  }
//}
}

#declare gear_1=object{
 union{
  difference{
   cylinder{<0,0,0.5>,<0,0,-0.5>,4}
   cylinder{<0,0,-10>,<0,0,-0.4>,2}
   cylinder{<0,0,-10>,<0,0,10>,0.5}
  }
  sphere{<0,0,0>,0.25 translate<1,0,-0.4>}
  sphere{<0,0,0>,0.25 translate<1,0,-0.4> rotate<0,0,120>}
  sphere{<0,0,0>,0.25 translate<1,0,-0.4> rotate<0,0,240>}  
  #declare z_rot=0;
  #while(z_rot<360)
   object{sprocket translate<0,4,0> rotate<0,0,z_rot+11.25>}
   #declare z_rot=z_rot+22.5;
  #end
 }
}

#declare gear_2=object{
 union{
  difference{
   cylinder{<0,0,0.5>,<0,0,-0.5>,2}
   cylinder{<0,0,-10>,<0,0,-0.4>,1}
   cylinder{<0,0,-10>,<0,0,10>,0.25}   
  }
  #declare z_rot=0;
  #while(z_rot<360)
   object{sprocket translate<0,2,0> rotate<0,0,z_rot>}
   #declare z_rot=z_rot+45;
  #end
 }
}

#fopen FrameFile "c:\animation\machine\framefile.txt" read
#read (FrameFile,Curr_Frame)
#fclose FrameFile

//#declare Curr_Frame = val(Curr_Frame_Str);
#declare StandRot_Index = 0;
#declare Gear1Rot_Index = 1;
#declare Gear2Rot_Index = 2;
#declare DishRot_Index = 3;
#declare Light1_Index = 4;
#declare Light2_Index = 5;
#declare Light3_Index = 6;
#declare Light4_Index = 7;
#declare Light5_Index = 8;
#declare Light6_Index = 9;
#declare Light7_Index = 10;
#declare Light8_Index = 11;
#declare TwistDial_Index = 12;
#declare Popper_Pop_Index =13;

#declare cam_loc_x =14;
#declare cam_loc_y =15;
#declare cam_loc_z =16;
#declare cam_look_x =17;
#declare cam_look_y =18;
#declare cam_look_z =19;

#declare Anim_Path=
 array[20][248]
 {

{0,5,10,15,20,25,30,35,40,45,50,55,60,65,70,75,80,85,90,95,100,105,110,115,120,125,130,135,140,145,150,155,160,165,170,175,180,185,190,195,200,205,210,215,220,225,230,235,240,245,250,255,260,265,270,275,280,285,290,295,300,305,310,315,320,325,330,335,340,345,350,355,0,5,10,15,20,25,30,35,40,45,50,55,60,65,70,75,80,85,90,95,100,105,110,115,120,125,130,135,140,145,150,155,160,165,170,175,180,185,190,195,200,205,210,215,220,225,230,235,240,245,250,255,260,265,270,275,280,285,290,295,300,305,310,315,320,325,330,335,340,345,350,355,0,5,10,15,20,25,30,35,40,45,50,55,60,65,70,75,80,85,90,95,100,105,110,115,120,125,130,135,140,145,150,155,160,165,170,175,180,185,190,195,200,205,210,215,220,225,230,235,240,245,250,255,260,265,270,275,280,285,290,295,300,305,310,315,320,325,330,335,340,345,350,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355},
{0,5,10,15,20,25,30,35,40,45,50,55,60,65,70,75,80,85,90,95,100,105,110,115,120,125,130,135,140,145,150,155,160,165,170,175,180,185,190,195,200,205,210,215,220,225,230,235,240,245,250,255,260,265,270,275,280,285,290,295,300,305,310,315,320,325,330,335,340,345,350,355,0,5,10,15,20,25,30,35,40,45,50,55,60,65,70,75,80,85,90,95,100,105,110,115,120,125,130,135,140,145,150,155,160,165,170,175,180,185,190,195,200,205,210,215,220,225,230,235,240,245,250,255,260,265,270,275,280,285,290,295,300,305,310,315,320,325,330,335,340,345,350,355,0,5,10,15,20,25,30,35,40,45,50,55,60,65,70,75,80,85,90,95,100,105,110,115,120,125,130,135,140,145,150,155,160,165,170,175,180,185,190,195,200,205,210,215,220,225,230,235,240,245,250,255,260,265,270,275,280,285,290,295,300,305,310,315,320,325,330,335,340,345,350,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355},
{0,-10,-20,-30,-40,-50,-60,-70,-80,-90,-100,-110,-120,-130,-140,-150,-160,-170,-180,-190,-200,-210,-220,-230,-240,-250,-260,-270,-280,-290,-300,-310,-320,-330,-340,-350,-360,-370,-380,-390,-400,-410,-420,-430,-440,-450,-460,-470,-480,-490,-500,-510,-520,-530,-540,-550,-560,-570,-580,-590,-600,-610,-620,-630,-640,-650,-660,-670,-680,-690,-700,-710,0,-10,-20,-30,-40,-50,-60,-70,-80,-90,-100,-110,-120,-130,-140,-150,-160,-170,-180,-190,-200,-210,-220,-230,-240,-250,-260,-270,-280,-290,-300,-310,-320,-330,-340,-350,-360,-370,-380,-390,-400,-410,-420,-430,-440,-450,-460,-470,-480,-490,-500,-510,-520,-530,-540,-550,-560,-570,-580,-590,-600,-610,-620,-630,-640,-650,-660,-670,-680,-690,-700,-710,0,-10,-20,-30,-40,-50,-60,-70,-80,-90,-100,-110,-120,-130,-140,-150,-160,-170,-180,-190,-200,-210,-220,-230,-240,-250,-260,-270,-280,-290,-300,-310,-320,-330,-340,-350,-360,-370,-380,-390,-400,-410,-420,-430,-440,-450,-460,-470,-480,-490,-500,-510,-520,-530,-540,-550,-560,-570,-580,-590,-600,-610,-620,-630,-640,-650,-660,-670,-680,-690,-700,-710,-710,-710,-710,-710,-710,-710,-710,-710,-710,-710,-710,-710,-710,-710,-710,-710,-710,-710,-710,-710,-710,-710,-710,-710,-710,-710,-710,-710,-710,-710,-710,-710},
{-45,-44,-43,-42,-41,-40,-39,-38,-37,-36,-37,-38,-39,-40,-41,-42,-43,-44,-45,-44,-43,-42,-41,-40,-39,-38,-37,-36,-37,-38,-39,-40,-41,-42,-43,-44,-45,-44,-43,-42,-41,-40,-39,-38,-37,-36,-37,-38,-39,-40,-41,-42,-43,-44,-45,-44,-43,-42,-41,-40,-39,-38,-37,-36,-37,-38,-39,-40,-41,-42,-43,-44,-45,-44,-43,-42,-41,-40,-39,-38,-37,-36,-37,-38,-39,-40,-41,-42,-43,-44,-45,-44,-43,-42,-41,-40,-39,-38,-37,-36,-37,-38,-39,-40,-41,-42,-43,-44,-45,-44,-43,-42,-41,-40,-39,-38,-37,-36,-37,-38,-39,-40,-41,-42,-43,-44,-45,-44,-43,-42,-41,-40,-39,-38,-37,-36,-37,-38,-39,-40,-41,-42,-43,-44,-45,-44,-43,-42,-41,-40,-39,-38,-37,-36,-37,-38,-39,-40,-41,-42,-43,-44,-45,-44,-43,-42,-41,-40,-39,-38,-37,-36,-37,-38,-39,-40,-41,-42,-43,-44,-45,-44,-43,-42,-41,-40,-39,-38,-37,-36,-37,-38,-39,-40,-41,-42,-43,-44,-45,-44,-43,-42,-41,-40,-39,-38,-37,-36,-37,-38,-39,-40,-41,-42,-43,-44,-44,-44,-44,-44,-44,-44,-44,-44,-44,-44,-44,-44,-44,-44,-44,-44,-44,-44,-44,-44,-44,-44,-44,-44,-44,-44,-44,-44,-44,-44,-44,-44},
{0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2},
{1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618},
{2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603},
{1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692},
{1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692,1.260492692},
{2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603,1.5869603},
{1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618,1.001185618},
{0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,0.01,0.01259,0.01585081,0.01995617,0.025124818,0.031632146,0.039824871,0.050139513,0.063125647,0.079475189,0.100059263,0.125974613,0.158602037,0.199679965,0.251397076,0.316508918,0.398484728,0.501692273,0.631630571,0.795222889,1.001185618,1.260492692,1.5869603,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2},
{0,5,10,15,20,25,30,35,40,45,50,55,60,65,70,75,80,85,90,95,100,105,110,115,120,125,130,135,140,145,150,155,160,165,170,175,180,185,190,195,200,205,210,215,220,225,230,235,240,245,250,255,260,265,270,275,280,285,290,295,300,305,310,315,320,325,330,335,340,345,350,355,0,5,10,15,20,25,30,35,40,45,50,55,60,65,70,75,80,85,90,95,100,105,110,115,120,125,130,135,140,145,150,155,160,165,170,175,180,185,190,195,200,205,210,215,220,225,230,235,240,245,250,255,260,265,270,275,280,285,290,295,300,305,310,315,320,325,330,335,340,345,350,355,0,5,10,15,20,25,30,35,40,45,50,55,60,65,70,75,80,85,90,95,100,105,110,115,120,125,130,135,140,145,150,155,160,165,170,175,180,185,190,195,200,205,210,215,220,225,230,235,240,245,250,255,260,265,270,275,280,285,290,295,300,305,310,315,320,325,330,335,340,345,350,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355},
{-1.5,-1.415,-1.33,-1.245,-1.16,-1.075,-0.99,-0.905,-0.82,-0.735,-0.65,-0.565,-0.48,-0.395,-0.31,-0.225,-0.14,-0.055,0.03,0.115,0.2,0.2,0.2,0.2,0.2,0.2,0.2,0.115,0.03,-0.055,-0.14,-0.225,-0.31,-0.395,-0.48,-0.565,-0.65,-0.735,-0.82,-0.905,-0.99,-1.075,-1.16,-1.245,-1.33,-1.415,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.415,-1.33,-1.245,-1.16,-1.075,-0.99,-0.905,-0.82,-0.735,-0.65,-0.565,-0.48,-0.395,-0.31,-0.225,-0.14,-0.055,0.03,0.115,0.2,0.2,0.2,0.2,0.2,0.2,0.2,0.115,0.03,-0.055,-0.14,-0.225,-0.31,-0.395,-0.48,-0.565,-0.65,-0.735,-0.82,-0.905,-0.99,-1.075,-1.16,-1.245,-1.33,-1.415,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.415,-1.33,-1.245,-1.16,-1.075,-0.99,-0.905,-0.82,-0.735,-0.65,-0.565,-0.48,-0.395,-0.31,-0.225,-0.14,-0.055,0.03,0.115,0.2,0.2,0.2,0.2,0.2,0.2,0.2,0.115,0.03,-0.055,-0.14,-0.225,-0.31,-0.395,-0.48,-0.565,-0.65,-0.735,-0.82,-0.905,-0.99,-1.075,-1.16,-1.245,-1.33,-1.415,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5,-1.5},
{-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20.83333333,41.66666667,62.5,83.33333333,104.1666667,125,145.8333333,166.6666667,187.5,208.3333333,229.1666667,250,270.8333333,291.6666667,312.5,333.3333333,354.1666667,375,395.8333333,416.6666667,437.5,458.3333333,479.1666667,500,520.8333333,541.6666667,562.5,583.3333333,604.1666667,625,645.8333333,666.6666667,687.5,708.3333333,729.1666667,750,770.8333333,791.6666667,812.5,833.3333333,854.1666667,875,895.8333333,916.6666667,937.5,958.3333333,979.1666667,1000,1020.833333,1041.666667,1062.5,1083.333333,1104.166667,1125,1145.833333,1166.666667,1187.5,1208.333333,1229.166667,1250,1270.833333,1291.666667,1312.5,1333.333333,1354.166667,1375,1395.833333,1416.666667,1437.5,1458.333333,1479.166667,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500},
{18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4.347222222,5.694444444,7.041666667,8.388888889,9.736111111,11.08333333,12.43055556,13.77777778,15.125,16.47222222,17.81944444,19.16666667,20.51388889,21.86111111,23.20833333,24.55555556,25.90277778,27.25,28.59722222,29.94444444,31.29166667,32.63888889,33.98611111,35.33333333,36.68055556,38.02777778,39.375,40.72222222,42.06944444,43.41666667,44.76388889,46.11111111,47.45833333,48.80555556,50.15277778,51.5,52.84722222,54.19444444,55.54166667,56.88888889,58.23611111,59.58333333,60.93055556,62.27777778,63.625,64.97222222,66.31944444,67.66666667,69.01388889,70.36111111,71.70833333,73.05555556,74.40277778,75.75,77.09722222,78.44444444,79.79166667,81.13888889,82.48611111,83.83333333,85.18055556,86.52777778,87.875,89.22222222,90.56944444,91.91666667,93.26388889,94.61111111,95.95833333,97.30555556,98.65277778,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100},
{-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-30,-99.02777778,-168.0555556,-237.0833333,-306.1111111,-375.1388889,-444.1666667,-513.1944444,-582.2222222,-651.25,-720.2777778,-789.3055556,-858.3333333,-927.3611111,-996.3888889,-1065.416667,-1134.444444,-1203.472222,-1272.5,-1341.527778,-1410.555556,-1479.583333,-1548.611111,-1617.638889,-1686.666667,-1755.694444,-1824.722222,-1893.75,-1962.777778,-2031.805556,-2100.833333,-2169.861111,-2238.888889,-2307.916667,-2376.944444,-2445.972222,-2515,-2584.027778,-2653.055556,-2722.083333,-2791.111111,-2860.138889,-2929.166667,-2998.194444,-3067.222222,-3136.25,-3205.277778,-3274.305556,-3343.333333,-3412.361111,-3481.388889,-3550.416667,-3619.444444,-3688.472222,-3757.5,-3826.527778,-3895.555556,-3964.583333,-4033.611111,-4102.638889,-4171.666667,-4240.694444,-4309.722222,-4378.75,-4447.777778,-4516.805556,-4585.833333,-4654.861111,-4723.888889,-4792.916667,-4861.944444,-4930.972222,-5000,-5000,-5000,-5000,-5000,-5000,-5000,-5000,-5000,-5000,-5000,-5000,-5000,-5000,-5000,-5000,-5000,-5000,-5000,-5000,-5000,-5000,-5000,-5000,-5000,-5000,-5000,-5000,-5000,-5000,-5000,-5000,-5000},
{-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.069444444,-0.138888889,-0.208333333,-0.277777778,-0.347222222,-0.416666667,-0.486111111,-0.555555556,-0.625,-0.694444444,-0.763888889,-0.833333333,-0.902777778,-0.972222222,-1.041666667,-1.111111111,-1.180555556,-1.25,-1.319444444,-1.388888889,-1.458333333,-1.527777778,-1.597222222,-1.666666667,-1.736111111,-1.805555556,-1.875,-1.944444444,-2.013888889,-2.083333333,-2.152777778,-2.222222222,-2.291666667,-2.361111111,-2.430555556,-2.5,-2.569444444,-2.638888889,-2.708333333,-2.777777778,-2.847222222,-2.916666667,-2.986111111,-3.055555556,-3.125,-3.194444444,-3.263888889,-3.333333333,-3.402777778,-3.472222222,-3.541666667,-3.611111111,-3.680555556,-3.75,-3.819444444,-3.888888889,-3.958333333,-4.027777778,-4.097222222,-4.166666667,-4.236111111,-4.305555556,-4.375,-4.444444444,-4.513888889,-4.583333333,-4.652777778,-4.722222222,-4.791666667,-4.861111111,-4.930555556,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5},
{25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,-18.27777778,-40.55555556,-62.83333333,-85.11111111,-107.3888889,-129.6666667,-151.9444444,-174.2222222,-196.5,-218.7777778,-241.0555556,-263.3333333,-285.6111111,-307.8888889,-330.1666667,-352.4444444,-374.7222222,-397,-419.2777778,-441.5555556,-463.8333333,-486.1111111,-508.3888889,-530.6666667,-552.9444444,-575.2222222,-597.5,-619.7777778,-642.0555556,-664.3333333,-686.6111111,-708.8888889,-731.1666667,-753.4444444,-775.7222222,-798,-820.2777778,-842.5555556,-864.8333333,-887.1111111,-909.3888889,-931.6666667,-953.9444444,-976.2222222,-998.5,-1020.777778,-1043.055556,-1065.333333,-1087.611111,-1109.888889,-1132.166667,-1154.444444,-1176.722222,-1199,-1221.277778,-1243.555556,-1265.833333,-1288.111111,-1310.388889,-1332.666667,-1354.944444,-1377.222222,-1399.5,-1421.777778,-1444.055556,-1466.333333,-1488.611111,-1510.888889,-1533.166667,-1555.444444,-1577.722222,-1600,-1600,-1600,-1600,-1600,-1600,-1600,-1600,-1600,-1600,-1600,-1600,-1600,-1600,-1600,-1600,-1600,-1600,-1600,-1600,-1600,-1600,-1600,-1600,-1600,-1600,-1600,-1600,-1600,-1600,-1600,-1600,-1600},
{5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.930555556,4.861111111,4.791666667,4.722222222,4.652777778,4.583333333,4.513888889,4.444444444,4.375,4.305555556,4.236111111,4.166666667,4.097222222,4.027777778,3.958333333,3.888888889,3.819444444,3.75,3.680555556,3.611111111,3.541666667,3.472222222,3.402777778,3.333333333,3.263888889,3.194444444,3.125,3.055555556,2.986111111,2.916666667,2.847222222,2.777777778,2.708333333,2.638888889,2.569444444,2.5,2.430555556,2.361111111,2.291666667,2.222222222,2.152777778,2.083333333,2.013888889,1.944444444,1.875,1.805555556,1.736111111,1.666666667,1.597222222,1.527777778,1.458333333,1.388888889,1.319444444,1.25,1.180555556,1.111111111,1.041666667,0.972222222,0.902777778,0.833333333,0.763888889,0.694444444,0.625,0.555555556,0.486111111,0.416666667,0.347222222,0.277777778,0.208333333,0.138888889,0.069444444,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}

 }



//BEGIN Main Stuff
#declare mach_width=25;
//camera{location  <-15, 18, -15> direction 1.5*z right 4/3*x look_at <-15, 25,  5>} //looking at the wrapped ball

//camera{location  <5.0, 18, -30> direction 1.5*z right 4/3*x look_at <-15, 18,  5>} //looking at the popperman
camera{location  <5.0, 18, -30> direction 1.5*z right 4/3*x look_at <12, 18,  5>} //looking at the popperman

//camera{location  <0, 3, -30> direction 1.5*z right 4/3*x look_at <0, 4,  5>} //looking at all narrow
//camera{location  <-1500.0, 100, -5000> direction 1.5*z right 4/3*x look_at <-2, -1600,  0.0>} //now looking at the building

//camera{location  <Anim_Path[cam_loc_x][Curr_Frame],Anim_Path[cam_loc_y][Curr_Frame],Anim_Path[cam_loc_z][Curr_Frame]> direction 1.5*z right 4/3*x look_at <Anim_Path[cam_look_x][Curr_Frame],Anim_Path[cam_look_y][Curr_Frame],Anim_Path[cam_look_z][Curr_Frame]>}

light_source{0*x color red 1.0 green 1.0 blue 1.0  translate <-30, 30, -30>}
light_source{0*x color red 1.0 green 1.0 blue 1.0  translate <40, 30, -30>}
light_source{0*x color red 1.0 green 1.0 blue 1.0  translate <-500, 1000, -300>}

union{
 object{gear_1 rotate<0,0,Anim_Path[Gear1Rot_Index][Curr_Frame]> translate<-3,0,0> texture{pigment{White}}}
 object{gear_2 rotate<0,0,Anim_Path[Gear2Rot_Index][Curr_Frame]> translate<4,0,0> texture{pigment{Gray40}}}
 object{gear_2 rotate<0,0,Anim_Path[Gear2Rot_Index][Curr_Frame]> translate<-3,-7,0> texture{pigment{Gray60}}}
 radar(Anim_Path[DishRot_Index][Curr_Frame],Anim_Path[StandRot_Index][Curr_Frame],<3,3,3>,<0,18,5>,texture{Polished_Chrome},texture{pigment{Red}},texture{pigment{White}},texture{Polished_Chrome},texture{pigment{White}})
 
 //head popper
 //popper_1(scale_vec,trans_vec,rot_vec,pop_val,pop_rot_vec,tube_tex)
 popper_1(<3,3,3>,<15,18,5>,<0,0,0>,Anim_Path[Popper_Pop_Index][Curr_Frame],<0,30,0>,texture{Polished_Chrome})                            
 
 //here is my LED array...                           
 sphere{<-14,10,0>,1 texture{T_Ruby_Glass} interior{I_Glass}}
 light_source{0*x color rgb<Anim_Path[Light1_Index][Curr_Frame],Anim_Path[Light1_Index][Curr_Frame],Anim_Path[Light1_Index][Curr_Frame]> translate <-14, 10, -0.5>}
 torus{1.25,0.25 rotate<90,0,0> translate<-14,10,0> texture{box_tex}}
 sphere{<-10,10,0>,1 texture{T_Ruby_Glass} interior{I_Glass}}
 light_source{0*x color rgb<Anim_Path[Light2_Index][Curr_Frame],Anim_Path[Light2_Index][Curr_Frame],Anim_Path[Light2_Index][Curr_Frame]> translate <-10, 10, -0.5>}
 torus{1.25,0.25 rotate<90,0,0> translate<-10,10,0> texture{box_tex}}
 sphere{<-6,10,0>,1 texture{T_Ruby_Glass} interior{I_Glass}}
 light_source{0*x color rgb<Anim_Path[Light3_Index][Curr_Frame],Anim_Path[Light3_Index][Curr_Frame],Anim_Path[Light3_Index][Curr_Frame]> translate <-6, 10, -0.5>}
 torus{1.25,0.25 rotate<90,0,0> translate<-6,10,0> texture{box_tex}}
 sphere{<-2,10,0>,1 texture{T_Ruby_Glass} interior{I_Glass}}
 light_source{0*x color rgb<Anim_Path[Light4_Index][Curr_Frame],Anim_Path[Light4_Index][Curr_Frame],Anim_Path[Light4_Index][Curr_Frame]> translate <-2, 10, -0.5>}
 torus{1.25,0.25 rotate<90,0,0> translate<-2,10,0> texture{box_tex}}
 sphere{<2,10,0>,1 texture{T_Ruby_Glass} interior{I_Glass}}
 light_source{0*x color rgb<Anim_Path[Light5_Index][Curr_Frame],Anim_Path[Light5_Index][Curr_Frame],Anim_Path[Light5_Index][Curr_Frame]> translate <2, 10, -0.5>}
 torus{1.25,0.25 rotate<90,0,0> translate<2,10,0> texture{box_tex}}
 sphere{<6,10,0>,1 texture{T_Ruby_Glass} interior{I_Glass}}
 light_source{0*x color rgb<Anim_Path[Light6_Index][Curr_Frame],Anim_Path[Light6_Index][Curr_Frame],Anim_Path[Light6_Index][Curr_Frame]> translate <6, 10, -0.5>}
 torus{1.25,0.25 rotate<90,0,0> translate<6,10,0> texture{box_tex}}
 sphere{<10,10,0>,1 texture{T_Ruby_Glass} interior{I_Glass}}
 light_source{0*x color rgb<Anim_Path[Light7_Index][Curr_Frame],Anim_Path[Light7_Index][Curr_Frame],Anim_Path[Light7_Index][Curr_Frame]> translate <10, 10, -0.5>}
 torus{1.25,0.25 rotate<90,0,0> translate<10,10,0> texture{box_tex}}
 sphere{<14,10,0>,1 texture{T_Ruby_Glass} interior{I_Glass}}
 light_source{0*x color rgb<Anim_Path[Light8_Index][Curr_Frame],Anim_Path[Light8_Index][Curr_Frame],Anim_Path[Light8_Index][Curr_Frame]> translate <14, 10, -0.5>}
 torus{1.25,0.25 rotate<90,0,0> translate<14,10,0> texture{box_tex}}

 union{
  box{<-mach_width+2,-15,10>,<mach_width-2,15,0>}
  box{<-mach_width,-15,8>,<mach_width,15,2>}
  cylinder{<-mach_width+2,-15,2>,<-mach_width+2,15,2>,2}
  cylinder{<mach_width-2,-15,2>,<mach_width-2,15,2>,2}
  cylinder{<-mach_width+2,-15,8>,<-mach_width+2,15,8>,2}
  cylinder{<mach_width-2,-15,8>,<mach_width-2,15,8>,2}
  texture{box_tex}
 }
 union{
  box{<-mach_width+2,0,11>,<mach_width-2,2,-1>}
  box{<-mach_width-1,0,8>,<mach_width+1,2,2>}
  cylinder{<-mach_width+2,0,2>,<-mach_width+2,2,2>,3}
  cylinder{<mach_width-2,0,2>,<mach_width-2,2,2>,3}
  cylinder{<-mach_width+2,0,8>,<-mach_width+2,2,8>,3}
  cylinder{<mach_width-2,0,8>,<mach_width-2,2,8>,3}
  texture{trim_tex}
  translate<0,13,0>
 }
 
 union{
  box{<-mach_width+2,0,11>,<mach_width-2,2,-1>}
  box{<-mach_width-1,0,8>,<mach_width+1,2,2>}
  cylinder{<-mach_width+2,0,2>,<-mach_width+2,2,2>,3}
  cylinder{<mach_width-2,0,2>,<mach_width-2,2,2>,3}
  cylinder{<-mach_width+2,0,8>,<-mach_width+2,2,8>,3}
  cylinder{<mach_width-2,0,8>,<mach_width-2,2,8>,3}
  texture{trim_tex}
  translate<0,6,0>
 }

 union{
  box{<-mach_width+2,0,11>,<mach_width-2,2,-1>}
  box{<-mach_width-1,0,8>,<mach_width+1,2,2>}
  cylinder{<-mach_width+2,0,2>,<-mach_width+2,2,2>,3}
  cylinder{<mach_width-2,0,2>,<mach_width-2,2,2>,3}
  cylinder{<-mach_width+2,0,8>,<-mach_width+2,2,8>,3}
  cylinder{<mach_width-2,0,8>,<mach_width-2,2,8>,3}
  texture{trim_tex}
  translate<0,-12,0>
 }
 union{
  cylinder{<-9,-10,0>,<-9,6,0>,1}
  cylinder{<9,-10,0>,<9,6,0>,1}
  texture{trim_tex}
 }
 object{dial_1 rotate<90,0,0> texture{Polished_Chrome} rotate<0,Anim_Path[TwistDial_Index][Curr_Frame],0> translate<-15,18,5>}
 box{<-9,-10,-0.75>,<9,6,-1> texture{T_Dark_Green_Glass} interior{I_Glass}}
 box{<-9,-10,0>,<9,6,-0.01> texture{wall_tex}}
 rotate<0,0,0>
 translate<0,0,0> 
}


box{<-150,-15,-150>,<150,-20,150>texture{wall_tex}}
box{<-150,35,-150>,<150,45,150> texture{wall_tex}}
//box{<-150,-20,-150>,<150,45,-150> texture{wall_tex}}
box{<-150,-20,150>,<150,45,150> texture{wall_tex}}
box{<-150,-20,-150>,<-160,45,150> texture{wall_tex}}
box{<150,-20,-150>,<160,45,150> texture{wall_tex}}

object{building_1 scale 400 translate<-300,-3020,0>}
plane{y,-3000 pigment{White}}

//END Main Stuff



#declare Curr_Frame = Curr_Frame+1;
#declare Curr_Frame_Str = concat(str(Curr_Frame,0,0),".0\n")
#fopen FrameFile "c:\animation\machine\framefile.txt" write
#write(FrameFile, Curr_Frame_Str)
#fclose FrameFile
