//
// Include objects for the scene
//

#include "desk.inc"
#include "sketch.inc"
#include "julia.inc"
#include "newtons_cradle.inc"
#include "mug.inc"
#include "mug_mat.inc"
#include "pencil_holder.inc"
#include "room.inc"
#include "desk_lamp.inc"

//
// Set the global settings for the image
//

global_settings
{
        assumed_gamma 2.0
}

global_settings
{
	radiosity
	{
	        count 800
	        error_bound 0.2
	        gray_threshold 0.5
	        distance_maximum 0
	        low_error_factor 0.7
	        nearest_count 9
	        minimum_reuse 0.01
	        brightness 3.3
	        recursion_limit 1
	}
}

//
// Set the background for the scene.
//

background
{
        colour rgb <0, 0, 0>
}

//
// Place the room
//

object
{
        room
        translate <0, -73.5, -80>
}

//
// Place the desk. Put it next to a wall.
//

object
{
        desk
        translate <0, -73.5, 0> // 0,0,72.5
}

//
// Add a lamp to the scene. Twist it slightly to illuminate other
// objects.
//

object
{
        desk_lamp 
        rotate <0, -22, 0>
        translate <25,0, 7>
}

//
// Show the subject of the sketch
//

object
{
        julia
        rotate <0, -14, 0>
        translate <-40, 16.541, 10>
}

//
// Now put the scetch on the desk, on top of a blank piece
// of paper.
//

object
{
        julia_sketch
        rotate <0, -20, 0>
        translate <-50, 0.021, -10>
}

object
{
        blank_sketch
        rotate <0, -2, 0>
        translate <-55, 0, -5>
}

//
// Add an 'executive toy'...
//

object
{
        newtons_cradle
        rotate <0, 0, 0>
        translate <-12, 0, -7>
}

//
// ... and a mug and a mat.
//

object
{
        mug
        rotate <0, 65, 0> // 0,13,0
        translate <25 + 0.3, 0.3, -6 + 0.2>
}

object
{
        mug_mat
        translate <25, 0, -6>
}

//
// Add a pencil holder and some pencils.
//

object
{
        pencils_holder_with_pencils
        rotate <0, 0, 0>
        translate <-20, 0, -9>
}

//
// Everything is now placed in the scene, so its time to set up some
// cameras and lights.
//

//
// Full scene.
//

camera
{
        location <0, 30, -65>

        #if (clock < 0.5)  
                #declare new_angle = -90 + (360 * clock);                
        #else   
                #declare new_angle = 90 + (360 * (0.5 - clock));
        #end

        #declare new_rotate = sin (radians (new_angle)) * 30;

        rotate <0, new_rotate, 0>
        
        look_at <0, 6.5, 0>
        angle 35

	focal_point <0, 6.5, 0>
	aperture 1.5
	blur_samples 20
}

light_source
{
        <0, 100, 0>
        colour rgb <0.6, 0.6, 0.6>
        shadowless
}
