//Welcome to my code!!!
//It's kind of messy, since I'm pretty new to animation. In particular, I used lots of variables 
//(#declares) while I was playing around with things and then just left them that way, even though there's
//really no reason to leave them as variables. Sorry. Anyway, if you have any questions, email me at
// reuven53@aol.com
//Enjoy!

#include "colors.inc"
#include "metals.inc"

light_source
{<200, 800, -600>
 color rgb <1.2,1.2,1.2>

 area_light <50,0,0>,<0,50,0>,10,10
 adaptive 1

 spotlight
 point_at <0,.4,.9>
 radius .01
 falloff .13
 tightness 20
}

#declare v0 = 4.5                   //Initial Velocity
#declare TIME = v0/4.9              //Air time, based on v = v0 + at
#declare INTUBE = .175*pi/4.5       //Time spent in the tube
#declare CYCLE = 2*TIME + 2*INTUBE  //Time for a full cycle

//Tossing and catching locations
#declare TOSS1 = .25
#declare TOSS2 = -.25
#declare CATCH1 = .6
#declare CATCH2 = -.6

#declare RAD = .045                      //Radius of balls
//clock variable goes from 0->5, and the next line translate it into the appropriate 
//numbers for the physics modeling
#declare CLOCK = clock * CYCLE
#declare CLOCK1 = mod (CLOCK, CYCLE)    //Juggling clock

#include "balls.inc"
#include "machine.inc"
#include "setting.inc"
#include "logo.inc"

background {Black}


/***
CAMERA CHANGES:
0-1 - moving with a ball, looking one step ahead
1-2 - moving towards center, still looking at one ball
2-3 - centered camera, looking at one ball
3-4 - centered camera, centering view
4-5 - centered camera, centered view
***/

#if (clock<1)
camera
{location CAMERALOC
 look_at CAMERALOOK
 //The following contortions make sure that the camera doesn't do a sharp 
 //snap to turn around when it hits the tubes. It eases the transition.
 #if (vdot(CAMERALOOK-CAMERALOC,y)<0)  //going down
 #if (vdot(CAMERALOC,x)<0)             //on the left
    #if (vdot(CAMERALOOK-CAMERALOC,x)<0)  //going left
     translate -CAMERALOC
     rotate z* degrees(asin(abs(vdot(CAMERALOOK-CAMERALOC,x))/vlength(CAMERALOOK-CAMERALOC)))
     rotate y* 180*(1.033163-vdot(CAMERALOC,y))/1.033163
     rotate z*-degrees(asin(abs(vdot(CAMERALOOK-CAMERALOC,x))/vlength(CAMERALOOK-CAMERALOC)))
     translate  CAMERALOC
    #end
 #else                                 //on the right
    #if (vdot(CAMERALOOK-CAMERALOC,x)>0)  //going right
     translate -CAMERALOC
     rotate z*-degrees(asin(abs(vdot(CAMERALOOK-CAMERALOC,x))/vlength(CAMERALOOK-CAMERALOC)))
     rotate y* 180*(1.033163-vdot(CAMERALOC,y))/1.033163
     rotate z* degrees(asin(abs(vdot(CAMERALOOK-CAMERALOC,x))/vlength(CAMERALOOK-CAMERALOC)))
     translate  CAMERALOC
    #end
 #end
 #end
}
#else
#if (clock <2)          //Follow ball and centering camera
#declare PART = clock - 1
#declare PART = PART*PART
camera
{location (1-PART)*CAMERALOC + (PART)*<0, 0.45, -1.5>
 look_at CAMERALOOK2
}
#else
#if (clock<3)           //Follow ball with still camera
#declare PART = clock - 2
camera
{location <0, 0.45, -1.5>
 look_at CAMERALOOK2
}
#else
#if (clock<4)           //Centering view, still camera
#declare PART = clock - 3
camera
{location <0, 0.45, -1.5>
 look_at (1-PART)*CAMERALOOK2 + (PART)*<0, 0.45, 0>
}
#else                   //Steady camera
camera
{location <0, 0.45, -1.5>
 look_at <0, 0.45, 0>
}
#end
#end
#end
#end

