//This file contains the logo in the center of the machine. REW stands for Reuven Eliezer Weiser,
//my name. 

#declare AMB = .4
#declare DIF = .5
#declare PHO = .3
#declare PHS =  6
#declare CRN =.02

#declare RTEX = texture
{pigment {color rgb <.2, .2, .6>}
 finish
 {ambient AMB
  diffuse DIF
  phong PHO
  phong_size PHS
  crand CRN
 }
}
#declare ETEX = texture
{pigment {color rgb <.2, .6, .2>}
 finish
 {ambient AMB-.05
  diffuse DIF
  phong PHO
  phong_size PHS
  crand CRN
 }
}

#declare WTEX = texture
{pigment {color rgb <.6, .2, .6>}
 finish
 {ambient AMB-.1
  diffuse DIF
  phong PHO
  phong_size PHS
  crand CRN
 }
}

#declare THICKNESS = 1

#declare R = text
{ttf "coprgtb.ttf",
 "R",
 THICKNESS, 0
 texture {RTEX}
}

#declare E = text
{ttf "coprgtb.ttf",
 "E",
 THICKNESS, 0
 texture {ETEX}
 scale <1,.99999,.999>
 translate <.37,0,.000001>
}

#declare W = text
{ttf "coprgtb.ttf",
 "W",
 THICKNESS, 0
 texture {WTEX}
 scale <1,.99998,.99>
 translate <.605,0,.00001>
}

#declare REW = merge
{object {R}
 object {E}
 object {W}
 translate <-1.76/2,-.34,-THICKNESS/2>
 scale .2
 translate <0,.1,.175>
}
object {REW}
