#include "colors.inc"
/*background { color rgb .25}
camera { location <50,25,-50>/15
direction 2*z    
look_at <0,0,0>} 
#declare Light = off
light_source { <-2000, 5000, -2500> 
color rgb 1.75
area_light <0,1600,0>, <1600,0,0>,3,3
adaptive 1
spotlight
point_at <0,0,0>
radius 50000
falloff 75000
}*/

#declare RBox2 =
superellipsoid {
<.25, .25>
translate <1,1,1>
scale .5
}
#macro SmoothSeed(Array,Freq)
  #declare Array[0]= Freq;
  #declare Array[1]= seed(floor(clock*(Freq)));
  #declare Array[2]= seed(floor(clock*(Freq)+1));
  #declare Array[3]= seed(floor(clock*(Freq)+2));
#end
#macro SmoothRand(Array)
  #local t_T=clock*Array[0]-floor(clock*Array[0]);
  ( rand(Array[1])*(t_T-1)*(t_T-1)*.5
  + rand(Array[2])*(.5+t_T-t_T*t_T)
  + rand(Array[3])*t_T*t_T*.5 )
#end

#declare MyArray=array[1001]
#declare A1=array[1111]
#declare A2=array[2222]
#declare A3=array[3333]
#declare A4=array[4444]
#declare A5=array[5555]
#declare A6=array[6666]

#declare EngineC =
// Object type: World
// Name: Root
union 
{
   object {
   
   union
   {
      // Object type: Sphere
      // Name: NoName
      object
      {
         sphere { < 0, 0, 0 >, 1 }

         scale < 3, 3, 6 >
         translate < 0, 0, -30 >
      }
      #declare C = 0;
      #while (C < 360)
      // Object type: Cone
      // Name: 360 fan
      object
      {
         cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.675}

         scale < 3, 12.5, 0.5 >
         rotate < 180, 45, 0 >
         pigment {spherical color_map {[0 rgb .75][1 rgb .25]} scale 26 translate -14*y}
         finish {ambient .25 diffuse .5}
         translate < 0, 14, -30 >
         rotate C*z
         rotate 80*z*clock
         
      }
      #declare C = C + 20
      #end
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

         scale < 12, 60, 12 >
         rotate < 90, 0, 0 >
         translate < 0, 2.974e-23, -22 >
      }
      // Object type: Union
      // Name: 'or'
      object
      {
         merge
         {
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

               scale < 13.5, 25, 13.5 >
               rotate < 90, 0, 0 >
               translate < 0, 0, 16 >
            }
            // Object type: Torus
            // Name: NoName
            object
            {
               torus { 14, 1 }

               scale < 0.9, 1, 0.9 >
               rotate < -90, 0, 0 >
               translate < 0, 0, 16 >
            }
            // Object type: Torus
            // Name: NoName
            object
            {
               torus { 14, 1 }

               scale < 0.9, 1, 0.9 >
               rotate < -90, 0, 0 >
               translate < 0, 0, 41 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

               scale < 11.7, 25, 11.7 >
               rotate < 90, 0, 0 >
               translate < 0, 0, 16 >
            }
         }
      }
      
      
      
      // Object type: Difference
      // Name: 'and not'
      object
      {
         difference
         {
            // Object type: Union
            // Name: 'or'
            object
            {
               merge
               {
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

                     scale < 15, 25, 15 >
                     rotate < 90, 0, 0 >
                     translate < 0, 0, -32 >
                  }
                  // Object type: Torus
                  // Name: NoName
                  object
                  {
                     torus { 14, 1 }

                     rotate < -90, 0, 0 >
                     translate < 0, 0, -32 >
                  }
                  // Object type: Torus
                  // Name: NoName
                  object
                  {
                     torus { 14, 1 }

                     rotate < -90, 0, 0 >
                     translate < 0, 0, -7 >
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

                     scale < 13, 25, 13 >
                     rotate < 90, 0, 0 >
                     translate < 0, 0, -32 >
                  }
               }
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

               scale < 5, 8, 5 >
               translate < 0, 9.5, -7 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

               scale < 5, 32, 5 >
               rotate < 0, 0, 90 >
               translate < 16, -6.9509e-22, -7 >
            }
         }
      } 
      
sphere_sweep{
linear_sphere_sweep,
4,
<0,12,-8>,2
<0,14,-8>,2
<0,14,10>,2
<0,12,10>,2
pigment {rgb .75}
finish {ambient .25 diffuse .75}
}
sphere_sweep{
linear_sphere_sweep,
4,
<0,-12,-8>,2
<0,-14,-8>,2
<0,-14,10>,2
<0,-12,10>,2
pigment {rgb .75}              
finish {ambient .25 diffuse .75}
}


#declare C = 0;
#while (C < 45)
sphere_sweep{
linear_sphere_sweep,
5,
<0,12,24>,.5
<0,14,24>,.5
<0,14,44>,.5
<0,10,44>,.5
<0,10,24>,.5
pigment {rgb .5}
finish {ambient .25 diffuse .75}
rotate C*z    
rotate 45*z
}
sphere_sweep{
linear_sphere_sweep,
5,
<0,12,24>,.5
<0,14,24>,.5
<0,14,44>,.5
<0,10,44>,.5
<0,10,24>,.5

pigment {rgb .5}
finish {ambient .25 diffuse .75}
rotate C*z    
rotate -75*z
}
sphere_sweep{
linear_sphere_sweep,
5,
<0,12,24>,.5
<0,14,24>,.5
<0,14,44>,.5
<0,10,44>,.5
<0,10,24>,.5

pigment {rgb .5}
finish {ambient .25 diffuse .75}
rotate C*z    
rotate 45*z
scale <1,-1,1>
}
sphere_sweep{
linear_sphere_sweep,
5,
<0,12,24>,.5
<0,14,24>,.5
<0,14,44>,.5
<0,10,44>,.5
<0,10,24>,.5

pigment {rgb .5}
finish {ambient .25 diffuse .75}
rotate C*z    
rotate -75*z 
scale <1,-1,1>
}
#declare C = C + 15;
#end



sphere_sweep{
linear_sphere_sweep,
4,
<-12,0,-8>,2
<-14,0,-8>,2
<-14,0,7>,2
<-12,0,7>,2
pigment {rgb 1} 
finish {ambient .25 diffuse .75}
}

      
      
      
      union {
      // Object type: Composite
      // Name: group #1
      object
      {
         union
         {
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Union
                  // Name: 'or'
                  object
                  {
                     merge
                     {
                        // Object type: Torus
                        // Name: NoName
                        object
                        {
                           torus { 30, 10 }

                           scale < 0.12, 0.12, 0.12 >
                           rotate < -90, 0, 180 >
                           translate < -7, -7.3435e-07, 45.4 >
                        }
                        // Object type: Torus
                        // Name: NoName
                        object
                        {
                           torus { 30, 10 }

                           scale < 0.12, 0.12, 0.12 >
                           rotate < -90, 0, 180 >
                           translate < -6.9682, -1.0838e-07, 38.208 >
                        }
                        // Object type: Torus
                        // Name: NoName
                        object
                        {
                           torus { 30, 10 }

                           scale < 0.12, 0.12, 0.12 >
                           rotate < -90, 0, 180 >
                           translate < -7, -2.6227e-07, 40 >
                        }
                        // Object type: Torus
                        // Name: NoName
                        object
                        {
                           torus { 30, 10 }

                           scale < 0.12, 0.12, 0.12 >
                           rotate < -90, 0, 180 >
                           translate < -7, -4.1963e-07, 41.8 >
                        }
                        // Object type: Torus
                        // Name: NoName
                        object
                        {
                           torus { 30, 10 }

                           scale < 0.12, 0.12, 0.12 >
                           rotate < -90, 0, 180 >
                           translate < -7, -5.7699e-07, 43.6 >
                        }
                     }
                  }
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 2.4, 11.658, 17.628 >
                     rotate < 180, 0, 180 >
                     translate < -5.8, -6, 50.2 >
                  }
               }
            }
            // Object type: Torus
            // Name: NoName
            object
            {
               torus { 30, 5 }

               scale < 0.12041, 2.162, 0.12041 >
               rotate < -90, 0, 180 >
               translate < -7, 0, 37 >
            }
         }
      }
      // Object type: Composite
      // Name: group #1
      object
      {
         union
         {
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Union
                  // Name: 'or'
                  object
                  {
                     merge
                     {
                        // Object type: Torus
                        // Name: NoName
                        object
                        {
                           torus { 30, 10 }

                           scale < 0.12, 0.12, 0.12 >
                           rotate < -90, 0, 180 >
                           translate < 7, -7.3435e-07, 45.4 >
                        }
                        // Object type: Torus
                        // Name: NoName
                        object
                        {
                           torus { 30, 10 }

                           scale < 0.12, 0.12, 0.12 >
                           rotate < -90, 0, 180 >
                           translate < 7.0318, -1.0838e-07, 38.208 >
                        }
                        // Object type: Torus
                        // Name: NoName
                        object
                        {
                           torus { 30, 10 }

                           scale < 0.12, 0.12, 0.12 >
                           rotate < -90, 0, 180 >
                           translate < 7, -2.6227e-07, 40 >
                        }
                        // Object type: Torus
                        // Name: NoName
                        object
                        {
                           torus { 30, 10 }

                           scale < 0.12, 0.12, 0.12 >
                           rotate < -90, 0, 180 >
                           translate < 7, -4.1963e-07, 41.8 >
                        }
                        // Object type: Torus
                        // Name: NoName
                        object
                        {
                           torus { 30, 10 }

                           scale < 0.12, 0.12, 0.12 >
                           rotate < -90, 0, 180 >
                           translate < 7, -5.7699e-07, 43.6 >
                        }
                     }
                  }
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 2.4, 11.658, 17.628 >
                     rotate < 180, 0, 180 >
                     translate < 8.2, -6, 50.2 >
                  }
               }
            }
            // Object type: Torus
            // Name: NoName
            object
            {
               torus { 30, 5 }

               scale < 0.12041, 2.162, 0.12041 >
               rotate < -90, 0, 180 >
               translate < 7, 0, 37 >
            }
         }
      }
      // Object type: Composite
      // Name: group #1
      object
      {
         union
         {
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Union
                  // Name: 'or'
                  object
                  {
                     merge
                     {
                        // Object type: Torus
                        // Name: NoName
                        object
                        {
                           torus { 30, 10 }

                           scale < 0.12, 0.12, 0.12 >
                           rotate < -90, 0, 180 >
                           translate < -6.2172e-14, -7, 45.4 >
                        }
                        // Object type: Torus
                        // Name: NoName
                        object
                        {
                           torus { 30, 10 }

                           scale < 0.12, 0.12, 0.12 >
                           rotate < -90, 0, 180 >
                           translate < 0.0318, -7, 38.208 >
                        }
                        // Object type: Torus
                        // Name: NoName
                        object
                        {
                           torus { 30, 10 }

                           scale < 0.12, 0.12, 0.12 >
                           rotate < -90, 0, 180 >
                           translate < -2.3093e-14, -7, 40 >
                        }
                        // Object type: Torus
                        // Name: NoName
                        object
                        {
                           torus { 30, 10 }

                           scale < 0.12, 0.12, 0.12 >
                           rotate < -90, 0, 180 >
                           translate < -3.7303e-14, -7, 41.8 >
                        }
                        // Object type: Torus
                        // Name: NoName
                        object
                        {
                           torus { 30, 10 }

                           scale < 0.12, 0.12, 0.12 >
                           rotate < -90, 0, 180 >
                           translate < -1.0729e-08, -7, 43.6 >
                        }
                     }
                  }
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 2.4, 11.658, 17.628 >
                     rotate < 180, 0, 180 >
                     translate < 1.2, -13, 50.2 >
                  }
               }
            }
            // Object type: Torus
            // Name: NoName
            object
            {
               torus { 30, 5 }

               scale < 0.12041, 2.162, 0.12041 >
               rotate < -90, 0, 180 >
               translate < 0, -7, 37 >
            }
         }
      }
      // Object type: Composite
      // Name: group #1
      object
      {
         union
         {
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Union
                  // Name: 'or'
                  object
                  {
                     merge
                     {
                        // Object type: Torus
                        // Name: NoName
                        object
                        {
                           torus { 30, 10 }

                           scale < 0.12, 0.12, 0.12 >
                           rotate < -90, 0, 180 >
                           translate < -6.2172e-14, 7, 45.4 >
                        }
                        // Object type: Torus
                        // Name: NoName
                        object
                        {
                           torus { 30, 10 }

                           scale < 0.12, 0.12, 0.12 >
                           rotate < -90, 0, 180 >
                           translate < 0.0318, 7, 38.208 >
                        }
                        // Object type: Torus
                        // Name: NoName
                        object
                        {
                           torus { 30, 10 }

                           scale < 0.12, 0.12, 0.12 >
                           rotate < -90, 0, 180 >
                           translate < -2.3093e-14, 7, 40 >
                        }
                        // Object type: Torus
                        // Name: NoName
                        object
                        {
                           torus { 30, 10 }

                           scale < 0.12, 0.12, 0.12 >
                           rotate < -90, 0, 180 >
                           translate < -3.7303e-14, 7, 41.8 >
                        }
                        // Object type: Torus
                        // Name: NoName
                        object
                        {
                           torus { 30, 10 }

                           scale < 0.12, 0.12, 0.12 >
                           rotate < -90, 0, 180 >
                           translate < -1.0729e-08, 7, 43.6 >
                        }
                     }
                  }
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 2.4, 11.658, 17.628 >
                     rotate < 180, 0, 180 >
                     translate < 1.2, 1, 50.2 >
                  }
               }
            }
            // Object type: Torus
            // Name: NoName
            object
            {
               torus { 30, 5 }

               scale < 0.12041, 2.162, 0.12041 >
               rotate < -90, 0, 180 >
               translate < 0, 7, 37 >
            }
         }
         
         }
         pigment {rgb .25}
      }
scale .5
}
}     
union {
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 1.75, 3.5, 7.25 >
         translate < 5.25, -1.75, -4.75 >
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

         scale < 1.5, 0.25, 1.5 >
         rotate < 0, 0, 90 >
         translate < 7.25, -3.3626e-22, -2 >
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 }

         scale < 1.25, 0.25, 1.25 >
         rotate < 0, 0, 90 >
         translate < 7.5, 4.6324e-23, -2 >
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 }

         scale < 0.25, 0.5, 0.25 >
         rotate < 0, 0, 90 >
         translate < 8, 7.0569e-23, -2 >
      }
      // Object type: Torus
      // Name: NoName
      object
      {
         torus { 1, 0.125 }

         rotate < 0, 0, -90 >
         translate < 7.5, 0, -2 >
      }
      // Object type: Torus
      // Name: NoName
      object
      {
         torus { 0.5, 0.125 }

         rotate < 0, 0, -90 >
         translate < 7.5, 0, -2 >
      }
      // Object type: Torus
      // Name: NoName
      object
      {
         torus { 0.75, 0.125 }

         rotate < 0, 0, -90 >
         translate < 7.5, 0, -2 >
      }
      pigment {rgb <.5,.5,.6>}
      finish {ambient .25 diffuse .75}
      }
pigment {image_map {png "as03a"} scale <40,16,1> rotate -90*y translate <0,-8,-18> }
normal {bump_map {png "as03b"} scale <40,16,1> rotate -90*y translate <0,-8,-18> bump_size 1}
finish {ambient .25 diffuse .75 crand .05}
scale 1.25
}





SmoothSeed(A2,25) 
#declare SRandPosA = <-5*SmoothRand(A2)+2.5,0,0> 
SmoothSeed(A3,25) 
#declare SRandPosA = SRandPosA+<0,-5*SmoothRand(A3)+2.5,0> 


SmoothSeed(A4,25)
#declare SRandPosB = <5*SmoothRand(A4)-2.5,0,0> 
SmoothSeed(A5,25)   
#declare SRandPosB = SRandPosB+<0,5*SmoothRand(A5)-2.5,0>

 
#declare ELocA = <-20,0,0>+SRandPosA
#declare ELocB = <20,0,0>+SRandPosB 

#declare LLocA = ELocA+<8,0,-2>*1.25
#declare LLocB = ELocB+<-8,0,-2>*1.25

#declare PA = (ELocA-ELocB);
#declare LLX = degrees(atan2(vlength(PA*<1, 0, 1>),PA.y+.001));
#declare LLY = degrees(atan2(PA.x,PA.z+.001));



#declare AS03 =
union {                                    
union {EngineC translate ELocA}
union {EngineC scale <-1,1,1> translate ELocB}                                    

#declare TF_Screen = object {
  difference {
    object {cone {<0,0,1.036>, 0.7, <0,0,1.2>, 0.3}}
    object {cone {<0,0,1.036>, 0.69, <0,0,1.19>, 0.29}}
  }
pigment {rgb 0}
}

#declare TF_ScreenFrame = object {
  union {
    object {torus {0.7,0.015} rotate <90,0,0> translate <0,0,1.036>}
    object {torus {0.3,0.015} rotate <90,0,0> translate <0,0,1.2>}
    #declare Count = 0
    #while (Count < 360)
    object {
      cylinder {<0,0.7,1.036>, <0,0.3,1.2>, 0.015}
      rotate <0,0,Count>
    }
    #declare Count = Count + (360/8)
    #end
  }

}

#declare Cannon = object {
  union {
    object {cylinder {<0,0,0>, <0,0,0.4>, 0.05}}
    object {cylinder {<0,0,0>, <0,0,0.5>, 0.04}}
    object {
      difference {
        object {cylinder {<0,0,0>, <0,0,0.65>, 0.035}}
        object {cylinder {<0,0,0.5>, <0,0,0.66>, 0.03}}
      }
    }
  }
}

#declare TF_Cockpit = object {
  union {
    object { //Main cockpit shape
      difference {
        object {sphere {<0,0,0>, 1.25}}
        object {sphere {<0,0,0>, 1.15}}
        object {cylinder {<0,0,0>, <0,0,2>, 0.7}}
        object {plane {<0,-1,0>, -1}} //Top cut-off for exit hatch
        object {cylinder {<0,0,-0.81>, <0,0,-1.4>, 0.55} texture {pigment {colour rgb 0.15}}}
        object {cylinder {<-0.25, -1, 0.5>, <-0.25, -1, 1>, 0.075}}
        object {cylinder {<0.25, -1, 0.5>, <0.25, -1, 1>, 0.075}}
        object { // Cutaways for laser cannon mounting
          intersection {
            object {
              union {
                object {cylinder {<-0.25, 0, 0.5>, <-0.25, 0, 1>, 0.075}}
                object {cylinder {<0.25, 0, 0.5>, <0.25, 0, 1>, 0.075}}
              }
            }
            object {plane {<0,1,0>, 0}}
          }
          scale <1,3,1>
          translate <0,-1,0>
        }
      }
      
    }
    object {Cannon translate <-0.25,-1.025,0.5> scale <1,1,1>}
    object {Cannon translate <-0.25,-1.025,0.5> scale <-1,1,1>}
    object { // Rear end
      difference {
        object {cone {<0,0,-0.8>, 0.85, <0,0,-1.3>, 0.6}}
        object {cylinder {<0,0,-1.15>, <0,0,-1.4>, 0.5} texture {pigment {colour rgb 0.15}}}
      }
    }
    object { //Detail on top of rear end
      union {
        object {cylinder {<0,0.85,-0.8>, <0,0.6,-1.3>, 0.01} rotate <0,0,-15>}
        object {cylinder {<0,0.85,-0.8>, <0,0.6,-1.3>, 0.01} rotate <0,0,-25>}
        object {cylinder {<0,0.85,-0.8>, <0,0.6,-1.3>, 0.01} rotate <0,0,-35>}
        object {cylinder {<0,0.85,-0.8>, <0,0.6,-1.3>, 0.01} rotate <0,0,-45>}
        object {cylinder {<0,0.85,-0.8>, <0,0.6,-1.3>, 0.01} rotate <0,0,15>}
        object {cylinder {<0,0.85,-0.8>, <0,0.6,-1.3>, 0.01} rotate <0,0,25>}
        object {cylinder {<0,0.85,-0.8>, <0,0.6,-1.3>, 0.01} rotate <0,0,35>}
        object {cylinder {<0,0.85,-0.8>, <0,0.6,-1.3>, 0.01} rotate <0,0,45>}
      }
      texture {pigment {colour rgb 0.25}}
    }
    object {
      difference {
        object {
          union {
            object {cylinder {<0,0,-1>, <0,0,-1.3>, 0.3}}
            #declare Count = 0
            #while (Count < 360)
            object {
              box {<-0.025,-0.6,-1.3>, <0.025, 0.6, -1>}
               rotate <0,0,Count>
            }
            #declare Count = Count + 30
            #end
          }
        }
        object {cylinder {<0,0,-1.15>, <0,0,-2>, 0.15} texture {pigment {colour rgb 0.15}}}
      }
    }
    object {
      intersection {
        object {box {<-1.2, -0.15, -1.1>, <1.2, 0.15, 0>}}
        object {sphere {<0,0,0>, 1.4}}
      }
      texture {pigment {colour rgb 0.15}}
    }
    object {
      difference {
        object {sphere {<0,0.01,0>, 1.225}}
        object {plane {<0,1,0>, 1.025}}
      }
    }
    object {
      difference {
        object {sphere {<0,0.01,0>, 1.25}}
        object {plane {<0,1,0>, 1.025}}
        object {box {<-0.4, 1.1, -2>, <-0.2, 1.5, 0.2>}}
        object {box {<0.4, 1.1, -2>, <0.2, 1.5, 0.2>}}
        object {box {<-0.9, 1.1, -2>, <-0.45, 1.5, 0>}}
        object {box {<0.9, 1.1, -2>, <0.45, 1.5, 0>}}
      }
      
    }
    object {
      cylinder {<0,1,0>, <0,1.025,0>, 0.75}
      texture {
        pigment {colour rgb 0.15}
      }
    }
    object {
      intersection {
        object {sphere {<0,0,0>, 1.35} scale <1.1, 0.75, 0.75>}
        object {cylinder {<-5,0,0>, <5,0,0>, 0.4}}
        object {sphere {<0,0,0>, 1.15} inverse}

      }
      
    }
    object {TF_Screen}
    object {TF_ScreenFrame}
  }
  pigment {rgb .5}
} 


union {TF_Cockpit scale 5 translate <0,21,65>}



sphere_sweep {
catmull_rom_spline_sphere_sweep, 
4,
<3,5,42>+ELocA, .5
//Start
<0,8,15>+ELocA, .5
//End
<-2.5,19,63.25>, .5

<8.5,10,65>+ELocA, .5
texture {
pigment {
color rgb .25
}
finish {
diffuse .5
specular .5 roughness .001
}
}
}
sphere_sweep {
catmull_rom_spline_sphere_sweep,4,
<-3,5,42>+ELocB, .5
//Start
<0,8,15>+ELocB, .5
//End
<2.5,19,63.25>, .5 

<-8.5,10,65>+ELocB, .5
texture {
pigment {
color rgb .25
}
finish {
diffuse .5
specular .5 roughness .001
}
}
} 

#declare LPos = <0,19,61>/33
#if (Light = on)
light_source { LPos
color rgb 1.5   
spotlight
point_at LPos+<0,0,-10>
radius 30
falloff 50
fade_distance 50
fade_power 2 
scale 33
}               
#end






#macro Lightning(LRand,LL)
cylinder{0,1*y,1
pigment {Clear}
hollow
interior {
media {
emission <.5,.25,1>/1.5*33
intervals 50
samples 1,15
confidence 0.9999
variance 1/2560
density {
cylindrical
color_map {
[0 rgb 0]  
[.75 rgb .25]
}
}
}
media {
emission <.5,.25,1>/1.5*33
intervals 50
samples 1,15
confidence 0.9999
variance 1/2560
density {
cylindrical
color_map {
[0 rgb 0]  
[.5 rgb 0]
[.75 rgb 3]
}
}
density {
marble
color_map {
[.925 rgb 0]  
[.95 rgb 6]
}
translate -1
translate LRand/4*y
translate (400*clock)*y
rotate LRand*y
scale <1,.25,1>
turbulence .5
}
}
}
scale <3,LL,3> 
hollow on
no_shadow
}
#local S = seed(clock)
light_source {<0,LL/2,0> rgb (<.5,.25,1>) fade_distance 1*(rand(S)*1)+.25 fade_power 2 }
#end 

union {
Lightning(20,vlength(LLocA-LLocB))
rotate <LLX,LLY,0>
translate LLocB
}
scale 1/33 
hollow on
} 
//union {AS03}