// this include file places the robot Boxer in the scene

#ifndef(LaserAimed) #local LaserAimed=true; #end

#ifndef(DoorOpen)
  #local DoorOpen=0;
#else
  #declare DoorOpen=min(max(DoorOpen,0),1);
#end

#ifndef(LaserUp)
  #local LaserUp=0;
#else
  #declare LaserUp=min(max(LaserUp,0),1);
#end

#ifndef(LaserOn)
  #local LaserOn=0;
#end

#include "boxer_l.inc"

#macro SeeBit(Field,Bit)
  #local tF=floor(Field/Bit);
  (tF-2*floor(tF/2))
#end

#local A=1;
#local C=5.5-A;
#local D=1;

#local qA=1;
#local qB=A*A + D*D - C*C;
#local qC=A*A*D*D;

#local qP=-qB/2/qA+sqrt(qB*qB-4*qA*qC)/2/qA;
#local qM=-qB/2/qA-sqrt(qB*qB-4*qA*qC)/2/qA;

#local B=sqrt(max(qP,qM));

#local tX=(B*B*C)/(A*A+B*B);

#local CutOut=merge {
  intersection {
    quadric { <0,1,-1>,<0,0,0>,<0,0,0>,D*D }
    box { <-2.1,-B,0>,<2.1,B,tX> } }
  cylinder { -x*2.1,x*2.1,1 scale <1,B,A> translate  z*C }
  scale <1,sqrt(1/3),1> }

#local Logo=array[14] { "P","O","V","T","I","R","E","C","O","M","P","A","N","Y" }

#local Rots=array[14] {
  0,4.5,10,18.5,23.5,25.5,30.5,
  39.5,45,51,57,60.5,66,70.5 }

#local CamDirL=vnormalize(BoxerEyeL-<-10,60,26.25>);
#local CamDirR=vnormalize(BoxerEyeR-< 10,60,26.25>);

#macro CrossBar(pA,pB)
  cylinder { pA-x*.125,pA+x*.125,.5 }
  cylinder { pB-x*.125,pB+x*.125,.5 }
  #local vz=vnormalize(pB-pA);
  #local vx=x;
  #local vy=vnormalize(vcross(vz,vx));
  box { <-.125,-.5,0>,<.125,.5,vlength(pA-pB)> Matrix(vx,vy,vz,pA) }
#end

union { // overall union for Boxer

#local sS=7+(sqrt(19)-7)*LaserUp;
#local sD=sqrt(49.25-sS*sS);

#local pL=<0,57+6*sD,-4>;

#ifndef(Target)
  #declare Target=pL+z*100;
#end

#if(LaserAimed=0)
#declare Target=vm_invert(Target,BoxerX,BoxerY,BoxerZ,BoxerL);
#end

#if(LaserOn) cylinder { pL,Target,1 hollow material { Laser } } #end

#local vZ=vnormalize(Target-pL);
#local vX=vnormalize(vcross(y,vZ));
#local vY=vnormalize(vcross(vZ,vX));

  union { // the laser
#local s2=sqrt(2)-1;
    intersection {
      lathe { 4, <0,-7>,<2.25,-4.75>,<2.25,4.75>,<0,7> transform FlipYZ }
      box { <-2,-2,-6>,<2,2,6> }
      box { <-2,-2,-5.25>,<2,2,5.25> rotate z*45 }
      material { Ruby }
    }
    union {
#local I=0; #while (I<8)
      cylinder { <-2.125,-2.125*s2, 3>,<-2.125,2.125*s2, 3>,.125 rotate z*45*I }
      cylinder { <-2.125,-2.125*s2,-3>,<-2.125,2.125*s2,-3>,.125 rotate z*45*I }
      sphere { <-2.125,-2.125*s2, 3>,.125 rotate z*45*I }
      sphere { <-2.125,-2.125*s2,-3>,.125 rotate z*45*I }
#local I=I+1; #end
#local I=0; #while (I<4)
      intersection {
        torus { 1.5,.125 }
        box { <0,-.125,0>,<1.625,.125,1.625> }
        translate < 2.125,0,1.5> rotate z*(I*90+45) }
      cylinder { <-3.625,0,1.5>,<-3.625,0,-8>,.125 rotate z*(I*90+45) }
      cylinder { <-3.625,0, -3>,<-2.125,0,-3>,.125 rotate z*(I*90+45) }
#local I=I+1; #end
//      box { <-.4,-4.6,-14.5>,< .4,-4.5,-13.5> }
//      box { <-.5,-5.1,-14.5>,<-.4,-4.6,-13.5> }
//      box { < .4,-5.1,-14.5>,< .5,-4.6,-13.5> }
//      cylinder { <-.5,-5.1,-14>,<-.4,-5.1,-14>,.5 }
//      cylinder { < .4,-5.1,-14>,< .5,-5.1,-14>,.5 }
//      cylinder { <-.4,-5.1,-14>,< .4,-5.1,-14>,.4 }
//      cylinder { <0,-4.5,-14>,<0,-4.0,-14>,.5 }
      texture { Steel } }
    union {
      torus { 2.42,.25 transform FlipYZ translate -z*2 }
      torus { 2.42,.25 transform FlipYZ translate  z*2 }
      torus { .225,.025 transform FlipYZ translate <-.25,3.17,-2> }
      torus { .225,.025 transform FlipYZ translate < .25,3.17,-2> }
      sphere { <-.25,2.67,-1.5>,.25 }
      sphere { < .25,2.67,-1.5>,.25 }
      intersection {
        torus { .5,.25 }
        box { <0,-.25,0>,<.75,.25,.75> }
        matrix <0,1,0, 1,0,0, 0,0,1, -.25,2.67,-2> }
      intersection {
        torus { .5,.25 }
        box { <0,-.25,0>,<.75,.25,.75> }
        matrix <0,1,0, 1,0,0, 0,0,1,  .25,2.67,-2> }
      difference {
        cylinder { -z*2,z*2,2.67 }
        cylinder { -z*2.1,z*2.1,2.17 }
      }
      texture { Chrome }
    }
#local sM=sqrt(.5)*.5;
#local sW=.5;
    union {
      prism { -15,-14.5,9,
        <-3.5-.5,   -3.5*s2>,<-3.5-.5,    3.5*s2>,<-3.5*s2-.5, 3.5   >,
        < 3.5*s2+.5, 3.5   >,< 3.5+.5,    3.5*s2>,< 3.5+.5,   -3.5*s2>,
        < 3.5*s2+.5,-3.5   >,<-3.5*s2-.5,-3.5   >,<-3.5-.5,   -3.5*s2>
        transform FlipYZ }
#local I=0; #while (I<8)
#local pB=vrotate(<-3.5,-3.5*s2,-14.5>,I*45*z);
#local pB=pB+sgn(pB.x)*x/2;
#local pC=vrotate(<-3.5, 3.5*s2,-14.5>,I*45*z);
#local pC=pC+sgn(pC.x)*x/2;
#local pE=vrotate(<-3.75,-3.5*s2,-2.5>,I*45*z);
#local pE=pE+sgn(pE.x)*x/2;
#local pF=vrotate(<-3.75, 3.5*s2,-2.5>,I*45*z);
#local pF=pF+sgn(pF.x)*x/2;

      sphere { pB,.5 }
      cylinder { pE,pF,.25 }
      cylinder { pB,pC,.5 }
      intersection { torus { .25,.25 } plane { z,0 } plane { x-z,0 }
        transform FlipYZ rotate z*I*45 translate pB+z*12 }
      intersection { cylinder { 0,z*12,.5 } plane { <1,s2,0>,0 }
        rotate z*I*45 translate pB }
#local I=I+1; #end
      box { <-3.5*s2-.5, 3.5,-14.5>,<3.5*s2+.5, 4,-2.5> }
      box { <-3.5*s2-.5,-4,-14.5>,<3.5*s2+.5,-3.5,-2.5> }

      box { <-3.5*s2, 3.5,-14.5>,<3.5*s2, 4,-2.5> rotate z* 45 translate -x/2 }
      box { <-3.5*s2, 3.5,-14.5>,<3.5*s2, 4,-2.5> rotate z* 90 translate -x/2 }
      box { <-3.5*s2, 3.5,-14.5>,<3.5*s2, 4,-2.5> rotate z*135 translate -x/2 }
      box { <-3.5*s2, 3.5,-14.5>,<3.5*s2, 4,-2.5> rotate z*225 translate  x/2 }
      box { <-3.5*s2, 3.5,-14.5>,<3.5*s2, 4,-2.5> rotate z*270 translate  x/2 }
      box { <-3.5*s2, 3.5,-14.5>,<3.5*s2, 4,-2.5> rotate z*315 translate  x/2 }

      intersection {
        cylinder { <-.25,0,-4.5>,<.25,0,-4.5>,8.5 }
        plane { y,-3.75 }
        plane { y+z,0 translate <0,-3.75,-2.5> }
      }
      texture { Plastic }
    }
    cylinder { <-.25,3.17,-2>,<-.25,3.17,-7>,.2 pigment { rgb <.75,0 ,0> } }
    cylinder { < .25,3.17,-2>,< .25,3.17,-7>,.2 pigment { rgb <0,.25,.75> } }
    translate z*4.5
    Matrix(vX,vY,vZ,pL)
  } // end of the laser

#local pA=vmatrix(<0,-5.6,-9.5>,vX,vY,vZ,pL);

#local vZ=vnormalize(vZ*<1,0,1>);
#local vY=y;
#local vX=vnormalize(vcross(vY,vZ));

#local pB=vmatrix(<0,-7.4,-1.5>,vX,vY,vZ,pL);

//cylinder { pA,pB,.35 texture { Chrome } }

//cylinder { pA+.5*vnormalize(pB-pA),pA+2.5*vnormalize(pB-pA),1
//  texture { BugLapis } }

  union { // the laser turret
    box { <-.125,-.5,0>,<.125,.5,10>
      matrix <1,0,0, 0, .6,.8, 0,-.8, .6, -4.625,0,0> }
    box { <-.125,-.5,0>,<.125,.5,10>
      matrix <1,0,0, 0,-.6,.8, 0,-.8,-.6, -4.625,0,0> }
    box { <-.125,-.5,0>,<.125,.5,10>
      matrix <1,0,0, 0, .6,.8, 0,-.8, .6,  4.625,0,0> }
    box { <-.125,-.5,0>,<.125,.5,10>
      matrix <1,0,0, 0,-.6,.8, 0,-.8,-.6,  4.625,0,0> }
    cylinder { <-4.75, 0, 0>,<-4.50, 0, 0>,.5 }
    cylinder { < 4.50, 0, 0>,< 4.75, 0, 0>,.5 }
    cylinder { <-4.75,-8, 6>,<-4.50,-8, 6>,.5 }
    cylinder { < 4.50,-8, 6>,< 4.75,-8, 6>,.5 }
    cylinder { <-4.75,-8,-6>,<-4.50,-8,-6>,.5 }
    cylinder { < 4.50,-8,-6>,< 4.75,-8,-6>,.5 }
    cylinder { <0,-8.5,0>,<0,-8,0>,9 }

//    box { <-.4,-8.0,-2>,< .4,-7.9,-1> }
//    box { <-.5,-7.9,-2>,<-.4,-7.4,-1> }
//    box { < .4,-7.9,-2>,< .5,-7.4,-1> }

//    cylinder { <-.4,-7.4,-1.5>,< .4,-7.4,-1.5>,.4 }
//    cylinder { <-.5,-7.4,-1.5>,<-.4,-7.4,-1.5>,.5 }
//    cylinder { < .4,-7.4,-1.5>,< .5,-7.4,-1.5>,.5 }

    texture { Steel }
    Matrix(vX,vY,vZ,pL)
  } // end of the laser turret

  union { // the laser mount
    difference {
      cylinder { -y*8.5,-y*8.0,10.5-sqrt(.75) }
      cylinder { -y*8.6,-y*7.9,9.05 }
    }
    difference {
      cylinder { -y*8.0,-y*7.75,10.5-sqrt(.1875) }
      cylinder { -y*8.1,-y*7.65,10.5-sqrt(.75) }
      torus { 10.5-sqrt(.75),.5 translate -y*7.5 }
    }
    torus { 10.5,.5 translate -y*8 }

    difference {
      cylinder { -y*10.5,-y*8.0,11.0 }
      cylinder { -y*10.6,-y*7.9,10.5 }
    }
    torus { 10.5,.5 translate -y*10.5 }
    CrossBar(<-7.125,-10.5, sS>,<-7.125,-10.5-sD*2,-sS>)
    CrossBar(< 7.125,-10.5, sS>,< 7.125,-10.5-sD*2,-sS>)
    CrossBar(<-6.875,-10.5,-sS>,<-6.875,-10.5-sD*2, sS>)
    CrossBar(< 6.875,-10.5,-sS>,< 6.875,-10.5-sD*2, sS>)

    CrossBar(<-7.125,-10.5-sD*2, sS>,<-7.125,-10.5-sD*4,-sS>)
    CrossBar(< 7.125,-10.5-sD*2, sS>,< 7.125,-10.5-sD*4,-sS>)
    CrossBar(<-6.875,-10.5-sD*2,-sS>,<-6.875,-10.5-sD*4, sS>)
    CrossBar(< 6.875,-10.5-sD*2,-sS>,< 6.875,-10.5-sD*4, sS>)

    CrossBar(<-7.125,-10.5-sD*4, sS>,<-7.125,-10.5-sD*6,-sS>)
    CrossBar(< 7.125,-10.5-sD*4, sS>,< 7.125,-10.5-sD*6,-sS>)
    CrossBar(<-6.875,-10.5-sD*4,-sS>,<-6.875,-10.5-sD*6, sS>)
    CrossBar(< 6.875,-10.5-sD*4,-sS>,< 6.875,-10.5-sD*6, sS>)

    texture { Steel }
    translate pL
  } // end of the laser mount

// the laser door
#local sX=.5+14.25*DoorOpen;
#local sO=(sX+15.75)/2+.5; //outer hinge
#local sI=(sX+15.75)/2-.5; //inner hinge

#local sH=sqrt(7.125*7.125-(sX-sI)*(sX-sI));

#local vX=<sI-sX,-sH,0>/7.125;
#local vY=<sH,sI-sX,0>/7.125;
#local vZ=z;
#local rX=vX*<-1,1,1>;
#local rY=vY*<-1,1,1>;

#local Panel=union {
  box { <-3.5625,-.5,-16.25>,<3.5625,.5,8> }
  cylinder { <-3.5625,0,-16.25>,<-3.5625,0,8>,.5 }
  cylinder { < 3.5625,0,-16.25>,< 3.5625,0,8>,.5 }
  texture { gradient y ramp_wave scale 2 translate -y
    texture_map { [.375 Steel][.5 Chrome] }
  }
}

object { Panel Matrix(vX,vY,vZ,<(sX+sI)/2,69.5-sH/2,0>) }
object { Panel Matrix(rX,rY,vZ,<(15.75+sO)/2,69.5-sH/2,0>) }

object { Panel Matrix(rX,rY,vZ,<-(sX+sI)/2,69.5-sH/2,0>) }
object { Panel Matrix(vX,vY,vZ,<-(15.75+sO)/2,69.5-sH/2,0>) }

// Boxer's arms and hands

#local s15=sqrt(.5-sqrt(.1875));
#local Count=0; #while(Count<2)

#switch (Count)
#case (0)
  #local pS=<-11,45,20-s15*2.5>;
  #local vH=BoxerHandL-pS;
  #break
#case (1)
  #local pS=< 11,45,20-s15*2.5>;
  #local vH=BoxerHandR-pS;
  #break
#end

#local l_A=vlength(vH);
#local vZ=vnormalize(vH);
#local vX=vnormalize(vcross(y,vZ));
#local vY=vnormalize(vcross(vZ,vX));

union {
  intersection {
    sphere { 0,2.5 }
    plane { y,-1.25 }
    texture { Steel }
  } 
  intersection {
    sphere { 0,2.5 }
    plane {-y,-1.25 }
    texture { Steel }
  } 
  intersection {
    sphere { 0,2.5 }
    plane { y, 1.25 }
    plane {-y, 1.25 }
    texture { Chrome }
  } 

  cylinder { 0,z*15,1.25 texture { Steel } }
  torus { 1,.25 transform FlipYZ translate z*15 texture { Steel } }
  cylinder { z*15,z*max(15.5,l_A-20),1 texture { Steel } }
  torus { .75,.25 transform FlipYZ translate z*max(15.5,l_A-20)
    texture { Steel } }
  cylinder { z*15,z*(l_A-5),.75 texture { Steel } }

  union { // a claw
    prism { -.85,.85,7,
      <.75,0>,<2,1.5>,<1.45,2>,<-1.45,2>,<-2,1.5>,<-.75,0>,<.75,0>
      texture { Steel }
    }
    cylinder { <-2,-.85,2>,<-2,-.75,2>,.55 texture { Steel } }
    cylinder { <-2, .75,2>,<-2, .85,2>,.55 texture { Steel } }
    cylinder { < 2,-.85,2>,< 2,-.75,2>,.55 texture { Steel } }
    cylinder { < 2, .75,2>,< 2, .85,2>,.55 texture { Steel } }

    union { // a finger
      cylinder { -y,y,1 scale <.5,.75,.5> }
      cylinder { 0,z,1 scale <.5,.75,2.5> }
      cylinder { 0,x,1 scale < 1,.75,.5> translate <.5,0,3> }
      sphere {0,1 scale <.5,.75,.5> translate <1.5,0,3> }
      intersection { torus { 1,1 } box { <-2,-1,0>,<0,1,2> }
        scale <.5,.75,.5> translate < .5,0,2.5> }
#switch(Count)
#case (0) rotate -y*BoxerClawL #break
#case (1) rotate -y*BoxerClawR #break
#end
      translate <-2,0,2>
      texture { Plastic }
    } // end of a finger
    union { // another finger
      cylinder { -y,y,1 scale <.5,.75,.5> }
      cylinder { 0,z,1 scale <.5,.75,2.5> }
      cylinder { 0,x,1 scale <-1,.75,.5> translate <-.5,0,3> }
      sphere {0,1 scale <.5,.75,.5> translate <-1.5,0,3> }
      intersection { torus { 1,1 } box { <0,-1,0>,<2,1,2> }
        scale <.5,.75,.5> translate <-.5,0,2.5> }
#switch(Count)
#case (0) rotate y*BoxerClawL #break
#case (1) rotate y*BoxerClawR #break
#end
      translate < 2,0,2>
      texture { Plastic }
    } // end of another finger

#switch(Count)
#case (0) rotate z*BoxerWristL #break
#case (1) rotate z*BoxerWristR #break
#end
    translate z*(l_A-5)
  } // end of a claw

  Matrix(vX,vY,vZ,pS)
}
#local Count=Count+1; #end

#local sD=sqrt(22*22+3*3);

#local pA=<0,-sD,9>+2*vnormalize(<0,-3,0>-<0,-sD,9>);
#local pB=<0,-3,-4>;
#local pC=<0,-3, 4>;

union { // the front wheel assembly
  union { // the wheel mount
    cylinder { <-6,-1,-4>,<6,-1,-4>,1 }
    cylinder { <-6,-1, 4>,<6,-1, 4>,1 }
#local Count=0; #while (Count<2)
    union { // one side of the wheel mount triangle
      intersection {
        torus { 2,1 transform FlipXY }
        plane { pB-pA,0 }
        plane { pC-pA,0 }
        translate pA }
      intersection {
        torus { 2,1 transform FlipXY }
        plane { pA-pB,0 }
        plane { pC-pB,0 }
        translate pB }
      intersection {
        torus { 2,1 transform FlipXY }
        plane { pA-pC,0 }
        plane { pB-pC,0 }
        translate pC }
#local vO=vnormalize(vcross(pA-pB,-x))*2;
      cylinder { pA+vO,pB+vO,1 }
#local vO=vnormalize(vcross(pB-pC,-x))*2;
      cylinder { pB+vO,pC+vO,1 }
#local vO=vnormalize(vcross(pC-pA,-x))*2;
      cylinder { pC+vO,pA+vO,1 }
#if (Count) // right side
  matrix <22/sD,-3/sD,0,  3/sD,22/sD,0, 0,0,1,  6,0,0>
#else // left side
  matrix <22/sD, 3/sD,0, -3/sD,22/sD,0, 0,0,1, -6,0,0>
#end
    } // end of one side of wheel the mount triangle
#local Count=Count+1; #end
    pigment { rgb 1 }
  } // end of the wheel mount
  intersection { // the tire
    torus { 6.4, sqrt(5.12) }
    sphere { 0,8 }
    texture { Rubber }
    transform FlipXY
    rotate x*WheelSpin/.8
    translate <0,-22,9>
  } // end of the tire
  difference { // the wheel
    cylinder { -2*x,2*x,6 }
    torus { 3,2.5 transform FlipXY scale <.6,1,1> translate -2*x }
    torus { 3,2.5 transform FlipXY scale <.6,1,1> translate  2*x }
    object { CutOut }
    object { CutOut rotate x* 72 }
    object { CutOut rotate x*144 }
    object { CutOut rotate x*216 }
    object { CutOut rotate x*288 }
    scale .8
    rotate x*WheelSpin/.8
    translate <0,-22,9>
    texture { Steel }
  } // end of the wheel
  cylinder { <-3,-22,9>,<3,-22,9>,.5 texture { Steel } }
  rotate y*WheelTurn
  translate <0,30,11>
} // end of the front wheel assembly

#local Count=0; #while (Count<2)
union { // the video camera

  union {
    union {
      difference {
        cylinder { < 0,0,-4.5>,< 0,0,5>,2.5 }
        cylinder { < 0,0,-5>,< 0,0,6>,2 }
      }
      torus { 2.25,.25 transform FlipYZ translate < 0,0,5> }
      torus { 2.00,.50 transform FlipYZ translate < 0,0,-4.5> }
      cylinder { <0,0,-5>,<0,0,-4.5>,2 }
      texture { Plastic }
    }
    intersection {
      sphere { z*3.75,4.25 }
      sphere {-z*3.75,4.25 }
      translate <0,0,4.5>
      material { Glass }
    }
#if (Count)
  #local v_T=vnormalize(<0,CamDirR.y,sqrt(1-CamDirR.y*CamDirR.y)>);
#else
  #local v_T=vnormalize(<0,CamDirL.y,sqrt(1-CamDirL.y*CamDirL.y)>);
#end
    matrix <1,0,0, 0,v_T.z,-v_T.y, 0,v_T.y,v_T.z ,0,0,0>
  }

  union {
    box { <-3,-1.9,-2>,<-2.6,1.9,2> }
    box { < 2.6,-1.9,-2>,< 3,1.9,2> }
    intersection {
      cylinder { <0,-1.9,-2>,<0,-1.9,2>,3 }
      cylinder { <0,-1.9,-3>,<0,-1.9,3>,2.6 inverse }
      plane { y,0 translate -y*1.9 }
    }
    intersection {
      cylinder { <0, 1.9,-2>,<0, 1.9,2>,3 }
      cylinder { <0, 1.9,-3>,<0, 1.9,3>,2.6 inverse }
      plane { -y,0 translate  y*1.9 }
    }
    sphere { <-3,0,0>,.3 }
    sphere { < 3,0,0>,.3 }
    cylinder { <-3,0,0>,< 3,0,0>,.2 }
    texture { Steel }
  }

#if (Count)
  #local v_T=vnormalize(<CamDirR.x,0,CamDirR.z>);
#else
  #local v_T=vnormalize(<CamDirL.x,0,CamDirL.z>);
#end
  matrix <v_T.z,0,-v_T.x, 0,1,0, v_T.x,0,v_T.z ,0,0,0>

#if (Count)
  translate < 10,60,26.25>
#else
  translate <-10,60,26.25>
#end
} // end of the video camera
#local Count=Count+1; #end

#local dZ= 6/sqrt(23*23+6*6);
#local dX=23/sqrt(23*23+6*6);

#local Count=0; #while (Count<2)
union { // camera mounts
  box { <-2.5,-5.5,0>,<2.5,5,.5> }
  intersection {
    cylinder { <-3,-5,.5>,<3,-5,.5>,.5 }
    box { <-2.5,-5.5,0>,<2.5,-5,.5> }
  }
  intersection {
    cylinder { <-3, 5,.5>,<3, 5,.5>,.5 }
    box { <-2.5, 5,0>,<2.5, 5.5,.5> }
  }
  cylinder { <0,-5.5,6.25>,<0,-5,6.25>,1 }
  cylinder { <0, 5,6.25>,<0, 5.5,6.25>,1 }
  intersection {
    union {
      cylinder { <-1.5,-5.5,.5>,<-1.5,-5,.5>,1 }
      cylinder { < 1.5,-5.5,.5>,< 1.5,-5,.5>,1 }
      cylinder { <-1.5, 5,.5>,<-1.5, 5.5,.5>,1 }
      cylinder { < 1.5, 5,.5>,< 1.5, 5.5,.5>,1 }
    }
    plane {-z,0 translate z*.5 }
  }
  prism { -5.5,-5,7,
    <1.5,.5>,<1.5+dX,.5+dZ>,<0+dX,6.25+dZ>,<0-dX,6.25+dZ>,
    <-1.5-dX,.5+dZ>,<-1.5,.5>,<1.5,.5> }
  prism {  5, 5.5,7,
    <1.5,.5>,<1.5+dX,.5+dZ>,<0+dX,6.25+dZ>,<0-dX,6.25+dZ>,
    <-1.5-dX,.5+dZ>,<-1.5,.5>,<1.5,.5> }
  cylinder { <0,-5.25,6.25>,<0,-4.25,6.25>,.5 }
  cylinder { <0, 5.25,6.25>,<0, 4.25,6.25>,.5 }

  texture { Steel }
#if (Count)
  translate < 10,60,20>
#else
  translate <-10,60,20>
#end
} // end of camera mount
#local Count=Count+1; #end

#local Count=0;
#while (Count<2)
union { // one of the wheels
  union { // the rubber
    intersection { 
      torus { 8,sqrt(8) matrix <0,1,0, 1,0,0, 0,0,1, 0,0,0> }
      cylinder { <-3,0,0>,<3,0,0>, 10 }
      cylinder { <-3,0,0>,<3,0,0>, 6 inverse }
    }
    intersection { // tire markings
      torus { 8,sqrt(8.5) matrix <0,1,0, 1,0,0, 0,0,1, 0,0,0> }
union { // letters for tire markings
#local i_L=0; #while (i_L<14)
      text { ttf "cyrvetic.ttf" Logo[i_L], 3,0
        matrix <0,0,-1, 0,1,0, 1,0,0, -3,7.625,0>
        rotate -x*Rots[i_L] }
#local i_L=i_L+1; #end
} // end of letters for tire markings
    } // end of tire markings
  texture { Rubber }
  #if (Count) scale <-1,1,-1> #end
  } // end of the rubber

difference {
  cylinder { -2*x,2*x,6 }
  sphere { 0,1 scale <1.5,5.5,5.5> translate -2*x }
  sphere { 0,1 scale <1.5,5.5,5.5> translate  2*x }
  object { CutOut }
  object { CutOut rotate x* 72 }
  object { CutOut rotate x*144 }
  object { CutOut rotate x*216 }
  object { CutOut rotate x*288 }
  texture { Steel } }

#switch (Count)
  #case (0) rotate x*WheelSpin translate <-22.5,10,-19> #break
  #case (1) rotate x*WheelSpin translate < 22.5,10,-19> #break
#end
} // end of one of the wheels
#local Count=Count+1; #end

#local S370=sqrt(370);

union { // the undercarriage
  cylinder { <-16,- 1,-12>,< 16,- 1,-12>,1 }
  cylinder { <-16,- 1,- 2>,< 16,- 1,- 2>,1 }
  cylinder { <-19,-20,-19>,< 19,-20,-19>,1 }

#local Count=0;
#while (Count<2)

union { // one side of the undercarriage
  cylinder { <0,0,-16>,<0,0,-2>,1 }
  intersection {
    torus { 2,1 matrix <0,1,0, 1,0,0, 0,0,1, 0,0,0> }
    plane { -z,0 }
    plane { <0,4-S370,-17>,0 }
    translate <0,-2,-2> }
  intersection {
    torus { 2,1 matrix <0,1,0, 1,0,0, 0,0,1, 0,0,0> }
    plane { z,0 }
    plane { <0,4-S370,-3>,0 }
    translate <0,-2,-16> }
  intersection {
    torus { 2,1 matrix <0,1,0, 1,0,0, 0,0,1, 0,0,0> }
    plane { <0,S370-4, 3>,0 }
    plane { <0,S370-4,17>,0 }
    translate <0,2-S370,-19> }
  cylinder {
    2*vnormalize(<0,3,4-S370>)+<0,-2,-16>,
    2*vnormalize(<0,3,4-S370>)+<0,2-S370,-19>,1 }
  cylinder {
    2*vnormalize(<0,-17,S370-4>)+<0,-2,-2>,
    2*vnormalize(<0,-17,S370-4>)+<0,2-S370,-19>,1 }

#if (Count=0)
  matrix <19/S370, 3/S370,0, -3/S370,19/S370,0, 0,0,1,  16,-1,0>
#else
  matrix <19/S370,-3/S370,0,  3/S370,19/S370,0, 0,0,1, -16,-1,0>
#end
} // end of one side of the undercarriage
#local Count=Count+1; #end

  pigment { rgb 1 }
  translate y*30
} // end of the undercarriage

union { // start of the marquee

#if (BMarqOn)
union { // the lights in the marquee
#local Count=0;
#while (Count<59)

#if (SeeBit(Marq[Count], 1)) sphere { <14.5-Count*.5,2.00,-2>,.225 } #end
#if (SeeBit(Marq[Count], 2)) sphere { <14.5-Count*.5,2.50,-2>,.225 } #end
#if (SeeBit(Marq[Count], 4)) sphere { <14.5-Count*.5,3.00,-2>,.225 } #end
#if (SeeBit(Marq[Count], 8)) sphere { <14.5-Count*.5,3.50,-2>,.225 } #end
#if (SeeBit(Marq[Count],16)) sphere { <14.5-Count*.5,4.00,-2>,.225 } #end
#if (SeeBit(Marq[Count],32)) sphere { <14.5-Count*.5,4.50,-2>,.225 } #end
#if (SeeBit(Marq[Count],64)) sphere { <14.5-Count*.5,5.00,-2>,.225 } #end

#local Count=Count+1; #end

#if (Test=0)
  hollow
  texture { pigment { rgbt 1 } }
  interior { media { emission <60,45,0> } }
#else
  texture {
    pigment { rgbt <20,15,0> }
    finish { ambient 1 diffuse 0 }
  }
#end

} // end of the lights in the marquee
#end

intersection { // start of front glass for marquee
  merge {
    RoundedBar(<-15.75,-1,.25>,<15.75,0,6.75>,.75)
    matrix <1,0,0, 0,0,1, 0,1,0, 0,0,0>
    texture { pigment { rgbf <.25,.25,.25,1> } }
  }
  plane { z,-.25
    texture {
      pigment { rgbf <.25,.25,.25,1> }
      finish { diffuse .6 ambient .1 reflection .15 specular 0 }
    }
  }
  plane {-z, .75 texture { pigment { rgbf <.25,.25,.25,1> } } }
} // end of front glass for marquee

union { // start of the marquee casing
  box { <-15.0,0.0,-5>,< 15.0,0.5, 0.0> }
  box { <-15.0,6.5,-5>,< 15.0,7.0, 0.0> }
  box { <-15.0,1.0,-6>,< 15.0,6.0,-5.5> }
  box { <-16.0,1.0,-5>,<-15.5,6.0, 0.0> }
  box { < 15.5,1.0,-5>,< 16.0,6.0, 0.0> }
  cylinder { <-15,1,-5>,< 15,1,-5>,1 }
  cylinder { <-15,6,-5>,< 15,6,-5>,1 }
  cylinder { <-15,1,-5>,<-15,6,-5>,1 }
  cylinder { < 15,1,-5>,< 15,6,-5>,1 }
  cylinder { <-15,.25,0>,< 15,.25,0>,.25 }
  cylinder { <-15,6.75,0>,< 15,6.75,0>,.25 }
  cylinder { <-15.75,1,0>,<-15.75,6,0>,.25 }
  cylinder { < 15.75,1,0>,< 15.75,6,0>,.25 }
  sphere { <-15,1,-5>,1 }
  sphere { < 15,1,-5>,1 }
  sphere { <-15,6,-5>,1 }
  sphere { < 15,6,-5>,1 }
  intersection {
    cylinder { <-15,1,-6>,<-15,1,1>,1 }
    cylinder { <-15,1,-6>,<-15,1,1>,.5 inverse }
    box {<-16,0,-5>,<-15,1,0> } }
  intersection {
    cylinder { < 15,1,-6>,< 15,1,1>,1 }
    cylinder { < 15,1,-6>,< 15,1,1>,.5 inverse }
    box {< 15,0,-5>,< 16,1,0> } }
  intersection {
    cylinder { <-15,6,-6>,<-15,6,1>,1 }
    cylinder { <-15,6,-6>,<-15,6,1>,.5 inverse }
    box {<-16,6,-5>,<-15,7,0> } }
  intersection {
    cylinder { < 15,6,-6>,< 15,6,1>,1 }
    cylinder { < 15,6,-6>,< 15,6,1>,.5 inverse }
    box {< 15,6,-5>,< 16,7,0> } }
  intersection {
    torus { .75,.25 matrix <1,0,0, 0,0,1, 0,1,0, -15,1,0> }
    box { <-16,0,-.25>,<-15,1,.25> } }
  intersection {
    torus { .75,.25 matrix <1,0,0, 0,0,1, 0,1,0,  15,1,0> }
    box { < 15,0,-.25>,< 16,1,.25> } }
  intersection {
    torus { .75,.25 matrix <1,0,0, 0,0,1, 0,1,0, -15,6,0> }
    box { <-16,6,-.25>,<-15,7,.25> } }
  intersection {
    torus { .75,.25 matrix <1,0,0, 0,0,1, 0,1,0,  15,6,0> }
    box { < 15,6,-.25>,< 16,7,.25> } }
  pigment { rgb 1 }
} // end of the marquee casing

  translate <0,70,15>
} // end of the marquee

#local R=3.75;
#local OC=20;
#local IC=OC-R;
#local EC=IC+.1;
#local RC=IC-.1;

#local Corner=intersection {
  sphere { 0,R }
  sphere { 0,R-1 inverse }
  box { 0,R }
  texture { onion ramp_wave scale 4
    texture_map { [3/4 Steel][3.5/4 Chrome] }
  }
}

#local Edge=intersection {
  cylinder { -IC*z,IC*z,R }
  cylinder { -EC*z,EC*z,R-1 inverse }
  box { -IC*z,<R,R,IC> }
  texture { wood ramp_wave scale 4
    texture_map { [3/4 Steel][3.5/4 Chrome] }
  }
}

#local Panel=box { <-1,0,-1>,<1,1,1>
  texture { gradient y ramp_wave scale 2 translate -y/2
    texture_map { [.375 Steel][.625 Chrome] }
  }
}

union { // start of Boxer's casing
// the corners
  object { Corner Matrix( x, y, z,< IC, IC, IC>) }
  object { Corner Matrix(-x, y, z,<-IC, IC, IC>) }
  object { Corner Matrix( x,-y, z,< IC,-IC, IC>) }
  object { Corner Matrix(-x,-y, z,<-IC,-IC, IC>) }
  object { Corner Matrix( x, y,-z,< IC, IC,-IC>) }
  object { Corner Matrix(-x, y,-z,<-IC, IC,-IC>) }
  object { Corner Matrix( x,-y,-z,< IC,-IC,-IC>) }
  object { Corner Matrix(-x,-y,-z,<-IC,-IC,-IC>) }

  object { Edge Matrix(-x,-y, z,<-IC,-IC,0>) }
  object { Edge Matrix( x,-y, z,< IC,-IC,0>) }
  object { Edge Matrix(-x, y, z,<-IC, IC,0>) }
  object { Edge Matrix( x, y, z,< IC, IC,0>) }

  object { Edge Matrix(-y,-z, x,<0,-IC,-IC>) }
  object { Edge Matrix( y,-z, x,<0, IC,-IC>) }
  object { Edge Matrix(-y, z, x,<0,-IC, IC>) }
  object { Edge Matrix( y, z, x,<0, IC, IC>) }

  object { Edge Matrix(-z,-x, y,<-IC,0,-IC>) }
  object { Edge Matrix( z,-x, y,<-IC,0, IC>) }
  object { Edge Matrix(-z, x, y,< IC,0,-IC>) }
  object { Edge Matrix( z, x, y,< IC,0, IC>) }

  object { Panel Matrix( x*IC,-y, z*IC,<0,-19,0>) }
  object { Panel Matrix( x*IC, y, z*(IC/2-4),<0, 19,IC/2+4>) }

  object { Panel Matrix( z*IC,-x, y*IC,<-19,0,0>) }
  object { Panel Matrix( z*IC, x, y*IC,< 19,0,0>) }

  object { Panel Matrix( y*IC,-z, x*IC,<0,0,-19>) }
  difference {
    object { Panel Matrix( y*IC, z, x*IC,<0,0, 19>) }
    sphere { <-11,-5,20-s15*2.5>,2.5 }
    sphere { < 11,-5,20-s15*2.5>,2.5 }
  }
  translate y*50
} // end of Boxer's casing

polygon { 5, <0,0,0>,<1,0,0>,<1,1,0>,<0,1,0,>,<0,0,0>
  pigment { image_map { gif "sticker.gif" interpolate 2 } }
  finish { ambient .5 diffuse 1 }
  scale <15,5,1>
  translate <1,34,-20.0001>
}

//everything in Boxer should be declared by now
Matrix(BoxerX,BoxerY,BoxerZ,BoxerL)

// he gets cut in half sometimes

#ifdef(BoxerClip) clipped_by { object { BoxerClip } } #end

} // end of overall union for Boxer
