global_settings { max_trace_level 10 }

#declare Test=0;

#include "macs.inc"
#include "spline.inc"
#include "walk.inc"
#include "voronoi.inc"

#include "bsp_text.inc"

#declare CamZ=2.5;
#declare Frame=floor(clock*24+.5);
#declare Clock=Frame/24;

//the various shots go here

#switch(Clock)
  #range(-.001,8.999) // opening title
    #declare Timer=Clock;
    #include "bsp_s01.inc"
  #break
// shot 2:  "in our last episode,"
  #range(8.999,14.999)
    #declare Timer=Clock-9;
    #include "bsp_s02.inc"
  #break
// shot 3:  "Sacrifice them to the god."
  #range(14.999,20.499)
    #declare Timer=Clock-15;
    #include "bsp_s03.inc"
  #break
// shot 4:  Boxer's response
  #range(20.499,23.999)
    #declare Timer=Clock-20.5;
    #include "bsp_s04.inc"
  #break
// shot 5:  "It is useless to resist!"
  #range(23.999,27.499)
    #declare Timer=Clock-24;
    #include "bsp_s05.inc"
  #break
// shot 6:  Grebs run for it, get blasted.
  #range(27.499,32.999)
    #declare Timer=Clock-27.5;
    #include "bsp_s06.inc"
  #break
// shot 7:  Two more get blasted
  #range(32.999,35.999)
    #declare Timer=Clock-33;
    #include "bsp_s07.inc"
  #break
// shot 8:  The Blue Screen of Death
  #range(35.999,40.499)
    #declare Timer=Clock-36;
    #include "bsp_s08.inc"
  #break
// shot 9:  Problem solved
  #range(40.499,43.499)
    #declare Timer=Clock-40.5;
    #include "bsp_s09.inc"
  #break
// shot 10:  Run away & fade to black
  #range(43.499,99.999)
    #declare Timer=Clock-43.5;
    #include "bsp_s10.inc"
  #break
#end

#declare CamD=vnormalize(CamE-CamL);
#declare CamR=vnormalize(vcross(y,CamD));
#declare CamU=vnormalize(vcross(CamD,CamR));

camera {
  up CamU
  right CamR*4/3
  direction CamD*CamZ
  location CamL
}

//subtitling goes here

#switch(Clock)
  #range(-.001,0.999) // opening fade from black
    #declare Timer=Clock;
    #include "bsp_t1.inc"
  #break
  #range(8.999,13.999) // back story
    #declare Timer=Clock-9;
    #include "bsp_t2.inc"
  #break
  #range(15.999,17.499) // "Sacrifice them to the god!"
    #declare Timer=Clock-15;
    #include "bsp_t3.inc"
  #break
  #range(24.499,25.499) // "It is useless to resist!"
    #declare Timer=Clock-24.5;
    #include "bsp_t4.inc"
  #break
  #range(47.999,99.999) // Fade to black
    #declare Timer=Clock-48;
    #include "bsp_t5.inc"
  #break
#end
