#declare Seed=seed(0);

#include "penshape.inc"

#include "penrose.inc"

#declare BugDir=z;
#declare BugRig=x;

#local L=<-15,0,8>/17;
#local R=< 15,0,8>/17;

#local Steps=floor(Clock*3);
#local Partial=Clock*3-Steps;
#local Spot=<0,0,Steps*.6-5.4>;

#local PntOne=Transition(Spot,Spot+.6*z,y*.1,Partial*2-1);
#local PntTwo=Transition(Spot-.3*z,Spot+.3*z,y*.1,Partial*2);

#declare Foot0=PntOne-.19*BugRig+.32*BugDir+L*.53;
#declare Foot1=PntTwo+.19*BugRig+.32*BugDir+R*.53;
#declare Foot2=PntTwo-.8*BugRig;
#declare Foot3=PntOne+.8*BugRig;
#declare Foot4=PntOne-.19*BugRig-.32*BugDir-R*.53;
#declare Foot5=PntTwo+.19*BugRig-.32*BugDir-L*.53;

#if (Clock<6)
#include "bugbot.inc"
#else
#declare BugX=x;
#declare BugY=y;
#declare BugZ=z;
#declare BugL=<0,0,5.4>;
#declare SparkOn=0;
#include "flatbug.inc"
#end

#local Yoff=max(0,(3-Clock)*30);

text { ttf "c:\windows\fonts\comicbd.ttf","BOXER",.75,0
  translate -x*1.66
  transform FlipYZ
  scale <-3,3,-3>
  translate -z*6.8
  translate y*Yoff
  texture { Plastic }
}

#local Yoff=max(0,(4-Clock)*30);

text { ttf "c:\windows\fonts\comicbd.ttf","SOLVES",.75,0
  translate -x*1.99
  transform FlipYZ
  scale <-3,3,-3>
  translate -z*2.5
  translate y*Yoff
  texture { Plastic }
}

#local Yoff=max(0,(5-Clock)*30);

text { ttf "c:\windows\fonts\comicbd.ttf","A",.75,0
  translate -x*.32
  transform FlipYZ
  scale <-3,3,-3>
  translate z*1.8
  translate y*Yoff
  texture { Plastic }
}

#local Yoff=max(0,(6-Clock)*30);

text { ttf "c:\windows\fonts\comicbd.ttf","PROBLEM",.75,0
  translate -x*2.3
  transform FlipYZ
  scale <-3,3,-3>
  translate z*6.1
  translate y*Yoff
  texture { Plastic }
}

#local Jp=sin(pi*Clock*24);

#local Jf=0;
#if (Clock>=3) #local Jf=Jp*exp((3-Clock)*10); #end
#if (Clock>=4) #local Jf=Jp*exp((4-Clock)*10); #end
#if (Clock>=5) #local Jf=Jp*exp((5-Clock)*10); #end
#if (Clock>=6) #local Jf=Jp*exp((6-Clock)*10); #end

#declare CamEs=<0,Jf*.3,Clock*1.8-6>;
#declare CamLs=CamEs+<1,1.5,5>;

#declare CamE=Transition(CamEs,y*2.25-z*1.475,0,Clock-7);
#declare CamL=Transition(CamLs,<0,45,5>,0,Clock-7);

