// file to create a bug robot, with placement of the feet specified
// the variables Foot0 through Foot5
#local E=.03; //the radius of the edge rounding

#local Lift=(Foot0+Foot1+Foot2+Foot3+Foot4+Foot5)/6;
#local v_BF=vnormalize(Foot0+Foot1-Foot4-Foot5);
#local v_BU=y;
#local v_BR=vnormalize(vcross(v_BU,v_BF));

#local L=vnormalize(8*v_BF-15*v_BR);
#local R=vnormalize(8*v_BF+15*v_BR);

union {
//bug body
// will fit in the box <-.3,.25,-.5> to <.3,.5,.5>

//make sure that calling software has invoked meshmacs.inc

//corners of bugbot:

#local UC0= .11*v_BR+.36*v_BU+.47*v_BF+Lift;
#local UC1= .27*v_BR+.36*v_BU+.17*v_BF+Lift;
#local UC2= .27*v_BR+.36*v_BU-.17*v_BF+Lift;
#local UC3= .11*v_BR+.36*v_BU-.47*v_BF+Lift;
#local UC4=-.11*v_BR+.36*v_BU-.47*v_BF+Lift;
#local UC5=-.27*v_BR+.36*v_BU-.17*v_BF+Lift;
#local UC6=-.27*v_BR+.36*v_BU+.17*v_BF+Lift;
#local UC7=-.11*v_BR+.36*v_BU+.47*v_BF+Lift;
#local LC0= .11*v_BR+.16*v_BU+.47*v_BF+Lift;
#local LC1= .27*v_BR+.16*v_BU+.17*v_BF+Lift;
#local LC2= .27*v_BR+.16*v_BU-.17*v_BF+Lift;
#local LC3= .11*v_BR+.16*v_BU-.47*v_BF+Lift;
#local LC4=-.11*v_BR+.16*v_BU-.47*v_BF+Lift;
#local LC5=-.27*v_BR+.16*v_BU-.17*v_BF+Lift;
#local LC6=-.27*v_BR+.16*v_BU+.17*v_BF+Lift;
#local LC7=-.11*v_BR+.16*v_BU+.47*v_BF+Lift;
#local BEL=-.06*v_BR+.29*v_BU+.50*v_BF+Lift;
#local BER= .06*v_BR+.29*v_BU+.50*v_BF+Lift;
#local ABL=-.11*v_BR+.36*v_BU+.42*v_BF+Lift;
#local ABR= .11*v_BR+.36*v_BU+.42*v_BF+Lift;
#local ATL=-.13*v_BR+.56*v_BU+.44*v_BF+Lift;
#local ATR= .13*v_BR+.56*v_BU+.44*v_BF+Lift;

union { // start of bug body
prism { .13,.39,9,< .11, .47>,< .27, .17>,< .27,-.17>,< .11,-.47>,
  <-.11,-.47>,<-.27,-.17>,<-.27, .17>,<-.11, .47>,< .11, .47>
  matrix < v_BR.x,v_BR.y,v_BR.z,
           v_BU.x,v_BU.y,v_BU.z,
           v_BF.x,v_BF.y,v_BF.z,
           Lift.x,Lift.y,Lift.z >
}

#local s_C=15/17*.03;
#local s_S=8/17*.03;

prism { .16,.36,17,
  < .11, .50>,< .11+s_C, .47+s_S>,
  < .27+s_C, .17+s_S>,< .30, .17>,
  < .30,-.17>,< .27+s_C,-.17-s_S>,
  < .11+s_C,-.47-s_S>,< .11,-.50>,
  <-.11,-.50>,<-.11-s_C,-.47-s_S>,
  <-.27-s_C,-.17-s_S>,<-.30,-.17>,
  <-.30, .17>,<-.27-s_C, .17+s_S>,
  <-.11-s_C, .47+s_S>,<-.11, .50>,
  < .11, .50>
  matrix < v_BR.x,v_BR.y,v_BR.z,
           v_BU.x,v_BU.y,v_BU.z,
           v_BF.x,v_BF.y,v_BF.z,
           Lift.x,Lift.y,Lift.z >
}

cylinder { UC0,UC1,.03 }
cylinder { UC1,UC2,.03 }
cylinder { UC2,UC3,.03 }
cylinder { UC3,UC4,.03 }
cylinder { UC4,UC5,.03 }
cylinder { UC5,UC6,.03 }
cylinder { UC6,UC7,.03 }
cylinder { UC7,UC0,.03 }
cylinder { LC0,LC1,.03 }
cylinder { LC1,LC2,.03 }
cylinder { LC2,LC3,.03 }
cylinder { LC3,LC4,.03 }
cylinder { LC4,LC5,.03 }
cylinder { LC5,LC6,.03 }
cylinder { LC6,LC7,.03 }
cylinder { LC7,LC0,.03 }
cylinder { UC0,LC0,.03 }
cylinder { UC1,LC1,.03 }
cylinder { UC2,LC2,.03 }
cylinder { UC3,LC3,.03 }
cylinder { UC4,LC4,.03 }
cylinder { UC5,LC5,.03 }
cylinder { UC6,LC6,.03 }
cylinder { UC7,LC7,.03 }

sphere { UC0,.03 }
sphere { UC1,.03 }
sphere { UC2,.03 }
sphere { UC3,.03 }
sphere { UC4,.03 }
sphere { UC5,.03 }
sphere { UC6,.03 }
sphere { UC7,.03 }
sphere { LC0,.03 }
sphere { LC1,.03 }
sphere { LC2,.03 }
sphere { LC3,.03 }
sphere { LC4,.03 }
sphere { LC5,.03 }
sphere { LC6,.03 }
sphere { LC7,.03 }
sphere { ATL,.02 }
sphere { ATR,.02 }
cylinder { ABL,ATL,.01 }
cylinder { ABR,ATR,.01 }
texture { BugIron } }

union {
  sphere { BEL,.04 }
  sphere { BER,.04 }
  texture { BugEye } }


#local Count=0; #while (Count<6)

#switch (Count)

#case (0)
#local Hip=-.19*v_BR+.26*v_BU+.32*v_BF+L*E+Lift;
#local Foot=Foot0+.01*v_BU;
#break

#case (1)
#local Hip= .19*v_BR+.26*v_BU+.32*v_BF+R*E+Lift;
#local Foot=Foot1+.01*v_BU;
#break

#case (2)
#local Hip=-.30*v_BR+.26*v_BU+Lift;
#local Foot=Foot2+.01*v_BU;
#break

#case (3)
#local Hip= .30*v_BR+.26*v_BU+Lift;
#local Foot=Foot3+.01*v_BU;
#break

#case (4)
#local Hip=-.19*v_BR+.26*v_BU-.32*v_BF-R*E+Lift;
#local Foot=Foot4+.01*v_BU;
#break

#case (5)
#local Hip= .19*v_BR+.26*v_BU-.32*v_BF-L*E+Lift;
#local Foot=Foot5+.01*v_BU;
#break
#end

// scene code to draw a leg from Hip to Foot goes here
//calculate location of the Knee

//
#local s_1=sqrt(.5*.5+.26*.26);
#local s_2=s_1/sqrt(5); // thigh length
#local s_3=s_1*1.8/sqrt(5); // shin length

#local Knee=FindKnee(Foot,Hip,s_2,s_3,y);

union {

// knee to foot

Connect(Knee,.04,Foot,.01)
sphere { Foot,.01 }
sphere { Knee,.05 }

// and now from the Hip to the Knee

cylinder { Hip,Knee,.04 }
sphere { Hip,.06 }
texture { BugBrass } }

#local Count=Count+1; #end
}
