#include "meshmacu.inc"
#include "greb_b.inc"
#include "greb_s.inc"
#include "greb_t.inc"
#include "greb_m.inc"
#include "greb_h.inc"
#include "greb_e.inc"
#include "greb_n.inc"
#include "greb_ha.inc"
#include "greb_ar.inc"
#include "greb_bi.inc"

#local Fire=texture {
  pigment { rgb <1,BugLife,0> }
  finish { ambient 1 diffuse 0 }
}

#local Speckle = texture {
  pigment { bumps
    color_map {
      [.84 rgb <0,.25,.125>+.4*Skin0 ]
      [.86 rgb <1,.8,.7>-.7*Skin1]
    }
  }
  finish { ambient .1 diffuse 1 specular 1 roughness .03 }
}


#if(BugLife=1)
  #local GrebSkin=texture { Speckle }
  #local EyeBall=texture { Obsidian }
#else

#local GrebSkin=texture {
  granite scale 30
  texture_map {
    [BugLife*1.25-.25 Speckle scale 1/30 ]
    [BugLife*1.25-.125 Fire]
    [BugLife*1.25 pigment { rgbt 1 } ]
  }
}

#local EyeBall=texture {
  granite scale 30
  texture_map {
    [BugLife*1.25-.25 Obsidian ]
    [BugLife*1.25-.125 Fire]
    [BugLife*1.25 pigment { rgbt 1 } ]
  }
}
#end

#declare GrebL=(FootLF+FootRF+FootLH+FootRH)/4+(LiftLF+LiftRF+LiftLH+LiftRH)/8+BodyRise;
#declare GrebZ=vnormalize(FootLF+FootRF-FootLH-FootRH);
#declare GrebX=vnormalize(vcross(y,GrebZ));
#declare GrebY=vnormalize(vcross(GrebZ,GrebX));

#if(BugLife>0) // start of the Greb

object { GrebButt scale <1,.75,1> texture { GrebSkin } Matrix(GrebX,GrebY,GrebZ,GrebL) }

#local Count=0; #while (Count<4)

#switch(Count)
  #case(0)
    #local Hip=GrebL-24.5/3*GrebX+14.25*GrebY-53/3*GrebZ;
    #local Ankle=FootLH+LiftLH+GrebY*.5;
  #break
  #case(1)
    #local Hip=GrebL+24.5/3*GrebX+14.25*GrebY-53/3*GrebZ;
    #local Ankle=FootRH+LiftRH+GrebY*.5;
  #break
  #case(2)
    #local Hip=GrebL-35.0/3*GrebX+16.50*GrebY+53/3*GrebZ;
    #local Ankle=FootLF+LiftLF+GrebY*.5;
  #break
  #case(3)
    #local Hip=GrebL+35.0/3*GrebX+16.50*GrebY+53/3*GrebZ;
    #local Ankle=FootRF+LiftRF+GrebY*.5;
  #break
#end

#local Knee=FindKnee(Ankle,Hip,30,40,GrebY);

//#local sC=vdot(vnormalize(Ankle-Knee),-GrebY);

//#debug concat("cosine=",str(sC,0,3),"\n")

#local v_X=vnormalize(Hip-Knee);
#local v_Z=vnormalize(vcross(GrebY,v_X));
#local v_Y=vnormalize(vcross(v_X,v_Z));

object { GrebThigh texture { GrebSkin } Matrix(v_X,v_Y,v_Z,Knee) }

//#local v_X=vnormalize(Toe-Ankle);
//#local v_Z=vnormalize(vcross(GrebY,v_X));
//#local v_Y=vnormalize(vcross(v_X,v_Z));

//object { GrebFoot texture { GrebSkin } Matrix(v_X,v_Y,v_Z,Ankle) }

#local v_X=vnormalize(Ankle-Knee);
#local v_Z=vnormalize(vcross(GrebY,v_X));
#local v_Y=vnormalize(vcross(v_X,v_Z));

object { GrebShin texture { GrebSkin } Matrix(v_X,v_Y,v_Z,Knee) }

#local Count=Count+1; #end

#declare GrebN=GrebL+GrebY*55+GrebZ*19;

object { GrebNeck texture { GrebSkin } Matrix(GrebX,GrebY,GrebZ,GrebN) }

#local GrebH=GrebN+20*GrebY;

#local v_Z=vnormalize(GrebGaze-GrebH);
#local v_X=vnormalize(vcross(GrebY,v_Z));
#local v_Y=vnormalize(vcross(v_Z,v_X));

object { GrebHead texture { GrebSkin }
  matrix <1,0,0, 0,2/sqrt(5),1/sqrt(5), 0,-1/sqrt(5),2/sqrt(5), 0,0,0>
  Matrix(v_X,v_Y,v_Z,GrebH) }
object { GrebEye translate <-8,7,4>
  matrix <1,0,0, 0,2/sqrt(5),1/sqrt(5), 0,-1/sqrt(5),2/sqrt(5), 0,0,0>
  Matrix(v_X,v_Y,v_Z,GrebH) texture { EyeBall } }
object { GrebEye translate < 8,7,4>
  matrix <1,0,0, 0,2/sqrt(5),1/sqrt(5), 0,-1/sqrt(5),2/sqrt(5), 0,0,0>
  Matrix(v_X,v_Y,v_Z,GrebH) texture { EyeBall } }

#declare MandRand=array[4]
SmoothSeed(MandRand,8)

#local aJabber=25-15*SmoothRand(MandRand);

object { GrebMund texture { GrebSkin }
  rotate y*aJabber
  translate < 8,0,8>
  matrix <1,0,0, 0,2/sqrt(5),1/sqrt(5), 0,-1/sqrt(5),2/sqrt(5), 0,0,0>
  Matrix(v_X,v_Y,v_Z,GrebH)
}

object { GrebMund
  scale <-1,1,1>
  texture { GrebSkin }
  rotate -y*aJabber
  translate <-8,0,8>
  matrix <1,0,0, 0,2/sqrt(5),1/sqrt(5), 0,-1/sqrt(5),2/sqrt(5), 0,0,0>
  Matrix(v_X,v_Y,v_Z,GrebH)
}

#declare ShoulderL=<-16,55,22>;
#declare ShoulderR=< 16,55,22>;

#local tKnee=FindKnee(FingerL,ShoulderL,l_GrebArm,l_GrebBicep+l_GrebHand,y);
#local WristL=tKnee+vnormalize(FingerL-tKnee)*l_GrebBicep;
#local ElbowL=ShoulderL+vnormalize(FingerL-tKnee)*l_GrebBicep;

#local tKnee=FindKnee(FingerR,ShoulderR,l_GrebArm,l_GrebBicep+l_GrebHand,y);
#local WristR=tKnee+vnormalize(FingerR-tKnee)*l_GrebBicep;
#local ElbowR=ShoulderR+vnormalize(FingerR-tKnee)*l_GrebBicep;

#local v_X=vnormalize(ElbowL-ShoulderL);
#local v_Z=vnormalize(vcross(y,v_X));
#local v_Y=vnormalize(vcross(v_X,v_Z));

object { GrebBicep texture { GrebSkin } Matrix(v_X,v_Y,v_Z,ShoulderL)
  Matrix(GrebX,GrebY,GrebZ,GrebL) }

#local v_X=vnormalize(WristL-ElbowL);
#local v_Z=vnormalize(vcross(v_X,FingerL-ShoulderL));
#local v_Y=vnormalize(vcross(v_X,v_Z));

object { GrebArm texture { GrebSkin } Matrix(v_X,v_Y,v_Z,ElbowL)
  Matrix(GrebX,GrebY,GrebZ,GrebL) }

#local v_X=vnormalize(FingerL-WristL);
#local v_Z=vnormalize(vcross(y,v_X));
#local v_Y=vnormalize(vcross(v_X,v_Z));

object { GrebHand texture { GrebSkin } Matrix(v_X,v_Y,v_Z,WristL)
  Matrix(GrebX,GrebY,GrebZ,GrebL) }

#local v_X=vnormalize(ElbowR-ShoulderR);
#local v_Z=vnormalize(vcross(y,v_X));
#local v_Y=vnormalize(vcross(v_X,v_Z));

object { GrebBicep texture { GrebSkin } Matrix(v_X,v_Y,v_Z,ShoulderR)
  Matrix(GrebX,GrebY,GrebZ,GrebL) }

#local v_X=vnormalize(WristR-ElbowR);
#local v_Z=vnormalize(vcross(v_X,FingerR-ShoulderR));
#local v_Y=vnormalize(vcross(v_X,v_Z));

object { GrebArm texture { GrebSkin } Matrix(v_X,v_Y,v_Z,ElbowR)
  Matrix(GrebX,GrebY,GrebZ,GrebL) }

#local v_X=vnormalize(FingerR-WristR);
#local v_Z=vnormalize(vcross(y,v_X));
#local v_Y=vnormalize(vcross(v_X,v_Z));

object { GrebHand texture { GrebSkin } Matrix(v_X,v_Y,v_Z,WristR)
  Matrix(GrebX,GrebY,GrebZ,GrebL) }
#end // end of the Greb

