#ifndef(GrebShin)

#local C=(sqrt(2)-1)*4/3;
#local V0=<1,1,0>;
#local V1=<1,1,C>;
#local V2=<C,C,1>;
#local V3=<0,0,1>;
#local Q0=<-1,-1,-1>;
#local Q1=< 1, 1,-1>;
#local Q2=<-1,-1, 1>;
#local Q3=< 1, 1, 1>;

#local KX=.8;
#local KY=.6;
#local AX=3/sqrt(10);
#local AY=1/sqrt(10);

#local R1=<-KY,KX,1>*<2.75,2.75,2.2>;
#local R0=<-KY,KX,1>*<3.75,3.75,3.2>;
#local R2=<KY,KX,1>*.5;
#local R3=<KY,KX,1>*.5*C;
#local R4=<KY,KX,1>*.01;

#local P0=< 0,0,0>-<KX,KY,0>;
#local P1=< 0,0,0>;
#local P2=< 0,0,0>+<KX,KY,0>*14;
#local P3=<40,0,0>+<-KX,KY,0>*14;
#local P4=<40,0,0>;
#local P5=<40,0,0>+<KX,-KY,0>*C;
#local P6=<40,0,0>+<KX,-KY,0>;

#declare l_GrebShin=40;

#local S=3-Test;

#declare GrebShin=mesh {

#local Count=0; #while(Count<4)
#switch (Count)
#case(0) #local Q=<-1,-1,-1>; #break
#case(1) #local Q=< 1, 1,-1>; #break
#case(2) #local Q=<-1,-1, 1>; #break
#case(3) #local Q=< 1, 1, 1>; #break
#end

// knee cuff
Bicubic(
  P1+R0*V0*Q,P0+R0*V0*Q,P0+R1*V0*Q,P1+R1*V0*Q,
  P1+R0*V1*Q,P0+R0*V1*Q,P0+R1*V1*Q,P1+R1*V1*Q,
  P1+R0*V2*Q,P0+R0*V2*Q,P0+R1*V2*Q,P1+R1*V2*Q,
  P1+R0*V3*Q,P0+R0*V3*Q,P0+R1*V3*Q,P1+R1*V3*Q,S)

// first half of shin
Bicubic(
  P1+R0*V0*Q,P2+R0*V0*Q,P3+R2*V0*Q,P4+R2*V0*Q,
  P1+R0*V1*Q,P2+R0*V1*Q,P3+R2*V1*Q,P4+R2*V1*Q,
  P1+R0*V2*Q,P2+R0*V2*Q,P3+R2*V2*Q,P4+R2*V2*Q,
  P1+R0*V3*Q,P2+R0*V3*Q,P3+R2*V3*Q,P4+R2*V3*Q,S)

// second half of shin
Bicubic(
  P4+R2*V0*Q,P5+R2*V0*Q,P6+R3*V0*Q,P6+R4*V0*Q,
  P4+R2*V1*Q,P5+R2*V1*Q,P6+R3*V1*Q,P6+R4*V1*Q,
  P4+R2*V2*Q,P5+R2*V2*Q,P6+R3*V2*Q,P6+R4*V2*Q,
  P4+R2*V3*Q,P5+R2*V3*Q,P6+R3*V3*Q,P6+R4*V3*Q,S)

#local Count=Count+1; #end

}
#end
