#include "idol.inc"

plane { y,0
  #if(Test)
    pigment { checker
      pigment { rgb <.70,.60,.50> },
      pigment { rgb <.65,.60,.55> }
      scale 100
    }
  #else
    texture { Sandstone2 }
  #end
}

//#include "ring.msh"

#local Angle=Test*8; #while(Angle<8)
height_field { tga "land3.tga"
  smooth water_level .5
  translate -.5
  scale <4000,1500,4000>
  rotate y*Angle*17
  translate vrotate(x*3000,y*Angle*45)
  #if(Test)
    pigment { checker
      pigment { rgb <.70,.60,.50> },
      pigment { rgb <.65,.60,.55> }
    }
  #else
    texture { Sandstone }
  #end
}
#local Angle=Angle+1; #end

#local LF=vnormalize(<2,4,1>);
#local LU=vnormalize(vcross(LF,y));
#local LV=vnormalize(vcross(LF,LU));

light_source { LF*1e5 rgb <1,.95,.9>
#if(Test=0)
  area_light LU*1e3,LV*1e3,4,4 adaptive 0
#end
}

sky_sphere {
  pigment { granite translate -x/100*clock
    pigment_map {
      [.4 gradient y
        color_map { [0 rgb <.8,.9,1>][1 rgb <0,.25,.75>] } ]
      [.9 rgb 1 ] } } }

//#if (Test=0)
//  fog { fog_type 2 distance 1e4 rgb .8 fog_offset 200 fog_alt 200 }
//#end

#local OctoColumn=union {
  object { BevelBox(<-50,0,-50>,<50, 10,50>,sqrt(2)) }
  object { BevelBox(<-30,0,-30>,<30, 10,30>,sqrt(2)) translate y*10 }
  object { BevelBox(<-40,0,-40>,<40,200,40>,sqrt(2)) translate y*20 }
  object { BevelBox(<-30,0,-30>,<30, 10,30>,sqrt(2)) translate y*220 }
  object { BevelBox(<-50,0,-50>,<50, 60,50>,sqrt(2)) translate y*230 }
  object { BevelBox(<-40,0,-40>,<40, 10,40>,sqrt(2))  translate y*290 }
}

object { OctoColumn translate < 200,0,-1482> texture { Sandstone3 } }
object { OctoColumn translate <-200,0,-1482> texture { Sandstone3 } }
object { OctoColumn translate < 482,0,-1200> texture { Sandstone3 } }
object { OctoColumn translate <-482,0,-1200> texture { Sandstone3 } }
object { OctoColumn translate < 482,0,- 800> texture { Sandstone3 } }
object { OctoColumn translate <-482,0,- 800> texture { Sandstone3 } }
object { OctoColumn translate < 482,0,- 400> texture { Sandstone3 } }
object { OctoColumn translate <-482,0,- 400> texture { Sandstone3 } }
object { OctoColumn translate < 482,0,    0> texture { Sandstone3 } }
object { OctoColumn translate <-482,0,    0> texture { Sandstone3 } }
object { OctoColumn translate < 482,0,  400> texture { Sandstone3 } }
object { OctoColumn translate <-482,0,  400> texture { Sandstone3 } }

Voronoi(<-200, 0,-1200>,<200, 20,-800>,12,12,1,Sandstone3)
//object { BevelBox(<-200, 0,-1200>,<200, 20,-800>,sqrt(2))
//  texture { Sandstone3 } }
Voronoi(<-160,20,-1160>,<160,40,-840>,10,10,1,Sandstone3)
//object { BevelBox(<-160,20,-1160>,<160,40,-840>,sqrt(2))
//  texture { Sandstone3 } }
