#ifndef(BSOD) #local BSOD=off; #end

#local BLOW=256;

#declare Salmon=texture { granite scale BLOW
  texture_map {
    [BSOD
      pigment { rgbt 1 }
    ]
    [BSOD
      pigment { rgb <1,.5,.25> }
      finish { ambient .1 diffuse 1 }
    ]
  }
}

#declare Skyblu=texture { granite scale BLOW
  texture_map {
    [BSOD
      pigment { rgbt 1 }
    ]
    [BSOD
      pigment { rgb <.25,.5,1> }
      finish { ambient .1 diffuse 1 }
    ]
  }
}

#declare Yeller=texture { granite scale BLOW
  texture_map {
    [BSOD
      pigment { rgbt 1 }
    ]
    [BSOD
      pigment { rgb <1,.85,0> }
      finish { ambient .1 diffuse 1 }
    ]
  }
}

#declare Greene=texture { granite scale BLOW
  texture_map {
    [BSOD
      pigment { rgbt 1 }
    ]
    [BSOD
      pigment { rgb <0,1,.25> }
      finish { ambient .1 diffuse 1 }
    ]
  }
}

#declare Darkie=texture { granite scale BLOW
  texture_map {
    [BSOD
      pigment { rgbt 1 }
    ]
    [BSOD
      pigment { rgb 0 }
      finish { ambient .1 diffuse 1 reflection .25 }
    ]
  }
}

#macro Upper(Y)
#local sR=(45*45+8*8)/16;
  cylinder { -z,z*11,sR translate y*(Y-sR) }
  cylinder { -z,z*11,sR
    matrix <1,0,0, 0,1,0, 0,2,1, 0,Y-sR-2,0>
  }
#end

#macro Lower(Y)
#local sR=(45*45+8*8)/16;
  cylinder { -z,z*11,sR translate y*(Y-sR) inverse }
  cylinder { -z,z*11,sR inverse
    matrix <1,0,0, 0,1,0, 0,-2,1, 0,Y-sR+2,0>
  }
#end


#macro Left(X)
  plane { -x,0 translate -x*X }
  plane { -z*2-x,-2/sqrt(5) translate -x*X }
#end

#macro Right(X)
  plane { x,0 translate x*X }
  plane { -z*2+x,-2/sqrt(5) translate x*X }
#end

#macro Top(Y)
  plane { <-1,2,0>,0 translate y*Y }
  plane { <-1/sqrt(5),2/sqrt(5),-2>,-2/sqrt(5) translate y*Y }
#end

#macro Bottom(Y)
  plane { <1,-2,0>,0 translate -y*Y }
  plane { <1/sqrt(5),-2/sqrt(5),-2>,-2/sqrt(5) translate -y*Y }
#end

#local Diamond1=intersection {
  plane { z,10 }
  plane { -z,0 }
  Left(4)
  Right(4)
  Top(4.5)
  Bottom(4.5)
  bounded_by { box { <-5,-8,-10>,<5,8,0> } }
}

#local Diamond2=intersection {
  plane { z,10 }
  plane { -z,0 }
  Left(4.5)
  Right(4.5)
  Top(5.5)
  Bottom(5.5)
  bounded_by { box { <-5,-9,-10>,<5,9,0> } }
}

#local Diamond3=intersection {
  plane { z,10 }
  plane { -z,0 }
  Left(6.5)
  Right(6.5)
  Top(7)
  Bottom(7)
  bounded_by { box { <-7,-11,-10>,<7,11,0> } }
}

#local Diamond4=intersection {
  plane { z,10 }
  plane { -z,0 }
  Left(7.5)
  Right(7.5)
  Top(8.5)
  Bottom(8.5)
  bounded_by { box { <-8,-12,-10>,<8,12,0> } }
}

#local Diamond5=intersection {
  plane { z,10 }
  plane { -z,0 }
  Left(8.5)
  Right(8.5)
  Top(8.5)
  Bottom(8.5)
  bounded_by { box { <-9,-13,-10>,<9,13,0> } }
}

#local Diamond6=intersection {
  plane { z,10 }
  plane { -z,0 }
  Left(9.5)
  Right(9.5)
  Top(10)
  Bottom(10)
  bounded_by { box { <-10,-15,-10>,<10,15,0> } }
}

union {
object { Diamond1 translate <-105.0, 68.0,0> texture { Darkie } }
object { Diamond1 translate <-105.0, 47.0,0> texture { Salmon } }
object { Diamond1 translate <-105.0, 26.0,0> texture { Salmon } }
object { Diamond1 translate <-105.0,  5.0,0> texture { Darkie } }
object { Diamond1 translate <-105.0,-16.0,0> texture { Skyblu } }
object { Diamond1 translate <-105.0,-37.0,0> texture { Skyblu } }
object { Diamond1 translate <-105.0,-58.0,0> texture { Darkie } }

object { Diamond2 translate <- 87.5, 62.5,0> texture { Darkie } }
object { Diamond2 translate <- 87.5, 41.5,0> texture { Salmon } }
object { Diamond2 translate <- 87.5, 20.5,0> texture { Salmon } }
object { Diamond2 translate <- 87.5,-00.5,0> texture { Darkie } }
object { Diamond2 translate <- 87.5,-21.5,0> texture { Skyblu } }
object { Diamond2 translate <- 87.5,-42.5,0> texture { Skyblu } }
object { Diamond2 translate <- 87.5,-63.5,0> texture { Darkie } }

object { Diamond3 translate <- 70.5, 56.0,0> texture { Darkie } }
object { Diamond3 translate <- 70.5, 35.0,0> texture { Salmon } }
object { Diamond3 translate <- 70.5, 14.0,0> texture { Salmon } }
object { Diamond3 translate <- 70.5,- 7.0,0> texture { Darkie } }
object { Diamond3 translate <- 70.5,-28.0,0> texture { Skyblu } }
object { Diamond3 translate <- 70.5,-49.0,0> texture { Skyblu } }
object { Diamond3 translate <- 70.5,-70.0,0> texture { Darkie } }

object { Diamond4 translate <- 50.5, 53.5,0> texture { Darkie } }
object { Diamond4 translate <- 50.5, 32.5,0> texture { Salmon } }
object { Diamond4 translate <- 50.5, 11.5,0> texture { Salmon } }
object { Diamond4 translate <- 50.5,- 9.5,0> texture { Darkie } }
object { Diamond4 translate <- 50.5,-30.5,0> texture { Skyblu } }
object { Diamond4 translate <- 50.5,-51.5,0> texture { Skyblu } }
object { Diamond4 translate <- 50.5,-72.5,0> texture { Darkie } }

object { Diamond5 translate <- 28.5, 56.5,0> texture { Darkie } }
object { Diamond5 translate <- 28.5, 35.5,0> texture { Salmon } }
object { Diamond5 translate <- 28.5, 14.5,0> texture { Salmon } }
object { Diamond5 translate <- 28.5,- 6.5,0> texture { Darkie } }
object { Diamond5 translate <- 28.5,-27.5,0> texture { Skyblu } }
object { Diamond5 translate <- 28.5,-48.5,0> texture { Skyblu } }
object { Diamond5 translate <- 28.5,-69.5,0> texture { Darkie } }

object { Diamond6 translate <-  6.5, 62.5,0> texture { Darkie } }
object { Diamond6 translate <-  6.5, 41.5,0> texture { Darkie } }
object { Diamond6 translate <-  6.5, 20.5,0> texture { Darkie } }
object { Diamond6 translate <-  6.5,- 0.5,0> texture { Darkie } }
object { Diamond6 translate <-  6.5,-21.5,0> texture { Darkie } }
object { Diamond6 translate <-  6.5,-42.5,0> texture { Darkie } }
object { Diamond6 translate <-  6.5,-63.5,0> texture { Darkie } }

intersection {
  plane { -z,0 }
  plane { z,10 }
  Upper(85)
  Lower(64)
  Left(45.5)
  Right(55.5)
  translate x*50.5
  texture { Darkie }
}

intersection {
  plane { -z,0 }
  plane { z,10 }
  Upper(20)
  Lower( 5)
  Left(45.5)
  Right(39.5)
  translate x*50.5
  texture { Darkie }
}

intersection {
  plane { -z,0 }
  plane { z,10 }
  Upper(-40)
  Lower(-61)
  Left(45.5)
  Right(55.5)
  translate x*50.5
  texture { Darkie }
}

intersection {
  plane { -z,0 }
  plane { z,10 }
  Upper( 68)
  Lower(-44)
  Left(-35.5)
  Right(55.5)
  translate x*50.5
  texture { Darkie }
}

intersection {
  plane { z,10 }
  plane { -z,0 }
  Left(10.5)
  Right(2.5)
  Upper( 68)
  Lower(-44)
  translate x*50.5
  texture { Darkie }
}

intersection {
  plane { z,10 }
  plane { -z,0 }
  Left(45.5)
  Right(-10.5)
  Upper( 64)
  Lower( 20)
  translate x*50.5
  texture { Salmon }
}

intersection {
  plane { z,10 }
  plane { -z,0 }
  Left(45.5)
  Right(-10.5)
  Upper(  5)
  Lower(-40)
  translate x*50.5
  texture { Skyblu }
}

intersection {
  plane { z,10 }
  plane { -z,0 }
  Left(-2.5)
  Right(35.5)
  Upper( 64)
  Lower( 20)
  translate x*50.5
  texture { Greene }
}

intersection {
  plane { z,10 }
  plane { -z,0 }
  Left(-2.5)
  Right(35.5)
  Upper(  5)
  Lower(-40)
  translate x*50.5
  texture { Yeller }
}
  object {
    BevelBox(<-120,-120,1>,<117,100,40>,4)
    texture { Sandstone }
  }

  polygon { 5,0,<228,0,0>,<228,171,0>,<0,171,0>,0
    texture { granite scale BLOW
      texture_map {
        [ BSOD 
          pigment { image_map { gif "bsod.gif" } scale <228,171,1>/BLOW }
          finish { ambient 1 diffuse 0 }
        ]
        [ BSOD
          pigment { rgbt 1 }
        ]
      }
    }  
    translate <-115.5,-85.5,.99>
  }  

  scale <-1,1,-1>
  translate <-1.5,115,-1700>
}
