#ifndef(MESHMACU_INC)

#declare MESHMACU_INC=true;

#macro MeshCornerU(Center,VectorA,VectorB,VectorC,Radius,Divisions)
  #local p_C=(Center);
  #local v_A=vnormalize(VectorA);
  #local v_B=vnormalize(VectorB);
  #local v_C=vnormalize(VectorC);
  #local s_R=(Radius);
  #local i_D=floor(Divisions);

  #local i_A=0; #while (i_A<i_D)
  #local i_X=i_A+1;
  #local i_B=0; #while ((i_A+i_B)<i_D)
  #local i_Y=i_B+1;
  #local i_C=i_D-i_A-i_B;
  #local i_Z=i_C-1;
  #local i_W=i_C-2;
  smooth_triangle {
    p_C+vnormalize(i_A*v_A+i_B*v_B+i_C*v_C)*s_R,i_A*v_A+i_B*v_B+i_C*v_C,
    p_C+vnormalize(i_X*v_A+i_B*v_B+i_Z*v_C)*s_R,i_X*v_A+i_B*v_B+i_Z*v_C,
    p_C+vnormalize(i_A*v_A+i_Y*v_B+i_Z*v_C)*s_R,i_A*v_A+i_Y*v_B+i_Z*v_C }
  #if (i_W>=0)
  smooth_triangle {
    p_C+vnormalize(i_X*v_A+i_Y*v_B+i_W*v_C)*s_R,i_X*v_A+i_Y*v_B+i_W*v_C,
    p_C+vnormalize(i_A*v_A+i_Y*v_B+i_Z*v_C)*s_R,i_A*v_A+i_Y*v_B+i_Z*v_C,
    p_C+vnormalize(i_X*v_A+i_B*v_B+i_Z*v_C)*s_R,i_X*v_A+i_B*v_B+i_Z*v_C }
  #end
  #local i_B=i_B+1; #end
  #local i_A=i_A+1; #end
#end

#macro MeshEdgeU(Start,Finish,VectorA,VectorB,Radius,Divisions)
  #local p_S=(Start);
  #local p_F=(Finish);
  #local v_A=vnormalize(VectorA);
  #local v_B=vnormalize(VectorB);
  #local s_R=(Radius);
  #local i_D=floor(Divisions);

  #local i_A=0; #while (i_A<i_D)
  #local i_X=i_A+1;
  #local i_B=i_D-i_A;
  #local i_Y=i_B-1;

  smooth_triangle {
    p_S+vnormalize(i_A*v_A+i_B*v_B)*s_R,i_A*v_A+i_B*v_B,
    p_F+vnormalize(i_A*v_A+i_B*v_B)*s_R,i_A*v_A+i_B*v_B,
    p_F+vnormalize(i_X*v_A+i_Y*v_B)*s_R,i_X*v_A+i_Y*v_B }
  smooth_triangle {
    p_S+vnormalize(i_A*v_A+i_B*v_B)*s_R,i_A*v_A+i_B*v_B,
    p_F+vnormalize(i_X*v_A+i_Y*v_B)*s_R,i_X*v_A+i_Y*v_B,
    p_S+vnormalize(i_X*v_A+i_Y*v_B)*s_R,i_X*v_A+i_Y*v_B }
  #local i_A=i_A+1; #end
#end

#macro MeshQuadU(P1,P2,P3,P4)
  triangle { P1,P2,P3 }
  triangle { P1,P3,P4 }
#end

#macro MeshConeU(Start,Finish,VectorA,VectorB,RadiusA,RadiusB,Divisions)
  #local p_S=(Start);
  #local p_F=(Finish);
  #local v_A=vnormalize(VectorA);
  #local v_B=vnormalize(VectorB);
  #local s_Ra=(RadiusA);
  #local s_Rb=(RadiusB);
  #local i_D=floor(Divisions);
  #local v_L=vnormalize(p_F-p_S)*(s_Ra-s_Rb)/vlength(p_F-p_S);

  #local i_A=0; #while (i_A<i_D)
  #local i_X=i_A+1;
  #local i_B=i_D-i_A;
  #local i_Y=i_B-1;

  smooth_triangle {
    p_S+vnormalize( i_A*v_A+i_B*v_B)*s_Ra, vnormalize( i_A*v_A+i_B*v_B)+v_L,
    p_F+vnormalize( i_A*v_A+i_B*v_B)*s_Rb, vnormalize( i_A*v_A+i_B*v_B)+v_L,
    p_F+vnormalize( i_X*v_A+i_Y*v_B)*s_Rb, vnormalize( i_X*v_A+i_Y*v_B)+v_L }
  smooth_triangle {
    p_S+vnormalize( i_A*v_A+i_B*v_B)*s_Ra, vnormalize( i_A*v_A+i_B*v_B)+v_L,
    p_F+vnormalize( i_X*v_A+i_Y*v_B)*s_Rb, vnormalize( i_X*v_A+i_Y*v_B)+v_L,
    p_S+vnormalize( i_X*v_A+i_Y*v_B)*s_Ra, vnormalize( i_X*v_A+i_Y*v_B)+v_L }
  smooth_triangle {
    p_S+vnormalize(-i_A*v_A+i_B*v_B)*s_Ra, vnormalize(-i_A*v_A+i_B*v_B)+v_L,
    p_F+vnormalize(-i_A*v_A+i_B*v_B)*s_Rb, vnormalize(-i_A*v_A+i_B*v_B)+v_L,
    p_F+vnormalize(-i_X*v_A+i_Y*v_B)*s_Rb, vnormalize(-i_X*v_A+i_Y*v_B)+v_L }
  smooth_triangle {
    p_S+vnormalize(-i_A*v_A+i_B*v_B)*s_Ra, vnormalize(-i_A*v_A+i_B*v_B)+v_L,
    p_F+vnormalize(-i_X*v_A+i_Y*v_B)*s_Rb, vnormalize(-i_X*v_A+i_Y*v_B)+v_L,
    p_S+vnormalize(-i_X*v_A+i_Y*v_B)*s_Ra, vnormalize(-i_X*v_A+i_Y*v_B)+v_L }
  smooth_triangle {
    p_S+vnormalize( i_A*v_A-i_B*v_B)*s_Ra, vnormalize( i_A*v_A-i_B*v_B)+v_L,
    p_F+vnormalize( i_A*v_A-i_B*v_B)*s_Rb, vnormalize( i_A*v_A-i_B*v_B)+v_L,
    p_F+vnormalize( i_X*v_A-i_Y*v_B)*s_Rb, vnormalize( i_X*v_A-i_Y*v_B)+v_L }
  smooth_triangle {
    p_S+vnormalize( i_A*v_A-i_B*v_B)*s_Ra, vnormalize( i_A*v_A-i_B*v_B)+v_L,
    p_F+vnormalize( i_X*v_A-i_Y*v_B)*s_Rb, vnormalize( i_X*v_A-i_Y*v_B)+v_L,
    p_S+vnormalize( i_X*v_A-i_Y*v_B)*s_Ra, vnormalize( i_X*v_A-i_Y*v_B)+v_L }
  smooth_triangle {
    p_S+vnormalize(-i_A*v_A-i_B*v_B)*s_Ra, vnormalize(-i_A*v_A-i_B*v_B)+v_L,
    p_F+vnormalize(-i_A*v_A-i_B*v_B)*s_Rb, vnormalize(-i_A*v_A-i_B*v_B)+v_L,
    p_F+vnormalize(-i_X*v_A-i_Y*v_B)*s_Rb, vnormalize(-i_X*v_A-i_Y*v_B)+v_L }
  smooth_triangle {
    p_S+vnormalize(-i_A*v_A-i_B*v_B)*s_Ra, vnormalize(-i_A*v_A-i_B*v_B)+v_L,
    p_F+vnormalize(-i_X*v_A-i_Y*v_B)*s_Rb, vnormalize(-i_X*v_A-i_Y*v_B)+v_L,
    p_S+vnormalize(-i_X*v_A-i_Y*v_B)*s_Ra, vnormalize(-i_X*v_A-i_Y*v_B)+v_L }
  #local i_A=i_A+1; #end
#end

#macro MeshTubeU(Start,Finis,Radius,Sides)
  #local vt_Q=(Finis)-(Start);
  #local vt_C=vnormalize(vcross(vt_Q,<vt_Q.y,vt_Q.z,-vt_Q.x>))*(Radius);
  #local vt_S=vnormalize(vcross(vt_Q,vt_C))*(Radius);
  #local st_A=0;
  #while (st_A<359.9)
  #local st_B=st_A+360/(Sides);
  #local st_CA=vrotate(x,z*st_A).x;
  #local st_CB=vrotate(x,z*st_B).x;
  #local st_SA=vrotate(x,z*st_A).y;
  #local st_SB=vrotate(x,z*st_B).y;

  smooth_triangle {
    Start+vt_C*st_CA+vt_S*st_SA,vt_C*st_CA+vt_S*st_SA,
    Start+vt_C*st_CB+vt_S*st_SB,vt_C*st_CB+vt_S*st_SB,
    Finis+vt_C*st_CB+vt_S*st_SB,vt_C*st_CB+vt_S*st_SB }

  smooth_triangle {
    Start+vt_C*st_CA+vt_S*st_SA,vt_C*st_CA+vt_S*st_SA,
    Finis+vt_C*st_CA+vt_S*st_SA,vt_C*st_CA+vt_S*st_SA,
    Finis+vt_C*st_CB+vt_S*st_SB,vt_C*st_CB+vt_S*st_SB }

  #local st_A=st_B;
  #end
#end
#end

#macro Bicubic(P0,P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,Div)
  #if (Div<1)
    smooth_triangle {
      P0, vcross(P1-P0,P4-P0),
      P3, vcross(P7-P3,P2-P3),
      PF, vcross(PE-PF,PB-PF) }
    smooth_triangle {
      P0, vcross(P1-P0,P4-P0),
      PF, vcross(PE-PF,PB-PF),
      PC, vcross(P8-PC,PD-PC) }
  #else
  Bicubic(
    P0,
    (P0+P1)/2,
    (P0+2*P1+P2)/4,
    (P0+3*P1+3*P2+P3)/8,

    (P0              + P4)/2,
    (P0+P1           + P4+P5)/4,
    (P0+2*P1+P2      + P4+2*P5+P6)/8,
    (P0+3*P1+3*P2+P3 + P4+3*P5+3*P6+P7)/16,

    (P0              + 2*P4                + P8)/4,
    (P0+P1           + 2*P4+2*P5           + P8+P9)/8,
    (P0+2*P1+P2      + 2*P4+4*P5+2*P6      + P8+2*P9+PA)/16,
    (P0+3*P1+3*P2+P3 + 2*P4+6*P5+6*P6+2*P7 + P8+3*P9+3*PA+PB)/32,

    (P0              + 3*P4                + 3*P8                + PC)/8,
    (P0+P1           + 3*P4+3*P5           + 3*P8+3*P9           + PC+PD)/16,
    (P0+2*P1+P2      + 3*P4+6*P5+3*P6      + 3*P8+6*P9+3*PA      + PC+2*PD+PE)/32,
    (P0+3*P1+3*P2+P3 + 3*P4+9*P5+9*P6+3*P7 + 3*P8+9*P9+9*PA+3*PB + PC+3*PD+3*PE+PF )/64,
    Div-1)

  Bicubic(
    (P0+3*P1+3*P2+P3)/8,
    (P1+2*P2+P3)/4,
    (P2+P3)/2,
     P3,

    ( P0+3*P1+3*P2+P3 + P4+3*P5+3*P6+P7 )/16,
    ( P1+2*P2+P3 +      P5+2*P6+P7 )/8,
    ( P2+P3 +           P6+P7 )/4,
    ( P3 +              P7 )/2,

    ( P0+3*P1+3*P2+P3 +2*P4+6*P5+6*P6+2*P7 + P8+3*P9+3*PA+PB)/32,
    ( P1+2*P2+P3 +     2*P5+4*P6+2*P7 +      P9+2*PA+PB)/16,
    ( P2+P3 +          2*P6+2*P7 +           PA+PB)/8,
    ( P3 +             2*P7 +                PB)/4,

    ( P0+3*P1+3*P2+P3 + 3*P4+9*P5+9*P6+3*P7 + 3*P8+9*P9+9*PA+3*PB + PC+3*PD+3*PE+PF )/64,
    ( P1+2*P2+P3 +      3*P5+6*P6+3*P7 +      3*P9+6*PA+3*PB +      PD+2*PE+PF )/32,
    ( P2+P3 +           3*P6+3*P7 +           3*PA+3*PB +           PE+PF )/16,
    ( P3 +              3*P7 +                3*PB +                PF )/8,

    Div-1)

  Bicubic(
    (P0              + 3*P4                + 3*P8                + PC)/8,
    (P0+P1           + 3*P4+3*P5           + 3*P8+3*P9           + PC+PD)/16,
    (P0+2*P1+P2      + 3*P4+6*P5+3*P6      + 3*P8+6*P9+3*PA      + PC+2*PD+PE)/32,
    (P0+3*P1+3*P2+P3 + 3*P4+9*P5+9*P6+3*P7 + 3*P8+9*P9+9*PA+3*PB + PC+3*PD+3*PE+PF )/64,

    ( P4              + 2*P8                + PC )/4,
    ( P4+P5           + 2*P8+2*P9           + PC+PD )/8,
    ( P4+2*P5+P6      + 2*P8+4*P9+2*PA      + PC+2*PD+PE)/16,
    ( P4+3*P5+3*P6+P7 + 2*P8+6*P9+6*PA+2*PB + PC+3*PD+3*PE+PF )/32,

    ( P8              + PC)/2,
    ( P8+P9           + PC+PD)/4,
    ( P8+2*P9+PA      + PC+2*PD+PE)/8,
    ( P8+3*P9+3*PA+PB + PC+3*PD+3*PE+PF )/16,

    PC,
    ( PC+PD)/2,
    ( PC+2*PD+PE)/4,
    ( PC+3*PD+3*PE+PF )/8,
    Div-1)

  Bicubic(
    ( P0+3*P1+3*P2+P3 + 3*P4+9*P5+9*P6+3*P7 + 3*P8+9*P9+9*PA+3*PB + PC+3*PD+3*PE+PF )/64,
    ( P1+2*P2+P3 +      3*P5+6*P6+3*P7 +      3*P9+6*PA+3*PB +      PD+2*PE+PF )/32,
    ( P2+P3 +           3*P6+3*P7 +           3*PA+3*PB +           PE+PF )/16,
    ( P3 +              3*P7 +                3*PB +                PF )/8,

    ( P4+3*P5+3*P6+P7 + 2*P8+6*P9+6*PA+2*PB + PC+3*PD+3*PE+PF )/32,
    ( P5+2*P6+P7      + 2*P9+4*PA+2*PB      + PD+2*PE+PF )/16,
    ( P6+P7           + 2*PA+2*PB           + PE+PF )/8,
    ( P7              + 2*PB                + PF )/4,

    ( P8+3*P9+3*PA+PB + PC+3*PD+3*PE+PF )/16,
    ( P9+2*PA+PB      + PD+2*PE+PF )/8,
    ( PA+PB           + PE+PF )/4,
    ( PB              + PF )/2,

    ( PC+3*PD+3*PE+PF )/8,
    ( PD+2*PE+PF )/4,
    ( PE+PF )/2,
    ( PF )/1,
    Div-1)

  #end
#end

