#declare phi=(sqrt(5)-1)/2;
#declare t36=sqrt(5-2*sqrt(5));
#declare c36=(sqrt(5)+1)/4;
#declare c18=sqrt(.5+c36/2);
#declare t18=sqrt(.5-c36/2)/c18;
#declare s36=sqrt(1-c36*c36);
#declare s72=c18;

#declare RedMarble=texture {
  pigment { granite color_map { [0 rgb <.25,.25,.5>][1 rgb <.5,0,.5>] } }
}
#declare BlueMarble=texture {
  pigment { granite color_map { [0 rgb <.25,.25,.5>][1 rgb <0,.5,.5>] } }
}

#macro Slim1(A,B,C,D)
  #if (D=0)
    #local W=vlength(B-C)*.03;
    triangle { A,B,C texture { RedMarble } }
  #else
    Slim1(B,C,A+(C-A)*phi,D-1)
    Slim2(B,B+(A-B)*phi,A+(C-A)*phi,D-1)
    Wide(A,A+(C-A)*phi,B+(A-B)*phi,D-1)
  #end
#end

#macro Slim2(A,B,C,D)
  #if (D=0)
    #local W=vlength(B-C)*.03;
    triangle { A,B,C texture { BlueMarble } }
  #else
    Slim1(B,C,A+(C-A)*phi,D-1)
    Slim2(B,B+(A-B)*phi,A+(C-A)*phi,D-1)
    Wide(A,A+(C-A)*phi,B+(A-B)*phi,D-1)
  #end
#end

#macro Wide(A,B,C,D)
  #if (D=0)
    #local W=vlength(B-C)*.03;
    triangle { A,B,C texture { BlueMarble } }
  #else
    Slim2(A,A+(B-A)*phi,C,D-1)
    Wide(B,C,A+(B-A)*phi,D-1)
  #end
#end
