//Path -- initalized array[n][5] containing spline coefficients for path taken during walk
//Face -- initialized array[n][5] containing spline coefficients for direction faced during walk
//  The spline coefficient arrays are in the style as is used in my spline.inc file; go read
//  that to learn more.  You can use the same array for Path and Face, or you can use different
//  ones if you want the walking figure to face directions other than forward.
//tTime -- the time the user wants to calculate for
//iOff -- the index into the spline path when tTime=0
//iMin -- the lower bound for the index
//iMax -- the upper bound for the index
//lStep -- the length of each step (in spline units)
//dStep -- the duration of each step (in seconds)
//wStep -- the wait time between steps (in seconds)
//vU -- the up vector
//pOff -- the offset of the step from the walker's location:
//  pOff.x = lateral offset (perpendicular to direction of motion)
//  pOff.z = parallel offset (parallel to direction of motion)
//returns: the location of the foot at the given moment

#macro Walk(Path,Face,tTime,iOff,iMin,iMax,lStep,dStep,wStep,vU,pOff)
  #local tT=tTime; // get time passed since start of walking
  #local iST=floor(tT/(dStep+wStep)); // total steps taken
  #local sPH=tT-iST*(dStep+wStep); // part of step taken
  #if (sPH>=dStep) // if next step has actually been taken
    #local iST=iST+1; // increment steps taken
    #local sPH=0; // no partial needed
  #end
  #local sPH=sPH/dStep; //adjust portion for Transition() macro
  #local iB=iST*lStep+iOff; // get index for start of step
  #local iE=iB+lStep;  // get index for end of step
  #local iB=min(max(iB,iMin),iMax); // clip to within range
  #local iE=min(max(iE,iMin),iMax); // clip to within range

  #local pS=SplineLoc(Path,iB); // calculate basic position
  #local vZ=vnormalize(SplineVel(Face,iB)); // find forward vector
  #local vX=vnormalize(vcross(vU,vZ)); // find lateral vector
  #local pS=pS+pOff.x*vX+pOff.z*vZ; //find actual start point of step

  #local pE=SplineLoc(Path,iE); // same for end point
  #local vZ=vnormalize(SplineVel(Face,iE));
  #local vX=vnormalize(vcross(vU,vZ));
  #local pE=pE+pOff.x*vX+pOff.z*vZ;

  #local sL=vlength(pS-pE)/4;
  #local pR=Transition(pS,pE,sL*vU,sPH);
  pR
#end
